/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityIdentity;

class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext createAndSetSecurityContext(final String domain, final String fqnClassName) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<SecurityContext>(){

            @Override
            public SecurityContext run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext((String)domain, (String)fqnClassName);
                SecurityActions.setSecurityContext(sc);
                return sc;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void pushCallerRunAsIdentity(final RunAs ra) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(ra);
                return null;
            }
        });
    }

    static void popCallerRunAsIdentity() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(null);
                return null;
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static void setSecurityIdentity(final SecurityContext sc, final SecurityIdentity si) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.getUtil().setSecurityIdentity(si);
                return null;
            }
        });
    }

    static SecurityIdentity getSecurityIdentity(final SecurityContext sc) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityIdentity>(){

            @Override
            public SecurityIdentity run() {
                return sc.getUtil().getSecurityIdentity();
            }
        });
    }

    static void setSecurityManagement(final SecurityContext sc, final ISecurityManagement sm) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setSecurityManagement(sm);
                return null;
            }
        });
    }

    static void setSecurityDomain(final SecurityContext sc, final String domain) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                sc.setSecurityDomain(domain);
                return null;
            }
        });
    }

    static String trace(final SecurityContext sc) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                StringBuilder sb = new StringBuilder();
                sb.append(" Principal = " + sc.getUtil().getUserPrincipal());
                sb.append(" Subject:" + sc.getUtil().getSubject());
                sb.append(" Incoming run as:" + sc.getIncomingRunAs());
                sb.append(" Outgoing run as:" + sc.getOutgoingRunAs());
                return sb.toString();
            }
        });
    }

    static String trace(final SecurityIdentity si) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                StringBuilder sb = new StringBuilder();
                sb.append(" Principal = " + si.getPrincipal());
                sb.append(" Subject:" + si.getSubject());
                sb.append(" Incoming run as:" + si.getIncomingRunAs());
                sb.append(" Outgoing run as:" + si.getOutgoingRunAs());
                return sb.toString();
            }
        });
    }
}

