/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCFunctionMappingMetaData {
    private final String functionName;
    private String[] sqlChunks;
    private int[] parameters;

    public JDBCFunctionMappingMetaData(String functionName, String[] sqlChunks, int[] parameters) {
        this.functionName = functionName;
        this.sqlChunks = sqlChunks;
        this.parameters = parameters;
    }

    public JDBCFunctionMappingMetaData(Element element) throws DeploymentException {
        this.functionName = MetaData.getUniqueChildContent((Element)element, (String)"function-name");
        String sql = MetaData.getUniqueChildContent((Element)element, (String)"function-sql");
        this.initFromString(sql);
    }

    public JDBCFunctionMappingMetaData(String functionName, String sql) throws DeploymentException {
        this.functionName = functionName;
        this.initFromString(sql);
    }

    private void initFromString(String sql) throws DeploymentException {
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> parameterList = new ArrayList<Integer>();
        if (sql.charAt(0) == '?') {
            chunkList.add("");
        }
        StringBuffer chunk = new StringBuffer();
        StringReader reader = new StringReader(sql);
        try {
            int c = reader.read();
            while (c >= 0) {
                if (c != 63) {
                    chunk.append((char)c);
                } else {
                    Integer parameter;
                    chunkList.add(chunk.toString());
                    chunk = new StringBuffer();
                    StringBuffer number = new StringBuffer();
                    int digit = reader.read();
                    while (digit >= 0) {
                        if (!Character.isDigit((char)digit)) {
                            if (digit < 0) break;
                            chunk.append((char)digit);
                            break;
                        }
                        number.append((char)digit);
                        digit = reader.read();
                    }
                    if (number.length() == 0) {
                        throw new DeploymentException("Invalid parameter in function-sql: " + sql);
                    }
                    try {
                        parameter = new Integer(number.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new DeploymentException("Invalid parameter number in function-sql: number=" + number + " sql=" + sql);
                    }
                    parameterList.add(parameter);
                }
                c = reader.read();
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Error parsing function-sql: " + sql);
        }
        chunkList.add(chunk.toString());
        this.sqlChunks = new String[chunkList.size()];
        chunkList.toArray(this.sqlChunks);
        this.parameters = new int[parameterList.size()];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = (Integer)parameterList.get(i) - 1;
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public StringBuffer getFunctionSql(Object[] args, StringBuffer buf) {
        for (int i = 0; i < this.sqlChunks.length; ++i) {
            if (i < this.parameters.length) {
                Object arg = args[this.parameters[i]];
                if (arg == null) continue;
                buf.append(this.sqlChunks[i]);
                buf.append(arg);
                continue;
            }
            buf.append(this.sqlChunks[i]);
        }
        return buf;
    }
}

