/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.jacorb.ssl.SSLPolicyValue;
import org.jacorb.ssl.SSLPolicyValueHelper;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.iiop.CorbaNamingService;
import org.jboss.iiop.CorbaORBService;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.InterfaceAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.ir.InterfaceRepository;
import org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.iiop.ReferenceFactory;
import org.jboss.invocation.iiop.ServantRegistries;
import org.jboss.invocation.iiop.ServantRegistry;
import org.jboss.invocation.iiop.ServantRegistryKind;
import org.jboss.logging.Logger;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.IorSecurityConfigMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.naming.Util;
import org.jboss.proxy.ejb.EJBMetaDataImplIIOP;
import org.jboss.proxy.ejb.EjbHomeCorbaServant;
import org.jboss.proxy.ejb.EjbObjectCorbaServant;
import org.jboss.proxy.ejb.HomeHandleImplIIOP;
import org.jboss.proxy.ejb.IIOPHomeFactory;
import org.jboss.system.Registry;
import org.jboss.web.WebClassLoader;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.POA;
import org.w3c.dom.Element;

public class IORFactory
implements EJBProxyFactory {
    private static final Logger staticLogger = Logger.getLogger(IORFactory.class);
    private ORB orb;
    private Container container;
    private String jndiName;
    private boolean useJNPContext;
    private String jnpName;
    private EJBMetaDataImplIIOP ejbMetaData;
    private Map beanMethodMap;
    private Map homeMethodMap;
    private String[] beanRepositoryIds;
    private String[] homeRepositoryIds;
    private ServantRegistry homeServantRegistry;
    private ServantRegistry beanServantRegistry;
    private ReferenceFactory homeReferenceFactory;
    private ReferenceFactory beanReferenceFactory;
    private Current poaCurrent;
    private Policy codebasePolicy;
    private Policy csiv2Policy;
    private Policy sslPolicy;
    private EJBHome ejbHome;
    private InvokerProxyBindingMetaData invokerMetaData;
    private ServantRegistries servantRegistries;
    private InterfaceRepository iri;
    private POA irPoa;
    private Logger logger = staticLogger;

    public void setContainer(Container container) {
        this.container = container;
        if (container != null) {
            String loggerName = IORFactory.class.getName() + '.' + container.getBeanMetaData().getJndiName();
            this.logger = Logger.getLogger((String)loggerName);
        }
    }

    public void create() throws Exception {
        String codebaseString;
        int i;
        try {
            this.orb = (ORB)new InitialContext().lookup("java:/" + CorbaORBService.ORB_NAME);
        }
        catch (NamingException e) {
            throw new Exception("Cannot lookup java:/" + CorbaORBService.ORB_NAME + ": " + e);
        }
        try {
            this.irPoa = (POA)new InitialContext().lookup("java:/" + CorbaORBService.IR_POA_NAME);
        }
        catch (NamingException e) {
            throw new Exception("Cannot lookup java:/" + CorbaORBService.IR_POA_NAME + ": " + e);
        }
        Element proxyFactoryConfig = this.invokerMetaData.getProxyFactoryConfig();
        boolean interfaceRepositorySupported = MetaData.getOptionalChildBooleanContent((Element)proxyFactoryConfig, (String)"interface-repository-supported");
        if (interfaceRepositorySupported) {
            this.iri = new InterfaceRepository(this.orb, this.irPoa, this.jndiName);
            this.iri.mapClass(((EJBProxyFactoryContainer)this.container).getRemoteClass());
            this.iri.mapClass(((EJBProxyFactoryContainer)this.container).getHomeClass());
            this.iri.finishBuild();
            this.logger.info((java.lang.Object)("CORBA interface repository for " + this.jndiName + ": " + this.orb.object_to_string((Object)this.iri.getReference())));
        }
        this.logger.debug((java.lang.Object)"Bean methods:");
        InterfaceAnalysis interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(((EJBProxyFactoryContainer)this.container).getRemoteClass());
        this.beanMethodMap = new HashMap();
        AttributeAnalysis[] attrs = interfaceAnalysis.getAttributes();
        for (int i2 = 0; i2 < attrs.length; ++i2) {
            OperationAnalysis op = attrs[i2].getAccessorAnalysis();
            this.logger.debug((java.lang.Object)("    " + op.getJavaName() + "\n                " + op.getIDLName()));
            this.beanMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
            op = attrs[i2].getMutatorAnalysis();
            if (op == null) continue;
            this.logger.debug((java.lang.Object)("    " + op.getJavaName() + "\n                " + op.getIDLName()));
            this.beanMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
        }
        OperationAnalysis[] ops = interfaceAnalysis.getOperations();
        for (i = 0; i < ops.length; ++i) {
            this.logger.debug((java.lang.Object)("    " + ops[i].getJavaName() + "\n                " + ops[i].getIDLName()));
            this.beanMethodMap.put(ops[i].getIDLName(), new SkeletonStrategy(ops[i].getMethod()));
        }
        this.beanRepositoryIds = interfaceAnalysis.getAllTypeIds();
        this.logger.debug((java.lang.Object)"Home methods:");
        interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(((EJBProxyFactoryContainer)this.container).getHomeClass());
        this.homeMethodMap = new HashMap();
        attrs = interfaceAnalysis.getAttributes();
        for (i = 0; i < attrs.length; ++i) {
            OperationAnalysis op = attrs[i].getAccessorAnalysis();
            this.logger.debug((java.lang.Object)("    " + op.getJavaName() + "\n                " + op.getIDLName()));
            this.homeMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
            op = attrs[i].getMutatorAnalysis();
            if (op == null) continue;
            this.logger.debug((java.lang.Object)("    " + op.getJavaName() + "\n                " + op.getIDLName()));
            this.homeMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
        }
        ops = interfaceAnalysis.getOperations();
        for (i = 0; i < ops.length; ++i) {
            this.logger.debug((java.lang.Object)("    " + ops[i].getJavaName() + "\n                " + ops[i].getIDLName()));
            this.homeMethodMap.put(ops[i].getIDLName(), new SkeletonStrategy(ops[i].getMethod()));
        }
        this.homeRepositoryIds = interfaceAnalysis.getAllTypeIds();
        this.logger.debug((java.lang.Object)("container classloader: " + this.container.getClassLoader() + "\ncontainer parent classloader: " + this.container.getClassLoader().getParent()));
        WebClassLoader wcl = (WebClassLoader)this.container.getWebClassLoader();
        if (wcl != null && (codebaseString = wcl.getCodebaseString()) != null) {
            Any codebase = this.orb.create_any();
            codebase.insert_string(codebaseString);
            this.codebasePolicy = this.orb.create_policy(305419896, codebase);
            this.logger.debug((java.lang.Object)("codebasePolicy: " + this.codebasePolicy));
        } else {
            this.logger.debug((java.lang.Object)"Not setting codebase policy, codebase is null");
        }
        Any secPolicy = this.orb.create_any();
        IorSecurityConfigMetaData securityConfig = this.container.getBeanMetaData().getIorSecurityConfigMetaData();
        if (securityConfig == null) {
            securityConfig = (IorSecurityConfigMetaData)Registry.lookup((java.lang.Object)CorbaORBService.IOR_SECURITY_CONFIG);
        }
        secPolicy.insert_Value((Serializable)securityConfig);
        this.csiv2Policy = this.orb.create_policy(-2023406815, secPolicy);
        boolean sslRequired = false;
        if (securityConfig != null) {
            IorSecurityConfigMetaData.TransportConfig tc = securityConfig.getTransportConfig();
            sslRequired = tc.getIntegrity() == "REQUIRED" || tc.getConfidentiality() == "REQUIRED" || tc.getEstablishTrustInClient() == "REQUIRED";
        }
        Any sslPolicyValue = this.orb.create_any();
        SSLPolicyValueHelper.insert((Any)sslPolicyValue, (SSLPolicyValue)(sslRequired ? SSLPolicyValue.SSL_REQUIRED : SSLPolicyValue.SSL_NOT_REQUIRED));
        this.sslPolicy = this.orb.create_policy(101, sslPolicyValue);
        this.logger.debug((java.lang.Object)("container's SSL policy: " + this.sslPolicy));
        this.poaCurrent = CurrentHelper.narrow((Object)this.orb.resolve_initial_references("POACurrent"));
    }

    public void start() throws Exception {
        ServantRegistryKind registryWithPersistentPOA;
        ServantRegistryKind registryWithTransientPOA;
        ObjectName oname = new ObjectName(this.invokerMetaData.getInvokerMBean());
        this.servantRegistries = (ServantRegistries)Registry.lookup((java.lang.Object)oname);
        if (this.servantRegistries == null) {
            throw new Exception("invoker is null: " + oname);
        }
        Policy[] policies = null;
        policies = this.codebasePolicy == null ? new Policy[]{this.sslPolicy, this.csiv2Policy} : new Policy[]{this.codebasePolicy, this.sslPolicy, this.csiv2Policy};
        Element proxyFactoryConfig = this.invokerMetaData.getProxyFactoryConfig();
        String poaUsageModel = MetaData.getOptionalChildContent((Element)proxyFactoryConfig, (String)"poa");
        if (poaUsageModel == null || poaUsageModel.equals("shared")) {
            registryWithTransientPOA = ServantRegistryKind.SHARED_TRANSIENT_POA;
            registryWithPersistentPOA = ServantRegistryKind.SHARED_PERSISTENT_POA;
        } else if (poaUsageModel.equals("per-servant")) {
            registryWithTransientPOA = ServantRegistryKind.TRANSIENT_POA_PER_SERVANT;
            registryWithPersistentPOA = ServantRegistryKind.PERSISTENT_POA_PER_SERVANT;
        } else {
            throw new Exception("invalid poa element in proxy factory config: " + poaUsageModel);
        }
        InterfaceDef homeInterfaceDef = null;
        if (this.iri != null) {
            Repository ir = this.iri.getReference();
            homeInterfaceDef = InterfaceDefHelper.narrow((Object)ir.lookup_id(this.homeRepositoryIds[0]));
        }
        this.homeServantRegistry = this.servantRegistries.getServantRegistry(registryWithPersistentPOA);
        String homeServantLoggerName = EjbHomeCorbaServant.class.getName() + '.' + this.jndiName;
        EjbHomeCorbaServant homeServant = new EjbHomeCorbaServant(this.container.getJmxName(), this.container.getClassLoader(), this.homeMethodMap, this.homeRepositoryIds, homeInterfaceDef, Logger.getLogger((String)homeServantLoggerName));
        this.homeReferenceFactory = this.homeServantRegistry.bind(IORFactory.homeServantName(this.jndiName), homeServant, policies);
        Object corbaRef = this.homeReferenceFactory.createReference(this.homeRepositoryIds[0]);
        this.ejbHome = (EJBHome)PortableRemoteObject.narrow((java.lang.Object)corbaRef, EJBHome.class);
        homeServant.setHomeHandle(new HomeHandleImplIIOP(this.ejbHome));
        if (this.container.getBeanMetaData() instanceof EntityMetaData) {
            Class<?> pkClass;
            this.beanServantRegistry = this.servantRegistries.getServantRegistry(registryWithPersistentPOA);
            EntityMetaData metaData = (EntityMetaData)this.container.getBeanMetaData();
            String pkClassName = metaData.getPrimaryKeyClass();
            try {
                pkClass = pkClassName != null ? this.container.getClassLoader().loadClass(pkClassName) : this.container.getClassLoader().loadClass(metaData.getEjbClass()).getField(metaData.getPrimKeyField()).getClass();
            }
            catch (NoSuchFieldException e) {
                this.logger.error((java.lang.Object)"Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field? Does that field exist?");
                throw new Exception("Primary Key Problem");
            }
            catch (NullPointerException e) {
                this.logger.error((java.lang.Object)"Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field? Does that field exist?");
                throw new Exception("Primary Key Problem");
            }
            this.ejbMetaData = new EJBMetaDataImplIIOP(((EJBProxyFactoryContainer)this.container).getRemoteClass(), ((EJBProxyFactoryContainer)this.container).getHomeClass(), pkClass, false, false, this.ejbHome);
        } else {
            this.beanServantRegistry = this.servantRegistries.getServantRegistry(registryWithTransientPOA);
            this.ejbMetaData = ((SessionMetaData)this.container.getBeanMetaData()).isStateless() ? new EJBMetaDataImplIIOP(((EJBProxyFactoryContainer)this.container).getRemoteClass(), ((EJBProxyFactoryContainer)this.container).getHomeClass(), null, true, true, this.ejbHome) : new EJBMetaDataImplIIOP(((EJBProxyFactoryContainer)this.container).getRemoteClass(), ((EJBProxyFactoryContainer)this.container).getHomeClass(), null, true, false, this.ejbHome);
        }
        InterfaceDef beanInterfaceDef = null;
        if (this.iri != null) {
            Repository ir = this.iri.getReference();
            beanInterfaceDef = InterfaceDefHelper.narrow((Object)ir.lookup_id(this.beanRepositoryIds[0]));
        }
        String beanServantLoggerName = EjbObjectCorbaServant.class.getName() + '.' + this.jndiName;
        EjbObjectCorbaServant beanServant = new EjbObjectCorbaServant(this.container.getJmxName(), this.container.getClassLoader(), this.poaCurrent, this.beanMethodMap, this.beanRepositoryIds, beanInterfaceDef, Logger.getLogger((String)beanServantLoggerName));
        this.beanReferenceFactory = this.beanServantRegistry.bind(IORFactory.beanServantName(this.jndiName), beanServant, policies);
        this.logger.info((java.lang.Object)("EJBHome reference for " + this.jndiName + ":\n" + this.orb.object_to_string((Object)this.ejbHome)));
        this.useJNPContext = MetaData.getOptionalChildBooleanContent((Element)proxyFactoryConfig, (String)"register-ejbs-in-jnp-context");
        InitialContext initialContext = new InitialContext();
        if (this.useJNPContext) {
            String jnpContext = MetaData.getOptionalChildContent((Element)proxyFactoryConfig, (String)"jnp-context");
            this.jnpName = jnpContext != null && !jnpContext.equals("") ? jnpContext + "/" + this.jndiName : this.jndiName;
            try {
                Util.rebind((Context)initialContext, (String)this.jnpName, (java.lang.Object)new Reference("javax.ejb.EJBHome", new StringRefAddr("IOR", this.orb.object_to_string((Object)this.ejbHome)), IIOPHomeFactory.class.getName(), null));
                this.logger.info((java.lang.Object)("Home IOR for " + this.container.getBeanMetaData().getEjbName() + " bound to " + this.jnpName + " in JNP naming service"));
            }
            catch (NamingException e) {
                throw new Exception("Cannot bind EJBHome in JNDI:\n" + e);
            }
        }
        NamingContextExt corbaContext = null;
        try {
            corbaContext = NamingContextExtHelper.narrow((Object)((Object)initialContext.lookup("java:/" + CorbaNamingService.NAMING_NAME)));
        }
        catch (NamingException e) {
            throw new Exception("Cannot lookup java:/" + CorbaNamingService.NAMING_NAME + ":\n" + e);
        }
        try {
            IORFactory.rebind(corbaContext, this.jndiName, (Object)this.ejbHome);
            this.logger.info((java.lang.Object)("Home IOR for " + this.container.getBeanMetaData().getEjbName() + " bound to " + this.jndiName + " in CORBA naming service"));
        }
        catch (Exception e) {
            this.logger.error((java.lang.Object)"Cannot bind EJBHome in CORBA naming service:", (Throwable)e);
            throw new Exception("Cannot bind EJBHome in CORBA naming service:\n" + e);
        }
    }

    public void stop() {
        try {
            InitialContext initialContext = new InitialContext();
            if (this.useJNPContext) {
                try {
                    initialContext.unbind(this.jnpName);
                }
                catch (NamingException namingException) {
                    this.logger.error((java.lang.Object)"Cannot unbind EJBHome from JNDI", (Throwable)namingException);
                }
            }
            NamingContextExt corbaContext = NamingContextExtHelper.narrow((Object)((Object)initialContext.lookup("java:/" + CorbaNamingService.NAMING_NAME)));
            try {
                NameComponent[] name = corbaContext.to_name(this.jndiName);
                corbaContext.unbind(name);
            }
            catch (InvalidName invalidName) {
                this.logger.error((java.lang.Object)"Cannot unregister EJBHome from CORBA naming service", (Throwable)invalidName);
            }
            catch (NotFound notFound) {
                this.logger.error((java.lang.Object)"Cannot unregister EJBHome from CORBA naming service", (Throwable)notFound);
            }
            catch (CannotProceed cannotProceed) {
                this.logger.error((java.lang.Object)"Cannot unregister EJBHome from CORBA naming service", (Throwable)cannotProceed);
            }
        }
        catch (NamingException namingException) {
            this.logger.error((java.lang.Object)"Unexpected error in JNDI lookup", (Throwable)namingException);
        }
        try {
            this.homeServantRegistry.unbind(IORFactory.homeServantName(this.jndiName));
        }
        catch (Exception e) {
            this.logger.error((java.lang.Object)"Cannot deactivate home servant", (Throwable)e);
        }
        try {
            this.beanServantRegistry.unbind(IORFactory.beanServantName(this.jndiName));
        }
        catch (Exception e) {
            this.logger.error((java.lang.Object)"Cannot deactivate bean servant", (Throwable)e);
        }
        if (this.iri != null) {
            this.iri.shutdown();
        }
    }

    public void destroy() {
    }

    public void setInvokerMetaData(InvokerProxyBindingMetaData imd) {
        this.invokerMetaData = imd;
    }

    public void setInvokerBinding(String binding) {
        this.jndiName = binding;
    }

    public boolean isIdentical(Container container, Invocation mi) {
        EJBObject me;
        EJBObject other = (EJBObject)mi.getArguments()[0];
        if (other == null) {
            return false;
        }
        if (container instanceof StatelessSessionContainer) {
            me = (EJBObject)this.getStatelessSessionEJBObject();
        } else if (container instanceof StatefulSessionContainer) {
            me = (EJBObject)this.getStatefulSessionEJBObject(mi.getId());
        } else if (container instanceof EntityContainer) {
            me = (EJBObject)this.getEntityEJBObject(mi.getId());
        } else {
            return false;
        }
        Stub meStub = (Stub)me;
        Stub otherStub = (Stub)other;
        return meStub._is_equivalent((Object)otherStub);
    }

    public EJBMetaData getEJBMetaData() {
        return this.ejbMetaData;
    }

    public java.lang.Object getEJBHome() {
        return this.ejbHome;
    }

    public java.lang.Object getStatelessSessionEJBObject() {
        try {
            return (EJBObject)PortableRemoteObject.narrow((java.lang.Object)this.beanReferenceFactory.createReference(this.beanRepositoryIds[0]), EJBObject.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create reference to EJBObject\n" + e);
        }
    }

    public java.lang.Object getStatefulSessionEJBObject(java.lang.Object id) {
        try {
            return (EJBObject)PortableRemoteObject.narrow((java.lang.Object)this.beanReferenceFactory.createReferenceWithId(id, this.beanRepositoryIds[0]), EJBObject.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create reference to EJBObject\n" + e);
        }
    }

    public java.lang.Object getEntityEJBObject(java.lang.Object id) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((java.lang.Object)("getEntityEJBObject(), id class is " + id.getClass().getName()));
        }
        try {
            EJBObject ejbObject = id == null ? null : (EJBObject)PortableRemoteObject.narrow((java.lang.Object)this.beanReferenceFactory.createReferenceWithId(id, this.beanRepositoryIds[0]), EJBObject.class);
            return ejbObject;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create reference to EJBObject\n" + e);
        }
    }

    public Collection getEntityCollection(Collection ids) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((java.lang.Object)"entering getEntityCollection()");
        }
        ArrayList<java.lang.Object> collection = new ArrayList<java.lang.Object>(ids.size());
        Iterator idEnum = ids.iterator();
        while (idEnum.hasNext()) {
            collection.add(this.getEntityEJBObject(idEnum.next()));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((java.lang.Object)"leaving getEntityCollection()");
        }
        return collection;
    }

    public static String rmiRepositoryId(Class clz) {
        return "RMI:" + clz.getName() + ":0000000000000000";
    }

    public static void rebind(NamingContextExt ctx, String strName, Object obj) throws Exception {
        NameComponent[] name = ctx.to_name(strName);
        NamingContextExt intermediateCtx = ctx;
        for (int i = 0; i < name.length - 1; ++i) {
            NameComponent[] relativeName = new NameComponent[]{name[i]};
            try {
                intermediateCtx = NamingContextHelper.narrow((Object)intermediateCtx.resolve(relativeName));
                continue;
            }
            catch (NotFound e) {
                intermediateCtx = intermediateCtx.bind_new_context(relativeName);
            }
        }
        intermediateCtx.rebind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    private static String homeServantName(String jndiName) {
        return "EJBHome/" + jndiName;
    }

    private static String beanServantName(String jndiName) {
        return "EJBObject/" + jndiName;
    }
}

