/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.naming.NameNotFoundException;
import org.jboss.ejb3.annotation.IgnoreDependency;
import org.jboss.injection.EJBInjectionContainer;
import org.jboss.injection.EJBInjectionHandler;
import org.jboss.injection.EjbEncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.AbstractEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;

public class EJBRemoteHandler<X extends RemoteEnvironment>
extends EJBInjectionHandler<X> {
    private static final Logger log = Logger.getLogger(EJBRemoteHandler.class);

    @Override
    public void loadXml(X xml, InjectionContainer container) {
        if (xml != null) {
            log.trace((Object)("ejbRefs = " + xml.getEjbReferences()));
            if (xml.getEjbReferences() != null) {
                this.loadEjbRefXml((Collection<EJBReferenceMetaData>)xml.getEjbReferences(), container);
            }
        }
    }

    protected void loadEjbRefXml(Collection<EJBReferenceMetaData> refs, InjectionContainer container) {
        for (EJBReferenceMetaData ref : refs) {
            String interfaceName = ref.getRemote();
            String errorType = "<ejb-ref>";
            this.ejbRefXml((AbstractEJBReferenceMetaData)ref, interfaceName, container, errorType);
        }
    }

    protected void ejbRefXml(AbstractEJBReferenceMetaData ref, String interfaceName, InjectionContainer container, String errorType) {
        String link;
        String encName = "env/" + ref.getEjbRefName();
        InjectionUtil.injectionTarget(encName, (ResourceInjectionMetaData)ref, container, container.getEncInjections());
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        String mappedName = ref.getMappedName();
        if (mappedName != null && mappedName.equals("")) {
            mappedName = null;
        }
        if (mappedName == null && ref.getResolvedJndiName() != null) {
            mappedName = ref.getResolvedJndiName();
        }
        if ((link = ref.getLink()) != null && link.trim().equals("")) {
            link = null;
        }
        Class<?> refClass = null;
        if (interfaceName != null) {
            try {
                refClass = container.getClassloader().loadClass(interfaceName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("could not find " + errorType + "'s local interface " + interfaceName + " in " + container.getDeploymentDescriptorType() + " of " + container.getIdentifier());
            }
        }
        if (mappedName != null || refClass != null || link != null) {
            this.ejbRefEncInjector(mappedName, encName, null, refClass, link, errorType, container);
            if (ref.getIgnoreDependency() != null) {
                log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + encName));
                return;
            }
            this.ejbRefDependency(mappedName, link, container, refClass, errorType, encName);
        }
    }

    protected void ejbRefDependency(String mappedName, String link, InjectionContainer container, Class<?> refClass, String errorType, String encName) {
        if (mappedName != null && mappedName.length() == 0) {
            mappedName = null;
        }
        if (refClass != null && (refClass.equals(Object.class) || refClass.equals(Void.TYPE))) {
            refClass = null;
        }
        if (container instanceof EJBInjectionContainer) {
            if (((EJBInjectionContainer)((Object)container)).canResolveEJB()) {
                this.addJNDIDependency(container, ((EJBInjectionContainer)((Object)container)).resolveEJB(link, refClass, null));
                return;
            }
            log.warn((Object)("EJBTHREE-1828: EJBInjectionContainer " + container + " is unconfigured, using legacy resolve"));
        }
        if (mappedName == null) {
            mappedName = EJBRemoteHandler.getMappedName(encName, container);
        }
        if (mappedName != null) {
            this.addJNDIDependency(container, mappedName);
            return;
        }
        if (refClass != null) {
            if (link != null && !link.trim().equals("")) {
                this.addDependency(container, link, refClass);
            } else {
                this.addDependency(container, refClass);
            }
        } else {
            String msg = "IGNORING DEPENDENCY: unable to resolve dependency of EJB, there is too little information";
            log.warn((Object)msg);
        }
    }

    protected void ejbRefEncInjector(String mappedName, String encName, String fieldName, Class refClass, String link, String errorType, InjectionContainer container) {
        if (refClass != null && (refClass.equals(Object.class) || refClass.equals(Void.TYPE))) {
            refClass = null;
        }
        if (mappedName != null && mappedName.trim().equals("")) {
            mappedName = null;
        }
        if (container instanceof EJBInjectionContainer) {
            if (((EJBInjectionContainer)((Object)container)).canResolveEJB()) {
                mappedName = ((EJBInjectionContainer)((Object)container)).resolveEJB(link, refClass, null);
                if (mappedName == null) {
                    throw new IllegalStateException("unable to resolve " + link + " " + refClass);
                }
            } else {
                log.warn((Object)("EJBTHREE-1828: EJBInjectionContainer " + container + " is unconfigured, using legacy resolve"));
            }
        }
        if (mappedName == null) {
            mappedName = EJBRemoteHandler.getMappedName(encName, container, fieldName);
        }
        EjbEncInjector injector = null;
        if (mappedName == null) {
            log.warn((Object)("EJBTHREE-1289: Using legacy EjbEncInjector, because mappedName for enc \"" + encName + "\", field \"" + fieldName + "\" is null (container.environmentRefGroup.annotatedEjbReferences = " + container.getEnvironmentRefGroup().getAnnotatedEjbReferences() + ")"));
            injector = new EjbEncInjector(encName, refClass, link, errorType);
        } else {
            injector = new EjbEncInjector(encName, mappedName, errorType);
        }
        container.getEncInjectors().put(encName, injector);
    }

    public static String getJndiName(EJB ref, InjectionContainer container, Class<?> memberType) {
        String jndiName;
        if (ref.mappedName() != null && !"".equals(ref.mappedName())) {
            return ref.mappedName();
        }
        if (ref.beanName().equals("") && memberType == null) {
            throw new RuntimeException("For deployment " + container.getIdentifier() + "not enough information for @EJB.  Please fill out the beanName and/or businessInterface attributes");
        }
        Class businessInterface = memberType;
        if (!ref.beanInterface().getName().equals(Object.class.getName())) {
            businessInterface = ref.beanInterface();
        }
        if (ref.beanName().equals("")) {
            try {
                jndiName = container.getEjbJndiName(businessInterface);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ") " + e.getMessage());
            }
            if (jndiName == null) {
                throw new RuntimeException("For deployment " + container.getIdentifier() + " could not find jndi binding based on interface only for @EJB(" + businessInterface.getName() + ")");
            }
        } else {
            jndiName = container.getEjbJndiName(ref.beanName(), businessInterface);
            if (jndiName == null) {
                throw new RuntimeException("For EJB " + container.getIdentifier() + "could not find jndi binding based on beanName and business interface for @EJB(" + ref.beanName() + ", " + businessInterface.getName() + ")");
            }
        }
        return jndiName;
    }

    private static String getMappedName(String encName, InjectionContainer container) {
        return EJBRemoteHandler.getMappedName(encName, container, null);
    }

    private static String getMappedName(String encName, InjectionContainer container, String fieldName) {
        String mappedName = null;
        String lookupName = encName;
        assert (lookupName.startsWith("env/")) : "encName used to start with 'env/'";
        lookupName = lookupName.substring(4);
        AnnotatedEJBReferencesMetaData amds = container.getEnvironmentRefGroup().getAnnotatedEjbReferences();
        if (amds != null) {
            AnnotatedEJBReferenceMetaData amd = (AnnotatedEJBReferenceMetaData)amds.get(lookupName);
            if (amd == null && fieldName != null) {
                lookupName = fieldName;
                amd = (AnnotatedEJBReferenceMetaData)amds.get(lookupName);
            }
            if (amd != null && (mappedName = amd.getMappedName()) == null) {
                mappedName = amd.getResolvedJndiName();
            }
        }
        return mappedName;
    }

    @Override
    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        EJB ejbref;
        EJBs ref = container.getAnnotation(EJBs.class, clazz);
        if (ref != null) {
            EJB[] ejbs;
            for (EJB ejb : ejbs = ref.value()) {
                this.handleClassAnnotation(ejb, clazz, container);
            }
        }
        if ((ejbref = container.getAnnotation(EJB.class, clazz)) != null) {
            this.handleClassAnnotation(ejbref, clazz, container);
        }
    }

    protected void handleClassAnnotation(EJB ejb, Class<?> clazz, InjectionContainer container) {
        String encName = ejb.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires the name of the @EJB in the @EJBs: " + clazz);
        }
        encName = "env/" + encName;
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        this.ejbRefEncInjector(ejb.mappedName(), encName, null, ejb.beanInterface(), ejb.beanName(), "@EJB", container);
        if (this.isIgnoreDependency(container, ejb)) {
            log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + encName));
        } else {
            this.ejbRefDependency(ejb.mappedName(), ejb.beanName(), container, ejb.beanInterface(), "@EJB", encName);
        }
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        EJB ref = container.getAnnotation(EJB.class, method);
        if (ref != null) {
            if (!method.getName().startsWith("set")) {
                throw new RuntimeException("@EJB can only be used with a set method: " + method);
            }
            String encName = this.getEncName(ref, method);
            if (!container.getEncInjectors().containsKey(encName)) {
                Class businessInterface = method.getParameterTypes()[0];
                if (ref.beanInterface() != null && ref.beanInterface() != Object.class) {
                    businessInterface = ref.beanInterface();
                }
                this.ejbRefEncInjector(ref.mappedName(), encName, method.getName().substring(0), businessInterface, ref.beanName(), "@EJB", container);
                if (container.getAnnotation(IgnoreDependency.class, method) == null) {
                    if (this.isIgnoreDependency(container, ref)) {
                        log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + encName));
                    } else {
                        this.ejbRefDependency(ref.mappedName(), ref.beanName(), container, businessInterface, "@EJB", encName);
                    }
                }
            }
            super.handleMethodAnnotations(method, container, injectors);
        }
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        EJB ref = container.getAnnotation(EJB.class, field);
        if (ref != null) {
            String encName = this.getEncName(ref, field);
            if (!container.getEncInjectors().containsKey(encName)) {
                Class businessInterface = field.getType();
                if (ref.beanInterface() != null && ref.beanInterface() != Object.class) {
                    businessInterface = ref.beanInterface();
                }
                if (container.getAnnotation(IgnoreDependency.class, field) == null) {
                    if (this.isIgnoreDependency(container, ref)) {
                        log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + encName));
                    } else {
                        this.ejbRefDependency(ref.mappedName(), ref.beanName(), container, businessInterface, "@EJB", encName);
                    }
                }
                this.ejbRefEncInjector(ref.mappedName(), encName, field.getName(), businessInterface, ref.beanName(), "@EJB", container);
            }
            super.handleFieldAnnotations(field, container, injectors);
        }
    }

    protected boolean isIgnoreDependency(InjectionContainer container, EJB ref) {
        RemoteEnvironment refGroup = container.getEnvironmentRefGroup();
        if (refGroup != null && refGroup.getEjbReferences() != null) {
            for (EJBReferenceMetaData ejbRef : refGroup.getEjbReferences()) {
                if (!ejbRef.getEjbRefName().equals(ref.name())) continue;
                return ejbRef.getIgnoreDependency() != null;
            }
        }
        return false;
    }
}

