/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.property;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.Strings;
import org.jboss.util.property.Property;
import org.jboss.util.property.PropertyGroup;
import org.jboss.util.property.PropertyListener;
import org.jboss.varia.property.SystemPropertiesServiceMBean;

public class SystemPropertiesService
extends ServiceMBeanSupport
implements SystemPropertiesServiceMBean {
    protected String serverHome;

    public String set(String name, String value) {
        return Property.set((String)name, (String)value);
    }

    public String get(String name, String defaultValue) {
        return Property.get((String)name, (String)defaultValue);
    }

    public String get(String name) {
        return Property.get((String)name);
    }

    public String remove(String name) {
        return Property.remove((String)name);
    }

    public List getArray(String base, List defaultValues) {
        String[] array = new String[defaultValues.size()];
        defaultValues.toArray(array);
        String[] values = Property.getArray((String)base, (String[])array);
        return Arrays.asList(values);
    }

    public List getArray(String name) {
        String[] array = Property.getArray((String)name);
        return Arrays.asList(array);
    }

    public boolean exists(String name) {
        return Property.exists((String)name);
    }

    public PropertyGroup getGroup(String basename) {
        return Property.getGroup((String)basename);
    }

    public PropertyGroup getGroup(String basename, int index) {
        return Property.getGroup((String)basename, (int)index);
    }

    public void addListener(PropertyListener listener) {
        Property.addListener((PropertyListener)listener);
    }

    public void addListeners(PropertyListener[] listeners) {
        Property.addListeners((PropertyListener[])listeners);
    }

    public boolean removeListener(PropertyListener listener) {
        return Property.removeListener((PropertyListener)listener);
    }

    public void load(URL url) throws IOException {
        this.log.trace((Object)("Loading system properties from: " + url));
        Properties props = System.getProperties();
        InputStream is = url.openConnection().getInputStream();
        props.load(is);
        is.close();
        this.log.info((Object)("Loaded system properties from: " + url));
    }

    public void load(String url) throws IOException, MalformedURLException {
        this.load(Strings.toURL((String)url, (String)this.serverHome));
    }

    public void addListener(String typename) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> type = Class.forName(typename);
        PropertyListener listener = (PropertyListener)type.newInstance();
        this.addListener(listener);
    }

    public void setURLList(String list) throws MalformedURLException, IOException {
        StringTokenizer stok = new StringTokenizer(list, ",");
        while (stok.hasMoreTokens()) {
            String url = stok.nextToken();
            this.load(url);
        }
    }

    public void setProperties(Properties props) throws IOException {
        this.log.debug((Object)("Merging with system properties: " + props));
        System.getProperties().putAll((Map<?, ?>)props);
    }

    public Map showAll() {
        return new HTMLMap((Map)System.getProperties());
    }

    public Map showGroup(String basename) {
        return new HTMLMap((Map)this.getGroup(basename));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.serverHome = new File(ServerConfigLocator.locate().getServerHomeLocation().toURI()).getPath();
        return super.preRegister(server, name);
    }

    protected static class HTMLMap
    extends HashMap {
        public HTMLMap(Map map) {
            super(map);
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("<table>");
            TreeSet keys = new TreeSet(this.keySet());
            for (String key : keys) {
                buff.append("<tr><td align=\"left\"><b>").append(key).append("</b></td><td align=\"left\">").append(this.get(key)).append("</td></tr>\n\r");
            }
            buff.append("</table>");
            return buff.toString();
        }
    }
}

