/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.descriptor.plugin.SubCategoryDescriptor;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.StringUtils;

public class SubCategoriesMetadataParser {
    public static ResourceSubCategory getSubCategory(SubCategoryDescriptor descriptor, ResourceType resourceType) {
        ResourceSubCategory subCat = new ResourceSubCategory();
        subCat.setName(descriptor.getName());
        if (descriptor.getDisplayName() != null) {
            subCat.setDisplayName(descriptor.getDisplayName());
        } else {
            subCat.setDisplayName(StringUtils.deCamelCase((String)descriptor.getName()));
        }
        subCat.setDescription(descriptor.getDescription());
        List<SubCategoryDescriptor> childDescriptors = descriptor.getSubcategory();
        if (childDescriptors != null) {
            for (SubCategoryDescriptor childDescriptor : childDescriptors) {
                subCat.addChildSubCategory(SubCategoriesMetadataParser.getSubCategory(childDescriptor, resourceType));
            }
        }
        return subCat;
    }

    @Nullable
    public static ResourceSubCategory findSubCategoryOnResourceTypeAncestor(@NotNull ResourceType resourceType, @Nullable String subCategoryName) {
        ResourceSubCategory selectedSubCategory = null;
        if (subCategoryName != null) {
            Set parents = resourceType.getParentResourceTypes();
            for (ResourceType parent : parents) {
                List ownedSubCategories = parent.getChildSubCategories();
                if (ownedSubCategories != null) {
                    for (ResourceSubCategory ownedSubCategory : ownedSubCategories) {
                        selectedSubCategory = SubCategoriesMetadataParser.findSubCategoryOnSubCategoryDescendant(ownedSubCategory, subCategoryName);
                        if (selectedSubCategory == null) continue;
                        return selectedSubCategory;
                    }
                }
                if ((selectedSubCategory = SubCategoriesMetadataParser.findSubCategoryOnResourceTypeAncestor(parent, subCategoryName)) == null) continue;
                break;
            }
        }
        return selectedSubCategory;
    }

    @Nullable
    private static ResourceSubCategory findSubCategoryOnSubCategoryDescendant(@NotNull ResourceSubCategory parentSubCategory, @NotNull String subCategoryName) {
        ResourceSubCategory childSubCategory;
        ResourceSubCategory selectedSubCategory = null;
        if (parentSubCategory.getName().equals(subCategoryName)) {
            selectedSubCategory = parentSubCategory;
            return selectedSubCategory;
        }
        Iterator i$ = parentSubCategory.getChildSubCategories().iterator();
        while (i$.hasNext() && (selectedSubCategory = SubCategoriesMetadataParser.findSubCategoryOnSubCategoryDescendant(childSubCategory = (ResourceSubCategory)i$.next(), subCategoryName)) == null) {
        }
        return selectedSubCategory;
    }
}

