/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.jaxws;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.security.Constants;
import org.jboss.ws.extensions.security.WSSecurityDispatcher;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.common.handler.GenericSOAPHandler;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public abstract class WSSecurityHandler
extends GenericSOAPHandler {
    private static Logger log = Logger.getLogger(WSSecurityHandler.class);
    private static Set<QName> headers;

    public Set<QName> getHeaders() {
        return headers;
    }

    protected boolean handleInboundSecurity(MessageContext msgContext) {
        try {
            WSSecurityConfiguration configuration = this.getSecurityConfiguration(msgContext);
            if (configuration != null) {
                CommonMessageContext ctx = (CommonMessageContext)msgContext;
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                new WSSecurityDispatcher().decodeMessage(configuration, soapMessage, null);
            }
        }
        catch (SOAPException ex) {
            log.error((Object)"Cannot handle inbound ws-security", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean handleOutboundSecurity(MessageContext msgContext) {
        try {
            WSSecurityConfiguration configuration = this.getSecurityConfiguration(msgContext);
            if (configuration != null) {
                CommonMessageContext ctx = (CommonMessageContext)msgContext;
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                String user = (String)ctx.get("javax.xml.ws.security.auth.username");
                String pass = (String)ctx.get("javax.xml.ws.security.auth.password");
                new WSSecurityDispatcher().encodeMessage(configuration, soapMessage, null, user, pass);
            }
        }
        catch (SOAPException ex) {
            log.error((Object)"Cannot handle outbound ws-security", (Throwable)ex);
            return false;
        }
        return true;
    }

    private WSSecurityConfiguration getSecurityConfiguration(MessageContext msgContext) {
        EndpointMetaData epMetaData = ((CommonMessageContext)msgContext).getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        if (serviceMetaData.getSecurityConfiguration() == null) {
            UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
            WSSecurityConfiguration config = null;
            try {
                WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
                config = wsseConfFactory.createConfiguration(vfsRoot, this.getConfigResourceName());
            }
            catch (IOException ex) {
                WSException.rethrow("Cannot load ws-security config", ex);
            }
            serviceMetaData.setSecurityConfiguration(config);
        }
        return serviceMetaData.getSecurityConfiguration();
    }

    protected abstract String getConfigResourceName();

    static {
        HashSet<QName> set = new HashSet<QName>();
        set.add(Constants.WSSE_HEADER_QNAME);
        headers = Collections.unmodifiableSet(set);
    }
}

