/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.env.bda;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.classloading.ResourceLookupProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;
import org.jboss.weld.integration.deployer.env.bda.Archive;
import org.jboss.weld.integration.deployer.env.bda.ArchiveFactory;
import org.jboss.weld.integration.deployer.env.bda.ArchiveInfo;
import org.jboss.weld.integration.deployer.env.bda.LibraryArchivesProvider;
import org.jboss.weld.integration.deployer.env.bda.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryDiscoveryService
implements LibraryArchivesProvider {
    private ResourceLookupProvider<Module> provider;
    private Iterable<URL> excludedUrls;
    private Set<Archive> libs;
    private AtomicBoolean checked = new AtomicBoolean();

    public LibraryDiscoveryService(ResourceLookupProvider<Module> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        this.provider = provider;
    }

    @Override
    public synchronized Set<Archive> getLibraries() throws Exception {
        if (this.libs == null || !this.checked.get()) {
            this.libs = new HashSet<Archive>();
            ArrayList<VirtualFile> excludedFiles = null;
            Map modules = this.provider.getMatchingModules();
            for (Map.Entry entry : modules.entrySet()) {
                ClassLoader cl;
                Set urls = (Set)entry.getValue();
                if (this.excludedUrls != null && excludedFiles == null) {
                    excludedFiles = new ArrayList<VirtualFile>();
                    for (URL eu : this.excludedUrls) {
                        excludedFiles.add(VFS.getChild((URL)eu));
                    }
                }
                HashSet<VirtualFile> files = new HashSet<VirtualFile>();
                for (URL u : urls) {
                    VirtualFile vf = VFS.getChild((URL)u);
                    boolean include = true;
                    if (excludedFiles != null) {
                        for (VirtualFile ef : excludedFiles) {
                            if (!vf.getParentFileList().contains(ef)) continue;
                            include = false;
                            break;
                        }
                    }
                    if (!include) continue;
                    files.add(vf);
                }
                if (files.isEmpty() || (cl = SecurityActions.getClassLoaderForModule((Module)entry.getKey())) == null) continue;
                ArchiveInfo archiveInfo = new ArchiveInfo(cl, Collections.<String>emptyList());
                Archive archive = ArchiveFactory.createArchive(archiveInfo, new ArrayList());
                BeanDeploymentArchive bda = archive.createBeanDeploymentArchive(NoopServiceRegistry.INSTANCE);
                if (bda != null) {
                    this.libs.add(archive);
                }
                WeldDiscoveryEnvironment environment = archiveInfo.getEnvironment();
                ResourceVisitor visitor = environment.visitor();
                Module module = (Module)entry.getKey();
                for (VirtualFile child : files) {
                    URL beansXmlURL = child.getChild(this.provider.getResourceName()).toURL();
                    environment.addWeldXmlURL(beansXmlURL);
                    module.visit(visitor, (ResourceFilter)ClassFilter.INSTANCE, null, new URL[]{child.toURL()});
                }
            }
            this.checked.set(true);
        }
        return this.libs;
    }

    public synchronized void refresh() {
        this.checked.set(false);
    }

    public void setExcludedUrls(Iterable<URL> excludedUrls) {
        this.excludedUrls = excludedUrls;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoopServiceRegistry
    implements ServiceRegistry {
        private static ServiceRegistry INSTANCE = new NoopServiceRegistry();

        private NoopServiceRegistry() {
        }

        public <S extends Service> void add(Class<S> type, S service) {
        }

        public void addAll(Collection<Map.Entry<Class<? extends Service>, Service>> services) {
        }

        public Set<Map.Entry<Class<? extends Service>, Service>> entrySet() {
            return Collections.emptySet();
        }

        public <S extends Service> S get(Class<S> type) {
            return null;
        }

        public <S extends Service> boolean contains(Class<S> type) {
            return true;
        }

        public void cleanup() {
        }

        public Iterator<Service> iterator() {
            return Collections.emptyList().iterator();
        }
    }
}

