/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.converter;

import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.rhq.core.template.TemplateEngine;

public class PropertySimpleValueConverter
implements Converter,
Serializable {
    TemplateEngine engine = null;
    public static final String NULL_INPUT_VALUE = " ";

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    public PropertySimpleValueConverter(TemplateEngine engine) {
        this.engine = engine;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String string) {
        if (this.engine != null && string != null) {
            string = this.engine.replaceTokens(string);
        }
        String object = NULL_INPUT_VALUE.equals(string) ? null : string;
        PropertySimpleValueConverter.validateEmptyString(context, component, string);
        return object;
    }

    public String getAsString(FacesContext facesContext, UIComponent component, Object object) {
        String string = (String)object;
        return string;
    }

    private static void validateEmptyString(FacesContext context, UIComponent component, String string) {
        UIInput input = (UIInput)component;
        if (input.isValid() && string != null && string.length() == 0 && input.getValidators() != null) {
            for (Validator validator : input.getValidators()) {
                try {
                    validator.validate(context, (UIComponent)input, (Object)string);
                }
                catch (ValidatorException ve) {
                    FacesMessage message;
                    input.setValid(false);
                    String validatorMessageString = input.getValidatorMessage();
                    if (null != validatorMessageString) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessageString, validatorMessageString);
                        message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    } else {
                        message = ve.getFacesMessage();
                    }
                    if (message == null) continue;
                    context.addMessage(input.getClientId(context), message);
                }
            }
        }
    }
}

