/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.server;

import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.RemoteInvocation;
import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;
import org.jboss.remoting.samples.chat.utility.ShutDownGate;

public class CallbackThread
extends Thread {
    protected static final Logger log = Logger.getLogger(CallbackThread.class);
    private InvokerCallbackHandler callbackHandler;
    private ShutDownGate shutDownGate;
    private boolean memberLeaving;
    private ReadWriteArrayList messages;
    private int backChatSize;

    public CallbackThread(InvokerCallbackHandler callbackHandler, ShutDownGate shutDownGate, ReadWriteArrayList messages) {
        this.callbackHandler = callbackHandler;
        this.memberLeaving = false;
        this.shutDownGate = shutDownGate;
        this.messages = messages;
        this.backChatSize = messages.size();
        ArrayList backChat = new ArrayList(this.backChatSize);
        backChat = messages.copy();
        RemoteInvocation invocation = new RemoteInvocation("sendMultiple", new Object[]{backChat});
        Callback callback = new Callback(invocation);
        try {
            callbackHandler.handleCallback(callback);
        }
        catch (HandleCallbackException e) {
            log.error((Object)e);
        }
    }

    public void setMemberLeaving() {
        this.memberLeaving = true;
    }

    @Override
    public void run() {
        int i = this.backChatSize;
        while (!this.shutDownGate.isShuttingDown() && !this.memberLeaving) {
            RemoteInvocation invocation = new RemoteInvocation("send", new Object[]{this.messages.get(i)});
            Callback callback = new Callback(invocation);
            try {
                this.callbackHandler.handleCallback(callback);
            }
            catch (HandleCallbackException e) {
                log.error((Object)e);
            }
            ++i;
        }
    }
}

