/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3IllegalFormatException;
import de.vdheide.mp3.NoID3TagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3 {
    private final String encoding = "Cp437";
    private File mp3_file = null;
    private String title = null;
    private String artist = null;
    private String album = null;
    private String year = null;
    private Byte genre = null;
    private String comment = null;
    private Byte track = null;

    public ID3(File mp3_file) {
        this.mp3_file = mp3_file;
    }

    public String getTitle() throws NoID3TagException {
        try {
            this.checkIfRead(this.title);
        }
        catch (IOException e) {
            throw new NoID3TagException();
        }
        return this.title;
    }

    public String getArtist() throws NoID3TagException {
        try {
            this.checkIfRead(this.artist);
        }
        catch (IOException e) {
            throw new NoID3TagException();
        }
        return this.artist;
    }

    public String getAlbum() throws NoID3TagException {
        try {
            this.checkIfRead(this.album);
        }
        catch (IOException e) {
            throw new NoID3TagException();
        }
        return this.album;
    }

    public String getYear() throws NoID3TagException {
        try {
            this.checkIfRead(this.year);
        }
        catch (IOException e) {
            throw new NoID3TagException();
        }
        return this.year;
    }

    public int getGenre() throws NoID3TagException {
        if (this.genre == null) {
            try {
                this.readTag();
            }
            catch (IOException e) {
                throw new NoID3TagException();
            }
        }
        return this.genre.byteValue();
    }

    public String getComment() throws NoID3TagException {
        try {
            this.checkIfRead(this.comment);
            return this.comment;
        }
        catch (IOException e) {
            throw new NoID3TagException();
        }
    }

    public int getTrack() throws NoID3TagException {
        if (this.track == null) {
            try {
                this.readTag();
            }
            catch (IOException e) {
                throw new NoID3TagException();
            }
        }
        return this.track.byteValue();
    }

    public void readTag() throws NoID3TagException, IOException {
        RandomAccessFile in = new RandomAccessFile(this.mp3_file, "r");
        if (!this.checkForTag()) {
            throw new NoID3TagException();
        }
        in.seek(in.length() - 125L);
        byte[] buffer = new byte[125];
        in.read(buffer, 0, 125);
        String tag = new String(buffer, 0, 125, "Cp437");
        this.title = tag.substring(0, 30).trim();
        this.artist = tag.substring(30, 60).trim();
        this.album = tag.substring(60, 90).trim();
        this.year = tag.substring(90, 94).trim();
        this.comment = tag.substring(94, 123).trim();
        this.track = new Byte((byte)tag.charAt(123));
        this.genre = new Byte((byte)tag.charAt(124));
        in.close();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTrack(int track) throws ID3IllegalFormatException {
        if (track < 0 || track > 255) {
            throw new ID3IllegalFormatException();
        }
        this.track = new Byte((byte)track);
    }

    public void setGenre(int genre) throws ID3IllegalFormatException {
        this.genre = new Byte((byte)genre);
    }

    public void writeTag() throws IOException {
        RandomAccessFile in = new RandomAccessFile(this.mp3_file, "rw");
        if (!this.checkForTag()) {
            in.seek(in.length());
        } else {
            in.seek(in.length() - 128L);
        }
        in.write(new String("TAG").getBytes("Cp437"));
        in.write(this.fillWithNills(this.title, 30).getBytes("Cp437"));
        in.write(this.fillWithNills(this.artist, 30).getBytes("Cp437"));
        in.write(this.fillWithNills(this.album, 30).getBytes("Cp437"));
        in.write(this.fillWithNills(this.year, 4).getBytes("Cp437"));
        in.write(this.fillWithNills(this.comment, 29).getBytes("Cp437"));
        if (this.track == null) {
            in.writeByte(0);
        } else {
            in.writeByte(this.track.byteValue());
        }
        if (this.genre == null) {
            in.writeByte(0);
        } else {
            in.writeByte(this.genre.byteValue());
        }
        in.close();
    }

    private void checkIfRead(String what) throws NoID3TagException, IOException {
        if (what == null) {
            this.readTag();
        }
    }

    public boolean checkForTag() throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.mp3_file, "r");
        if (raf.length() < 129L) {
            return false;
        }
        long seekPos = raf.length() - 128L;
        raf.seek(seekPos);
        byte[] buffer = new byte[3];
        if (raf.read(buffer, 0, 3) != 3) {
            throw new IOException("Read beyond end of file");
        }
        String testTag = new String(buffer, 0, 3, "Cp437");
        return testTag.equals("TAG");
    }

    private String fillWithNills(String str, int len) {
        if (str == null) {
            str = new String("");
        }
        StringBuffer tmp = new StringBuffer(str);
        int i = str.length() + 1;
        while (i <= len) {
            tmp.append('\u0000');
            ++i;
        }
        return tmp.toString();
    }
}

