/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.browse;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.web.browse.TLatest;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Latester
extends WebAction {
    private static final Logger log = Logger.getLogger(Latester.class);

    @Override
    public void handleRequest() throws SQLException, IOException {
        Properties p = this.getProperties();
        Vector<Track> tracks = this.getLatestTracks((int)p.get("browse.latestTracks.count", 20L));
        Vector<Artist> artists = this.getLatestArtists();
        Vector<Album> albums = this.getLatestAlbums();
        this.showLatest(tracks, artists, albums);
    }

    protected void showLatest(Vector<Track> tracks, Vector<Artist> artists, Vector<Album> albums) throws IOException, SQLException {
        TLatest tpl = new TLatest();
        tpl.setTracks(tracks);
        tpl.setArtists(artists);
        tpl.setAlbums(albums);
        this.getResponse().showHtml(tpl);
    }

    protected Vector<Artist> getLatestArtists() throws SQLException {
        ResultSet rs = this.getLatestMusic("artist", "browse.latestArtists.count");
        Vector<Artist> artists = new Vector<Artist>();
        while (rs.next()) {
            artists.addElement(new Artist(rs.getInt("id"), rs.getString("name")));
        }
        Utils.close(rs);
        return artists;
    }

    private ResultSet getLatestMusic(String type, String totalPropertyName) throws SQLException {
        PreparedStatement st = null;
        Properties p = this.getProperties();
        Database db = this.getDatabase();
        String sql = " select ar.id, ar.name, max(t.date_added) as mostRecent  from tracks t  inner join " + type + "s ar " + " on ar.id = t." + type + "_id " + " group by ar.id, ar.name " + " order by mostRecent desc " + " limit ? ";
        st = db.prepare(sql);
        st.setInt(1, (int)p.get(totalPropertyName, 10L));
        return st.executeQuery();
    }

    protected Vector<Album> getLatestAlbums() throws SQLException {
        ResultSet rs = this.getLatestMusic("album", "browse.latestAlbums.count");
        Vector<Album> albums = new Vector<Album>();
        while (rs.next()) {
            albums.addElement(new Album(null, rs.getInt("id"), rs.getString("name")));
        }
        return albums;
    }
}

