/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.TBurp;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TBurpImpl
extends AbstractTemplateImpl
implements TBurp.Intf {
    private final boolean showStackTrace;
    private final Vector<User> recentUsers;
    private final String referer;
    private final BadRequestException exception;
    private final String host;
    private final Locale locale;
    private final Properties properties;
    private final int statusCode;
    private final User user;
    private final String message;

    protected static TBurp.ImplData __jamon_setOptionalArguments(TBurp.ImplData p_implData) {
        if (!p_implData.getShowStackTrace__IsNotDefault()) {
            p_implData.setShowStackTrace(false);
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getReferer__IsNotDefault()) {
            p_implData.setReferer("");
        }
        if (!p_implData.getException__IsNotDefault()) {
            p_implData.setException(null);
        }
        if (!p_implData.getHost__IsNotDefault()) {
            p_implData.setHost("");
        }
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        if (!p_implData.getStatusCode__IsNotDefault()) {
            p_implData.setStatusCode(200);
        }
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        if (!p_implData.getMessage__IsNotDefault()) {
            p_implData.setMessage("");
        }
        return p_implData;
    }

    public TBurpImpl(TemplateManager p_templateManager, TBurp.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TBurpImpl.__jamon_setOptionalArguments(p_implData));
        this.showStackTrace = p_implData.getShowStackTrace();
        this.recentUsers = p_implData.getRecentUsers();
        this.referer = p_implData.getReferer();
        this.exception = p_implData.getException();
        this.host = p_implData.getHost();
        this.locale = p_implData.getLocale();
        this.properties = p_implData.getProperties();
        this.statusCode = p_implData.getStatusCode();
        this.user = p_implData.getUser();
        this.message = p_implData.getMessage();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_0 = new IHeader(this.getTemplateManager());
        __jamon__var_0.setUser(this.user);
        __jamon__var_0.setLocale(this.locale);
        __jamon__var_0.setProperties(this.properties);
        __jamon__var_0.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n<h2>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.error.title")), jamonWriter);
        jamonWriter.write("</h2>\n\n");
        if (this.statusCode >= 400 && this.statusCode < 500) {
            jamonWriter.write("\n\n    ");
            if (this.referer.equals("")) {
                jamonWriter.write("\n\n        <!-- error: no referer -->\n        <p>");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.locale.getString("www.error.noRefererErrorDesc")), jamonWriter);
                jamonWriter.write("</p>\n\n    ");
            } else {
                jamonWriter.write("\n\n        ");
                if (this.referer.contains(this.host)) {
                    jamonWriter.write("\n\n            <!-- error: local error -->\n            <p>");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)this.locale.getString("www.error.localErrorDesc")), jamonWriter);
                    jamonWriter.write("</p>\n        \n        ");
                } else {
                    jamonWriter.write("\n            ");
                    Pattern p = Pattern.compile("(http[s]?://)([a-zA-Z0-9-]+)(/.*)");
                    Matcher m = p.matcher(this.referer);
                    String domain = "";
                    String protocol = "";
                    if (m.matches()) {
                        protocol = m.group(1);
                        domain = m.group(2);
                    }
                    jamonWriter.write("<!-- error: remote error -->\n            <p>");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)this.locale.getString("www.error.remoteErrorDesc", new String[]{protocol, domain})), jamonWriter);
                    jamonWriter.write("</p>\n        ");
                }
                jamonWriter.write("\n\n    ");
            }
            jamonWriter.write("\n\n");
        }
        jamonWriter.write("\n\n<p>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.error.desc")), jamonWriter);
        jamonWriter.write("...</p>\n\n<ul>\n    ");
        for (String message : this.exception.getMessages()) {
            jamonWriter.write("\n        <li>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)message), jamonWriter);
            jamonWriter.write("</li>\n    ");
        }
        jamonWriter.write("\n</ul>\n\n");
        if (this.showStackTrace) {
            jamonWriter.write("\n\n    <h3>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.error.stackTrace")), jamonWriter);
            jamonWriter.write("</h3>\n\n    <ul>\n        ");
            for (StackTraceElement stackItem : this.exception.getStackTrace()) {
                jamonWriter.write("\n            <li>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)stackItem.toString()), jamonWriter);
                jamonWriter.write("</li>\n        ");
            }
            jamonWriter.write("\n    </ul>\n\n");
        }
        jamonWriter.write("\n\n");
        IFooter __jamon__var_1 = new IFooter(this.getTemplateManager());
        __jamon__var_1.setUser(this.user);
        __jamon__var_1.setProperties(this.properties);
        __jamon__var_1.setLocale(this.locale);
        __jamon__var_1.setRecentUsers(this.recentUsers);
        __jamon__var_1.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

