/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music;

import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.MusicItem;
import java.util.Date;

public class Album
extends MusicItem {
    private final Artist artist;
    private final int trackCount;
    private final int playCount;
    private final Date dateAdded;

    public Album(int artistId, String artistName, int id, String name) {
        this(new Artist(artistId, artistName), id, name);
    }

    public Album(Artist artist, int id, String name) {
        this(artist, id, name, -1);
    }

    public Album(Artist artist, int id, String name, int trackCount) {
        this(artist, id, name, null, trackCount, -1);
    }

    public Album(Artist artist, int id, String name, Date dateAdded, int trackCount, int playCount) {
        super("album", id, name);
        this.artist = artist;
        this.trackCount = trackCount;
        this.playCount = playCount;
        this.dateAdded = dateAdded != null ? new Date(dateAdded.getTime()) : null;
    }

    public Artist getArtist() {
        return this.artist;
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public Date getDateAdded() {
        return new Date(this.dateAdded.getTime());
    }

    public int getPlayCount() {
        return this.playCount;
    }
}

