/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.MusicTreeCellRenderer;
import com.pugh.sockso.gui.MusicTreeNode;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Collection;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.CollectionManagerListener;
import com.pugh.sockso.music.MusicItem;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Resources;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MusicTree
extends JTree
implements DragSourceListener,
DragGestureListener,
CollectionManagerListener {
    private static Logger log = Logger.getLogger(MusicTree.class);
    private DragSource dragSource;
    private Database db;

    public MusicTree(Database db, CollectionManager cm, Resources r) {
        super(new MusicTreeNode(new Collection()));
        this.db = db;
        cm.addCollectionManagerListener(this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new MusicTreeCellRenderer(r));
        this.totalRefresh();
    }

    private void totalRefresh() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block8: {
                    ResultSet rs = null;
                    PreparedStatement st = null;
                    try {
                        DefaultTreeModel model = (DefaultTreeModel)MusicTree.this.getModel();
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                        root.removeAllChildren();
                        String sql = Track.getSelectFromSql() + " order by ar.name asc, al.name asc, t.track_no asc, t.name asc ";
                        st = MusicTree.this.db.prepare(sql);
                        rs = st.executeQuery();
                        String artist = Utils.getRandomString(10);
                        String album = Utils.getRandomString(10);
                        MusicTreeNode artistNode = null;
                        MusicTreeNode albumNode = null;
                        while (rs.next()) {
                            boolean albumChanged;
                            boolean artistChanged = !artist.equals(rs.getString("artistName"));
                            boolean bl = albumChanged = artistChanged || !album.equals(rs.getString("albumName"));
                            if (artistChanged) {
                                artistNode = new MusicTreeNode(new Artist(rs.getInt("artistId"), rs.getString("artistName")));
                                root.add(artistNode);
                            }
                            if (albumChanged) {
                                albumNode = new MusicTreeNode(new Album(new Artist(rs.getInt("artistId"), rs.getString("artistName")), rs.getInt("albumId"), rs.getString("albumName")));
                                artistNode.add(albumNode);
                            }
                            artist = rs.getString("artistName");
                            album = rs.getString("albumName");
                            Artist artistObj = new Artist(rs.getInt("artistId"), rs.getString("artistName"));
                            MusicTreeNode trackNode = new MusicTreeNode(Track.createFromResultSet(rs));
                            albumNode.add(trackNode);
                        }
                        model.reload(root);
                        MusicTree.this.expandPath(new TreePath(root.getPath()));
                        Utils.close(rs);
                    }
                    catch (SQLException e) {
                        log.error((Object)("Error Refreshing: " + e.getMessage()));
                        break block8;
                    }
                    finally {
                        Utils.close(rs);
                        Utils.close(st);
                    }
                    Utils.close(st);
                }
            }
        }).start();
    }

    public void collectionManagerChangePerformed(int type, String message) {
        if (type == 6) {
            this.totalRefresh();
        }
    }

    public void dragGestureRecognized(DragGestureEvent evt) {
        try {
            MusicTreeNode node = (MusicTreeNode)this.getSelectionPath().getLastPathComponent();
            this.dragSource.startDrag(evt, DragSource.DefaultMoveDrop, (MusicItem)node.getUserObject(), this);
        }
        catch (ClassCastException e) {
            log.error((Object)("Error starting drag: " + e.getMessage()));
        }
    }

    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    public void dragExit(DragSourceEvent evt) {
    }

    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    public void dragOver(DragSourceDragEvent evt) {
    }

    public void dragEnter(DragSourceDragEvent evt) {
    }
}

