/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.SingleNodeOperation;
import freemind.modes.mindmapmode.actions.xml.AbstractXmlAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class NodeGeneralAction
extends AbstractXmlAction {
    protected final MindMapController modeController;
    private NodeActorXml actor;
    SingleNodeOperation singleNodeOperation;
    protected static Logger logger;

    protected NodeGeneralAction(MindMapController modeController, String textID, String iconPath) {
        super(null, iconPath != null ? new ImageIcon(modeController.getResource(iconPath)) : null, modeController);
        this.modeController = modeController;
        if (textID != null) {
            this.setName(modeController.getText(textID));
        }
        this.singleNodeOperation = null;
        this.actor = null;
        if (logger == null) {
            logger = modeController.getFrame().getLogger(this.getClass().getName());
        }
    }

    protected void setName(String name) {
        if (name != null) {
            this.putValue("Name", name);
            this.putValue("ShortDescription", Tools.removeMnemonic(name));
        }
    }

    public NodeGeneralAction(MindMapController modeController, String textID, String iconPath, SingleNodeOperation singleNodeOperation) {
        this(modeController, textID, iconPath);
        this.singleNodeOperation = singleNodeOperation;
    }

    public NodeGeneralAction(MindMapController modeController, String textID, String iconPath, NodeActorXml actor) {
        this(modeController, textID, iconPath);
        this.addActor(actor);
    }

    public void addActor(NodeActorXml actor) {
        this.actor = actor;
        if (actor != null) {
            super.addActor(actor);
        }
    }

    public void setSingleNodeOperation(SingleNodeOperation singleNodeOperation) {
        this.singleNodeOperation = singleNodeOperation;
    }

    public void xmlActionPerformed(ActionEvent e) {
        if (this.singleNodeOperation != null) {
            ListIterator it = this.modeController.getSelecteds().listIterator();
            while (it.hasNext()) {
                MindMapNodeModel selected = (MindMapNodeModel)it.next();
                this.singleNodeOperation.apply((MindMapMapModel)this.modeController.getMap(), selected);
            }
        } else {
            CompoundAction doAction = new CompoundAction();
            CompoundAction undo = new CompoundAction();
            ListIterator it = this.modeController.getSelecteds().listIterator();
            while (it.hasNext()) {
                MindMapNodeModel selected = (MindMapNodeModel)it.next();
                ActionPair pair = this.actor.apply(this.modeController.getMap(), selected);
                if (pair == null) continue;
                doAction.addChoice((Object)pair.getDoAction());
                undo.addAtChoice(0, (Object)pair.getUndoAction());
            }
            if (doAction.sizeChoiceList() == 0) {
                return;
            }
            this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
            this.modeController.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undo));
            this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
        }
    }

    protected void execute(ActionPair pair) {
        this.modeController.getActionFactory().executeAction(pair);
    }

    public void act(XmlAction action) {
    }

    protected NodeAdapter getNodeFromID(String string) {
        return this.modeController.getNodeFromID(string);
    }

    protected String getNodeID(MindMapNode selected) {
        return this.modeController.getNodeID(selected);
    }
}

