/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter;

import freemind.controller.Controller;
import freemind.controller.MapModuleManager;
import freemind.controller.filter.DefaultFilter;
import freemind.controller.filter.Filter;
import freemind.controller.filter.FilterComposerDialog;
import freemind.controller.filter.FilterToolbar;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.ConditionFactory;
import freemind.controller.filter.condition.ConditionRenderer;
import freemind.controller.filter.condition.NoFilteringCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.Mode;
import freemind.view.MapModule;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class FilterController
implements MapModuleManager.MapModuleChangeObserver {
    private Controller c;
    private FilterToolbar filterToolbar;
    private DefaultComboBoxModel filterConditionModel;
    private static ConditionRenderer conditionRenderer = null;
    private static ConditionFactory conditionFactory;
    private MindMap map;
    static final String FREEMIND_FILTER_EXTENSION_WITHOUT_DOT = "mmfilter";
    private static Filter inactiveFilter;

    public FilterController(Controller c) {
        this.c = c;
        c.getMapModuleManager().addListener(this);
    }

    ConditionRenderer getConditionRenderer() {
        if (conditionRenderer == null) {
            conditionRenderer = new ConditionRenderer();
        }
        return conditionRenderer;
    }

    public FilterToolbar getFilterToolbar() {
        if (this.filterToolbar == null) {
            this.filterToolbar = new FilterToolbar(this.c);
            this.filterConditionModel = (DefaultComboBoxModel)this.filterToolbar.getFilterConditionModel();
            MindIcon.factory("AttributeExist", new ImageIcon(Resources.getInstance().getResource("images/showAttributes.gif")));
            MindIcon.factory("accessories.plugins.NodeNoteIcon", new ImageIcon(Resources.getInstance().getResource("images/knotes.png")));
            MindIcon.factory("encrypted");
            MindIcon.factory("decrypted");
            this.filterToolbar.initConditions();
        }
        return this.filterToolbar;
    }

    public void showFilterToolbar(boolean show) {
        if (show == this.getFilterToolbar().isVisible()) {
            return;
        }
        this.getFilterToolbar().setVisible(show);
        Filter filter = this.getMap().getFilter();
        if (show) {
            filter.applyFilter(this.c);
        } else {
            FilterController.createTransparentFilter().applyFilter(this.c);
        }
        this.refreshMap();
    }

    void refreshMap() {
        this.c.getModeController().refreshMap();
    }

    public static ConditionFactory getConditionFactory() {
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactory();
        }
        return conditionFactory;
    }

    public MindMap getMap() {
        return this.map;
    }

    private void setFilterToolbar(FilterToolbar filterToolbar) {
        this.filterToolbar = filterToolbar;
    }

    public boolean isMapModuleChangeAllowed(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        return true;
    }

    public void beforeMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
    }

    public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
    }

    public void afterMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        MindMap newMap = newMapModule != null ? newMapModule.getModel() : null;
        FilterComposerDialog fd = this.getFilterToolbar().getFilterDialog();
        if (fd != null) {
            fd.mapChanged(newMap);
        }
        this.map = newMap;
        this.getFilterToolbar().mapChanged(newMap);
    }

    public void numberOfOpenMapInformation(int number) {
    }

    private static Filter createTransparentFilter() {
        if (inactiveFilter == null) {
            inactiveFilter = new DefaultFilter(NoFilteringCondition.createCondition(), true, false);
        }
        return inactiveFilter;
    }

    public void saveConditions() {
        if (this.filterToolbar != null) {
            this.filterToolbar.saveConditions();
        }
    }

    public DefaultComboBoxModel getFilterConditionModel() {
        return this.filterConditionModel;
    }

    public void setFilterConditionModel(DefaultComboBoxModel filterConditionModel) {
        this.filterConditionModel = filterConditionModel;
        this.filterToolbar.setFilterConditionModel(filterConditionModel);
    }

    void saveConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile) throws IOException {
        XMLElement saver = new XMLElement();
        saver.setName("filter_conditions");
        FileWriter writer = new FileWriter(pathToFilterFile);
        for (int i = 0; i < filterConditionModel.getSize(); ++i) {
            Condition cond = (Condition)filterConditionModel.getElementAt(i);
            cond.save(saver);
        }
        saver.write(writer);
        ((Writer)writer).close();
    }

    void loadConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile) throws IOException {
        filterConditionModel.removeAllElements();
        XMLElement loader = new XMLElement();
        FileReader reader = new FileReader(pathToFilterFile);
        loader.parseFromReader(reader);
        ((Reader)reader).close();
        Vector conditions = loader.getChildren();
        for (int i = 0; i < conditions.size(); ++i) {
            filterConditionModel.addElement(FilterController.getConditionFactory().loadCondition((XMLElement)conditions.get(i)));
        }
    }
}

