/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.randlsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RandomLSBOutputStream
extends OutputStream {
    private ImageHolder image = null;
    private int channelBitsUsed = 1;
    private int dataLength = 0;
    private String fileName = null;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private OpenStegoConfig config = null;
    private Set<String> bitWritten = new HashSet<String>();
    private Random rand = null;

    public RandomLSBOutputStream(ImageHolder image, int dataLength, String fileName, OpenStegoConfig config) throws OpenStegoException {
        if (image == null || image.getImage() == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.dataLength = dataLength;
        this.imgWidth = image.getImage().getWidth();
        this.imgHeight = image.getImage().getHeight();
        this.config = config;
        switch (image.getImage().getType()) {
            case 1: {
                this.image = image;
                break;
            }
            default: {
                BufferedImage newImg = new BufferedImage(this.imgWidth, this.imgHeight, 1);
                this.image = new ImageHolder(newImg, image.getMetadata());
                for (int x = 0; x < this.imgWidth; ++x) {
                    for (int y = 0; y < this.imgHeight; ++y) {
                        newImg.setRGB(x, y, image.getImage().getRGB(x, y));
                    }
                }
            }
        }
        this.channelBitsUsed = 1;
        this.fileName = fileName;
        this.rand = new Random(StringUtil.passwordHash(config.getPassword()));
        this.writeHeader();
    }

    private void writeHeader() throws OpenStegoException {
        int channelBits = 1;
        int noOfPixels = 0;
        int headerSize = 0;
        LSBDataHeader header = null;
        try {
            noOfPixels = this.imgWidth * this.imgHeight;
            header = new LSBDataHeader(this.dataLength, channelBits, this.fileName, this.config);
            headerSize = header.getHeaderSize();
            while ((double)(noOfPixels * 3 * channelBits) / 8.0 < (double)(headerSize + this.dataLength)) {
                if (++channelBits <= ((LSBConfig)this.config).getMaxBitsUsedPerChannel()) continue;
                throw new OpenStegoException(null, "LSB", 3);
            }
            header.setChannelBitsUsed(channelBits);
            this.write(header.getHeaderData());
            this.channelBitsUsed = channelBits;
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    @Override
    public void write(int data) throws IOException {
        boolean bitValue = false;
        int x = 0;
        int y = 0;
        int channel = 0;
        int bit = 0;
        for (int i = 0; i < 8; ++i) {
            String key;
            bitValue = (data >> 7 - i & 1) == 1;
            do {
                x = this.rand.nextInt(this.imgWidth);
                y = this.rand.nextInt(this.imgHeight);
                channel = this.rand.nextInt(3);
                bit = this.rand.nextInt(this.channelBitsUsed);
            } while (this.bitWritten.contains(key = x + "_" + y + "_" + channel + "_" + bit));
            this.bitWritten.add(key);
            this.setPixelBit(x, y, channel, bit, bitValue);
        }
    }

    public ImageHolder getImage() {
        return this.image;
    }

    private void setPixelBit(int x, int y, int channel, int bit, boolean bitValue) {
        int pixel = 0;
        int newColor = 0;
        int newPixel = 0;
        pixel = this.image.getImage().getRGB(x, y);
        if (bitValue) {
            newPixel = pixel | 1 << bit + channel * 8;
        } else {
            newColor = -2;
            for (int i = 0; i < bit + channel * 8; ++i) {
                newColor = newColor << 1 | 1;
            }
            newPixel = pixel & newColor;
        }
        this.image.getImage().setRGB(x, y, newPixel);
    }
}

