/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import net.xmind.core.IAccount;
import net.xmind.ui.internal.e4handlers.SignInHandler;
import net.xmind.ui.internal.e4handlers.SignOutHandler;
import net.xmind.verify.IValidity;
import net.xmind.verify.IVerifyListener;
import net.xmind.verify.VerifyEngine20161018;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.views.Page;

public class UnactivatedPage
extends Page {
    private static final String COLOR_TITLE = "#505050";
    private static final String COLOR_DESCRIPTION = "#9B9B9B";
    private IAccount account;
    private SeawindLibrary library;
    private Composite titleBar;
    private Label userNameLabel;

    public UnactivatedPage(SeawindLibrary library, IAccount account) {
        this.library = library;
        this.account = account;
    }

    protected Control doCreateControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(1).applyTo(composite);
        Control body = this.createBody(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(body);
        return composite;
    }

    private Control createBody(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Control centerControl = this.createContent(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo(centerControl);
        return composite;
    }

    private Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 24).applyTo(composite);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage((Image)resources.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("unactivated.png")));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)imageLabel);
        Point imageSize = imageLabel.computeSize(-1, -1);
        Control textArea = this.createTextArea(composite, resources);
        GridDataFactory.fillDefaults().align(0x1000000, 4).grab(true, false).hint(imageSize.x + 140, -1).applyTo(textArea);
        Control actionBar = this.createActionBar(composite);
        if (actionBar != null) {
            GridDataFactory.fillDefaults().grab(true, false).hint(imageSize.x, -1).applyTo(actionBar);
        }
        return composite;
    }

    private Control createTextArea(Composite parent, LocalResourceManager resources) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().spacing(0, 12).applyTo(composite);
        Label titleLabel = new Label(composite, 0);
        titleLabel.setForeground((Color)resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_TITLE)));
        titleLabel.setFont((Font)resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().withStyle(1).setHeight(14)));
        titleLabel.setText(SeawindMessages.CloudDashboardPage_ImportErrorDialog_title);
        GridDataFactory.fillDefaults().align(0x1000000, 4).grab(true, false).applyTo((Control)titleLabel);
        Label descriptionLabel = new Label(composite, 0x1000040);
        descriptionLabel.setForeground((Color)resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_DESCRIPTION)));
        descriptionLabel.setFont((Font)resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setStyle(0).setHeight(12)));
        descriptionLabel.setText(SeawindMessages.CloudDashboardPage_Intro_message);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)descriptionLabel);
        return composite;
    }

    private Control createActionBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setForeground(parent.getForeground());
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(7, 7).numColumns(1).applyTo(composite);
        Button upgradeButton = new Button(composite, 0);
        upgradeButton.setText(SeawindMessages.CloudDashboardPage_UpgradeToProButton_text);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)upgradeButton);
        upgradeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                UnactivatedPage.this.verify();
            }
        });
        Hyperlink reSign = new Hyperlink(composite, 4);
        reSign.setText(SeawindMessages.CloudDashboardPage_UseAnotherAccountButton_text);
        reSign.setForeground(parent.getDisplay().getSystemColor(9));
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)reSign);
        reSign.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UnactivatedPage.this.signOut();
                UnactivatedPage.this.signIn();
            }
        });
        return composite;
    }

    private void signOut() {
        SignOutHandler.signOut((IAccount)this.account);
    }

    private void signIn() {
        new SignInHandler().signIn(Display.getCurrent().getActiveShell(), this.account);
    }

    private void verify() {
        VerifyEngine20161018.verify20161018((String)"ShowLicenseCommand", null, (int)7, (IVerifyListener)new IVerifyListener(){

            public void notifyValidity(IValidity validity) {
                if ((validity.getCode() & 2) != 0) {
                    UnactivatedPage.this.library.sync();
                }
            }
        }, (int)9);
    }

    public void updateUserInfo() {
        if (this.titleBar != null && this.userNameLabel != null) {
            this.userNameLabel.setText(this.library.getUserName() == null ? "" : this.library.getUserName());
            this.titleBar.layout(true, true);
        }
    }
}

