/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.internal.image;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.graphics.RGB;
import org.xmind.gef.internal.image.IColorReplacingPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MinRiskColorReplacingPolicy
implements IColorReplacingPolicy {
    private Map<RGB, ColorReplacing> replacings;
    private int[][] riskCache;
    private Set<RGB> retainedColors;

    MinRiskColorReplacingPolicy() {
    }

    @Override
    public RGB[] getReplacingColors(int numMaxColors, final Map<RGB, Integer> colorOccurrences) {
        TreeSet<RGB> sorter = new TreeSet<RGB>(new Comparator<RGB>(){

            @Override
            public int compare(RGB o1, RGB o2) {
                int x = (Integer)colorOccurrences.get(o2) - (Integer)colorOccurrences.get(o1);
                return x == 0 ? 1 : x;
            }
        });
        sorter.addAll(colorOccurrences.keySet());
        ArrayList<RGB> sortedColors = new ArrayList<RGB>(sorter);
        this.replacings = new HashMap<RGB, ColorReplacing>();
        int t = 0;
        int i = 0;
        while (i < sortedColors.size()) {
            RGB c1 = (RGB)sortedColors.get(i);
            ColorReplacing rep = this.createMinRiskReplacing(c1, sortedColors.subList(0, i));
            this.replacings.put(c1, rep);
            if (i >> 10 > t) {
                t = i >> 10;
            }
            ++i;
        }
        TreeSet<RGB> sorter2 = new TreeSet<RGB>(new Comparator<RGB>(){

            @Override
            public int compare(RGB o1, RGB o2) {
                int delta = ((ColorReplacing)((MinRiskColorReplacingPolicy)MinRiskColorReplacingPolicy.this).replacings.get((Object)o2)).risk * (int)Math.sqrt(((Integer)colorOccurrences.get(o2)).intValue()) - ((ColorReplacing)((MinRiskColorReplacingPolicy)MinRiskColorReplacingPolicy.this).replacings.get((Object)o1)).risk * (int)Math.sqrt(((Integer)colorOccurrences.get(o1)).intValue());
                return delta == 0 ? 1 : delta;
            }
        });
        sorter2.addAll(sortedColors);
        sortedColors = new ArrayList<RGB>(sorter2);
        List<RGB> results = sortedColors.subList(0, numMaxColors);
        for (RGB c : results) {
            this.replacings.put(c, new ColorReplacing(c, c, 0));
        }
        for (RGB c : sortedColors.subList(numMaxColors, sortedColors.size())) {
            this.replacings.put(c, this.createMinRiskReplacing(c, results));
        }
        this.retainedColors = new HashSet<RGB>(results);
        return results.toArray(new RGB[results.size()]);
    }

    @Override
    public RGB getReplacedColor(RGB source) {
        ColorReplacing replacing = this.replacings.get(source);
        RGB result = replacing.replacement;
        if (!this.retainedColors.contains(result)) {
            replacing.replacement = result = this.getReplacedColor(result);
        }
        return result;
    }

    public ColorReplacing createMinRiskReplacing(RGB src, List<RGB> colors) {
        RGB resultColor = src;
        int minRisk = Integer.MAX_VALUE;
        for (RGB toTest : colors) {
            int risk = MinRiskColorReplacingPolicy.getColorReplacingRisk2(src, toTest);
            if (risk >= minRisk) continue;
            minRisk = risk;
            resultColor = toTest;
        }
        return new ColorReplacing(src, resultColor, minRisk);
    }

    protected int getRisk(RGB src, RGB dest) {
        int index;
        int[] rc = this.getRiskCache(src);
        int risk = rc[index = dest.hashCode()];
        if (risk < 0) {
            rc[index] = risk = MinRiskColorReplacingPolicy.getColorReplacingRisk2(src, dest);
        }
        return risk;
    }

    private int[] getRiskCache(RGB src) {
        int index = src.hashCode();
        int[] rc = this.getRiskCache()[index];
        if (rc == null) {
            rc = new int[0xFFFFFF];
            int i = 0;
            while (i < rc.length) {
                rc[i] = -1;
                ++i;
            }
            this.getRiskCache()[index] = rc;
        }
        return rc;
    }

    private int[][] getRiskCache() {
        if (this.riskCache == null) {
            this.riskCache = new int[0xFFFFFF][];
        }
        return this.riskCache;
    }

    public static int getColorReplacingRisk(RGB c1, RGB c2) {
        int deltaRed = c1.red - c2.red;
        int deltaGreen = c1.green - c2.green;
        int deltaBlue = c1.blue - c2.blue;
        return deltaRed * deltaRed + deltaGreen * deltaGreen + deltaBlue * deltaBlue;
    }

    public static int getColorReplacingRisk2(RGB c1, RGB c2) {
        int deltaRed = c1.red - c2.red;
        int deltaGreen = c1.green - c2.green;
        int deltaBlue = c1.blue - c2.blue;
        return Math.abs(deltaRed) + Math.abs(deltaGreen) + Math.abs(deltaBlue);
    }

    private static class ColorReplacing {
        RGB source;
        RGB replacement;
        int risk;

        public ColorReplacing(RGB source, RGB replacement, int risk) {
            this.source = source;
            this.replacement = replacement;
            this.risk = risk;
        }

        public String toString() {
            return "source=" + this.source + ",replacement=" + this.replacement + ",risk=" + this.risk;
        }
    }
}

