/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.util.Iterator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.ConnectionFigure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.IDecoratedFigureListener;
import org.xmind.gef.draw2d.decoration.IConnectionDecorationEx;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;

public class DecoratedConnectionFigure
extends ConnectionFigure
implements IDecoratedFigure {
    private IConnectionDecorationEx decoration;

    public IConnectionDecorationEx getDecoration() {
        return this.decoration;
    }

    public void setDecoration(IConnectionDecorationEx decoration) {
        IConnectionDecorationEx oldDecoration = this.decoration;
        if (decoration == oldDecoration) {
            return;
        }
        if (oldDecoration != null) {
            this.connectionRemoved(oldDecoration);
        }
        this.decoration = decoration;
        if (decoration != null) {
            this.connectionAdded(decoration);
        }
        this.revalidate();
        this.fireDecorationChanged(oldDecoration, decoration);
        this.repaint();
    }

    public void addDecoratedFigureListener(IDecoratedFigureListener listener) {
        this.addListener(IDecoratedFigureListener.class, listener);
    }

    public void removeDecoratedFigureListener(IDecoratedFigureListener listener) {
        this.removeListener(IDecoratedFigureListener.class, listener);
    }

    protected void fireDecorationChanged(IDecoration oldDecoration, IDecoration newDecoration) {
        Iterator listeners = this.getListeners(IDecoratedFigureListener.class);
        while (listeners.hasNext()) {
            ((IDecoratedFigureListener)listeners.next()).decorationChanged(this, oldDecoration, newDecoration);
        }
    }

    protected void connectionRemoved(IConnectionDecorationEx connection) {
        connection.setSourceAnchor(this, null);
        connection.setTargetAnchor(this, null);
    }

    protected void connectionAdded(IConnectionDecorationEx connection) {
        connection.setSourceAnchor(this, this.getSourceAnchor());
        connection.setTargetAnchor(this, this.getTargetAnchor());
    }

    public void setSourceAnchor(IAnchor anchor) {
        super.setSourceAnchor(anchor);
        if (this.decoration != null) {
            this.decoration.setSourceAnchor(this, anchor);
        }
    }

    public void setTargetAnchor(IAnchor anchor) {
        super.setTargetAnchor(anchor);
        if (this.decoration != null) {
            this.decoration.setTargetAnchor(this, anchor);
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.repaint();
    }

    public Rectangle getPreferredBounds() {
        Rectangle r;
        if (this.decoration != null && (r = this.decoration.getPreferredBounds(this)) != null) {
            return r;
        }
        return this.getBounds();
    }

    public boolean containsPoint(int x, int y) {
        if (this.decoration != null) {
            return this.decoration.containsPoint(this, x, y);
        }
        return false;
    }

    public void invalidate() {
        if (this.decoration != null) {
            this.decoration.invalidate();
        }
        super.invalidate();
    }

    protected void layout() {
        super.layout();
        this.setBounds(this.getPreferredBounds());
    }

    public void anchorMoved(IAnchor anchor) {
        super.anchorMoved(anchor);
        if (anchor.getOwner() != this) {
            if (this.decoration != null) {
                this.decoration.reroute(this);
            }
            this.setBounds(this.getPreferredBounds());
        }
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon(graphics, this);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setAntialias(1);
        if (this.decoration != null) {
            this.decoration.paint(this, graphics);
        }
    }
}

