/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.GEF;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.export.ExportConstants;
import org.xmind.ui.gantt.export.GanttFigureRenderer;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.internal.print.PrintUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.UnitConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttPrintClient
extends GanttFigureRenderer {
    private static final int TEXT_MARGIN = 0;
    private String jobName;
    private Shell parentShell;
    private PrinterData printerData;
    private IDialogSettings settings;
    private Printer printer;
    private Rectangle pageClientArea;
    private Point dpi;
    private boolean jobStarted = false;
    private Transform transform;

    public GanttPrintClient(String jobName, Shell parentShell, PrinterData printerData, IDialogSettings settings, GanttViewer ganttViewer) {
        super(ganttViewer);
        this.jobName = jobName;
        this.parentShell = parentShell;
        this.printerData = printerData;
        this.settings = settings;
    }

    public void print() {
        if (!this.start()) {
            return;
        }
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, false, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GanttPrintClient.this.parentShell.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            GanttPrintClient.this.internalPrint(monitor);
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void internalPrint(IProgressMonitor monitor) {
        int usefulPerPageHeightByRatio;
        int lines;
        int heightByRatio;
        double scale;
        boolean fullWidth;
        GanttViewer ganttViewer = this.getGanttViewer();
        TaskTreeHeaderViewer headerViewer = ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round(value, ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        int leftMarginPixel = ExportConstants.toPixel(this.getDouble("leftMargin", 0.25));
        int rightMarginPixel = ExportConstants.toPixel(this.getDouble("rightMargin", 0.25));
        int topMarginPixel = ExportConstants.toPixel(this.getDouble("topMargin", 0.25));
        int bottomMarginPixel = ExportConstants.toPixel(this.getDouble("bottomMargin", 0.25));
        int headerHeight2 = PrintUtils.getHeaderHeight((IDialogSettings)this.settings, (int)120);
        int footerHeight = PrintUtils.getBottomHeight((IDialogSettings)this.settings, (int)120);
        int orientation = this.getInt("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel;
        usefulPerPageHeight -= headerHeight2 + footerHeight;
        int widthPages = this.getInt("widthPages", 1);
        int heightPages = this.getInt("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !this.settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            int heightByRatio2 = (int)((double)usefulPerPageHeight / fillHeightRatio);
            int lines2 = (heightByRatio2 - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines2 = (heightByRatio2 - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines2 : lines2 + 1;
            int usefulPerPageHeightByRatio2 = headerHeight + lines2 * ExportConstants.ITEM_HEIGHT;
            fillHeightRatio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio2;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            scale = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            this.setScale(scale);
            heightByRatio = (int)((double)usefulPerPageHeight / scale);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            usefulHeightPages = contentHeight / (usefulPerPageHeightByRatio - headerHeight);
            usefulHeightPages = contentHeight % (usefulPerPageHeightByRatio - headerHeight) == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            scale = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            this.setScale(scale);
            heightByRatio = (int)((double)usefulPerPageHeight / scale);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines = (heightByRatio - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            scale = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
            this.setScale(scale);
            usefulWidthPages = sourceWidth / (int)((double)usefulPerPageWidth / scale);
            usefulWidthPages = sourceWidth % (int)((double)usefulPerPageWidth / scale) == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / this.getScale());
        double widthScale = (double)this.pageClientArea.width / (double)usefulPerPageWidth * this.getScale();
        double heightScale = (double)this.pageClientArea.height / (double)usefulPerPageHeight * this.getScale();
        double scale2 = widthScale < heightScale ? widthScale : heightScale;
        this.setScale(scale2);
        int originX = (int)((double)this.pageClientArea.width - (double)usefulPerPageWidthByRatio * scale2) / 2 + this.pageClientArea.x;
        int originY = (int)((double)this.pageClientArea.height - (double)usefulPerPageHeightByRatio * scale2) / 2 + this.pageClientArea.y;
        Rectangle realPageClientArea = new Rectangle(originX, originY, (int)((double)usefulPerPageWidthByRatio * scale2), (int)((double)usefulPerPageHeightByRatio * scale2));
        monitor.beginTask(GanttMessages.GanttPrintClient_TaskStart_text, widthPages * heightPages);
        int j = 0;
        while (j < heightPages) {
            int y = j * (usefulPerPageHeightByRatio - headerHeight);
            int i = 0;
            while (i < widthPages) {
                int x = i * usefulPerPageWidthByRatio;
                Rectangle contentClip = new Rectangle(0, headerHeight, usefulPerPageWidthByRatio, usefulPerPageHeightByRatio - headerHeight);
                int pageNumber = j * widthPages + i + 1;
                boolean isValidPage = i < usefulWidthPages && j < usefulHeightPages;
                this.render(realPageClientArea, startTime, endTime, new Point(-x, -y), usefulPerPageWidthByRatio, usefulPerPageHeightByRatio, contentClip, pageNumber, isValidPage);
                monitor.worked(1);
                ++i;
            }
            ++j;
        }
        monitor.done();
    }

    private void render(Rectangle realPageClientArea, long startTime, long endTime, Point origin, int usefulPerPageWidthByRatio, int usefulPerPageHeightByRatio, Rectangle contentClip, int pageNumber, boolean isValidPage) {
        if (!this.printer.startPage()) {
            return;
        }
        this.pageClientArea = new Rectangle(realPageClientArea);
        GC gc = new GC((Drawable)this.printer);
        try {
            boolean hasPageNumber;
            boolean hasBorder;
            String footerText;
            if (isValidPage) {
                this.pushState(gc);
                this.render(gc, startTime, endTime, origin, contentClip);
                this.popState(gc);
            }
            gc.setClipping(null);
            String headerText = this.settings.get("headerText");
            if (headerText != null && !"".equals(headerText)) {
                this.drawHeader(gc, headerText);
            }
            if ((footerText = this.settings.get("footerText")) != null && !"".equals(footerText)) {
                this.drawFooter(gc, footerText);
            }
            gc.setClipping(null);
            boolean bl = hasBorder = !this.settings.getBoolean("noBorder");
            if (hasBorder) {
                gc.setLineWidth(1);
                gc.setForeground(Display.getCurrent().getSystemColor(2));
                gc.drawRectangle(this.pageClientArea.x - 1, this.pageClientArea.y - 1, this.pageClientArea.width + 2, this.pageClientArea.height + 2);
            }
            boolean bl2 = hasPageNumber = !this.settings.getBoolean("noPageNumber");
            if (hasPageNumber) {
                this.drawPageNumber(gc, "- " + pageNumber + " -");
            }
        }
        finally {
            gc.dispose();
        }
        this.printer.endPage();
    }

    private void pushState(GC gc) {
        Transform tempTransform = new Transform(gc.getDevice());
        gc.getTransform(tempTransform);
        float[] elements = new float[6];
        tempTransform.getElements(elements);
        if (this.transform != null && !this.transform.isDisposed()) {
            this.transform.dispose();
        }
        this.transform = new Transform(gc.getDevice(), elements);
        tempTransform.dispose();
    }

    private void popState(GC gc) {
        gc.setTransform(this.transform);
    }

    private void drawHeader(GC gc, String text) {
        Font font = this.getFont("headerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("headerAlign", 2), true);
        }
        finally {
            font.dispose();
        }
    }

    private void drawFooter(GC gc, String text) {
        Font font = this.getFont("footerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("footerAlign", 4), false);
        }
        finally {
            font.dispose();
        }
    }

    private void drawPageNumber(GC gc, String text) {
        int footerAlign = this.getAlign("footerAlign", 4);
        int pageNumberAlign = footerAlign == 2 ? 4 : 2;
        this.drawPageNumber(gc, text, pageNumberAlign);
    }

    private Font getFont(String fontKey) {
        FontData[] fontData;
        Font font = null;
        String fontValue = this.settings.get(fontKey);
        if (fontValue != null && (fontData = FontUtils.toFontData((String)fontValue)) != null) {
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setHeight(fd.getHeight() * this.dpi.y / UnitConvertor.getScreenDpi().y);
                ++n2;
            }
            font = new Font((Device)Display.getCurrent(), fontData);
        }
        if (font == null) {
            FontData[] defaultFontData = JFaceResources.getDefaultFontDescriptor().getFontData();
            int defaultHeight = defaultFontData[0].getHeight();
            font = new Font((Device)Display.getCurrent(), FontUtils.newHeight((FontData[])defaultFontData, (int)(defaultHeight * this.dpi.y / UnitConvertor.getScreenDpi().y)));
        }
        return font;
    }

    private int getAlign(String alignKey, int defaultAlign) {
        return ExportConstants.toDraw2DAlignment(this.settings.get(alignKey), defaultAlign);
    }

    private void drawText(GC gc, String text, Font font, int alignment, boolean top) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(this.parentShell.getDisplay().getSystemColor(2));
        int width = this.pageClientArea.width;
        int marginWidth = 0 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        Dimension size = label.getPreferredSize(width -= marginWidth * 2, -1);
        int x = -width / 2;
        org.eclipse.swt.graphics.Rectangle pageBounds = this.printer.getClientArea();
        int y = top ? -this.pageClientArea.height / 2 - (this.pageClientArea.y - pageBounds.y) + Math.max((this.pageClientArea.y - pageBounds.y - size.height) / 2, marginWidth) : this.pageClientArea.height / 2 + (pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height)) - size.height - Math.max((pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height) - size.height) / 2, marginWidth);
        label.setBounds(new Rectangle(x, y, width, size.height));
        SWTGraphics baseGraphics = new SWTGraphics(gc);
        baseGraphics.translate(this.pageClientArea.x + this.pageClientArea.width / 2, this.pageClientArea.y + this.pageClientArea.height / 2);
        SWTGraphics graphics = baseGraphics;
        Object rotatedGraphics = null;
        try {
            try {
                label.paint((Graphics)graphics);
            }
            catch (Throwable e) {
                Logger.log((Throwable)e, (String)"Error occurred while printing");
                if (rotatedGraphics != null) {
                    rotatedGraphics.dispose();
                }
                baseGraphics.dispose();
            }
        }
        finally {
            if (rotatedGraphics != null) {
                rotatedGraphics.dispose();
            }
            baseGraphics.dispose();
        }
    }

    private void drawPageNumber(GC gc, String text, int alignment) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        Font font = Display.getCurrent().getSystemFont();
        font = FontUtils.getNewHeight((Font)font, (int)(font.getFontData()[0].getHeight() * this.dpi.y / UnitConvertor.getScreenDpi().y));
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(this.parentShell.getDisplay().getSystemColor(2));
        Rectangle pageBounds = new Rectangle(this.printer.getClientArea());
        int width = this.pageClientArea.width;
        int marginWidth = 0 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        Dimension size = label.getPreferredSize(width -= marginWidth * 2, -1);
        int x = -width / 2;
        int y = pageBounds.height / 2 - size.height - Math.max((pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height) - size.height) / 2, marginWidth);
        label.setBounds(new Rectangle(x, y, width, size.height));
        SWTGraphics baseGraphics = new SWTGraphics(gc);
        baseGraphics.translate(pageBounds.x + pageBounds.width / 2, pageBounds.y + pageBounds.height / 2);
        SWTGraphics graphics = baseGraphics;
        Object rotatedGraphics = null;
        try {
            try {
                label.paint((Graphics)graphics);
            }
            catch (Throwable e) {
                Logger.log((Throwable)e, (String)"Error occurred while printing");
                if (rotatedGraphics != null) {
                    rotatedGraphics.dispose();
                }
                baseGraphics.dispose();
            }
        }
        finally {
            if (rotatedGraphics != null) {
                rotatedGraphics.dispose();
            }
            baseGraphics.dispose();
        }
    }

    private boolean start() {
        if (this.printer == null) {
            this.printer = new Printer(this.printerData);
        }
        this.receivePrinterInfo();
        if (this.pageClientArea.width <= 0 || this.pageClientArea.height <= 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.GanttPrintClient_InvalidMargin_text, (String)GanttMessages.GanttPrintClient_InvalidMargin_message);
                }
            });
            return false;
        }
        if (!this.jobStarted) {
            if (!this.printer.startJob(this.jobName)) {
                return false;
            }
            this.jobStarted = true;
        }
        return this.jobStarted;
    }

    private void receivePrinterInfo() {
        this.dpi = new Point(this.printer.getDPI());
        this.pageClientArea = new Rectangle(this.printer.getClientArea());
        int leftMargin = this.getUserMargin("leftMargin");
        int rightMargin = this.getUserMargin("rightMargin");
        int topMargin = this.getUserMargin("topMargin");
        int bottomMargin = this.getUserMargin("bottomMargin");
        this.pageClientArea.x += leftMargin;
        this.pageClientArea.y += topMargin;
        this.pageClientArea.width -= leftMargin + rightMargin;
        this.pageClientArea.height -= topMargin + bottomMargin;
        int headerHeight = PrintUtils.getHeaderHeight((IDialogSettings)this.settings, (int)this.dpi.y);
        int footerHeight = PrintUtils.getBottomHeight((IDialogSettings)this.settings, (int)this.dpi.y);
        this.pageClientArea.expand(new Insets(-headerHeight, 0, -footerHeight, 0));
    }

    private int getUserMargin(String key) {
        double marginInch;
        try {
            marginInch = this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            marginInch = 0.25;
        }
        double dpi = "leftMargin".equals(key) || "rightMargin".equals(key) ? (double)this.dpi.x : (double)this.dpi.y;
        return (int)(marginInch * dpi);
    }

    public void dispose() {
        if (this.printer != null) {
            if (!this.printer.isDisposed()) {
                this.printer.endJob();
            }
            this.printer.dispose();
            this.printer = null;
        }
        this.jobStarted = false;
        if (this.transform != null) {
            this.transform.dispose();
        }
    }

    @Override
    protected void createGraphics(Graphics graphics, Stack<Graphics> stack) {
        graphics.setClip(new Rectangle(this.pageClientArea.x, this.pageClientArea.y, this.pageClientArea.width, this.pageClientArea.height));
        graphics.translate(this.pageClientArea.x, this.pageClientArea.y);
        if (this.getScale() > 0.0) {
            graphics.scale(this.getScale());
            stack.push(graphics);
        }
    }

    private int getInt(String key, int defaultValue) {
        try {
            return this.settings.getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

