/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss.util;

import org.bouncycastle.crypto.Digest;

public class WinternitzOTSVerify {
    private Digest messDigestOTS;
    private int w;

    public WinternitzOTSVerify(Digest digest, int w) {
        this.w = w;
        this.messDigestOTS = digest;
    }

    public int getSignatureLength() {
        int mdsize = this.messDigestOTS.getDigestSize();
        int size = ((mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        return mdsize * (size += (logs + this.w - 1) / this.w);
    }

    public byte[] Verify(byte[] message, byte[] signature) {
        int d;
        int mdsize = this.messDigestOTS.getDigestSize();
        byte[] hash = new byte[mdsize];
        this.messDigestOTS.update(message, 0, message.length);
        hash = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(hash, 0);
        int size = ((mdsize << 3) + (this.w - 1)) / this.w;
        int logs = this.getLog((size << this.w) + 1);
        int keysize = size + (logs + this.w - 1) / this.w;
        int testKeySize = mdsize * keysize;
        if (testKeySize != signature.length) {
            return null;
        }
        byte[] testKey = new byte[testKeySize];
        int c = 0;
        int counter = 0;
        if (8 % this.w == 0) {
            int test;
            d = 8 / this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            int i = 0;
            while (i < hash.length) {
                int j = 0;
                while (j < d) {
                    test = hash[i] & k;
                    c += test;
                    System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                    while (test < k) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                        ++test;
                    }
                    System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                    hash[i] = (byte)(hash[i] >>> this.w);
                    ++counter;
                    ++j;
                }
                ++i;
            }
            c = (size << this.w) - c;
            i = 0;
            while (i < logs) {
                test = c & k;
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                while (test < k) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    ++test;
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c >>>= this.w;
                ++counter;
                i += this.w;
            }
        } else if (this.w < 8) {
            int test;
            long big8;
            d = mdsize / this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            int ii = 0;
            int i = 0;
            while (i < d) {
                big8 = 0L;
                int j = 0;
                while (j < this.w) {
                    big8 ^= (long)((hash[ii] & 0xFF) << (j << 3));
                    ++ii;
                    ++j;
                }
                j = 0;
                while (j < 8) {
                    test = (int)(big8 & (long)k);
                    c += test;
                    System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                    while (test < k) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                        ++test;
                    }
                    System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                    big8 >>>= this.w;
                    ++counter;
                    ++j;
                }
                ++i;
            }
            d = mdsize % this.w;
            big8 = 0L;
            int j = 0;
            while (j < d) {
                big8 ^= (long)((hash[ii] & 0xFF) << (j << 3));
                ++ii;
                ++j;
            }
            d <<= 3;
            j = 0;
            while (j < d) {
                test = (int)(big8 & (long)k);
                c += test;
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                while (test < k) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    ++test;
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                big8 >>>= this.w;
                ++counter;
                j += this.w;
            }
            c = (size << this.w) - c;
            i = 0;
            while (i < logs) {
                test = c & k;
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                while (test < k) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    ++test;
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c >>>= this.w;
                ++counter;
                i += this.w;
            }
        } else if (this.w < 57) {
            long test8;
            int j;
            int ii;
            long big8;
            int rest;
            int s;
            d = (mdsize << 3) - this.w;
            int k = (1 << this.w) - 1;
            byte[] hlp = new byte[mdsize];
            int r = 0;
            while (r <= d) {
                s = r >>> 3;
                rest = r % 8;
                int f = (r += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                j = s;
                while (j < f) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                    ++j;
                }
                test8 = (big8 >>>= rest) & (long)k;
                c = (int)((long)c + test8);
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                while (test8 < (long)k) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    ++test8;
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                ++counter;
            }
            s = r >>> 3;
            if (s < mdsize) {
                rest = r % 8;
                big8 = 0L;
                ii = 0;
                j = s;
                while (j < mdsize) {
                    big8 ^= (long)((hash[j] & 0xFF) << (ii << 3));
                    ++ii;
                    ++j;
                }
                test8 = (big8 >>>= rest) & (long)k;
                c = (int)((long)c + test8);
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                while (test8 < (long)k) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    ++test8;
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                ++counter;
            }
            c = (size << this.w) - c;
            int i = 0;
            while (i < logs) {
                test8 = c & k;
                System.arraycopy(signature, counter * mdsize, hlp, 0, mdsize);
                while (test8 < (long)k) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                    ++test8;
                }
                System.arraycopy(hlp, 0, testKey, counter * mdsize, mdsize);
                c >>>= this.w;
                ++counter;
                i += this.w;
            }
        }
        byte[] TKey = new byte[mdsize];
        this.messDigestOTS.update(testKey, 0, testKey.length);
        TKey = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(TKey, 0);
        return TKey;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i = 2;
        while (i < intValue) {
            i <<= 1;
            ++log;
        }
        return log;
    }
}

