/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.SessionManager;

public class ReportManager {
    private static final Log log = LogFactory.getLog(ReportManager.class);

    private ReportManager() {
    }

    public static Boolean financialTxn(String filename, String format, String dateStart, String dateEnd) {
        ReportName reportName = ReportName.FIN_TRANS;
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("accountAmount", "accountBalance", "comment", "currencyID", "finTranID", "finTranTypeID", "orderID", "orderNo", "systemAmount", "tranAmount", "tranWhen", "wlpAmount", "execID", "dnb"));
        String sessionKey = SessionManager.getInstance().getSessionKey();
        String url = "DriveWealth?LanguageID=en_US&wlpID=DW&ReportFormat=" + format + "&ReportName=" + reportName.value + "&sessionKey=" + sessionKey + "&AccountNumber=" + SessionManager.getInstance().getUser().getActiveAccount().accountNo + "&DateStart=" + dateStart + "&DateEnd=" + dateEnd;
        log.info((Object)("Financial Transaction Report URL: " + url));
        Boolean status = Http.postSaveReportToFile(url, filename, sessionKey);
        if (status == null || !status.booleanValue()) {
            log.error((Object)"Financial Transaction Report error - save to file failed");
            return null;
        }
        return true;
    }

    public static Boolean orderTxn(String filename, String format, String dateStart, String dateEnd, String symbol) {
        ReportName reportName = ReportName.ORDER_TRANS;
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("orderNo", "transactTime", "execType", "ordStatus", "ordType", "side", "symbol", "lastShares", "lastPx", "cumQty", "leavesQty"));
        String symbolArg = "";
        if (symbol != null) {
            symbolArg = "&symbol=" + symbol;
        }
        String sessionKey = SessionManager.getInstance().getSessionKey();
        String url = "DriveWealth?LanguageID=en_US&wlpID=DW&ReportFormat=" + format + "&ReportName=" + reportName.value + "&sessionKey=" + sessionKey + "&AccountNumber=" + SessionManager.getInstance().getUser().getActiveAccount().accountNo + "&DateStart=" + dateStart + "&DateEnd=" + dateEnd + symbolArg;
        log.info((Object)("Order Transaction Report URL: " + url));
        Boolean status = Http.postSaveReportToFile(url, filename, sessionKey);
        if (status == null || !status.booleanValue()) {
            log.error((Object)"Order Transaction Report error - save to file failed");
            return null;
        }
        return true;
    }

    public static Boolean openPosRestingOrder(String filename, String format) {
        ReportName reportName = ReportName.POSITION_RESTING_ORDER;
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("costBasis", "initQty", "side", "openQty", "instrument", "price", "mtm", "mtmPL"));
        String sessionKey = SessionManager.getInstance().getSessionKey();
        String url = "DriveWealth?LanguageID=en_US&wlpID=DW&ReportFormat=" + format + "&ReportName=" + reportName.value + "&sessionKey=" + sessionKey + "&AccountNumber=" + SessionManager.getInstance().getUser().getActiveAccount().accountNo;
        log.info((Object)("Open Position & Resting Order Report URL: " + url));
        Boolean status = Http.postSaveReportToFile(url, filename, sessionKey);
        if (status == null || !status.booleanValue()) {
            log.error((Object)"Open Position & Resting Order Report error - save to file failed");
            return null;
        }
        return true;
    }

    public static Boolean stocksOffered(String filename, String format) {
        ReportName reportName = ReportName.INSTRUMENT;
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("instrument", "instrumentTypeDescr", "tradeStatusDescr", "tagDescr", "linkable10K"));
        ArrayList<String> RESULT_INSTRUMENT_FIELDS = new ArrayList<String>(Arrays.asList("currencyID", "instrumentID", "limitStatus", "instrumentTypeID", "marginCurrencyID", "name", "orderSizeMax", "orderSizeMin", "orderSizeStep", "symbol", "tradeStatus", "urlInvestor", "priorClose", "marketState", "minTic", "pipMultiplier", "rebateSpread"));
        String sessionKey = SessionManager.getInstance().getSessionKey();
        String url = "DriveWealth?wlpID=DW&LanguageID=en_US&TradeStatus=-1&InstrumentType=-1&ReportFormat=" + format + "&ReportName=" + reportName.value + "&sessionKey=" + sessionKey + "&AccountNumber=" + SessionManager.getInstance().getUser().getActiveAccount().accountNo;
        log.info((Object)("Stocks, ETFs and ADRs Offered Report URL: " + url));
        Boolean status = Http.postSaveReportToFile(url, filename, sessionKey);
        if (status == null || !status.booleanValue()) {
            log.error((Object)"Stocks, ETFs and ADRs Offered Report error - save to file failed");
            return null;
        }
        return true;
    }

    public static List<Map<String, Object>> listStatements(StatementType type, String startDate, String endDate) {
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("displayName", "fileKey"));
        String url = "statements?accountID=" + SessionManager.getInstance().getUser().getActiveAccount().accountID + "&type=" + type.value;
        if (type != StatementType.DOCUMENTS_1099_B) {
            url = url + "&startDate=" + startDate + "&endDate=" + endDate;
        }
        log.info((Object)("List Statements Report URL: " + url));
        HttpRespond respond = Http.get(url, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        List result = (List)new Gson().fromJson(body, ArrayList.class);
        return result;
    }

    public static String getStatement(String fileKey) {
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("accountID", "url"));
        String url = "statements/" + SessionManager.getInstance().getUser().getActiveAccount().accountID + "/" + fileKey;
        log.info((Object)("Get Statement Report URL: " + url));
        HttpRespond respond = Http.get(url, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        String reportAcID = result.get("accountID").toString();
        String reportUrl = result.get("url").toString();
        log.info((Object)("Get Statement Report - accountID: " + reportAcID + ", URL: " + reportUrl));
        return reportUrl;
    }

    public static enum StatementType {
        TRADE_CONFIRMS("01", "TradeConfirms", "Trade_confirms"),
        STATEMENTS("02", "Statements", "Statements"),
        DOCUMENTS_1099_B("03", "1099BDocuments", "1099-B_documents");

        public final String value;
        public final String code;
        private final String key;

        private StatementType(String value, String code, String key) {
            this.value = value;
            this.code = code;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }

    public static enum ReportName {
        FIN_TRANS("FinTrans", "Financial_transaction"),
        ORDER_TRANS("OrderTrans", "Order_transaction"),
        POSITION_RESTING_ORDER("PositionRestingOrder", "Open_positions_resting_orders"),
        INSTRUMENT("Instrument", "Stocks_ETFs_ADRs_offered"),
        REFERRAL_SUMMARY_PERFORMANCE("ReferralSummaryPerformance", "Referral_summary");

        public final String value;
        public final String key;

        private ReportName(String value, String key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return DriveWealthBundle.getString(this.key);
        }
    }
}

