/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.CSVHelper;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.gui.AbstractTableModelWithMemory;
import org.yccheok.jstock.gui.StockAlert;
import org.yccheok.jstock.internationalization.GUIBundle;

public class StockTableModel
extends AbstractTableModelWithMemory
implements CSVHelper {
    private long timestamp = 0L;
    private final List<List<Object>> tableModel = new ArrayList<List<Object>>();
    private final List<List<Object>> oldTableModel = new ArrayList<List<Object>>();
    private final List<Stock> stocks = new ArrayList<Stock>();
    private final Map<Code, StockAlert> alerts = new ConcurrentHashMap<Code, StockAlert>();
    private final Map<String, Integer> columnNameMapping = new ConcurrentHashMap<String, Integer>();
    private final Map<Code, Integer> codeToRow = new ConcurrentHashMap<Code, Integer>();
    private static final String[] columnNames;
    private static final String[] languageIndependentColumnNames;
    private static final Class[] columnClasses;

    public StockTableModel() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNameMapping.put(columnNames[i], i);
        }
    }

    @Override
    public Object getOldValueAt(int rowIndex, int columnIndex) {
        List<Object> stockInfo = this.oldTableModel.get(rowIndex);
        if (null == stockInfo) {
            return null;
        }
        return stockInfo.get(columnIndex);
    }

    @Override
    public void clearOldValueAt(int rowIndex, int columnIndex) {
        List<Object> stockInfo = this.oldTableModel.get(rowIndex);
        if (null == stockInfo) {
            return;
        }
        stockInfo.set(columnIndex, null);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<Object> stockInfo = this.tableModel.get(rowIndex);
        return stockInfo.get(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.tableModel.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Class getColumnClass(int c) {
        return columnClasses[c];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == columnClasses.length - 1 || col == columnClasses.length - 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == columnClasses.length - 1) {
            Double riseAbove = (Double)value;
            Code code = this.stocks.get((int)row).code;
            this.alerts.put(code, this.alerts.get(code).setRiseAbove(riseAbove));
            List<Object> oldInfos = this.oldTableModel.get(row);
            if (oldInfos != null) {
                oldInfos.set(col, this.tableModel.get(row).get(col));
            }
            this.tableModel.get(row).set(col, riseAbove);
            this.fireTableCellUpdated(row, col);
            return;
        }
        if (col == columnClasses.length - 2) {
            Double fallBelow = (Double)value;
            Code code = this.stocks.get((int)row).code;
            this.alerts.put(code, this.alerts.get(code).setFallBelow(fallBelow));
            List<Object> oldInfos = this.oldTableModel.get(row);
            if (oldInfos != null) {
                oldInfos.set(col, this.tableModel.get(row).get(col));
            }
            this.tableModel.get(row).set(col, fallBelow);
            this.fireTableCellUpdated(row, col);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void updateStock(Stock stock) {
        assert (SwingUtilities.isEventDispatchThread());
        Integer row = this.codeToRow.get(stock.code);
        if (row != null) {
            this.oldTableModel.set(row, this.tableModel.get(row));
            StockAlert alert = this.alerts.get(stock.code);
            this.tableModel.set(row, this.stockToList(stock, alert));
            this.stocks.set(row, stock);
            this.fireTableRowsUpdated(row, row);
        }
    }

    public void addStock(Stock stock, StockAlert alert) {
        assert (SwingUtilities.isEventDispatchThread());
        Integer row = this.codeToRow.get(stock.code);
        if (row == null) {
            this.tableModel.add(this.stockToList(stock, alert));
            this.oldTableModel.add(null);
            this.stocks.add(stock);
            this.alerts.put(stock.code, alert);
            int rowIndex = this.tableModel.size() - 1;
            this.codeToRow.put(stock.code, rowIndex);
            this.fireTableRowsInserted(rowIndex, rowIndex);
        }
    }

    public void addStock(Stock stock) {
        assert (SwingUtilities.isEventDispatchThread());
        this.addStock(stock, new StockAlert());
    }

    public void clearAllStocks() {
        assert (SwingUtilities.isEventDispatchThread());
        int size = this.stocks.size();
        if (size == 0) {
            return;
        }
        this.tableModel.clear();
        this.oldTableModel.clear();
        this.stocks.clear();
        this.alerts.clear();
        this.codeToRow.clear();
        this.fireTableRowsDeleted(0, size - 1);
    }

    public Stock getStock(int row) {
        return this.stocks.get(row);
    }

    public Double getRiseAbove(Stock stock) {
        StockAlert stockAlert = this.alerts.get(stock.code);
        if (stockAlert == null) {
            return null;
        }
        return stockAlert.riseAbove;
    }

    public Double getFallBelow(Stock stock) {
        StockAlert stockAlert = this.alerts.get(stock.code);
        if (stockAlert == null) {
            return null;
        }
        return stockAlert.fallBelow;
    }

    public List<Stock> getStocks() {
        return Collections.unmodifiableList(this.stocks);
    }

    public void removeRow(int row) {
        assert (SwingUtilities.isEventDispatchThread());
        this.oldTableModel.remove(row);
        List<Object> list = this.tableModel.remove(row);
        this.stocks.remove(row);
        Code code = (Code)list.get(0);
        this.alerts.remove(code);
        this.codeToRow.remove(code);
        int size = this.stocks.size();
        for (int i = row; i < size; ++i) {
            Stock s = this.stocks.get(i);
            this.codeToRow.put(s.code, i);
        }
        this.fireTableRowsDeleted(row, row);
    }

    private List<Object> stockToList(Stock stock, StockAlert alert) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stock.code);
        list.add(stock.symbol);
        list.add(stock.getPrevPrice());
        list.add(stock.getOpenPrice());
        list.add(stock.getLastPrice());
        list.add(stock.getHighPrice());
        list.add(stock.getLowPrice());
        list.add(stock.getVolume());
        list.add(stock.getChangePrice());
        list.add(stock.getChangePricePercentage());
        list.add(stock.getLastVolume());
        list.add(stock.getBuyPrice());
        list.add(stock.getBuyQuantity());
        list.add(stock.getSellPrice());
        list.add(stock.getSellQuantity());
        list.add(alert.fallBelow);
        list.add(alert.riseAbove);
        return list;
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnNameMapping.get(columnName);
    }

    public int findRow(Stock stock) {
        Integer row = this.codeToRow.get(stock.code);
        if (row != null) {
            return row;
        }
        return -1;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getLanguageIndependentColumnName(int columnIndex) {
        return languageIndependentColumnNames[columnIndex];
    }

    static {
        columnClasses = new Class[]{Code.class, Symbol.class, Double.class, Double.class, Double.class, Double.class, Double.class, Long.class, Double.class, Double.class, Integer.class, Double.class, Integer.class, Double.class, Integer.class, Double.class, Double.class};
        String[] tmp = new String[]{GUIBundle.getString("MainFrame_Code"), GUIBundle.getString("MainFrame_Symbol"), GUIBundle.getString("MainFrame_Prev"), GUIBundle.getString("MainFrame_Open"), GUIBundle.getString("MainFrame_Last"), GUIBundle.getString("MainFrame_High"), GUIBundle.getString("MainFrame_Low"), GUIBundle.getString("MainFrame_Vol"), GUIBundle.getString("MainFrame_Chg"), GUIBundle.getString("MainFrame_ChgPercentage"), GUIBundle.getString("MainFrame_LVol"), GUIBundle.getString("MainFrame_Buy"), GUIBundle.getString("MainFrame_BQty"), GUIBundle.getString("MainFrame_Sell"), GUIBundle.getString("MainFrame_SQty"), GUIBundle.getString("MainFrame_FallBelow"), GUIBundle.getString("MainFrame_RiseAbove")};
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        String[] tmp2 = new String[]{guiBundleWrapper.getString("MainFrame_Code"), guiBundleWrapper.getString("MainFrame_Symbol"), guiBundleWrapper.getString("MainFrame_Prev"), guiBundleWrapper.getString("MainFrame_Open"), guiBundleWrapper.getString("MainFrame_Last"), guiBundleWrapper.getString("MainFrame_High"), guiBundleWrapper.getString("MainFrame_Low"), guiBundleWrapper.getString("MainFrame_Vol"), guiBundleWrapper.getString("MainFrame_Chg"), guiBundleWrapper.getString("MainFrame_ChgPercentage"), guiBundleWrapper.getString("MainFrame_LVol"), guiBundleWrapper.getString("MainFrame_Buy"), guiBundleWrapper.getString("MainFrame_BQty"), guiBundleWrapper.getString("MainFrame_Sell"), guiBundleWrapper.getString("MainFrame_SQty"), guiBundleWrapper.getString("MainFrame_FallBelow"), guiBundleWrapper.getString("MainFrame_RiseAbove")};
        columnNames = tmp;
        languageIndependentColumnNames = tmp2;
    }
}

