/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.xml.DOMFactory;
import org.yccheok.jstock.analysis.AbstractOperator;
import org.yccheok.jstock.analysis.Operator;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.gui.IndicatorDOMFactory;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.analysis.OperatorFigure;

public class IndicatorDefaultDrawing
extends DefaultDrawing {
    private final UndoRedoManager undoRedoManager = new UndoRedoManager();

    public IndicatorDefaultDrawing() {
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat((DOMFactory)new IndicatorDOMFactory());
        LinkedList<DOMStorableInputOutputFormat> inputFormats = new LinkedList<DOMStorableInputOutputFormat>();
        inputFormats.add(ioFormat);
        this.setInputFormats(inputFormats);
        LinkedList<DOMStorableInputOutputFormat> outputFormats = new LinkedList<DOMStorableInputOutputFormat>();
        outputFormats.add(ioFormat);
        this.setOutputFormats(outputFormats);
        this.addUndoableEditListener((UndoableEditListener)this.undoRedoManager);
    }

    public OperatorIndicator getOperatorIndicator() {
        OperatorIndicator operatorIndicator = new OperatorIndicator();
        List figures = this.getChildren();
        for (Figure figure : figures) {
            if (!(figure instanceof OperatorFigure)) continue;
            OperatorFigure operatorFigure = (OperatorFigure)figure;
            operatorIndicator.add(operatorFigure.getOperator());
        }
        return operatorIndicator;
    }

    public void write(String projectName, String jHotDrawFilename, String operatorIndicatorFilename) throws IOException {
        File jHotdrawFile = new File(jHotDrawFilename);
        OperatorIndicator operatorIndicator = this.getOperatorIndicator();
        operatorIndicator.setName(projectName);
        OutputFormat outputFormat = (OutputFormat)this.getOutputFormats().get(0);
        outputFormat.write(jHotdrawFile, (Drawing)this);
        Utils.toXML((Object)operatorIndicator, operatorIndicatorFilename);
        this.undoRedoManager.setHasSignificantEdits(false);
    }

    public boolean hasSignificantEdits() {
        return this.undoRedoManager.hasSignificantEdits();
    }

    public void read(String jHotDrawFilename, String operatorIndicatorFilename) throws IOException {
        File jHotdrawFile = new File(jHotDrawFilename);
        File xStreamFile = new File(operatorIndicatorFilename);
        InputFormat inputFormat = (InputFormat)this.getInputFormats().get(0);
        inputFormat.read(jHotdrawFile, (Drawing)this);
        OperatorIndicator operatorIndicator = Utils.fromXML(OperatorIndicator.class, xStreamFile);
        if (operatorIndicator == null) {
            throw new IOException();
        }
        List figures = this.getChildren();
        int counter = 0;
        for (Figure f : figures) {
            if (!(f instanceof OperatorFigure)) continue;
            Operator operator = operatorIndicator.get(counter);
            OperatorFigure operatorFigure = (OperatorFigure)f;
            operatorFigure.setOperator(operator);
            ((AbstractOperator)operator).addPropertyChangeListener(operatorFigure);
            ++counter;
        }
    }
}

