/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.List;

public class TernarySearchTree<E> {
    private TSTNode<E> rootNode;
    private int defaultNumReturnValues = -1;

    public void put(String key, E value) {
        this.getOrCreateNode((String)key).data = value;
    }

    public E get(String key) {
        TSTNode<E> node = this.getNode(key);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    public E remove(String key) {
        TSTNode<E> node = this.getNode(key);
        this.deleteNode(this.getNode(key));
        return node != null ? (E)node.data : null;
    }

    public void setNumReturnValues(int num) {
        this.defaultNumReturnValues = num < 0 ? -1 : num;
    }

    private int checkNumberOfReturnValues(int numReturnValues) {
        return numReturnValues < 0 ? -1 : numReturnValues;
    }

    public TSTNode<E> getNode(String key) {
        return this.getNode(key, this.rootNode);
    }

    protected TSTNode<E> getNode(String key, TSTNode<E> startNode) {
        if (key == null || startNode == null || key.length() == 0) {
            return null;
        }
        TSTNode<E> currentNode = startNode;
        int charIndex = 0;
        while (currentNode != null) {
            int charComp = TernarySearchTree.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar);
            if (charComp == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                currentNode = currentNode.relatives[1];
                continue;
            }
            currentNode = currentNode.relatives[3];
        }
        return null;
    }

    public List<E> matchPrefix(String prefix) {
        return this.matchPrefix(prefix, this.defaultNumReturnValues);
    }

    public List<E> matchPrefix(String prefix, int numReturnValues) {
        int sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        ArrayList sortKeysResult = new ArrayList();
        TSTNode<E> startNode = this.getNode(prefix);
        if (startNode == null) {
            return sortKeysResult;
        }
        if (startNode.data != null) {
            sortKeysResult.add(startNode.data);
            --sortKeysNumReturnValues;
        }
        this.sortKeysRecursion(sortKeysResult, startNode.relatives[2], sortKeysNumReturnValues);
        return sortKeysResult;
    }

    private void sortKeysRecursion(List<E> sortKeysResult, TSTNode<E> currentNode, int sortKeysNumReturnValues) {
        if (currentNode == null) {
            return;
        }
        this.sortKeysRecursion(sortKeysResult, currentNode.relatives[1], sortKeysNumReturnValues);
        if (sortKeysNumReturnValues == 0) {
            return;
        }
        if (currentNode.data != null) {
            sortKeysResult.add(currentNode.data);
            --sortKeysNumReturnValues;
        }
        this.sortKeysRecursion(sortKeysResult, currentNode.relatives[2], sortKeysNumReturnValues);
        this.sortKeysRecursion(sortKeysResult, currentNode.relatives[3], sortKeysNumReturnValues);
    }

    protected List<E> sortKeys(TSTNode<E> startNode, int numReturnValues) {
        int sortKeysNumReturnValues = this.checkNumberOfReturnValues(numReturnValues);
        ArrayList sortKeysResult = new ArrayList();
        this.sortKeysRecursion(sortKeysResult, startNode, sortKeysNumReturnValues);
        return sortKeysResult;
    }

    protected TSTNode<E> getOrCreateNode(String key) throws NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException("attempt to get or create node with null key");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("attempt to get or create node with key of zero length");
        }
        if (this.rootNode == null) {
            this.rootNode = new TSTNode(key.charAt(0), null);
        }
        TSTNode<E> currentNode = this.rootNode;
        int charIndex = 0;
        while (true) {
            int charComp;
            if ((charComp = TernarySearchTree.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar)) == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                if (currentNode.relatives[2] == null) {
                    currentNode.relatives[2] = new TSTNode<E>(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                if (currentNode.relatives[1] == null) {
                    currentNode.relatives[1] = new TSTNode<E>(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[1];
                continue;
            }
            if (currentNode.relatives[3] == null) {
                currentNode.relatives[3] = new TSTNode<E>(key.charAt(charIndex), currentNode);
            }
            currentNode = currentNode.relatives[3];
        }
    }

    private void deleteNode(TSTNode<E> nodeToDelete) {
        if (nodeToDelete == null) {
            return;
        }
        nodeToDelete.data = null;
        while (nodeToDelete != null) {
            nodeToDelete = this.deleteNodeRecursion(nodeToDelete);
        }
    }

    private TSTNode<E> deleteNodeRecursion(TSTNode<E> currentNode) {
        TSTNode targetNode;
        int movingKid;
        int childType;
        boolean hikidNull;
        if (currentNode == null) {
            return null;
        }
        if (currentNode.relatives[2] != null || currentNode.data != null) {
            return null;
        }
        TSTNode currentParent = currentNode.relatives[0];
        boolean lokidNull = currentNode.relatives[1] == null;
        boolean bl = hikidNull = currentNode.relatives[3] == null;
        if (currentParent == null && currentNode == this.rootNode) {
            this.rootNode = null;
            return null;
        }
        if (currentParent.relatives[1] == currentNode) {
            childType = 1;
        } else if (currentParent.relatives[2] == currentNode) {
            childType = 2;
        } else if (currentParent.relatives[3] == currentNode) {
            childType = 3;
        } else {
            this.rootNode = null;
            return null;
        }
        if (lokidNull && hikidNull) {
            currentParent.relatives[childType] = null;
            return currentParent;
        }
        if (lokidNull) {
            currentParent.relatives[childType] = currentNode.relatives[3];
            currentNode.relatives[3].relatives[0] = currentParent;
            return currentParent;
        }
        if (hikidNull) {
            currentParent.relatives[childType] = currentNode.relatives[1];
            currentNode.relatives[1].relatives[0] = currentParent;
            return currentParent;
        }
        int deltaHi = currentNode.relatives[3].splitchar - currentNode.splitchar;
        int deltaLo = currentNode.splitchar - currentNode.relatives[1].splitchar;
        if (deltaHi == deltaLo) {
            if (Math.random() < 0.5) {
                ++deltaHi;
            } else {
                ++deltaLo;
            }
        }
        if (deltaHi > deltaLo) {
            movingKid = 3;
            targetNode = currentNode.relatives[1];
        } else {
            movingKid = 1;
            targetNode = currentNode.relatives[3];
        }
        while (targetNode.relatives[movingKid] != null) {
            targetNode = targetNode.relatives[movingKid];
        }
        targetNode.relatives[movingKid] = currentNode.relatives[movingKid];
        currentParent.relatives[childType] = targetNode;
        targetNode.relatives[0] = currentParent;
        if (!lokidNull) {
            currentNode.relatives[1] = null;
        }
        if (!hikidNull) {
            currentNode.relatives[3] = null;
        }
        return currentParent;
    }

    private static int compareCharsAlphabetically(char cCompare, char cRef) {
        return TernarySearchTree.alphabetizeChar(cCompare) - TernarySearchTree.alphabetizeChar(cRef);
    }

    private static int alphabetizeChar(char c) {
        if (c < 'A') {
            return c;
        }
        if (c < 'Y') {
            return 2 * c - 65;
        }
        if (c < 'a') {
            return c + 24;
        }
        if (c < 'y') {
            return 2 * c - 128;
        }
        return c;
    }

    private static final class TSTNode<E> {
        protected static final int PARENT = 0;
        protected static final int LOKID = 1;
        protected static final int EQKID = 2;
        protected static final int HIKID = 3;
        protected char splitchar;
        protected TSTNode<E>[] relatives = new TSTNode[4];
        protected E data;

        protected TSTNode(char splitchar, TSTNode<E> parent) {
            this.splitchar = splitchar;
            this.relatives[0] = parent;
        }
    }
}

