/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.color.ColorSliderModel;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.ColorWheelImageProducer;
import org.jhotdraw.color.DefaultColorSliderModel;
import org.jhotdraw.color.HSVRGBColorSystem;

public class JColorWheel
extends JPanel {
    private ColorSystem sys;
    protected Insets wheelInsets;
    protected Image colorWheelImage;
    protected ColorWheelImageProducer colorWheelProducer;
    protected ColorSliderModel model;
    protected int radialIndex = 1;
    protected int angularIndex = 0;
    protected int verticalIndex = 2;
    private MouseHandler mouseHandler;
    private ModelHandler modelHandler;

    public JColorWheel() {
        this(new HSVRGBColorSystem());
    }

    public JColorWheel(ColorSystem sys) {
        this.sys = sys;
        this.wheelInsets = new Insets(0, 0, 0, 0);
        this.model = new DefaultColorSliderModel(sys);
        this.initComponents();
        this.colorWheelProducer = this.createWheelProducer(0, 0);
        this.modelHandler = new ModelHandler();
        this.model.addChangeListener(this.modelHandler);
        this.installMouseListeners();
        this.setOpaque(false);
    }

    protected void installMouseListeners() {
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
    }

    public void setModel(ColorSliderModel m) {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelHandler);
        }
        this.model = m;
        if (this.model != null) {
            this.model.addChangeListener(this.modelHandler);
            this.colorWheelProducer = this.createWheelProducer(this.getWidth(), this.getHeight());
            this.repaint();
        }
    }

    public void setRadialComponentIndex(int newValue) {
        this.radialIndex = newValue;
        this.colorWheelImage = null;
        this.repaint();
    }

    public void setAngularComponentIndex(int newValue) {
        this.angularIndex = newValue;
        this.colorWheelImage = null;
        this.repaint();
    }

    public void setVerticalComponentIndex(int newValue) {
        this.verticalIndex = newValue;
        this.colorWheelImage = null;
        this.repaint();
    }

    public void setWheelInsets(Insets newValue) {
        this.wheelInsets = newValue;
        this.repaint();
    }

    public Insets getWheelInsets() {
        return this.wheelInsets;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public ColorSliderModel getModel() {
        return this.model;
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        this.paintWheel(g);
        this.paintThumb(g);
    }

    protected ColorWheelImageProducer createWheelProducer(int w, int h) {
        ColorWheelImageProducer p = new ColorWheelImageProducer(this.model.getColorSystem(), w, h);
        p.setAngularComponentIndex(this.angularIndex);
        p.setRadialComponentIndex(this.radialIndex);
        p.setVerticalComponentIndex(this.verticalIndex);
        return p;
    }

    protected void paintWheel(Graphics2D g) {
        int w = this.getWidth() - this.wheelInsets.left - this.wheelInsets.right;
        int h = this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom;
        if (this.colorWheelImage == null || this.colorWheelImage.getWidth(this) != w || this.colorWheelImage.getHeight(this) != h) {
            if (this.colorWheelImage != null) {
                this.colorWheelImage.flush();
            }
            this.colorWheelProducer = this.createWheelProducer(w, h);
            this.colorWheelImage = this.createImage(this.colorWheelProducer);
        }
        this.colorWheelProducer.setVerticalValue(this.model.getComponentValue(this.verticalIndex));
        this.colorWheelProducer.regenerateColorWheel();
        g.drawImage(this.colorWheelImage, this.wheelInsets.left, this.wheelInsets.top, this);
    }

    protected void paintThumb(Graphics2D g) {
        Point p = this.getThumbLocation();
        g.setColor(Color.white);
        g.fillRect(p.x - 1, p.y - 1, 2, 2);
        g.setColor(Color.black);
        g.drawRect(p.x - 2, p.y - 2, 3, 3);
    }

    protected Point getCenter() {
        int w = this.getWidth() - this.wheelInsets.left - this.wheelInsets.right;
        int h = this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom;
        return new Point(this.wheelInsets.left + w / 2, this.wheelInsets.top + h / 2);
    }

    protected int getRadius() {
        return this.colorWheelProducer.getRadius();
    }

    protected Point getThumbLocation() {
        return this.getColorLocation(this.model.getComponentValue(0), this.model.getComponentValue(1), this.model.getComponentValue(2));
    }

    protected Point getColorLocation(Color c) {
        Point p = this.colorWheelProducer.getColorLocation(c, this.getWidth() - this.wheelInsets.left - this.wheelInsets.right, this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom);
        p.x += this.wheelInsets.left;
        p.y += this.wheelInsets.top;
        return p;
    }

    protected Point getColorLocation(float hue, float saturation, float brightness) {
        Point p = this.colorWheelProducer.getColorLocation(hue, saturation, brightness, this.getWidth() - this.wheelInsets.left - this.wheelInsets.right, this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom);
        p.x += this.wheelInsets.left;
        p.y += this.wheelInsets.top;
        return p;
    }

    protected float[] getColorAt(int x, int y) {
        float[] cc = this.colorWheelProducer.getColorAt(x - this.wheelInsets.left, y - this.wheelInsets.top, this.getWidth() - this.wheelInsets.left - this.wheelInsets.right, this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom);
        return cc;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class ModelHandler
    implements ChangeListener {
        private ModelHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JColorWheel.this.repaint();
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.update(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.update(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.update(e);
        }

        private void update(MouseEvent e) {
            float[] hsb = JColorWheel.this.getColorAt(e.getX(), e.getY());
            JColorWheel.this.model.setComponentValue(JColorWheel.this.angularIndex, hsb[JColorWheel.this.angularIndex]);
            JColorWheel.this.model.setComponentValue(JColorWheel.this.radialIndex, hsb[JColorWheel.this.radialIndex]);
            JColorWheel.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

