/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.annotation.processing;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import jlibs.core.annotation.processing.Environment;
import jlibs.core.lang.model.ModelUtil;

public class AnnotationError
extends Error {
    private Element pos1;
    private AnnotationMirror pos2;
    private AnnotationValue pos3;

    public AnnotationError(String message) {
        super(message);
    }

    public AnnotationError(Element pos, String message) {
        this(message);
        this.pos1 = pos;
    }

    public AnnotationError(Element elem, Class annotation, String message) {
        this(elem, ModelUtil.getAnnotationMirror(elem, annotation), message);
    }

    public AnnotationError(Element elem, Class annotation, String method, String message) {
        this(elem, ModelUtil.getAnnotationMirror(elem, annotation), ModelUtil.getRawAnnotationValue(elem, ModelUtil.getAnnotationMirror(elem, annotation), method), message);
    }

    public AnnotationError(Element pos1, AnnotationMirror pos2, String message) {
        this(pos1, message);
        this.pos2 = pos2;
    }

    public AnnotationError(Element pos1, AnnotationMirror pos2, AnnotationValue pos3, String message) {
        this(pos1, pos2, message);
        this.pos3 = pos3;
    }

    public void printMessage(Diagnostic.Kind kind) {
        if (this.pos1 == null) {
            Environment.get().getMessager().printMessage(kind, this.getMessage());
        } else if (this.pos2 == null) {
            Environment.get().getMessager().printMessage(kind, this.getMessage(), this.pos1);
        } else if (this.pos3 == null) {
            Environment.get().getMessager().printMessage(kind, this.getMessage(), this.pos1, this.pos2);
        } else {
            Environment.get().getMessager().printMessage(kind, this.getMessage(), this.pos1, this.pos2, this.pos3);
        }
    }

    public void report() {
        this.printMessage(Diagnostic.Kind.ERROR);
    }

    public void warn() {
        this.printMessage(Diagnostic.Kind.WARNING);
    }
}

