/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.utils.Entities;
import cz.vity.freerapid.plugins.webclient.utils.GOCR;
import cz.vity.freerapid.utilities.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.methods.PostMethod;

public final class PlugUtils {
    private static final Logger logger = Logger.getLogger(PlugUtils.class.getName());
    private static Pattern parameterInputPattern;
    private static Pattern parameterNamePattern;
    private static Pattern parameterValuePattern;

    public static long getFileSizeFromString(String string) throws PluginImplementationException {
        String value = string.replace('\u0431', 'B').replace('\u043a', 'K').replace('\u041a', 'K').replace('\u041c', 'M').replace('\u0433', 'G').replace('\u0413', 'G');
        value = value.toUpperCase(Locale.ENGLISH).replaceAll("(\\s|\u00a0|&NBSP;)+", "");
        long constant = 1L;
        int index = value.lastIndexOf("KB");
        if (index >= 0) {
            constant = 1024L;
        } else {
            index = value.lastIndexOf("MB");
            if (index >= 0) {
                constant = 0x100000L;
            } else {
                index = value.lastIndexOf("GB");
                if (index >= 0) {
                    constant = 0x40000000L;
                } else {
                    index = value.lastIndexOf("TB");
                    if (index >= 0) {
                        constant = 0x10000000000L;
                    } else {
                        index = value.lastIndexOf("BYTE");
                        if (index < 0) {
                            index = value.lastIndexOf("BB");
                        }
                        if (index < 0) {
                            index = value.lastIndexOf("B");
                        }
                    }
                }
            }
        }
        if (index > 0) {
            value = value.substring(0, index);
        }
        try {
            value = PlugUtils.handlePointAndComma(value);
        }
        catch (IllegalArgumentException e) {
            throw new PluginImplementationException("Error parsing file size: " + string);
        }
        try {
            if (value.indexOf(46) > 0) {
                return new BigDecimal(value).multiply(BigDecimal.valueOf(constant)).setScale(0, RoundingMode.UP).longValue();
            }
            return Long.parseLong(value) * constant;
        }
        catch (NumberFormatException e) {
            throw new PluginImplementationException("Error parsing file size: " + string);
        }
    }

    private static String handlePointAndComma(String string) {
        boolean multipleCommas;
        int firstPointIndex = string.indexOf(46);
        int lastPointIndex = string.lastIndexOf(46);
        int firstCommaIndex = string.indexOf(44);
        int lastCommaIndex = string.lastIndexOf(44);
        boolean noPoints = firstPointIndex == -1 && lastPointIndex == -1;
        boolean noCommas = firstCommaIndex == -1 && lastCommaIndex == -1;
        boolean multiplePoints = firstPointIndex != lastPointIndex;
        boolean bl = multipleCommas = firstCommaIndex != lastCommaIndex;
        if (noPoints && noCommas) {
            return string;
        }
        if (multiplePoints && multipleCommas) {
            throw new IllegalArgumentException();
        }
        if (noPoints && multipleCommas) {
            return string.replace(",", "");
        }
        if (noCommas && multiplePoints) {
            return string.replace(".", "");
        }
        if (multiplePoints && firstCommaIndex < lastPointIndex) {
            throw new IllegalArgumentException();
        }
        if (multipleCommas && firstPointIndex < lastCommaIndex) {
            throw new IllegalArgumentException();
        }
        if (lastPointIndex < lastCommaIndex) {
            return string.replace(".", "").replace(',', '.');
        }
        return string.replace(",", "");
    }

    public static Matcher matcher(String regexp, String contentString) {
        if (contentString == null) {
            throw new NullPointerException("Input value cannot be null");
        }
        return Pattern.compile(regexp, 8).matcher(contentString);
    }

    public static boolean find(String regexp, String contentString) {
        return PlugUtils.matcher(regexp, contentString).find();
    }

    public static String unescapeHtml(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter((int)((double)str.length() * 1.5));
            Entities.HTML40.unescape(writer, str);
            return writer.toString().replaceAll("\u00a0", " ");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot unescape HTML", e);
            return null;
        }
    }

    public static String unescapeUnicode(String str) throws PluginImplementationException {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        block14: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == str.length() - 1) {
                        buf.append('\\');
                        continue block14;
                    }
                    c = str.charAt(++i);
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            continue block14;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block14;
                        }
                        case 'r': {
                            buf.append('\r');
                            continue block14;
                        }
                        case 'u': {
                            int value = 0;
                            block15: for (int j = 0; j < 4; ++j) {
                                c = str.charAt(++i);
                                switch (c) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + c - 48;
                                        continue block15;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + c - 97;
                                        continue block15;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + c - 65;
                                        continue block15;
                                    }
                                    default: {
                                        throw new PluginImplementationException("Malformed \\uxxxx encoding: " + str);
                                    }
                                }
                            }
                            buf.append((char)value);
                            continue block14;
                        }
                    }
                    buf.append(c);
                    continue block14;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String getParameter(String name, String content) throws PluginImplementationException {
        PlugUtils.initParameterPatterns();
        int start = 0;
        Matcher matcher = parameterInputPattern.matcher(content);
        while (matcher.find(start)) {
            String input = matcher.group(1);
            Matcher matchName = parameterNamePattern.matcher(input);
            if (matchName.find()) {
                String paramName = PlugUtils.getCorrectGroup(matchName);
                if (name.toLowerCase().equals(paramName.toLowerCase())) {
                    Matcher matchValue = parameterValuePattern.matcher(input);
                    if (matchValue.find()) {
                        return PlugUtils.getCorrectGroup(matchValue);
                    }
                    return "";
                }
            }
            start = matcher.end();
        }
        throw new PluginImplementationException("Parameter " + name + " was not found");
    }

    public static void addParameters(PostMethod postMethod, String content, String[] parameters) throws PluginImplementationException {
        if (parameters.length == 0) {
            throw new IllegalArgumentException("You have to provide some parameter names");
        }
        HashSet<String> set = new HashSet<String>(parameters.length);
        set.addAll(Arrays.asList(parameters));
        PlugUtils.initParameterPatterns();
        int start = 0;
        Matcher matcher = parameterInputPattern.matcher(content);
        while (matcher.find(start)) {
            String paramName;
            String input = matcher.group(1);
            Matcher matchName = parameterNamePattern.matcher(input);
            if (matchName.find() && set.contains(paramName = PlugUtils.getCorrectGroup(matchName))) {
                Matcher matchValue = parameterValuePattern.matcher(input);
                String paramValue = "";
                if (matchValue.find()) {
                    paramValue = PlugUtils.getCorrectGroup(matchValue);
                }
                set.remove(paramName);
                postMethod.addParameter(paramName, paramValue);
                if (set.isEmpty()) break;
            }
            start = matcher.end();
        }
        if (!set.isEmpty()) {
            throw new PluginImplementationException("The parameters " + Arrays.toString(set.toArray()) + " were not found");
        }
    }

    private static void initParameterPatterns() {
        if (parameterInputPattern == null) {
            parameterInputPattern = Pattern.compile("<input (.+?)>", 42);
        }
        if (parameterNamePattern == null) {
            parameterNamePattern = Pattern.compile("(?:name\\s?=\\s?)(?:([\"]([^\"]+)[\">$])|([']([^']+)['>$])|(([^'\">\\s]+)[/\\s>$]?))", 10);
        }
        if (parameterValuePattern == null) {
            parameterValuePattern = Pattern.compile("(?:value\\s?=\\s?)(?:([\"]([^\"]+)[\">$])|([']([^']+)['>$])|(([^'\">\\s]+)[/\\s>$]?))", 10);
        }
    }

    private static String getCorrectGroup(Matcher matcher) {
        for (int i = matcher.groupCount(); i > 0; --i) {
            String group = matcher.group(i);
            if (group == null) continue;
            return group;
        }
        throw new IllegalStateException("Group cannot be empty");
    }

    public static String replaceEntities(String s) {
        return s.replaceAll("&amp;", "&");
    }

    public static String recognize(BufferedImage image, String commandLineOptions) {
        GOCR gocr = new GOCR(image, commandLineOptions);
        try {
            return gocr.recognize();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void checkName(HttpFile file, String content, String fileNameBefore, String fileNameAfter) throws PluginImplementationException {
        Matcher matcher = PlugUtils.prepareMatcher(fileNameBefore, "(.+?)", fileNameAfter, content);
        if (!matcher.find()) {
            throw new PluginImplementationException("File name not found");
        }
        String fileName = matcher.group(1);
        logger.info("File name " + fileName);
        file.setFileName(fileName);
    }

    public static void checkFileSize(HttpFile file, String content, String fileSizeBefore, String fileSizeAfter) throws PluginImplementationException {
        Matcher matcher = PlugUtils.prepareMatcher(fileSizeBefore, "(.+?)", fileSizeAfter, content);
        if (!matcher.find()) {
            throw new PluginImplementationException("File size not found");
        }
        String fileSize = matcher.group(1);
        logger.info("File size " + fileSize);
        long size = PlugUtils.getFileSizeFromString(matcher.group(1));
        file.setFileSize(size);
    }

    public static String getStringBetween(String content, String stringBefore, String stringAfter) throws PluginImplementationException {
        return PlugUtils.getStringBetween(content, stringBefore, stringAfter, 1);
    }

    public static String getStringBetween(String content, String stringBefore, String stringAfter, int count) throws PluginImplementationException {
        if (count < 1) {
            throw new IllegalArgumentException("Finding count is less than 1");
        }
        Matcher matcher = PlugUtils.prepareMatcher(stringBefore, "(.+?)", stringAfter, content);
        for (int i = 1; i <= count; ++i) {
            if (matcher.find()) {
                if (i != count) continue;
                return matcher.group(1);
            }
            throw new PluginImplementationException(String.format("No string between '%s' and '%s' was found", stringBefore, stringAfter));
        }
        throw new PluginImplementationException();
    }

    public static int getNumberBetween(String content, String stringBefore, String stringAfter) throws PluginImplementationException {
        Matcher matcher = PlugUtils.prepareMatcher(stringBefore, "(\\d+?)", stringAfter, content);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new PluginImplementationException(String.format("No number between '%s' and '%s' was found", stringBefore, stringAfter));
    }

    public static int getWaitTimeBetween(String content, String stringBefore, String stringAfter, TimeUnit srcTimeUnit) throws PluginImplementationException {
        int i = PlugUtils.getNumberBetween(content, stringBefore, stringAfter);
        return (int)srcTimeUnit.toSeconds(i);
    }

    private static Matcher prepareMatcher(String before, String middle, String after, String content) {
        before = Pattern.quote(Utils.rtrim(before)).replaceAll("\n", "\\\\E\\\\s*\\\\Q");
        after = Pattern.quote(Utils.ltrim(after)).replaceAll("\n", "\\\\E\\\\s*\\\\Q");
        return PlugUtils.matcher(before + "\\s*" + middle + "\\s*" + after, content);
    }

    public static String suggestFilename(String stringURL) throws PluginImplementationException {
        if (stringURL == null || stringURL.isEmpty()) {
            throw new PluginImplementationException("Error suggesting file name");
        }
        try {
            String path = new URL(stringURL).getPath();
            int i = path.lastIndexOf("/");
            if (i < 0) {
                throw new PluginImplementationException("Error suggesting file name");
            }
            return URLDecoder.decode(path.substring(i + 1), "UTF-8");
        }
        catch (Exception e) {
            throw new PluginImplementationException("Error suggesting file name");
        }
    }
}

