/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.SpecialEntities;
import org.htmlcleaner.SpecialEntity;

public class Utils {
    private static String ampNcr;
    private static final Pattern ASCII_CHAR;
    public static Pattern HEX_STRICT;
    public static Pattern HEX_RELAXED;
    public static Pattern DECIMAL;

    static String bchomp(String str) {
        return Utils.chomp(Utils.lchomp(str));
    }

    static String chomp(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return "";
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (last != '\r') {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    static String lchomp(String str) {
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return "";
            }
            return str;
        }
        int firstIndex = 0;
        char first = str.charAt(0);
        if (first == '\n') {
            ++firstIndex;
            if (str.charAt(1) == '\r') {
                ++firstIndex;
            }
        } else if (first != '\r') {
            firstIndex = 0;
        }
        return str.substring(firstIndex, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static CharSequence readUrl(URL url, String charset) throws IOException {
        StringBuilder buffer = new StringBuilder(1024);
        InputStream inputStream = url.openStream();
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, charset);
            char[] charArray = new char[1024];
            int charsRead = 0;
            do {
                if ((charsRead = reader.read(charArray)) < 0) continue;
                buffer.append(charArray, 0, charsRead);
            } while (charsRead > 0);
        }
        finally {
            inputStream.close();
        }
        return buffer;
    }

    public static boolean isFullUrl(String link) {
        if (link == null) {
            return false;
        }
        return (link = link.trim().toLowerCase()).startsWith("http://") || link.startsWith("https://") || link.startsWith("file://");
    }

    public static String fullUrl(String pageUrl, String link) {
        if (Utils.isFullUrl(link)) {
            return link;
        }
        if (link != null && link.startsWith("?")) {
            int qindex = pageUrl.indexOf(63);
            int len = pageUrl.length();
            if (qindex < 0) {
                return pageUrl + link;
            }
            if (qindex == len - 1) {
                return pageUrl.substring(0, len - 1) + link;
            }
            return pageUrl + "&" + link.substring(1);
        }
        boolean isLinkAbsolute = link.startsWith("/");
        if (!Utils.isFullUrl(pageUrl)) {
            pageUrl = "http://" + pageUrl;
        }
        int slashIndex = isLinkAbsolute ? pageUrl.indexOf("/", 8) : pageUrl.lastIndexOf("/");
        pageUrl = slashIndex <= 8 ? pageUrl + "/" : pageUrl.substring(0, slashIndex + 1);
        return isLinkAbsolute ? pageUrl + link.substring(1) : pageUrl + link;
    }

    public static String escapeHtml(String s, CleanerProperties props) {
        boolean advanced = props.isAdvancedXmlEscape();
        boolean recognizeUnicodeChars = props.isRecognizeUnicodeChars();
        boolean translateSpecialEntities = props.isTranslateSpecialEntities();
        boolean transResCharsToNCR = props.isTransResCharsToNCR();
        boolean transSpecialEntitiesToNCR = props.isTransSpecialEntitiesToNCR();
        return Utils.escapeXml(s, advanced, recognizeUnicodeChars, translateSpecialEntities, false, transResCharsToNCR, transSpecialEntitiesToNCR, true);
    }

    public static String escapeXml(String s, CleanerProperties props, boolean isDomCreation) {
        boolean advanced = props.isAdvancedXmlEscape();
        boolean recognizeUnicodeChars = props.isRecognizeUnicodeChars();
        boolean translateSpecialEntities = props.isTranslateSpecialEntities();
        boolean transResCharsToNCR = props.isTransResCharsToNCR();
        boolean transSpecialEntitiesToNCR = props.isTransSpecialEntitiesToNCR();
        return Utils.escapeXml(s, advanced, recognizeUnicodeChars, translateSpecialEntities, isDomCreation, transResCharsToNCR, transSpecialEntitiesToNCR, false);
    }

    public static String escapeXml(String s, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities, boolean isDomCreation, boolean transResCharsToNCR, boolean translateSpecialEntitiesToNCR) {
        return Utils.escapeXml(s, advanced, recognizeUnicodeChars, translateSpecialEntities, isDomCreation, transResCharsToNCR, translateSpecialEntitiesToNCR, false);
    }

    public static String escapeXml(String s, boolean advanced, boolean recognizeUnicodeChars, boolean translateSpecialEntities, boolean isDomCreation, boolean transResCharsToNCR, boolean translateSpecialEntitiesToNCR, boolean isHtmlOutput) {
        if (s != null) {
            int len = s.length();
            StringBuilder result = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                SpecialEntity code;
                char ch = s.charAt(i);
                if (ch == '&') {
                    if ((advanced || recognizeUnicodeChars) && i < len - 1 && s.charAt(i + 1) == '#') {
                        i = Utils.convertToUnicode(s, isDomCreation, recognizeUnicodeChars, translateSpecialEntitiesToNCR, result, i + 2);
                        continue;
                    }
                    if ((translateSpecialEntities || advanced) && (code = SpecialEntities.INSTANCE.getSpecialEntity(s.substring(i, i + Math.min(10, len - i)))) != null) {
                        if (translateSpecialEntities && code.isHtmlSpecialEntity()) {
                            if (recognizeUnicodeChars) {
                                result.append((char)code.intValue());
                            } else {
                                result.append(code.getDecimalNCR());
                            }
                            i += code.getKey().length() + 1;
                            continue;
                        }
                        if (advanced) {
                            result.append(transResCharsToNCR ? code.getDecimalNCR() : code.getEscaped(isHtmlOutput || isDomCreation));
                            i += code.getKey().length() + 1;
                            continue;
                        }
                        result.append(transResCharsToNCR ? Utils.getAmpNcr() : "&amp;");
                        continue;
                    }
                    if (isHtmlOutput) {
                        code = SpecialEntities.INSTANCE.getSpecialEntity(s.substring(i, i + Math.min(10, len - i)));
                        if (code != null) {
                            result.append(code.getEscapedValue());
                            i += code.getKey().length() + 1;
                            continue;
                        }
                        if (i < len - 1 && s.charAt(i + 1) == '#') {
                            i = Utils.convert_To_Entity_Name(s, false, false, false, result, i + 2);
                            continue;
                        }
                        result.append(transResCharsToNCR ? Utils.getAmpNcr() : "&amp;");
                        continue;
                    }
                    result.append(transResCharsToNCR ? Utils.getAmpNcr() : "&amp;");
                    continue;
                }
                code = SpecialEntities.INSTANCE.getSpecialEntityByUnicode(ch);
                if (code != null) {
                    if (isHtmlOutput) {
                        if ("apos".equals(code.getKey())) {
                            result.append(ch);
                            continue;
                        }
                        result.append(isDomCreation ? code.getHtmlString() : code.getEscapedValue());
                        continue;
                    }
                    result.append(transResCharsToNCR ? code.getDecimalNCR() : code.getEscaped(isDomCreation));
                    continue;
                }
                result.append(ch);
            }
            return result.toString();
        }
        return null;
    }

    private static String getAmpNcr() {
        if (ampNcr == null) {
            ampNcr = SpecialEntities.INSTANCE.getSpecialEntityByUnicode(38).getDecimalNCR();
        }
        return ampNcr;
    }

    private static int convert_To_Entity_Name(String s, boolean domCreation, boolean recognizeUnicodeChars, boolean translateSpecialEntitiesToNCR, StringBuilder result, int i) {
        int charIndex;
        block11: {
            StringBuilder unicode = new StringBuilder();
            charIndex = Utils.extractCharCode(s, i, true, unicode);
            if (unicode.length() > 0) {
                try {
                    boolean isHex = unicode.substring(0, 1).equals("x");
                    int codePoint = -1;
                    char[] unicodeChar = null;
                    if (isHex) {
                        codePoint = Integer.parseInt(unicode.substring(1), 16);
                        unicodeChar = Character.toChars(codePoint);
                    } else {
                        codePoint = Integer.parseInt(unicode.toString());
                        unicodeChar = Character.toChars(codePoint);
                    }
                    SpecialEntity specialEntity = SpecialEntities.INSTANCE.getSpecialEntityByUnicode(codePoint);
                    if (unicodeChar.length == 1 && unicodeChar[0] == '\u0000') {
                        result.append("&amp;");
                        break block11;
                    }
                    if (specialEntity != null) {
                        if (specialEntity.isHtmlSpecialEntity()) {
                            result.append(domCreation ? specialEntity.getHtmlString() : specialEntity.getEscapedValue());
                            break block11;
                        }
                        result.append(domCreation ? specialEntity.getHtmlString() : (translateSpecialEntitiesToNCR ? (isHex ? specialEntity.getHexNCR() : specialEntity.getDecimalNCR()) : specialEntity.getHtmlString()));
                        break block11;
                    }
                    if (recognizeUnicodeChars) {
                        result.append(String.valueOf(unicodeChar));
                        break block11;
                    }
                    if (ASCII_CHAR.matcher(new String(unicodeChar)).find()) {
                        result.append(String.valueOf(unicodeChar));
                        break block11;
                    }
                    result.append("&#").append((CharSequence)unicode).append(";");
                }
                catch (NumberFormatException e) {
                    result.append("&amp;#").append((CharSequence)unicode).append(";");
                }
            } else {
                result.append("&amp;");
            }
        }
        return charIndex;
    }

    private static int convertToUnicode(String s, boolean domCreation, boolean recognizeUnicodeChars, boolean translateSpecialEntitiesToNCR, StringBuilder result, int i) {
        int charIndex;
        block9: {
            StringBuilder unicode = new StringBuilder();
            charIndex = Utils.extractCharCode(s, i, true, unicode);
            if (unicode.length() > 0) {
                try {
                    boolean isHex = unicode.substring(0, 1).equals("x");
                    int codePoint = -1;
                    char[] unicodeChar = null;
                    codePoint = isHex ? Integer.parseInt(unicode.substring(1), 16) : Integer.parseInt(unicode.toString());
                    unicodeChar = Character.toChars(codePoint);
                    SpecialEntity specialEntity = SpecialEntities.INSTANCE.getSpecialEntityByUnicode(codePoint);
                    if (unicodeChar.length == 1 && unicodeChar[0] == '\u0000') {
                        result.append("&amp;");
                        break block9;
                    }
                    if (!(specialEntity == null || specialEntity.isHtmlSpecialEntity() && recognizeUnicodeChars)) {
                        result.append(domCreation ? specialEntity.getHtmlString() : (translateSpecialEntitiesToNCR ? (isHex ? specialEntity.getHexNCR() : specialEntity.getDecimalNCR()) : specialEntity.getEscapedXmlString()));
                        break block9;
                    }
                    if (recognizeUnicodeChars) {
                        result.append(String.valueOf(unicodeChar));
                        break block9;
                    }
                    if (ASCII_CHAR.matcher(new String(unicodeChar)).find()) {
                        result.append(String.valueOf(unicodeChar));
                        break block9;
                    }
                    result.append("&#").append((CharSequence)unicode).append(";");
                }
                catch (NumberFormatException e) {
                    result.append("&amp;#").append((CharSequence)unicode).append(";");
                }
                catch (IllegalArgumentException e) {
                    result.append("&amp;#").append((CharSequence)unicode).append(";");
                }
            } else {
                result.append("&amp;");
            }
        }
        return charIndex;
    }

    private static int extractCharCode(String s, int charIndex, boolean relaxedUnicode, StringBuilder unicode) {
        int len = s.length();
        CharSequence subSequence = s.subSequence(charIndex, Math.min(len, charIndex + 15));
        Matcher matcher = relaxedUnicode ? HEX_RELAXED.matcher(subSequence) : HEX_STRICT.matcher(subSequence);
        if (matcher.find() || (matcher = DECIMAL.matcher(subSequence)).find()) {
            charIndex += matcher.end() - 1;
            unicode.append(matcher.group(1));
        }
        return charIndex;
    }

    public static String sanitizeXmlAttributeName(String attName, String prefix) {
        if (Utils.isValidXmlIdentifier(attName)) {
            return attName;
        }
        String generatedAttName = prefix + attName;
        if (Utils.isValidXmlIdentifier(generatedAttName)) {
            return generatedAttName;
        }
        generatedAttName = prefix;
        for (int i = 0; i < attName.length(); ++i) {
            if (!Utils.isValidXmlIdentifierChar(attName.charAt(i))) continue;
            generatedAttName = generatedAttName + attName.charAt(i);
        }
        if (Utils.isValidXmlIdentifier(generatedAttName)) {
            return generatedAttName;
        }
        return null;
    }

    public static boolean isIdentifierHelperChar(char ch) {
        return ':' == ch || '.' == ch || '-' == ch || '_' == ch;
    }

    public static boolean isValidXmlIdentifier(String s) {
        if (s != null) {
            int len = s.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if ((i != 0 || Character.isUnicodeIdentifierStart(ch)) && (Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || Utils.isIdentifierHelperChar(ch))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(Object o) {
        if (o == null) {
            return true;
        }
        String s = o.toString();
        String text = Utils.escapeXml(s, true, false, false, false, false, false, false);
        String last = text.replace('\u00a0', ' ').trim();
        return last.length() == 0;
    }

    public static String[] tokenize(String s, String delimiters) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        String[] result = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            result[index++] = tokenizer.nextToken();
        }
        return result;
    }

    public static String getXmlNSPrefix(String name) {
        int colIndex = name.indexOf(58);
        if (colIndex > 0) {
            return name.substring(0, colIndex);
        }
        return null;
    }

    public static String getXmlName(String name) {
        int colIndex = name.indexOf(58);
        if (colIndex > 0 && colIndex < name.length() - 1) {
            return name.substring(colIndex + 1);
        }
        return name;
    }

    static boolean isValidInt(String s, int radix) {
        try {
            Integer.parseInt(s, radix);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static boolean isValidXmlChar(char ch) {
        return ch >= ' ' && ch <= '\ud7ff' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
    }

    public static boolean isValidXmlIdentifierChar(char ch) {
        return Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || Utils.isIdentifierHelperChar(ch);
    }

    public static String ltrim(String s) {
        int index;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (index = 0; index < len && Character.isWhitespace(s.charAt(index)); ++index) {
        }
        return index >= len ? "" : s.substring(index);
    }

    public static String rtrim(String s) {
        int len;
        int index;
        if (s == null) {
            return null;
        }
        for (index = len = s.length(); index > 0 && Character.isWhitespace(s.charAt(index - 1)); --index) {
        }
        return index <= 0 ? "" : s.substring(0, index);
    }

    public static boolean isWhitespaceString(Object object) {
        if (object != null) {
            String s = object.toString();
            return s != null && "".equals(s.trim());
        }
        return false;
    }

    public static String deserializeEntities(String str, boolean recognizeUnicodeChars) {
        StringBuffer buf = new StringBuffer(str);
        SpecialEntities entities = SpecialEntities.INSTANCE;
        int entityStart = -1;
        boolean numericEntity = false;
        boolean hexEntity = false;
        int maxEntityLength = entities.getMaxEntityLength();
        int i = 0;
        int length = buf.length();
        while (i < length) {
            if (buf.charAt(i) == '&') {
                entityStart = i++;
                numericEntity = false;
                hexEntity = false;
                continue;
            }
            if (entityStart != -1) {
                if (buf.charAt(i) == ';') {
                    SpecialEntity entity;
                    int entityValue = -1;
                    if (numericEntity) {
                        try {
                            entityValue = Integer.parseInt(buf.substring(entityStart + (hexEntity ? 3 : 2), i), hexEntity ? 16 : 10);
                        }
                        catch (NumberFormatException e) {
                            entityValue = -1;
                        }
                        entity = entities.getSpecialEntityByUnicode(entityValue);
                        if (entity != null) {
                            entityValue = entity.intValue();
                        } else if (!recognizeUnicodeChars) {
                            entityValue = -1;
                        }
                    } else {
                        entity = entities.getSpecialEntity(buf.substring(entityStart + 1, i));
                        if (entity != null) {
                            entityValue = entity.intValue();
                        }
                    }
                    if (entityValue >= 0) {
                        char[] decodedEntity = Character.toChars(entityValue);
                        buf.replace(entityStart, i + 1, new String(decodedEntity));
                        length = buf.length();
                        i = entityStart + decodedEntity.length;
                    } else {
                        ++i;
                    }
                    entityStart = -1;
                    continue;
                }
                if (i == entityStart + 1 && buf.charAt(i) == '#') {
                    numericEntity = true;
                } else if (i == entityStart + 2 && numericEntity && buf.charAt(i) == 'x') {
                    hexEntity = true;
                } else if (i - entityStart > maxEntityLength) {
                    entityStart = -1;
                }
                ++i;
                continue;
            }
            ++i;
        }
        return buf.toString();
    }

    static {
        ASCII_CHAR = Pattern.compile("\\p{Print}");
        HEX_STRICT = Pattern.compile("^([x|X][\\p{XDigit}]+)(;?)");
        HEX_RELAXED = Pattern.compile("^0*([x|X][\\p{XDigit}]+)(;?)");
        DECIMAL = Pattern.compile("^([\\p{Digit}]+)(;?)");
    }
}

