/*
 * Decompiled with CFR 0.152.
 */
package davmail.http;

import davmail.Settings;
import davmail.exception.HttpForbiddenException;
import davmail.exception.HttpNotFoundException;
import davmail.exception.HttpPreconditionFailedException;
import davmail.exception.HttpServerErrorException;
import davmail.exception.LoginTimeoutException;
import davmail.http.DavGatewayProxySelector;
import davmail.http.DavGatewaySSLSocketFactory;
import davmail.http.DavMailIdleConnectionEvictor;
import davmail.http.JCIFSNTLMSchemeFactory;
import davmail.http.request.ExchangeDavRequest;
import davmail.http.request.ExchangeSearchRequest;
import davmail.http.request.GetRequest;
import davmail.http.request.PostRequest;
import davmail.http.request.ResponseWrapper;
import davmail.http.request.RestRequest;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.security.Security;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpCopy;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONObject;

public class HttpClientAdapter
implements Closeable {
    static final Logger LOGGER = Logger.getLogger((String)"davmail.http.HttpClientAdapter");
    static final String[] SUPPORTED_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    static final Registry<ConnectionSocketFactory> SCHEME_REGISTRY;
    static String WORKSTATION_NAME;
    static final int MAX_REDIRECTS = 10;
    HttpClientConnectionManager connectionManager;
    CloseableHttpClient httpClient;
    CredentialsProvider provider = new BasicCredentialsProvider();
    BasicCookieStore cookieStore = new BasicCookieStore(){

        public void addCookie(Cookie cookie) {
            LOGGER.debug((Object)("Add cookie " + cookie));
            super.addCookie(cookie);
        }
    };
    URI uri;
    String domain;
    String userid;
    String userEmail;

    public static boolean isGzipEncoded(HttpResponse response) {
        Header header = response.getFirstHeader("Content-Encoding");
        return header != null && "gzip".equals(header.getValue());
    }

    public HttpClientAdapter(String url) {
        this(URI.create(url));
    }

    public HttpClientAdapter(String url, String username, String password) {
        this(URI.create(url), username, password, false);
    }

    public HttpClientAdapter(String url, boolean enablePool) {
        this(URI.create(url), null, null, enablePool);
    }

    public HttpClientAdapter(String url, String username, String password, boolean enablePool) {
        this(URI.create(url), username, password, enablePool);
    }

    public HttpClientAdapter(URI uri) {
        this(uri, null, null, false);
    }

    public HttpClientAdapter(URI uri, boolean enablePool) {
        this(uri, null, null, enablePool);
    }

    public HttpClientAdapter(URI uri, String username, String password) {
        this(uri, username, password, false);
    }

    public HttpClientAdapter(URI uri, String username, String password, boolean enablePool) {
        this.uri = uri;
        if (enablePool) {
            this.connectionManager = new PoolingHttpClientConnectionManager(SCHEME_REGISTRY);
            ((PoolingHttpClientConnectionManager)this.connectionManager).setDefaultMaxPerRoute(5);
            this.startEvictorThread();
        } else {
            this.connectionManager = new BasicHttpClientConnectionManager(SCHEME_REGISTRY);
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().disableRedirectHandling().setDefaultRequestConfig(this.getRequestConfig()).setUserAgent(this.getUserAgent()).setDefaultAuthSchemeRegistry(this.getAuthSchemeRegistry()).disableConnectionState().setConnectionManager(this.connectionManager);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        clientBuilder.setDefaultCookieStore((CookieStore)this.cookieStore);
        this.setCredentials(username, password);
        boolean enableProxy = Settings.getBooleanProperty("davmail.enableProxy");
        boolean useSystemProxies = Settings.getBooleanProperty("davmail.useSystemProxies", Boolean.FALSE);
        String proxyHost = null;
        int proxyPort = 0;
        String proxyUser = null;
        String proxyPassword = null;
        if (useSystemProxies) {
            System.setProperty("java.net.useSystemProxies", "true");
            List<Proxy> proxyList = HttpClientAdapter.getProxyForURI(uri);
            if (!proxyList.isEmpty() && proxyList.get(0).address() != null) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)proxyList.get(0).address();
                proxyHost = inetSocketAddress.getHostName();
                proxyPort = inetSocketAddress.getPort();
                proxyUser = Settings.getProperty("davmail.proxyUser");
                proxyPassword = Settings.getProperty("davmail.proxyPassword");
            }
        } else if (HttpClientAdapter.isNoProxyFor(uri)) {
            LOGGER.debug((Object)("no proxy for " + uri.getHost()));
        } else if (enableProxy) {
            proxyHost = Settings.getProperty("davmail.proxyHost");
            proxyPort = Settings.getIntProperty("davmail.proxyPort");
            proxyUser = Settings.getProperty("davmail.proxyUser");
            proxyPassword = Settings.getProperty("davmail.proxyPassword");
        }
        if (proxyHost != null && proxyHost.length() > 0 && proxyUser != null && proxyUser.length() > 0) {
            int backslashindex;
            AuthScope authScope = new AuthScope(proxyHost, proxyPort, AuthScope.ANY_REALM);
            if (this.provider == null) {
                this.provider = new BasicCredentialsProvider();
            }
            if ((backslashindex = proxyUser.indexOf(92)) > 0) {
                this.provider.setCredentials(authScope, (Credentials)new NTCredentials(proxyUser.substring(backslashindex + 1), proxyPassword, WORKSTATION_NAME, proxyUser.substring(0, backslashindex)));
            } else {
                this.provider.setCredentials(authScope, (Credentials)new NTCredentials(proxyUser, proxyPassword, WORKSTATION_NAME, ""));
            }
        }
        clientBuilder.setDefaultCredentialsProvider(this.provider);
        this.httpClient = clientBuilder.build();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    private Registry<AuthSchemeProvider> getAuthSchemeRegistry() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("NTLM", (Object)new JCIFSNTLMSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory());
        if (Settings.getBooleanProperty("davmail.enableKerberos")) {
            registryBuilder.register("Negotiate", (Object)new SPNegoSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory());
        }
        return registryBuilder.build();
    }

    private RequestConfig getRequestConfig() {
        HashSet<String> authSchemes = new HashSet<String>();
        authSchemes.add("NTLM");
        authSchemes.add("Basic");
        authSchemes.add("Digest");
        if (Settings.getBooleanProperty("davmail.enableKerberos")) {
            authSchemes.add("Negotiate");
            authSchemes.add("Kerberos");
        }
        return RequestConfig.custom().setConnectTimeout(Settings.getIntProperty("davmail.exchange.connectionTimeout", 10) * 1000).setSocketTimeout(Settings.getIntProperty("davmail.exchange.soTimeout", 120) * 1000).setTargetPreferredAuthSchemes(authSchemes).build();
    }

    private void parseUserName(String username) {
        if (username != null) {
            int pipeIndex = username.indexOf("|");
            if (pipeIndex >= 0) {
                this.userid = username.substring(0, pipeIndex);
                this.userEmail = username.substring(pipeIndex + 1);
            } else {
                this.userid = username;
                this.userEmail = username;
            }
            int backSlashIndex = this.userid.indexOf(92);
            if (backSlashIndex >= 0) {
                this.domain = this.userid.substring(0, backSlashIndex);
                this.userid = this.userid.substring(backSlashIndex + 1);
            } else {
                this.domain = Settings.getProperty("davmail.defaultDomain", "");
            }
        }
    }

    private static List<Proxy> getProxyForURI(URI uri) {
        LOGGER.debug((Object)"get Default proxy selector");
        ProxySelector proxySelector = ProxySelector.getDefault();
        LOGGER.debug((Object)("getProxyForURI(" + uri + ')'));
        List<Proxy> proxies = proxySelector.select(uri);
        LOGGER.debug((Object)("got system proxies:" + proxies));
        return proxies;
    }

    protected static boolean isNoProxyFor(URI uri) {
        String noProxyFor = Settings.getProperty("davmail.noProxyFor");
        if (noProxyFor != null) {
            String[] domains;
            String urihost = uri.getHost().toLowerCase();
            for (String domain : domains = noProxyFor.toLowerCase().split(",\\s*")) {
                if (!urihost.endsWith(domain)) continue;
                return true;
            }
        }
        return false;
    }

    public void startEvictorThread() {
        DavMailIdleConnectionEvictor.addConnectionManager(this.connectionManager);
    }

    @Override
    public void close() {
        DavMailIdleConnectionEvictor.removeConnectionManager(this.connectionManager);
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Exception closing http client", (Throwable)e);
        }
    }

    public static void close(HttpClientAdapter httpClientAdapter) {
        if (httpClientAdapter != null) {
            httpClientAdapter.close();
        }
    }

    public CloseableHttpResponse execute(HttpRequestBase request) throws IOException {
        return this.execute(request, null);
    }

    public CloseableHttpResponse execute(HttpRequestBase request, HttpClientContext context) throws IOException {
        this.handleURI(request);
        return this.httpClient.execute((HttpUriRequest)request, (HttpContext)context);
    }

    private void handleURI(HttpRequestBase request) {
        URI requestURI = request.getURI();
        if (!requestURI.isAbsolute()) {
            request.setURI(URIUtils.resolve((URI)this.uri, (URI)requestURI));
        }
        this.uri = request.getURI();
    }

    public ResponseWrapper executeFollowRedirect(PostRequest request) throws IOException {
        ResponseWrapper responseWrapper = request;
        LOGGER.debug((Object)(request.getMethod() + " " + request.getURI().toString()));
        LOGGER.debug(request.getParameters());
        int count = 0;
        int maxRedirect = Settings.getIntProperty("davmail.httpMaxRedirects", 10);
        this.executePostRequest(request);
        URI redirectLocation = request.getRedirectLocation();
        while (count++ < maxRedirect && redirectLocation != null) {
            LOGGER.debug((Object)("Redirect " + request.getURI() + " to " + redirectLocation));
            responseWrapper = new GetRequest(redirectLocation);
            this.executeGetRequest((GetRequest)responseWrapper);
            redirectLocation = ((GetRequest)responseWrapper).getRedirectLocation();
        }
        return responseWrapper;
    }

    public GetRequest executeFollowRedirect(GetRequest request) throws IOException {
        GetRequest result = request;
        LOGGER.debug((Object)(request.getMethod() + " " + request.getURI().toString()));
        int count = 0;
        int maxRedirect = Settings.getIntProperty("davmail.httpMaxRedirects", 10);
        this.executeGetRequest(request);
        URI redirectLocation = request.getRedirectLocation();
        while (count++ < maxRedirect && redirectLocation != null) {
            LOGGER.debug((Object)("Redirect " + request.getURI() + " to " + redirectLocation));
            result = new GetRequest(redirectLocation);
            this.executeGetRequest(result);
            redirectLocation = result.getRedirectLocation();
        }
        return result;
    }

    public String executeGetRequest(GetRequest getRequest) throws IOException {
        String responseBodyAsString;
        this.handleURI((HttpRequestBase)getRequest);
        try (CloseableHttpResponse response = this.execute((HttpRequestBase)getRequest);){
            responseBodyAsString = getRequest.handleResponse((HttpResponse)response);
        }
        return responseBodyAsString;
    }

    public String executePostRequest(PostRequest postRequest) throws IOException {
        String responseBodyAsString;
        this.handleURI((HttpRequestBase)postRequest);
        try (CloseableHttpResponse response = this.execute((HttpRequestBase)postRequest);){
            responseBodyAsString = postRequest.handleResponse((HttpResponse)response);
        }
        return responseBodyAsString;
    }

    public JSONObject executeRestRequest(RestRequest restRequest) throws IOException {
        JSONObject responseBody;
        this.handleURI((HttpRequestBase)restRequest);
        try (CloseableHttpResponse response = this.execute((HttpRequestBase)restRequest);){
            responseBody = restRequest.handleResponse((HttpResponse)response);
        }
        return responseBody;
    }

    public MultiStatus executeDavRequest(BaseDavRequest request) throws IOException {
        this.handleURI((HttpRequestBase)request);
        MultiStatus multiStatus = null;
        try (CloseableHttpResponse response = this.execute((HttpRequestBase)request);){
            request.checkSuccess((HttpResponse)response);
            if (response.getStatusLine().getStatusCode() == 207) {
                multiStatus = request.getResponseBodyAsMultiStatus((HttpResponse)response);
            }
        }
        catch (DavException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getErrorCode() + " " + e.getStatusPhrase(), e);
        }
        return multiStatus;
    }

    public MultiStatusResponse[] executeDavRequest(ExchangeDavRequest request) throws IOException {
        MultiStatusResponse[] responses;
        this.handleURI((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.execute((HttpRequestBase)request);){
            Object responseList = request.handleResponse((HttpResponse)response);
            responses = responseList.toArray(new MultiStatusResponse[0]);
        }
        return responses;
    }

    public MultiStatusResponse[] executeSearchRequest(String path, String searchStatement, int maxCount) throws IOException {
        ExchangeSearchRequest searchRequest = new ExchangeSearchRequest(path, searchStatement);
        if (maxCount > 0) {
            searchRequest.setHeader("Range", "rows=0-" + (maxCount - 1));
        }
        return this.executeDavRequest(searchRequest);
    }

    public static boolean isRedirect(HttpResponse response) {
        return HttpClientAdapter.isRedirect(response.getStatusLine().getStatusCode());
    }

    public static boolean isRedirect(int status) {
        return status == 301 || status == 302 || status == 303 || status == 307;
    }

    public static URI getRedirectLocation(HttpResponse response) {
        Header location = response.getFirstHeader("Location");
        if (HttpClientAdapter.isRedirect(response.getStatusLine().getStatusCode()) && location != null) {
            return URI.create(location.getValue());
        }
        return null;
    }

    public void setCredentials(String username, String password) {
        this.parseUserName(username);
        if (this.userid != null && password != null) {
            NTCredentials credentials = new NTCredentials(this.userid, password, WORKSTATION_NAME, this.domain);
            this.provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    public List<Cookie> getCookies() {
        return this.cookieStore.getCookies();
    }

    public void addCookie(Cookie cookie) {
        this.cookieStore.addCookie(cookie);
    }

    public String getUserAgent() {
        return Settings.getProperty("davmail.userAgent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; Trident/6.0; Microsoft Outlook 15.0.4420)");
    }

    public static HttpResponseException buildHttpResponseException(HttpRequestBase request, HttpResponse response) {
        return HttpClientAdapter.buildHttpResponseException(request, response.getStatusLine());
    }

    public static HttpResponseException buildHttpResponseException(HttpRequestBase method, StatusLine statusLine) {
        int status = statusLine.getStatusCode();
        StringBuilder message = new StringBuilder();
        message.append(status).append(' ').append(statusLine.getReasonPhrase());
        message.append(" at ").append(method.getURI());
        if (method instanceof HttpCopy || method instanceof HttpMove) {
            message.append(" to ").append(method.getFirstHeader("Destination"));
        }
        if (status == 440) {
            return new LoginTimeoutException(message.toString());
        }
        if (status == 403) {
            return new HttpForbiddenException(message.toString());
        }
        if (status == 404) {
            return new HttpNotFoundException(message.toString());
        }
        if (status == 412) {
            return new HttpPreconditionFailedException(message.toString());
        }
        if (status == 500) {
            return new HttpServerErrorException(message.toString());
        }
        return new HttpResponseException(status, message.toString());
    }

    static {
        WORKSTATION_NAME = "UNKNOWN";
        System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
        System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
        Security.setProperty("ssl.SocketFactory.provider", "davmail.http.DavGatewaySSLSocketFactory");
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        RegistryBuilder schemeRegistry = RegistryBuilder.create();
        schemeRegistry.register("http", (Object)new PlainConnectionSocketFactory());
        schemeRegistry.register("https", (Object)new SSLConnectionSocketFactory((SSLSocketFactory)new DavGatewaySSLSocketFactory(), SUPPORTED_PROTOCOLS, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier()));
        SCHEME_REGISTRY = schemeRegistry.build();
        try {
            WORKSTATION_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Settings.getBooleanProperty("davmail.useSystemProxies", Boolean.FALSE)) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        ProxySelector.setDefault(new DavGatewayProxySelector(ProxySelector.getDefault()));
    }
}

