/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CodeGenUtil;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.apache.xmlbeans.impl.xb.xsdschema.FormChoice;
import org.apache.xmlbeans.impl.xb.xsdschema.IncludeDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.NamedAttributeGroup;
import org.apache.xmlbeans.impl.xb.xsdschema.NamedGroup;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelAttribute;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelComplexType;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelElement;
import org.apache.xmlbeans.impl.xb.xsdschema.TopLevelSimpleType;

public class FactorImports {
    public static void printUsage() {
        System.out.println("Refactors a directory of XSD files to remove name conflicts.");
        System.out.println("Usage: sfactor [-import common.xsd] [-out outputdir] inputdir");
        System.out.println("    -import common.xsd - The XSD file to contain redundant ");
        System.out.println("                         definitions for importing.");
        System.out.println("    -out outputdir - The directory into which to place XSD ");
        System.out.println("                     files resulting from refactoring, ");
        System.out.println("                     plus a commonly imported common.xsd.");
        System.out.println("    inputdir - The directory containing the XSD files with");
        System.out.println("               redundant definitions.");
        System.out.println("    -license - Print license information.");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        SchemaDocument doc;
        String out;
        HashSet<String> flags = new HashSet<String>();
        flags.add("h");
        flags.add("help");
        flags.add("usage");
        flags.add("license");
        flags.add("version");
        CommandLine cl = new CommandLine(args, flags, Arrays.asList("import", "out"));
        if (cl.getOpt("h") != null || cl.getOpt("help") != null || cl.getOpt("usage") != null || args.length < 1) {
            FactorImports.printUsage();
            System.exit(0);
            return;
        }
        String[] badopts = cl.getBadOpts();
        if (badopts.length > 0) {
            for (int i2 = 0; i2 < badopts.length; ++i2) {
                System.out.println("Unrecognized option: " + badopts[i2]);
            }
            FactorImports.printUsage();
            System.exit(0);
            return;
        }
        if (cl.getOpt("license") != null) {
            CommandLine.printLicense();
            System.exit(0);
            return;
        }
        if (cl.getOpt("version") != null) {
            CommandLine.printVersion();
            System.exit(0);
            return;
        }
        args = cl.args();
        if (args.length != 1) {
            System.exit(0);
            return;
        }
        String commonName = cl.getOpt("import");
        if (commonName == null) {
            commonName = "common.xsd";
        }
        if ((out = cl.getOpt("out")) == null) {
            System.out.println("Using output directory 'out'");
            out = "out";
        }
        File outdir = new File(out);
        File basedir = new File(args[0]);
        File[] files = cl.getFiles();
        HashMap<SchemaDocument, File> schemaDocs = new HashMap<SchemaDocument, File>();
        HashSet elementNames = new HashSet();
        HashSet attributeNames = new HashSet();
        HashSet typeNames = new HashSet();
        HashSet modelGroupNames = new HashSet();
        HashSet attrGroupNames = new HashSet();
        HashSet dupeElementNames = new HashSet();
        HashSet dupeAttributeNames = new HashSet();
        HashSet dupeTypeNames = new HashSet();
        HashSet dupeModelGroupNames = new HashSet();
        HashSet dupeAttrGroupNames = new HashSet();
        HashSet dupeNamespaces = new HashSet();
        for (int i3 = 0; i3 < files.length; ++i3) {
            try {
                String targetNamespace;
                SchemaDocument doc2 = SchemaDocument.Factory.parse(files[i3]);
                schemaDocs.put(doc2, files[i3]);
                if (doc2.getSchema().sizeOfImportArray() > 0 || doc2.getSchema().sizeOfIncludeArray() > 0) {
                    System.out.println("warning: " + files[i3] + " contains imports or includes that are being ignored.");
                }
                if ((targetNamespace = doc2.getSchema().getTargetNamespace()) == null) {
                    targetNamespace = "";
                }
                TopLevelComplexType[] ct = doc2.getSchema().getComplexTypeArray();
                for (int j2 = 0; j2 < ct.length; ++j2) {
                    FactorImports.noteName(ct[j2].getName(), targetNamespace, typeNames, dupeTypeNames, dupeNamespaces);
                }
                TopLevelSimpleType[] st = doc2.getSchema().getSimpleTypeArray();
                for (int j3 = 0; j3 < st.length; ++j3) {
                    FactorImports.noteName(st[j3].getName(), targetNamespace, typeNames, dupeTypeNames, dupeNamespaces);
                }
                TopLevelElement[] el = doc2.getSchema().getElementArray();
                for (int j4 = 0; j4 < el.length; ++j4) {
                    FactorImports.noteName(el[j4].getName(), targetNamespace, elementNames, dupeElementNames, dupeNamespaces);
                }
                TopLevelAttribute[] at = doc2.getSchema().getAttributeArray();
                for (int j5 = 0; j5 < at.length; ++j5) {
                    FactorImports.noteName(at[j5].getName(), targetNamespace, attributeNames, dupeAttributeNames, dupeNamespaces);
                }
                NamedGroup[] gr = doc2.getSchema().getGroupArray();
                for (int j6 = 0; j6 < gr.length; ++j6) {
                    FactorImports.noteName(gr[j6].getName(), targetNamespace, modelGroupNames, dupeModelGroupNames, dupeNamespaces);
                }
                NamedAttributeGroup[] ag = doc2.getSchema().getAttributeGroupArray();
                for (int j7 = 0; j7 < ag.length; ++j7) {
                    FactorImports.noteName(ag[j7].getName(), targetNamespace, attrGroupNames, dupeAttrGroupNames, dupeNamespaces);
                }
                continue;
            }
            catch (XmlException e2) {
                System.out.println("warning: " + files[i3] + " is not a schema file - " + e2.getError().toString());
                continue;
            }
            catch (IOException e3) {
                System.err.println("Unable to load " + files[i3] + " - " + e3.getMessage());
                System.exit(1);
                return;
            }
        }
        if (schemaDocs.size() == 0) {
            System.out.println("No schema files found.");
            System.exit(0);
            return;
        }
        if (dupeTypeNames.size() + dupeElementNames.size() + dupeAttributeNames.size() + dupeModelGroupNames.size() + dupeAttrGroupNames.size() == 0) {
            System.out.println("No duplicate names found.");
            System.exit(0);
            return;
        }
        HashMap<String, SchemaDocument> commonDocs = new HashMap<String, SchemaDocument>();
        HashMap<SchemaDocument, File> commonFiles = new HashMap<SchemaDocument, File>();
        int count = dupeNamespaces.size() == 1 ? 0 : 1;
        Iterator<Object> i4 = dupeNamespaces.iterator();
        while (i4.hasNext()) {
            String namespace = (String)i4.next();
            SchemaDocument commonDoc = SchemaDocument.Factory.parse("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'/>");
            if (namespace.length() > 0) {
                commonDoc.getSchema().setTargetNamespace(namespace);
            }
            commonDoc.getSchema().setElementFormDefault(FormChoice.QUALIFIED);
            commonDocs.put(namespace, commonDoc);
            commonFiles.put(commonDoc, FactorImports.commonFileFor(commonName, namespace, count++, outdir));
        }
        i4 = schemaDocs.keySet().iterator();
        while (i4.hasNext()) {
            doc = (SchemaDocument)i4.next();
            String targetNamespace = doc.getSchema().getTargetNamespace();
            if (targetNamespace == null) {
                targetNamespace = "";
            }
            SchemaDocument commonDoc = (SchemaDocument)commonDocs.get(targetNamespace);
            boolean needImport = false;
            TopLevelComplexType[] ct = doc.getSchema().getComplexTypeArray();
            for (int j8 = ct.length - 1; j8 >= 0; --j8) {
                if (!FactorImports.isDuplicate(ct[j8].getName(), targetNamespace, dupeTypeNames)) continue;
                if (FactorImports.isFirstDuplicate(ct[j8].getName(), targetNamespace, typeNames, dupeTypeNames)) {
                    commonDoc.getSchema().addNewComplexType().set(ct[j8]);
                }
                needImport = true;
                doc.getSchema().removeComplexType(j8);
            }
            TopLevelSimpleType[] st = doc.getSchema().getSimpleTypeArray();
            for (int j9 = 0; j9 < st.length; ++j9) {
                if (!FactorImports.isDuplicate(st[j9].getName(), targetNamespace, dupeTypeNames)) continue;
                if (FactorImports.isFirstDuplicate(st[j9].getName(), targetNamespace, typeNames, dupeTypeNames)) {
                    commonDoc.getSchema().addNewSimpleType().set(st[j9]);
                }
                needImport = true;
                doc.getSchema().removeSimpleType(j9);
            }
            TopLevelElement[] el = doc.getSchema().getElementArray();
            for (int j10 = 0; j10 < el.length; ++j10) {
                if (!FactorImports.isDuplicate(el[j10].getName(), targetNamespace, dupeElementNames)) continue;
                if (FactorImports.isFirstDuplicate(el[j10].getName(), targetNamespace, elementNames, dupeElementNames)) {
                    commonDoc.getSchema().addNewElement().set(el[j10]);
                }
                needImport = true;
                doc.getSchema().removeElement(j10);
            }
            TopLevelAttribute[] at = doc.getSchema().getAttributeArray();
            for (int j11 = 0; j11 < at.length; ++j11) {
                if (!FactorImports.isDuplicate(at[j11].getName(), targetNamespace, dupeAttributeNames)) continue;
                if (FactorImports.isFirstDuplicate(at[j11].getName(), targetNamespace, attributeNames, dupeAttributeNames)) {
                    commonDoc.getSchema().addNewElement().set(at[j11]);
                }
                needImport = true;
                doc.getSchema().removeElement(j11);
            }
            NamedGroup[] gr = doc.getSchema().getGroupArray();
            for (int j12 = 0; j12 < gr.length; ++j12) {
                if (!FactorImports.isDuplicate(gr[j12].getName(), targetNamespace, dupeModelGroupNames)) continue;
                if (FactorImports.isFirstDuplicate(gr[j12].getName(), targetNamespace, modelGroupNames, dupeModelGroupNames)) {
                    commonDoc.getSchema().addNewElement().set(gr[j12]);
                }
                needImport = true;
                doc.getSchema().removeElement(j12);
            }
            NamedAttributeGroup[] ag = doc.getSchema().getAttributeGroupArray();
            for (int j13 = 0; j13 < ag.length; ++j13) {
                if (!FactorImports.isDuplicate(ag[j13].getName(), targetNamespace, dupeAttrGroupNames)) continue;
                if (FactorImports.isFirstDuplicate(ag[j13].getName(), targetNamespace, attrGroupNames, dupeAttrGroupNames)) {
                    commonDoc.getSchema().addNewElement().set(ag[j13]);
                }
                needImport = true;
                doc.getSchema().removeElement(j13);
            }
            if (!needImport) continue;
            IncludeDocument.Include newInclude = doc.getSchema().addNewInclude();
            File inputFile = (File)schemaDocs.get(doc);
            File outputFile = FactorImports.outputFileFor(inputFile, basedir, outdir);
            File commonFile = (File)commonFiles.get(commonDoc);
            if (targetNamespace == null) continue;
            newInclude.setSchemaLocation(FactorImports.relativeURIFor(outputFile, commonFile));
        }
        if (!outdir.isDirectory() && !outdir.mkdirs()) {
            System.err.println("Unable to makedir " + outdir);
            System.exit(1);
            return;
        }
        i4 = schemaDocs.keySet().iterator();
        while (i4.hasNext()) {
            doc = (SchemaDocument)i4.next();
            File inputFile = (File)schemaDocs.get(doc);
            File outputFile = FactorImports.outputFileFor(inputFile, basedir, outdir);
            if (outputFile == null) {
                System.out.println("Cannot copy " + inputFile);
                continue;
            }
            doc.save(outputFile, new XmlOptions().setSavePrettyPrint().setSaveAggresiveNamespaces());
        }
        i4 = commonFiles.keySet().iterator();
        while (i4.hasNext()) {
            doc = (SchemaDocument)i4.next();
            File outputFile = (File)commonFiles.get(doc);
            doc.save(outputFile, new XmlOptions().setSavePrettyPrint().setSaveAggresiveNamespaces());
        }
    }

    private static File outputFileFor(File file, File baseDir, File outdir) {
        URI abs;
        URI base = baseDir.getAbsoluteFile().toURI();
        URI rel = base.relativize(abs = file.getAbsoluteFile().toURI());
        if (rel.isAbsolute()) {
            System.out.println("Cannot relativize " + file);
            return null;
        }
        URI outbase = outdir.toURI();
        URI out = CodeGenUtil.resolve(outbase, rel);
        return new File(out);
    }

    private static URI commonAncestor(URI first, URI second) {
        int i2;
        String firstStr = first.toString();
        String secondStr = second.toString();
        int len = firstStr.length();
        if (secondStr.length() < len) {
            len = secondStr.length();
        }
        for (i2 = 0; i2 < len && firstStr.charAt(i2) == secondStr.charAt(i2); ++i2) {
        }
        if (--i2 >= 0) {
            i2 = firstStr.lastIndexOf(47, i2);
        }
        if (i2 < 0) {
            return null;
        }
        try {
            return new URI(firstStr.substring(0, i2));
        }
        catch (URISyntaxException e2) {
            return null;
        }
    }

    private static String relativeURIFor(File source, File target) {
        URI abs;
        URI base = source.getAbsoluteFile().toURI();
        URI commonBase = FactorImports.commonAncestor(base, abs = target.getAbsoluteFile().toURI());
        if (commonBase == null) {
            return abs.toString();
        }
        URI baserel = commonBase.relativize(base);
        URI targetrel = commonBase.relativize(abs);
        if (baserel.isAbsolute() || targetrel.isAbsolute()) {
            return abs.toString();
        }
        String prefix = "";
        String sourceRel = baserel.toString();
        for (int i2 = 0; i2 < sourceRel.length() && (i2 = sourceRel.indexOf(47, i2)) >= 0; ++i2) {
            prefix = prefix + "../";
        }
        return prefix + targetrel.toString();
    }

    private static File commonFileFor(String commonName, String namespace, int i2, File outdir) {
        String name = commonName;
        if (i2 > 0) {
            int index = commonName.lastIndexOf(46);
            if (index < 0) {
                index = commonName.length();
            }
            name = commonName.substring(0, index) + i2 + commonName.substring(index);
        }
        return new File(outdir, name);
    }

    private static void noteName(String name, String targetNamespace, Set seen, Set dupes, Set dupeNamespaces) {
        if (name == null) {
            return;
        }
        QName qName = new QName(targetNamespace, name);
        if (seen.contains(qName)) {
            dupes.add(qName);
            dupeNamespaces.add(targetNamespace);
        } else {
            seen.add(qName);
        }
    }

    private static boolean isFirstDuplicate(String name, String targetNamespace, Set notseen, Set dupes) {
        if (name == null) {
            return false;
        }
        QName qName = new QName(targetNamespace, name);
        if (dupes.contains(qName) && notseen.contains(qName)) {
            notseen.remove(qName);
            return true;
        }
        return false;
    }

    private static boolean isDuplicate(String name, String targetNamespace, Set dupes) {
        if (name == null) {
            return false;
        }
        QName qName = new QName(targetNamespace, name);
        return dupes.contains(qName);
    }
}

