/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal.elements;

import org.apache.xmlbeans.impl.jam.JAnnotation;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.JComment;
import org.apache.xmlbeans.impl.jam.JMethod;
import org.apache.xmlbeans.impl.jam.JProperty;
import org.apache.xmlbeans.impl.jam.JSourcePosition;
import org.apache.xmlbeans.impl.jam.internal.classrefs.JClassRef;
import org.apache.xmlbeans.impl.jam.internal.classrefs.QualifiedJClassRef;
import org.apache.xmlbeans.impl.jam.internal.elements.AnnotatedElementImpl;
import org.apache.xmlbeans.impl.jam.internal.elements.ClassImpl;
import org.apache.xmlbeans.impl.jam.internal.elements.ElementImpl;
import org.apache.xmlbeans.impl.jam.mutable.MMethod;
import org.apache.xmlbeans.impl.jam.visitor.JVisitor;
import org.apache.xmlbeans.impl.jam.visitor.MVisitor;

public class PropertyImpl
extends AnnotatedElementImpl
implements JProperty {
    private String mName;
    private JMethod mGetter;
    private JMethod mSetter;
    private JClassRef mTypeRef;

    public PropertyImpl(String name, JMethod getter, JMethod setter, String qualifiedTypeName) {
        super((ElementImpl)(getter != null ? getter.getParent() : setter.getParent()));
        this.mName = name;
        this.mGetter = getter;
        this.mSetter = setter;
        ClassImpl cont = (ClassImpl)(getter != null ? getter.getContainingClass() : setter.getContainingClass());
        this.mTypeRef = QualifiedJClassRef.create(qualifiedTypeName, cont);
        this.initAnnotations();
    }

    public JClass getType() {
        return this.mTypeRef.getRefClass();
    }

    public String getSimpleName() {
        return this.mName;
    }

    public String getQualifiedName() {
        return this.getParent().getQualifiedName() + "." + this.getSimpleName();
    }

    public JMethod getSetter() {
        return this.mSetter;
    }

    public JMethod getGetter() {
        return this.mGetter;
    }

    public JAnnotation[] getAnnotations() {
        return this.combine(this.mGetter == null ? ElementImpl.NO_ANNOTATION : this.mGetter.getAnnotations(), this.mSetter == null ? ElementImpl.NO_ANNOTATION : this.mSetter.getAnnotations());
    }

    public void setSetter(JMethod method) {
        this.mSetter = method;
    }

    public void setGetter(JMethod method) {
        this.mGetter = method;
    }

    public JAnnotation getAnnotation(String named) {
        JAnnotation out;
        JAnnotation jAnnotation = out = this.mGetter != null ? this.mGetter.getAnnotation(named) : null;
        if (out != null) {
            return out;
        }
        return this.mSetter != null ? this.mSetter.getAnnotation(named) : null;
    }

    public JComment getComment() {
        if (this.mGetter != null) {
            return this.mGetter.getComment();
        }
        if (this.mSetter != null) {
            return this.mSetter.getComment();
        }
        return null;
    }

    public JSourcePosition getSourcePosition() {
        return this.mGetter != null ? this.mGetter.getSourcePosition() : this.mSetter.getSourcePosition();
    }

    public void accept(JVisitor visitor) {
        if (this.mGetter != null) {
            visitor.visit(this.mGetter);
        }
        if (this.mSetter != null) {
            visitor.visit(this.mSetter);
        }
    }

    public String toString() {
        return this.getQualifiedName();
    }

    private void initAnnotations() {
        int i2;
        JAnnotation[] anns;
        if (this.mSetter != null) {
            anns = this.mSetter.getAnnotations();
            for (i2 = 0; i2 < anns.length; ++i2) {
                super.addAnnotation(anns[i2]);
            }
            anns = this.mSetter.getAllJavadocTags();
            for (i2 = 0; i2 < anns.length; ++i2) {
                super.addAnnotation(anns[i2]);
            }
        }
        if (this.mGetter != null) {
            anns = this.mGetter.getAnnotations();
            for (i2 = 0; i2 < anns.length; ++i2) {
                super.addAnnotation(anns[i2]);
            }
            anns = this.mGetter.getAllJavadocTags();
            for (i2 = 0; i2 < anns.length; ++i2) {
                super.addAnnotation(anns[i2]);
            }
        }
    }

    private JAnnotation[] combine(JAnnotation[] a2, JAnnotation[] b2) {
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        JAnnotation[] out = new JAnnotation[a2.length + b2.length];
        System.arraycopy(a2, 0, out, 0, a2.length);
        System.arraycopy(b2, 0, out, a2.length, b2.length);
        return out;
    }

    private JComment[] combine(JComment[] a2, JComment[] b2) {
        if (a2.length == 0) {
            return b2;
        }
        if (b2.length == 0) {
            return a2;
        }
        JComment[] out = new JComment[a2.length + b2.length];
        System.arraycopy(a2, 0, out, 0, a2.length);
        System.arraycopy(b2, 0, out, a2.length, b2.length);
        return out;
    }

    public void accept(MVisitor visitor) {
        if (this.mGetter != null) {
            visitor.visit((MMethod)this.mGetter);
        }
        if (this.mSetter != null) {
            visitor.visit((MMethod)this.mSetter);
        }
    }
}

