/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.BindingConfig;
import org.apache.xmlbeans.InterfaceExtension;
import org.apache.xmlbeans.PrePostExtension;
import org.apache.xmlbeans.UserType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.config.InterfaceExtensionImpl;
import org.apache.xmlbeans.impl.config.NameSet;
import org.apache.xmlbeans.impl.config.NameSetBuilder;
import org.apache.xmlbeans.impl.config.PrePostExtensionImpl;
import org.apache.xmlbeans.impl.config.UserTypeImpl;
import org.apache.xmlbeans.impl.jam.JamClassLoader;
import org.apache.xmlbeans.impl.jam.JamService;
import org.apache.xmlbeans.impl.jam.JamServiceFactory;
import org.apache.xmlbeans.impl.jam.JamServiceParams;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.xb.xmlconfig.ConfigDocument;
import org.apache.xmlbeans.impl.xb.xmlconfig.Extensionconfig;
import org.apache.xmlbeans.impl.xb.xmlconfig.Nsconfig;
import org.apache.xmlbeans.impl.xb.xmlconfig.Qnameconfig;
import org.apache.xmlbeans.impl.xb.xmlconfig.Qnametargetenum;
import org.apache.xmlbeans.impl.xb.xmlconfig.Usertypeconfig;

public class BindingConfigImpl
extends BindingConfig {
    private Map _packageMap;
    private Map _prefixMap;
    private Map _suffixMap;
    private Map _packageMapByUriPrefix;
    private Map _prefixMapByUriPrefix;
    private Map _suffixMapByUriPrefix;
    private Map _qnameTypeMap;
    private Map _qnameDocTypeMap;
    private Map _qnameElemMap;
    private Map _qnameAttMap;
    private List _interfaceExtensions;
    private List _prePostExtensions;
    private Map _userTypes;

    private BindingConfigImpl() {
        this._packageMap = Collections.EMPTY_MAP;
        this._prefixMap = Collections.EMPTY_MAP;
        this._suffixMap = Collections.EMPTY_MAP;
        this._packageMapByUriPrefix = Collections.EMPTY_MAP;
        this._prefixMapByUriPrefix = Collections.EMPTY_MAP;
        this._suffixMapByUriPrefix = Collections.EMPTY_MAP;
        this._qnameTypeMap = Collections.EMPTY_MAP;
        this._qnameDocTypeMap = Collections.EMPTY_MAP;
        this._qnameElemMap = Collections.EMPTY_MAP;
        this._qnameAttMap = Collections.EMPTY_MAP;
        this._interfaceExtensions = new ArrayList();
        this._prePostExtensions = new ArrayList();
        this._userTypes = Collections.EMPTY_MAP;
    }

    public static BindingConfig forConfigDocuments(ConfigDocument.Config[] configs, File[] javaFiles, File[] classpath) {
        return new BindingConfigImpl(configs, javaFiles, classpath);
    }

    private BindingConfigImpl(ConfigDocument.Config[] configs, File[] javaFiles, File[] classpath) {
        this._packageMap = new LinkedHashMap();
        this._prefixMap = new LinkedHashMap();
        this._suffixMap = new LinkedHashMap();
        this._packageMapByUriPrefix = new LinkedHashMap();
        this._prefixMapByUriPrefix = new LinkedHashMap();
        this._suffixMapByUriPrefix = new LinkedHashMap();
        this._qnameTypeMap = new LinkedHashMap();
        this._qnameDocTypeMap = new LinkedHashMap();
        this._qnameElemMap = new LinkedHashMap();
        this._qnameAttMap = new LinkedHashMap();
        this._interfaceExtensions = new ArrayList();
        this._prePostExtensions = new ArrayList();
        this._userTypes = new LinkedHashMap();
        for (int i2 = 0; i2 < configs.length; ++i2) {
            ConfigDocument.Config config = configs[i2];
            Nsconfig[] nsa = config.getNamespaceArray();
            for (int j2 = 0; j2 < nsa.length; ++j2) {
                BindingConfigImpl.recordNamespaceSetting(nsa[j2].getUri(), nsa[j2].getPackage(), this._packageMap);
                BindingConfigImpl.recordNamespaceSetting(nsa[j2].getUri(), nsa[j2].getPrefix(), this._prefixMap);
                BindingConfigImpl.recordNamespaceSetting(nsa[j2].getUri(), nsa[j2].getSuffix(), this._suffixMap);
                BindingConfigImpl.recordNamespacePrefixSetting(nsa[j2].getUriprefix(), nsa[j2].getPackage(), this._packageMapByUriPrefix);
                BindingConfigImpl.recordNamespacePrefixSetting(nsa[j2].getUriprefix(), nsa[j2].getPrefix(), this._prefixMapByUriPrefix);
                BindingConfigImpl.recordNamespacePrefixSetting(nsa[j2].getUriprefix(), nsa[j2].getSuffix(), this._suffixMapByUriPrefix);
            }
            Qnameconfig[] qnc = config.getQnameArray();
            for (int j3 = 0; j3 < qnc.length; ++j3) {
                List applyto = qnc[j3].xgetTarget().xgetListValue();
                QName name = qnc[j3].getName();
                String javaname = qnc[j3].getJavaname();
                block9: for (int k2 = 0; k2 < applyto.size(); ++k2) {
                    Qnametargetenum a2 = (Qnametargetenum)applyto.get(k2);
                    switch (a2.enumValue().intValue()) {
                        case 1: {
                            this._qnameTypeMap.put(name, javaname);
                            continue block9;
                        }
                        case 2: {
                            this._qnameDocTypeMap.put(name, javaname);
                            continue block9;
                        }
                        case 3: {
                            this._qnameElemMap.put(name, javaname);
                            continue block9;
                        }
                        case 4: {
                            this._qnameAttMap.put(name, javaname);
                        }
                    }
                }
            }
            Extensionconfig[] ext = config.getExtensionArray();
            for (int j4 = 0; j4 < ext.length; ++j4) {
                this.recordExtensionSetting(javaFiles, classpath, ext[j4]);
            }
            Usertypeconfig[] utypes = config.getUsertypeArray();
            for (int j5 = 0; j5 < utypes.length; ++j5) {
                this.recordUserTypeSetting(javaFiles, classpath, utypes[j5]);
            }
        }
        this.secondPhaseValidation();
    }

    void addInterfaceExtension(InterfaceExtensionImpl ext) {
        if (ext == null) {
            return;
        }
        this._interfaceExtensions.add(ext);
    }

    void addPrePostExtension(PrePostExtensionImpl ext) {
        if (ext == null) {
            return;
        }
        this._prePostExtensions.add(ext);
    }

    void secondPhaseValidation() {
        int i2;
        HashMap<InterfaceExtensionImpl.MethodSignatureImpl, InterfaceExtensionImpl.MethodSignatureImpl> methodSignatures = new HashMap<InterfaceExtensionImpl.MethodSignatureImpl, InterfaceExtensionImpl.MethodSignatureImpl>();
        for (i2 = 0; i2 < this._interfaceExtensions.size(); ++i2) {
            InterfaceExtensionImpl interfaceExtension = (InterfaceExtensionImpl)this._interfaceExtensions.get(i2);
            InterfaceExtensionImpl.MethodSignatureImpl[] methods = (InterfaceExtensionImpl.MethodSignatureImpl[])interfaceExtension.getMethods();
            for (int j2 = 0; j2 < methods.length; ++j2) {
                InterfaceExtensionImpl.MethodSignatureImpl ms = methods[j2];
                if (methodSignatures.containsKey(methods[j2])) {
                    InterfaceExtensionImpl.MethodSignatureImpl ms2 = (InterfaceExtensionImpl.MethodSignatureImpl)methodSignatures.get(methods[j2]);
                    if (!ms.getReturnType().equals(ms2.getReturnType())) {
                        BindingConfigImpl.error("Colliding methods '" + ms.getSignature() + "' in interfaces " + ms.getInterfaceName() + " and " + ms2.getInterfaceName() + ".", null);
                    }
                    return;
                }
                methodSignatures.put(methods[j2], methods[j2]);
            }
        }
        for (i2 = 0; i2 < this._prePostExtensions.size() - 1; ++i2) {
            PrePostExtensionImpl a2 = (PrePostExtensionImpl)this._prePostExtensions.get(i2);
            for (int j3 = 1; j3 < this._prePostExtensions.size(); ++j3) {
                PrePostExtensionImpl b2 = (PrePostExtensionImpl)this._prePostExtensions.get(j3);
                if (!a2.hasNameSetIntersection(b2)) continue;
                BindingConfigImpl.error("The applicable domain for handler '" + a2.getHandlerNameForJavaSource() + "' intersects with the one for '" + b2.getHandlerNameForJavaSource() + "'.", null);
            }
        }
    }

    private static void recordNamespaceSetting(Object key, String value, Map result) {
        if (value == null) {
            return;
        }
        if (key == null) {
            result.put("", value);
        } else if (key instanceof String && "##any".equals(key)) {
            result.put(key, value);
        } else if (key instanceof List) {
            Iterator i2 = ((List)key).iterator();
            while (i2.hasNext()) {
                String uri = (String)i2.next();
                if ("##local".equals(uri)) {
                    uri = "";
                }
                result.put(uri, value);
            }
        }
    }

    private static void recordNamespacePrefixSetting(List list, String value, Map result) {
        if (value == null) {
            return;
        }
        if (list == null) {
            return;
        }
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            result.put(i2.next(), value);
        }
    }

    private void recordExtensionSetting(File[] javaFiles, File[] classpath, Extensionconfig ext) {
        NameSet xbeanSet = null;
        Object key = ext.getFor();
        if (key instanceof String && "*".equals(key)) {
            xbeanSet = NameSet.EVERYTHING;
        } else if (key instanceof List) {
            NameSetBuilder xbeanSetBuilder = new NameSetBuilder();
            Iterator i2 = ((List)key).iterator();
            while (i2.hasNext()) {
                String xbeanName = (String)i2.next();
                xbeanSetBuilder.add(xbeanName);
            }
            xbeanSet = xbeanSetBuilder.toNameSet();
        }
        if (xbeanSet == null) {
            BindingConfigImpl.error("Invalid value of attribute 'for' : '" + key + "'.", ext);
        }
        Extensionconfig.Interface[] intfXO = ext.getInterfaceArray();
        Extensionconfig.PrePostSet ppXO = ext.getPrePostSet();
        if (intfXO.length > 0 || ppXO != null) {
            JamClassLoader jamLoader = this.getJamLoader(javaFiles, classpath);
            for (int i3 = 0; i3 < intfXO.length; ++i3) {
                this.addInterfaceExtension(InterfaceExtensionImpl.newInstance(jamLoader, xbeanSet, intfXO[i3]));
            }
            this.addPrePostExtension(PrePostExtensionImpl.newInstance(jamLoader, xbeanSet, ppXO));
        }
    }

    private void recordUserTypeSetting(File[] javaFiles, File[] classpath, Usertypeconfig usertypeconfig) {
        JamClassLoader jamLoader = this.getJamLoader(javaFiles, classpath);
        UserTypeImpl userType = UserTypeImpl.newInstance(jamLoader, usertypeconfig);
        this._userTypes.put(userType.getName(), userType);
    }

    private String lookup(Map map, Map mapByUriPrefix, String uri) {
        String result;
        if (uri == null) {
            uri = "";
        }
        if ((result = (String)map.get(uri)) != null) {
            return result;
        }
        if (mapByUriPrefix != null && (result = this.lookupByUriPrefix(mapByUriPrefix, uri)) != null) {
            return result;
        }
        return (String)map.get("##any");
    }

    private String lookupByUriPrefix(Map mapByUriPrefix, String uri) {
        if (uri == null) {
            return null;
        }
        if (!mapByUriPrefix.isEmpty()) {
            String uriprefix = null;
            Iterator i2 = mapByUriPrefix.keySet().iterator();
            while (i2.hasNext()) {
                String nextprefix = (String)i2.next();
                if (uriprefix != null && nextprefix.length() < uriprefix.length() || !uri.startsWith(nextprefix)) continue;
                uriprefix = nextprefix;
            }
            if (uriprefix != null) {
                return (String)mapByUriPrefix.get(uriprefix);
            }
        }
        return null;
    }

    static void warning(String s2, XmlObject xo) {
        StscState.get().error(s2, 1, xo);
    }

    static void error(String s2, XmlObject xo) {
        StscState.get().error(s2, 0, xo);
    }

    public String lookupPackageForNamespace(String uri) {
        return this.lookup(this._packageMap, this._packageMapByUriPrefix, uri);
    }

    public String lookupPrefixForNamespace(String uri) {
        return this.lookup(this._prefixMap, this._prefixMapByUriPrefix, uri);
    }

    public String lookupSuffixForNamespace(String uri) {
        return this.lookup(this._suffixMap, this._suffixMapByUriPrefix, uri);
    }

    public String lookupJavanameForQName(QName qname) {
        String result = (String)this._qnameTypeMap.get(qname);
        if (result != null) {
            return result;
        }
        return (String)this._qnameDocTypeMap.get(qname);
    }

    public String lookupJavanameForQName(QName qname, int kind) {
        switch (kind) {
            case 1: {
                return (String)this._qnameTypeMap.get(qname);
            }
            case 2: {
                return (String)this._qnameDocTypeMap.get(qname);
            }
            case 3: {
                return (String)this._qnameElemMap.get(qname);
            }
            case 4: {
                return (String)this._qnameAttMap.get(qname);
            }
        }
        return null;
    }

    public UserType lookupUserTypeForQName(QName qname) {
        if (qname == null) {
            return null;
        }
        return (UserType)this._userTypes.get(qname);
    }

    public InterfaceExtension[] getInterfaceExtensions() {
        return this._interfaceExtensions.toArray(new InterfaceExtension[this._interfaceExtensions.size()]);
    }

    public InterfaceExtension[] getInterfaceExtensions(String fullJavaName) {
        ArrayList<InterfaceExtensionImpl> result = new ArrayList<InterfaceExtensionImpl>();
        for (int i2 = 0; i2 < this._interfaceExtensions.size(); ++i2) {
            InterfaceExtensionImpl intfExt = (InterfaceExtensionImpl)this._interfaceExtensions.get(i2);
            if (!intfExt.contains(fullJavaName)) continue;
            result.add(intfExt);
        }
        return result.toArray(new InterfaceExtension[result.size()]);
    }

    public PrePostExtension[] getPrePostExtensions() {
        return this._prePostExtensions.toArray(new PrePostExtension[this._prePostExtensions.size()]);
    }

    public PrePostExtension getPrePostExtension(String fullJavaName) {
        for (int i2 = 0; i2 < this._prePostExtensions.size(); ++i2) {
            PrePostExtensionImpl prePostExt = (PrePostExtensionImpl)this._prePostExtensions.get(i2);
            if (!prePostExt.contains(fullJavaName)) continue;
            return prePostExt;
        }
        return null;
    }

    private JamClassLoader getJamLoader(File[] javaFiles, File[] classpath) {
        JamService service;
        int i2;
        JamServiceFactory jf = JamServiceFactory.getInstance();
        JamServiceParams params = jf.createServiceParams();
        params.set14WarningsEnabled(false);
        params.setShowWarnings(false);
        if (javaFiles != null) {
            for (i2 = 0; i2 < javaFiles.length; ++i2) {
                params.includeSourceFile(javaFiles[i2]);
            }
        }
        params.addClassLoader(this.getClass().getClassLoader());
        if (classpath != null) {
            for (i2 = 0; i2 < classpath.length; ++i2) {
                params.addClasspath(classpath[i2]);
            }
        }
        try {
            service = jf.createService(params);
        }
        catch (IOException ioe) {
            BindingConfigImpl.error("Error when accessing .java files.", null);
            return null;
        }
        return service.getClassLoader();
    }
}

