/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import javax.xml.stream.XMLStreamReader;

public final class XmlStreamUtils {
    public static String printEvent(XMLStreamReader xmlr) {
        StringBuffer b2 = new StringBuffer();
        b2.append("EVENT:[" + xmlr.getLocation().getLineNumber() + "][" + xmlr.getLocation().getColumnNumber() + "] ");
        b2.append(XmlStreamUtils.getName(xmlr.getEventType()));
        b2.append(" [");
        switch (xmlr.getEventType()) {
            case 1: {
                int i2;
                b2.append("<");
                XmlStreamUtils.printName(xmlr, b2);
                for (i2 = 0; i2 < xmlr.getNamespaceCount(); ++i2) {
                    b2.append(" ");
                    String n2 = xmlr.getNamespacePrefix(i2);
                    if ("xmlns".equals(n2)) {
                        b2.append("xmlns=\"" + xmlr.getNamespaceURI(i2) + "\"");
                        continue;
                    }
                    b2.append("xmlns:" + n2);
                    b2.append("=\"");
                    b2.append(xmlr.getNamespaceURI(i2));
                    b2.append("\"");
                }
                for (i2 = 0; i2 < xmlr.getAttributeCount(); ++i2) {
                    b2.append(" ");
                    XmlStreamUtils.printName(xmlr.getAttributePrefix(i2), xmlr.getAttributeNamespace(i2), xmlr.getAttributeLocalName(i2), b2);
                    b2.append("=\"");
                    b2.append(xmlr.getAttributeValue(i2));
                    b2.append("\"");
                }
                b2.append(">");
                break;
            }
            case 2: {
                b2.append("</");
                XmlStreamUtils.printName(xmlr, b2);
                for (int i3 = 0; i3 < xmlr.getNamespaceCount(); ++i3) {
                    b2.append(" ");
                    String n3 = xmlr.getNamespacePrefix(i3);
                    if ("xmlns".equals(n3)) {
                        b2.append("xmlns=\"" + xmlr.getNamespaceURI(i3) + "\"");
                        continue;
                    }
                    b2.append("xmlns:" + n3);
                    b2.append("=\"");
                    b2.append(xmlr.getNamespaceURI(i3));
                    b2.append("\"");
                }
                b2.append(">");
                break;
            }
            case 4: 
            case 6: {
                int start = xmlr.getTextStart();
                int length = xmlr.getTextLength();
                b2.append(new String(xmlr.getTextCharacters(), start, length));
                break;
            }
            case 3: {
                String data;
                String target = xmlr.getPITarget();
                if (target == null) {
                    target = "";
                }
                if ((data = xmlr.getPIData()) == null) {
                    data = "";
                }
                b2.append("<?");
                b2.append(target + " " + data);
                b2.append("?>");
                break;
            }
            case 12: {
                b2.append("<![CDATA[");
                if (xmlr.hasText()) {
                    b2.append(xmlr.getText());
                }
                b2.append("]]>");
                break;
            }
            case 5: {
                b2.append("<!--");
                if (xmlr.hasText()) {
                    b2.append(xmlr.getText());
                }
                b2.append("-->");
                break;
            }
            case 9: {
                b2.append(xmlr.getLocalName() + "=");
                if (!xmlr.hasText()) break;
                b2.append("[" + xmlr.getText() + "]");
                break;
            }
            case 7: {
                b2.append("<?xml");
                b2.append(" version='" + xmlr.getVersion() + "'");
                b2.append(" encoding='" + xmlr.getCharacterEncodingScheme() + "'");
                if (xmlr.isStandalone()) {
                    b2.append(" standalone='yes'");
                } else {
                    b2.append(" standalone='no'");
                }
                b2.append("?>");
            }
        }
        b2.append("]");
        return b2.toString();
    }

    private static void printName(String prefix, String uri, String localName, StringBuffer b2) {
        if (uri != null && !"".equals(uri)) {
            b2.append("['" + uri + "']:");
        }
        if (prefix != null && !"".equals(prefix)) {
            b2.append(prefix + ":");
        }
        if (localName != null) {
            b2.append(localName);
        }
    }

    private static void printName(XMLStreamReader xmlr, StringBuffer b2) {
        if (xmlr.hasName()) {
            String prefix = xmlr.getPrefix();
            String uri = xmlr.getNamespaceURI();
            String localName = xmlr.getLocalName();
            XmlStreamUtils.printName(prefix, uri, localName, b2);
        }
    }

    public static String getName(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 6: {
                return "SPACE";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 13: {
                return "NAMESPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE";
    }

    public static int getType(String val) {
        if (val.equals("START_ELEMENT")) {
            return 1;
        }
        if (val.equals("SPACE")) {
            return 6;
        }
        if (val.equals("END_ELEMENT")) {
            return 2;
        }
        if (val.equals("PROCESSING_INSTRUCTION")) {
            return 3;
        }
        if (val.equals("CHARACTERS")) {
            return 4;
        }
        if (val.equals("COMMENT")) {
            return 5;
        }
        if (val.equals("START_DOCUMENT")) {
            return 7;
        }
        if (val.equals("END_DOCUMENT")) {
            return 8;
        }
        if (val.equals("ATTRIBUTE")) {
            return 10;
        }
        if (val.equals("DTD")) {
            return 11;
        }
        if (val.equals("CDATA")) {
            return 12;
        }
        if (val.equals("NAMESPACE")) {
            return 13;
        }
        return -1;
    }
}

