/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

public class Levenshtein {
    private static int minimum(int a2, int b2, int c2) {
        int mi = a2;
        if (b2 < mi) {
            mi = b2;
        }
        if (c2 < mi) {
            mi = c2;
        }
        return mi;
    }

    public static int distance(String s2, String t2) {
        int j2;
        int i2;
        int n2 = s2.length();
        int m2 = t2.length();
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        int[][] d2 = new int[n2 + 1][m2 + 1];
        for (i2 = 0; i2 <= n2; ++i2) {
            d2[i2][0] = i2;
        }
        for (j2 = 0; j2 <= m2; ++j2) {
            d2[0][j2] = j2;
        }
        for (i2 = 1; i2 <= n2; ++i2) {
            char s_i = s2.charAt(i2 - 1);
            for (j2 = 1; j2 <= m2; ++j2) {
                char t_j = t2.charAt(j2 - 1);
                int cost = s_i == t_j ? 0 : 1;
                d2[i2][j2] = Levenshtein.minimum(d2[i2 - 1][j2] + 1, d2[i2][j2 - 1] + 1, d2[i2 - 1][j2 - 1] + cost);
            }
        }
        return d2[n2][m2];
    }
}

