/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.HaltingThread;
import org.w3c.dom.svg.SVGDocument;

public class SVGDocumentLoader
extends HaltingThread {
    protected String url;
    protected DocumentLoader loader;
    protected Exception exception;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingStarted((SVGDocumentLoaderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingCompleted((SVGDocumentLoaderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingCancelled((SVGDocumentLoaderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((SVGDocumentLoaderListener)listener).documentLoadingFailed((SVGDocumentLoaderEvent)event);
        }
    };

    public SVGDocumentLoader(String u2, DocumentLoader l2) {
        this.url = u2;
        this.loader = l2;
    }

    @Override
    public void run() {
        SVGDocumentLoaderEvent evt = new SVGDocumentLoaderEvent(this, null);
        try {
            this.fireEvent(startedDispatcher, evt);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, evt);
                return;
            }
            SVGDocument svgDocument = (SVGDocument)this.loader.loadDocument(this.url);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, evt);
                return;
            }
            evt = new SVGDocumentLoaderEvent(this, svgDocument);
            this.fireEvent(completedDispatcher, evt);
        }
        catch (InterruptedIOException e2) {
            this.fireEvent(cancelledDispatcher, evt);
        }
        catch (Exception e3) {
            this.exception = e3;
            this.fireEvent(failedDispatcher, evt);
        }
        catch (ThreadDeath td) {
            this.exception = new Exception(td.getMessage());
            this.fireEvent(failedDispatcher, evt);
            throw td;
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            this.exception = new Exception(t2.getMessage());
            this.fireEvent(failedDispatcher, evt);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener l2) {
        this.listeners.add(l2);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener l2) {
        this.listeners.remove(l2);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent(dispatcher, this.listeners, event, true);
    }
}

