/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.BumpMap;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class DiffuseLightingRed
extends AbstractRed {
    private double kd;
    private Light light;
    private BumpMap bumpMap;
    private double scaleX;
    private double scaleY;
    private Rectangle litRegion;
    private boolean linear;

    public DiffuseLightingRed(double kd, Light light, BumpMap bumpMap, Rectangle litRegion, double scaleX, double scaleY, boolean linear) {
        this.kd = kd;
        this.light = light;
        this.bumpMap = bumpMap;
        this.litRegion = litRegion;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.linear = linear;
        ColorModel cm = linear ? GraphicsUtil.Linear_sRGB_Pre : GraphicsUtil.sRGB_Pre;
        SampleModel sm = cm.createCompatibleSampleModel(litRegion.width, litRegion.height);
        this.init((CachableRed)null, litRegion, cm, sm, litRegion.x, litRegion.y, null);
    }

    @Override
    public WritableRaster copyData(WritableRaster wr) {
        double[] lightColor = this.light.getColor(this.linear);
        int w2 = wr.getWidth();
        int h2 = wr.getHeight();
        int minX = wr.getMinX();
        int minY = wr.getMinY();
        DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
        int[] pixels = db.getBankData()[0];
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int offset = db.getOffset() + sppsm.getOffset(minX - wr.getSampleModelTranslateX(), minY - wr.getSampleModelTranslateY());
        int scanStride = sppsm.getScanlineStride();
        int adjust = scanStride - w2;
        int p2 = offset;
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int i2 = 0;
        int j2 = 0;
        double x2 = this.scaleX * (double)minX;
        double y2 = this.scaleY * (double)minY;
        double NL = 0.0;
        double[][][] NA2 = this.bumpMap.getNormalArray(minX, minY, w2, h2);
        if (!this.light.isConstant()) {
            double[][] LA2 = new double[w2][3];
            for (i2 = 0; i2 < h2; ++i2) {
                double[][] NR = NA2[i2];
                this.light.getLightRow(x2, y2 + (double)i2 * this.scaleY, this.scaleX, w2, NR, LA2);
                for (j2 = 0; j2 < w2; ++j2) {
                    double[] N2 = NR[j2];
                    double[] L2 = LA2[j2];
                    NL = 255.0 * this.kd * (N2[0] * L2[0] + N2[1] * L2[1] + N2[2] * L2[2]);
                    r2 = (int)(NL * lightColor[0]);
                    g2 = (int)(NL * lightColor[1]);
                    b2 = (int)(NL * lightColor[2]);
                    if ((r2 & 0xFFFFFF00) != 0) {
                        int n2 = r2 = (r2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((g2 & 0xFFFFFF00) != 0) {
                        int n3 = g2 = (g2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((b2 & 0xFFFFFF00) != 0) {
                        b2 = (b2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    pixels[p2++] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
                }
                p2 += adjust;
            }
        } else {
            double[] L3 = new double[3];
            this.light.getLight(0.0, 0.0, 0.0, L3);
            for (i2 = 0; i2 < h2; ++i2) {
                double[][] NR = NA2[i2];
                for (j2 = 0; j2 < w2; ++j2) {
                    double[] N3 = NR[j2];
                    NL = 255.0 * this.kd * (N3[0] * L3[0] + N3[1] * L3[1] + N3[2] * L3[2]);
                    r2 = (int)(NL * lightColor[0]);
                    g2 = (int)(NL * lightColor[1]);
                    b2 = (int)(NL * lightColor[2]);
                    if ((r2 & 0xFFFFFF00) != 0) {
                        int n4 = r2 = (r2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((g2 & 0xFFFFFF00) != 0) {
                        int n5 = g2 = (g2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if ((b2 & 0xFFFFFF00) != 0) {
                        b2 = (b2 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    pixels[p2++] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
                }
                p2 += adjust;
            }
        }
        return wr;
    }
}

