/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import org.apache.batik.ext.awt.image.TransferFunction;

public class GammaTransfer
implements TransferFunction {
    public byte[] lutData;
    public float amplitude;
    public float exponent;
    public float offset;

    public GammaTransfer(float amplitude, float exponent, float offset) {
        this.amplitude = amplitude;
        this.exponent = exponent;
        this.offset = offset;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        for (int j2 = 0; j2 <= 255; ++j2) {
            int v2 = (int)Math.round(255.0 * ((double)this.amplitude * Math.pow((float)j2 / 255.0f, this.exponent) + (double)this.offset));
            if (v2 > 255) {
                v2 = -1;
            } else if (v2 < 0) {
                v2 = 0;
            }
            this.lutData[j2] = (byte)(v2 & 0xFF);
        }
    }

    @Override
    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

