/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.constants.XMLConstants;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtilities
extends XMLUtilities
implements XMLConstants {
    protected static final String[] LOCK_STRINGS = new String[]{"", "CapsLock", "NumLock", "NumLock CapsLock", "Scroll", "Scroll CapsLock", "Scroll NumLock", "Scroll NumLock CapsLock", "KanaMode", "KanaMode CapsLock", "KanaMode NumLock", "KanaMode NumLock CapsLock", "KanaMode Scroll", "KanaMode Scroll CapsLock", "KanaMode Scroll NumLock", "KanaMode Scroll NumLock CapsLock"};
    protected static final String[] MODIFIER_STRINGS = new String[]{"", "Shift", "Control", "Control Shift", "Meta", "Meta Shift", "Control Meta", "Control Meta Shift", "Alt", "Alt Shift", "Alt Control", "Alt Control Shift", "Alt Meta", "Alt Meta Shift", "Alt Control Meta", "Alt Control Meta Shift", "AltGraph", "AltGraph Shift", "AltGraph Control", "AltGraph Control Shift", "AltGraph Meta", "AltGraph Meta Shift", "AltGraph Control Meta", "AltGraph Control Meta Shift", "Alt AltGraph", "Alt AltGraph Shift", "Alt AltGraph Control", "Alt AltGraph Control Shift", "Alt AltGraph Meta", "Alt AltGraph Meta Shift", "Alt AltGraph Control Meta", "Alt AltGraph Control Meta Shift"};

    protected DOMUtilities() {
    }

    public static void writeDocument(Document doc, Writer w2) throws IOException {
        AbstractDocument d2 = (AbstractDocument)doc;
        if (doc.getDocumentElement() == null) {
            throw new IOException("No document element");
        }
        NSMap m2 = NSMap.create();
        for (Node n2 = doc.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            DOMUtilities.writeNode(n2, w2, m2, "1.1".equals(d2.getXmlVersion()));
        }
    }

    protected static void writeNode(Node n2, Writer w2, NSMap m2, boolean isXML11) throws IOException {
        switch (n2.getNodeType()) {
            case 1: {
                Node c2;
                String tagName;
                if (n2.hasAttributes()) {
                    NamedNodeMap attr = n2.getAttributes();
                    int len = attr.getLength();
                    for (int i2 = 0; i2 < len; ++i2) {
                        Attr a2 = (Attr)attr.item(i2);
                        String name = a2.getNodeName();
                        if (!name.startsWith("xmlns")) continue;
                        if (name.length() == 5) {
                            m2 = m2.declare("", a2.getNodeValue());
                            continue;
                        }
                        String prefix = name.substring(6);
                        m2 = m2.declare(prefix, a2.getNodeValue());
                    }
                }
                w2.write(60);
                String ns = n2.getNamespaceURI();
                if (ns == null) {
                    tagName = n2.getNodeName();
                    w2.write(tagName);
                    if (!"".equals(m2.getNamespace(""))) {
                        w2.write(" xmlns=\"\"");
                        m2 = m2.declare("", "");
                    }
                } else {
                    String prefix = n2.getPrefix();
                    if (prefix == null) {
                        prefix = "";
                    }
                    if (ns.equals(m2.getNamespace(prefix))) {
                        tagName = n2.getNodeName();
                        w2.write(tagName);
                    } else {
                        prefix = m2.getPrefixForElement(ns);
                        if (prefix == null) {
                            prefix = m2.getNewPrefix();
                            tagName = prefix + ':' + n2.getLocalName();
                            w2.write(tagName + " xmlns:" + prefix + "=\"" + DOMUtilities.contentToString(ns, isXML11) + '\"');
                            m2 = m2.declare(prefix, ns);
                        } else {
                            tagName = prefix.equals("") ? n2.getLocalName() : prefix + ':' + n2.getLocalName();
                            w2.write(tagName);
                        }
                    }
                }
                if (n2.hasAttributes()) {
                    NamedNodeMap attr = n2.getAttributes();
                    int len = attr.getLength();
                    for (int i3 = 0; i3 < len; ++i3) {
                        Attr a3 = (Attr)attr.item(i3);
                        String name = a3.getNodeName();
                        String prefix = a3.getPrefix();
                        String ans = a3.getNamespaceURI();
                        if (!(ans == null || "xmlns".equals(prefix) || name.equals("xmlns") || (prefix == null || ans.equals(m2.getNamespace(prefix))) && prefix != null)) {
                            prefix = m2.getPrefixForAttr(ans);
                            if (prefix == null) {
                                prefix = m2.getNewPrefix();
                                m2 = m2.declare(prefix, ans);
                                w2.write(" xmlns:" + prefix + "=\"" + DOMUtilities.contentToString(ans, isXML11) + '\"');
                            }
                            name = prefix + ':' + a3.getLocalName();
                        }
                        w2.write(' ' + name + "=\"" + DOMUtilities.contentToString(a3.getNodeValue(), isXML11) + '\"');
                    }
                }
                if ((c2 = n2.getFirstChild()) != null) {
                    w2.write(62);
                    do {
                        DOMUtilities.writeNode(c2, w2, m2, isXML11);
                    } while ((c2 = c2.getNextSibling()) != null);
                    w2.write("</" + tagName + '>');
                    break;
                }
                w2.write("/>");
                break;
            }
            case 3: {
                w2.write(DOMUtilities.contentToString(n2.getNodeValue(), isXML11));
                break;
            }
            case 4: {
                String data = n2.getNodeValue();
                if (data.indexOf("]]>") != -1) {
                    throw new IOException("Unserializable CDATA section node");
                }
                w2.write("<![CDATA[" + DOMUtilities.assertValidCharacters(data, isXML11) + "]]>");
                break;
            }
            case 5: {
                w2.write('&' + n2.getNodeName() + ';');
                break;
            }
            case 7: {
                String target = n2.getNodeName();
                String data = n2.getNodeValue();
                if (target.equalsIgnoreCase("xml") || target.indexOf(58) != -1 || data.indexOf("?>") != -1) {
                    throw new IOException("Unserializable processing instruction node");
                }
                w2.write("<?" + target + ' ' + data + "?>");
                break;
            }
            case 8: {
                w2.write("<!--");
                String data = n2.getNodeValue();
                int len = data.length();
                if (len != 0 && data.charAt(len - 1) == '-' || data.indexOf("--") != -1) {
                    throw new IOException("Unserializable comment node");
                }
                w2.write(data);
                w2.write("-->");
                break;
            }
            case 10: {
                String subset;
                String sysID;
                DocumentType dt = (DocumentType)n2;
                w2.write("<!DOCTYPE " + n2.getOwnerDocument().getDocumentElement().getNodeName());
                String pubID = dt.getPublicId();
                if (pubID != null) {
                    char q2 = DOMUtilities.getUsableQuote(pubID);
                    if (q2 == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    w2.write(" PUBLIC " + q2 + pubID + q2);
                }
                if ((sysID = dt.getSystemId()) != null) {
                    char q3 = DOMUtilities.getUsableQuote(sysID);
                    if (q3 == '\u0000') {
                        throw new IOException("Unserializable DOCTYPE node");
                    }
                    if (pubID == null) {
                        w2.write(" SYSTEM");
                    }
                    w2.write(" " + q3 + sysID + q3);
                }
                if ((subset = dt.getInternalSubset()) != null) {
                    w2.write('[' + subset + ']');
                }
                w2.write(62);
                break;
            }
            default: {
                throw new IOException("Unknown DOM node type " + n2.getNodeType());
            }
        }
    }

    public static void writeNode(Node n2, Writer w2) throws IOException {
        if (n2.getNodeType() == 9) {
            DOMUtilities.writeDocument((Document)n2, w2);
        } else {
            AbstractDocument d2 = (AbstractDocument)n2.getOwnerDocument();
            DOMUtilities.writeNode(n2, w2, NSMap.create(), d2 == null ? false : "1.1".equals(d2.getXmlVersion()));
        }
    }

    private static char getUsableQuote(String s2) {
        int ret = 0;
        for (int i2 = s2.length() - 1; i2 >= 0; --i2) {
            char c2 = s2.charAt(i2);
            if (c2 == '\"') {
                if (ret == 0) {
                    ret = 39;
                    continue;
                }
                return '\u0000';
            }
            if (c2 != '\'') continue;
            if (ret == 0) {
                ret = 34;
                continue;
            }
            return '\u0000';
        }
        return (char)(ret == 0 ? 34 : ret);
    }

    public static String getXML(Node n2) {
        StringWriter writer = new StringWriter();
        try {
            DOMUtilities.writeNode(n2, writer);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            return "";
        }
        return ((Object)writer).toString();
    }

    protected static String assertValidCharacters(String s2, boolean isXML11) throws IOException {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if ((isXML11 || DOMUtilities.isXMLCharacter(c2)) && (!isXML11 || DOMUtilities.isXML11Character(c2))) continue;
            throw new IOException("Invalid character");
        }
        return s2;
    }

    public static String contentToString(String s2, boolean isXML11) throws IOException {
        StringBuffer result = new StringBuffer(s2.length());
        int len = s2.length();
        block7: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (!isXML11 && !DOMUtilities.isXMLCharacter(c2) || isXML11 && !DOMUtilities.isXML11Character(c2)) {
                throw new IOException("Invalid character");
            }
            switch (c2) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block7;
                }
                default: {
                    result.append(c2);
                }
            }
        }
        return result.toString();
    }

    public static int getChildIndex(Node child, Node parent) {
        if (child == null || child.getParentNode() != parent || child.getParentNode() == null) {
            return -1;
        }
        return DOMUtilities.getChildIndex(child);
    }

    public static int getChildIndex(Node child) {
        NodeList children = child.getParentNode().getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node currentChild = children.item(i2);
            if (currentChild != child) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isAnyNodeAncestorOf(ArrayList ancestorNodes, Node node) {
        int n2 = ancestorNodes.size();
        for (Object ancestorNode : ancestorNodes) {
            Node ancestor = (Node)ancestorNode;
            if (!DOMUtilities.isAncestorOf(ancestor, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestorOf(Node node, Node descendant) {
        if (node == null || descendant == null) {
            return false;
        }
        for (Node currentNode = descendant.getParentNode(); currentNode != null; currentNode = currentNode.getParentNode()) {
            if (currentNode != node) continue;
            return true;
        }
        return false;
    }

    public static boolean isParentOf(Node node, Node parentNode) {
        return node != null && parentNode != null && node.getParentNode() == parentNode;
    }

    public static boolean canAppend(Node node, Node parentNode) {
        return node != null && parentNode != null && node != parentNode && !DOMUtilities.isAncestorOf(node, parentNode);
    }

    public static boolean canAppendAny(ArrayList children, Node parentNode) {
        if (!DOMUtilities.canHaveChildren(parentNode)) {
            return false;
        }
        int n2 = children.size();
        for (Object aChildren : children) {
            Node child = (Node)aChildren;
            if (!DOMUtilities.canAppend(child, parentNode)) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveChildren(Node parentNode) {
        if (parentNode == null) {
            return false;
        }
        switch (parentNode.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static Node parseXML(String text, Document doc, String uri, Map prefixes, String wrapperElementName, SAXDocumentFactory documentFactory) {
        String wrapperElementPrefix = "";
        String wrapperElementSuffix = "";
        if (wrapperElementName != null) {
            wrapperElementPrefix = "<" + wrapperElementName;
            if (prefixes != null) {
                wrapperElementPrefix = wrapperElementPrefix + " ";
                Iterator i$ = prefixes.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o2;
                    Map.Entry e2 = o2 = i$.next();
                    String currentKey = (String)e2.getKey();
                    String currentValue = (String)e2.getValue();
                    wrapperElementPrefix = wrapperElementPrefix + currentKey + "=\"" + currentValue + "\" ";
                }
            }
            wrapperElementPrefix = wrapperElementPrefix + ">";
            wrapperElementSuffix = wrapperElementSuffix + "</" + wrapperElementName + '>';
        }
        if (wrapperElementPrefix.trim().length() == 0 && wrapperElementSuffix.trim().length() == 0) {
            try {
                Document d2 = documentFactory.createDocument(uri, new StringReader(text));
                if (doc == null) {
                    return d2;
                }
                DocumentFragment result = doc.createDocumentFragment();
                result.appendChild(doc.importNode(d2.getDocumentElement(), true));
                return result;
            }
            catch (Exception d2) {
                // empty catch block
            }
        }
        StringBuffer sb = new StringBuffer(wrapperElementPrefix.length() + text.length() + wrapperElementSuffix.length());
        sb.append(wrapperElementPrefix);
        sb.append(text);
        sb.append(wrapperElementSuffix);
        String newText = sb.toString();
        try {
            Document d3 = documentFactory.createDocument(uri, new StringReader(newText));
            if (doc == null) {
                return d3;
            }
            for (Node node = d3.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                node = doc.importNode(node, true);
                DocumentFragment result = doc.createDocumentFragment();
                result.appendChild(node);
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Document deepCloneDocument(Document doc, DOMImplementation impl) {
        Element root = doc.getDocumentElement();
        Document result = impl.createDocument(root.getNamespaceURI(), root.getNodeName(), null);
        Element rroot = result.getDocumentElement();
        boolean before = true;
        for (Node n2 = doc.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2 == root) {
                before = false;
                if (root.hasAttributes()) {
                    NamedNodeMap attr = root.getAttributes();
                    int len = attr.getLength();
                    for (int i2 = 0; i2 < len; ++i2) {
                        rroot.setAttributeNode((Attr)result.importNode(attr.item(i2), true));
                    }
                }
                for (Node c2 = root.getFirstChild(); c2 != null; c2 = c2.getNextSibling()) {
                    rroot.appendChild(result.importNode(c2, true));
                }
                continue;
            }
            if (n2.getNodeType() == 10) continue;
            if (before) {
                result.insertBefore(result.importNode(n2, true), rroot);
                continue;
            }
            result.appendChild(result.importNode(n2, true));
        }
        return result;
    }

    public static boolean isValidName(String s2) {
        int m2;
        int len = s2.length();
        if (len == 0) {
            return false;
        }
        char c2 = s2.charAt(0);
        int d2 = c2 / 32;
        if ((NAME_FIRST_CHARACTER[d2] & 1 << (m2 = c2 % 32)) == 0) {
            return false;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            c2 = s2.charAt(i2);
            d2 = c2 / 32;
            if ((NAME_CHARACTER[d2] & 1 << (m2 = c2 % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidName11(String s2) {
        int m2;
        int len = s2.length();
        if (len == 0) {
            return false;
        }
        char c2 = s2.charAt(0);
        int d2 = c2 / 32;
        if ((NAME11_FIRST_CHARACTER[d2] & 1 << (m2 = c2 % 32)) == 0) {
            return false;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            c2 = s2.charAt(i2);
            d2 = c2 / 32;
            if ((NAME11_CHARACTER[d2] & 1 << (m2 = c2 % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefix(String s2) {
        return s2.indexOf(58) == -1;
    }

    public static String getPrefix(String s2) {
        int i2 = s2.indexOf(58);
        return i2 == -1 || i2 == s2.length() - 1 ? null : s2.substring(0, i2);
    }

    public static String getLocalName(String s2) {
        int i2 = s2.indexOf(58);
        return i2 == -1 || i2 == s2.length() - 1 ? s2 : s2.substring(i2 + 1);
    }

    public static void parseStyleSheetPIData(String data, HashMap<String, String> table) {
        char c2;
        int i2;
        for (i2 = 0; i2 < data.length() && XMLUtilities.isXMLSpace(c2 = data.charAt(i2)); ++i2) {
        }
        while (i2 < data.length()) {
            int m2;
            c2 = data.charAt(i2);
            int d2 = c2 / 32;
            if ((NAME_FIRST_CHARACTER[d2] & 1 << (m2 = c2 % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c2);
            }
            StringBuffer ident = new StringBuffer();
            ident.append(c2);
            while (++i2 < data.length() && (NAME_CHARACTER[d2 = (c2 = data.charAt(i2)) / 32] & 1 << (m2 = c2 % 32)) != 0) {
                ident.append(c2);
            }
            if (i2 >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            while (i2 < data.length() && XMLUtilities.isXMLSpace(c2 = data.charAt(i2))) {
                ++i2;
            }
            if (i2 >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            if (data.charAt(i2) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            ++i2;
            while (i2 < data.length() && XMLUtilities.isXMLSpace(c2 = data.charAt(i2))) {
                ++i2;
            }
            if (i2 >= data.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            c2 = data.charAt(i2);
            ++i2;
            StringBuffer value = new StringBuffer();
            if (c2 == '\'') {
                while (i2 < data.length() && (c2 = data.charAt(i2)) != '\'') {
                    value.append(c2);
                    ++i2;
                }
                if (i2 >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else if (c2 == '\"') {
                while (i2 < data.length() && (c2 = data.charAt(i2)) != '\"') {
                    value.append(c2);
                    ++i2;
                }
                if (i2 >= data.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + data);
            }
            table.put(ident.toString().intern(), value.toString());
            ++i2;
            while (i2 < data.length() && XMLUtilities.isXMLSpace(c2 = data.charAt(i2))) {
                ++i2;
            }
        }
    }

    public static String getModifiersList(int lockState, int modifiersEx) {
        modifiersEx = (modifiersEx & 0x2000) != 0 ? 0x10 | modifiersEx >> 6 & 0xF : modifiersEx >> 6 & 0xF;
        String s2 = LOCK_STRINGS[lockState & 0xF];
        if (s2.length() != 0) {
            return s2 + ' ' + MODIFIER_STRINGS[modifiersEx];
        }
        return MODIFIER_STRINGS[modifiersEx];
    }

    public static boolean isAttributeSpecifiedNS(Element e2, String namespaceURI, String localName) {
        Attr a2 = e2.getAttributeNodeNS(namespaceURI, localName);
        return a2 != null && a2.getSpecified();
    }

    private static final class NSMap {
        private String prefix;
        private String ns;
        private NSMap next;
        private int nextPrefixNumber;

        public static NSMap create() {
            return new NSMap().declare("xml", "http://www.w3.org/XML/1998/namespace").declare("xmlns", "http://www.w3.org/2000/xmlns/");
        }

        private NSMap() {
        }

        public NSMap declare(String prefix, String ns) {
            NSMap m2 = new NSMap();
            m2.prefix = prefix;
            m2.ns = ns;
            m2.next = this;
            m2.nextPrefixNumber = this.nextPrefixNumber;
            return m2;
        }

        public String getNewPrefix() {
            String prefix;
            while (this.getNamespace(prefix = "a" + this.nextPrefixNumber++) != null) {
            }
            return prefix;
        }

        public String getNamespace(String prefix) {
            NSMap m2 = this;
            while (m2.next != null) {
                if (m2.prefix.equals(prefix)) {
                    return m2.ns;
                }
                m2 = m2.next;
            }
            return null;
        }

        public String getPrefixForElement(String ns) {
            NSMap m2 = this;
            while (m2.next != null) {
                if (ns.equals(m2.ns)) {
                    return m2.prefix;
                }
                m2 = m2.next;
            }
            return null;
        }

        public String getPrefixForAttr(String ns) {
            NSMap m2 = this;
            while (m2.next != null) {
                if (ns.equals(m2.ns) && !m2.prefix.equals("")) {
                    return m2.prefix;
                }
                m2 = m2.next;
            }
            return null;
        }
    }
}

