/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractChildNode;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractCharacterData
extends AbstractChildNode
implements CharacterData {
    protected String nodeValue = "";

    @Override
    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        String val = this.nodeValue;
        this.nodeValue = nodeValue == null ? "" : nodeValue;
        this.fireDOMCharacterDataModifiedEvent(val, this.nodeValue);
        if (this.getParentNode() != null) {
            ((AbstractParentNode)this.getParentNode()).fireDOMSubtreeModifiedEvent();
        }
    }

    @Override
    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setData(String data) throws DOMException {
        this.setNodeValue(data);
    }

    @Override
    public int getLength() {
        return this.nodeValue.length();
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        this.checkOffsetCount(offset, count);
        String v2 = this.getNodeValue();
        return v2.substring(offset, Math.min(v2.length(), offset + count));
    }

    @Override
    public void appendData(String arg) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        this.setNodeValue(this.getNodeValue() + (arg == null ? "" : arg));
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        if (offset < 0 || offset > this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{offset});
        }
        String v2 = this.getNodeValue();
        this.setNodeValue(v2.substring(0, offset) + arg + v2.substring(offset, v2.length()));
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        this.checkOffsetCount(offset, count);
        String v2 = this.getNodeValue();
        this.setNodeValue(v2.substring(0, offset) + v2.substring(Math.min(v2.length(), offset + count), v2.length()));
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        this.checkOffsetCount(offset, count);
        String v2 = this.getNodeValue();
        this.setNodeValue(v2.substring(0, offset) + arg + v2.substring(Math.min(v2.length(), offset + count), v2.length()));
    }

    protected void checkOffsetCount(int offset, int count) throws DOMException {
        if (offset < 0 || offset >= this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{offset});
        }
        if (count < 0) {
            throw this.createDOMException((short)1, "negative.count", new Object[]{count});
        }
    }

    @Override
    protected Node export(Node n2, AbstractDocument d2) {
        super.export(n2, d2);
        AbstractCharacterData cd = (AbstractCharacterData)n2;
        cd.nodeValue = this.nodeValue;
        return n2;
    }

    @Override
    protected Node deepExport(Node n2, AbstractDocument d2) {
        super.deepExport(n2, d2);
        AbstractCharacterData cd = (AbstractCharacterData)n2;
        cd.nodeValue = this.nodeValue;
        return n2;
    }

    @Override
    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        AbstractCharacterData cd = (AbstractCharacterData)n2;
        cd.nodeValue = this.nodeValue;
        return n2;
    }

    @Override
    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        AbstractCharacterData cd = (AbstractCharacterData)n2;
        cd.nodeValue = this.nodeValue;
        return n2;
    }
}

