/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.TransformAnimation;
import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableTransformListValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAnimateElementBridge;
import org.apache.batik.dom.svg.SVGOMTransform;

public class SVGAnimateTransformElementBridge
extends SVGAnimateElementBridge {
    @Override
    public String getLocalName() {
        return "animateTransform";
    }

    @Override
    public Bridge getInstance() {
        return new SVGAnimateTransformElementBridge();
    }

    @Override
    protected AbstractAnimation createAnimation(AnimationTarget target) {
        short type = this.parseType();
        AnimatableValue from = null;
        AnimatableValue to = null;
        AnimatableValue by = null;
        if (this.element.hasAttributeNS(null, "from")) {
            from = this.parseValue(this.element.getAttributeNS(null, "from"), type, target);
        }
        if (this.element.hasAttributeNS(null, "to")) {
            to = this.parseValue(this.element.getAttributeNS(null, "to"), type, target);
        }
        if (this.element.hasAttributeNS(null, "by")) {
            by = this.parseValue(this.element.getAttributeNS(null, "by"), type, target);
        }
        return new TransformAnimation(this.timedElement, this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(type, target), from, to, by, type);
    }

    protected short parseType() {
        String typeString = this.element.getAttributeNS(null, "type");
        if (typeString.equals("translate")) {
            return 2;
        }
        if (typeString.equals("scale")) {
            return 3;
        }
        if (typeString.equals("rotate")) {
            return 4;
        }
        if (typeString.equals("skewX")) {
            return 5;
        }
        if (typeString.equals("skewY")) {
            return 6;
        }
        throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"type", typeString});
    }

    protected AnimatableValue parseValue(String s2, short type, AnimationTarget target) {
        int i2;
        float val2 = 0.0f;
        float val3 = 0.0f;
        int c2 = 44;
        int len = s2.length();
        for (i2 = 0; i2 < len && (c2 = (int)s2.charAt(i2)) != 32 && c2 != 44; ++i2) {
        }
        float val1 = Float.parseFloat(s2.substring(0, i2));
        if (i2 < len) {
            ++i2;
        }
        int count = 1;
        if (i2 < len && c2 == 32) {
            while (i2 < len && (c2 = (int)s2.charAt(i2)) == 32) {
                ++i2;
            }
            if (c2 == 44) {
                ++i2;
            }
        }
        while (i2 < len && s2.charAt(i2) == ' ') {
            ++i2;
        }
        int j2 = i2;
        if (i2 < len && type != 5 && type != 6) {
            while (i2 < len && (c2 = (int)s2.charAt(i2)) != 32 && c2 != 44) {
                ++i2;
            }
            val2 = Float.parseFloat(s2.substring(j2, i2));
            if (i2 < len) {
                ++i2;
            }
            ++count;
            if (i2 < len && c2 == 32) {
                while (i2 < len && (c2 = (int)s2.charAt(i2)) == 32) {
                    ++i2;
                }
                if (c2 == 44) {
                    ++i2;
                }
            }
            while (i2 < len && s2.charAt(i2) == ' ') {
                ++i2;
            }
            j2 = i2;
            if (i2 < len && type == 4) {
                while (i2 < len && (c2 = (int)s2.charAt(i2)) != 44 && c2 != 32) {
                    ++i2;
                }
                val3 = Float.parseFloat(s2.substring(j2, i2));
                if (i2 < len) {
                    ++i2;
                }
                ++count;
                while (i2 < len && s2.charAt(i2) == ' ') {
                    ++i2;
                }
            }
        }
        if (i2 != len) {
            return null;
        }
        SVGOMTransform t2 = new SVGOMTransform();
        switch (type) {
            case 2: {
                if (count == 2) {
                    t2.setTranslate(val1, val2);
                    break;
                }
                t2.setTranslate(val1, 0.0f);
                break;
            }
            case 3: {
                if (count == 2) {
                    t2.setScale(val1, val2);
                    break;
                }
                t2.setScale(val1, val1);
                break;
            }
            case 4: {
                if (count == 3) {
                    t2.setRotate(val1, val2, val3);
                    break;
                }
                t2.setRotate(val1, 0.0f, 0.0f);
                break;
            }
            case 5: {
                t2.setSkewX(val1);
                break;
            }
            case 6: {
                t2.setSkewY(val1);
            }
        }
        return new AnimatableTransformListValue(target, t2);
    }

    protected AnimatableValue[] parseValues(short type, AnimationTarget target) {
        String valuesString = this.element.getAttributeNS(null, "values");
        int len = valuesString.length();
        if (len == 0) {
            return null;
        }
        ArrayList<AnimatableValue> values = new ArrayList<AnimatableValue>(7);
        int i2 = 0;
        int start = 0;
        block0: while (i2 < len) {
            int end;
            String valueString;
            AnimatableValue value;
            while (valuesString.charAt(i2) == ' ') {
                if (++i2 != len) continue;
                break block0;
            }
            start = i2++;
            if (i2 < len) {
                char c2 = valuesString.charAt(i2);
                while (c2 != ';' && ++i2 != len) {
                    c2 = valuesString.charAt(i2);
                }
            }
            if ((value = this.parseValue(valueString = valuesString.substring(start, end = i2++), type, target)) == null) {
                throw new BridgeException(this.ctx, this.element, "attribute.malformed", new Object[]{"values", valuesString});
            }
            values.add(value);
        }
        AnimatableValue[] ret = new AnimatableValue[values.size()];
        return values.toArray(ret);
    }

    @Override
    protected boolean canAnimateType(int type) {
        return type == 9;
    }
}

