/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.css.engine.value.svg12.CIELabColor;
import org.apache.batik.css.engine.value.svg12.DeviceColor;
import org.apache.batik.css.engine.value.svg12.ICCNamedColor;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.CSSConstants;
import org.apache.batik.util.SVGConstants;
import org.apache.xmlgraphics.java2d.color.CIELabColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorSpaces;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;
import org.apache.xmlgraphics.java2d.color.DeviceCMYKColorSpace;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.java2d.color.profile.NamedColorProfile;
import org.apache.xmlgraphics.java2d.color.profile.NamedColorProfileParser;
import org.w3c.dom.Element;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element e2, ShapeNode node, BridgeContext ctx) {
        Value v2 = CSSUtilities.getComputedStyle(e2, 36);
        Marker startMarker = PaintServer.convertMarker(e2, v2, ctx);
        v2 = CSSUtilities.getComputedStyle(e2, 35);
        Marker midMarker = PaintServer.convertMarker(e2, v2, ctx);
        v2 = CSSUtilities.getComputedStyle(e2, 34);
        Marker endMarker = PaintServer.convertMarker(e2, v2, ctx);
        if (startMarker != null || midMarker != null || endMarker != null) {
            MarkerShapePainter p2 = new MarkerShapePainter(node.getShape());
            p2.setStartMarker(startMarker);
            p2.setMiddleMarker(midMarker);
            p2.setEndMarker(endMarker);
            return p2;
        }
        return null;
    }

    public static Marker convertMarker(Element e2, Value v2, BridgeContext ctx) {
        if (v2.getPrimitiveType() == 21) {
            return null;
        }
        String uri = v2.getStringValue();
        Element markerElement = ctx.getReferencedElement(e2, uri);
        Bridge bridge = ctx.getBridge(markerElement);
        if (bridge == null || !(bridge instanceof MarkerBridge)) {
            throw new BridgeException(ctx, e2, "css.uri.badTarget", new Object[]{uri});
        }
        return ((MarkerBridge)bridge).createMarker(ctx, markerElement, e2);
    }

    public static ShapePainter convertFillAndStroke(Element e2, ShapeNode node, BridgeContext ctx) {
        Shape shape = node.getShape();
        if (shape == null) {
            return null;
        }
        Paint fillPaint = PaintServer.convertFillPaint(e2, node, ctx);
        FillShapePainter fp = new FillShapePainter(shape);
        fp.setPaint(fillPaint);
        Stroke stroke = PaintServer.convertStroke(e2);
        if (stroke == null) {
            return fp;
        }
        Paint strokePaint = PaintServer.convertStrokePaint(e2, node, ctx);
        StrokeShapePainter sp = new StrokeShapePainter(shape);
        sp.setStroke(stroke);
        sp.setPaint(strokePaint);
        CompositeShapePainter cp = new CompositeShapePainter(shape);
        cp.addShapePainter(fp);
        cp.addShapePainter(sp);
        return cp;
    }

    public static ShapePainter convertStrokePainter(Element e2, ShapeNode node, BridgeContext ctx) {
        Shape shape = node.getShape();
        if (shape == null) {
            return null;
        }
        Stroke stroke = PaintServer.convertStroke(e2);
        if (stroke == null) {
            return null;
        }
        Paint strokePaint = PaintServer.convertStrokePaint(e2, node, ctx);
        StrokeShapePainter sp = new StrokeShapePainter(shape);
        sp.setStroke(stroke);
        sp.setPaint(strokePaint);
        return sp;
    }

    public static Paint convertStrokePaint(Element strokedElement, GraphicsNode strokedNode, BridgeContext ctx) {
        Value v2 = CSSUtilities.getComputedStyle(strokedElement, 51);
        float opacity = PaintServer.convertOpacity(v2);
        v2 = CSSUtilities.getComputedStyle(strokedElement, 45);
        return PaintServer.convertPaint(strokedElement, strokedNode, v2, opacity, ctx);
    }

    public static Paint convertFillPaint(Element filledElement, GraphicsNode filledNode, BridgeContext ctx) {
        Value v2 = CSSUtilities.getComputedStyle(filledElement, 16);
        float opacity = PaintServer.convertOpacity(v2);
        v2 = CSSUtilities.getComputedStyle(filledElement, 15);
        return PaintServer.convertPaint(filledElement, filledNode, v2, opacity, ctx);
    }

    public static Paint convertPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) {
        if (paintDef.getCssValueType() == 1) {
            switch (paintDef.getPrimitiveType()) {
                case 21: {
                    return null;
                }
                case 25: {
                    return PaintServer.convertColor(paintDef, opacity);
                }
                case 20: {
                    return PaintServer.convertURIPaint(paintedElement, paintedNode, paintDef, opacity, ctx);
                }
            }
            throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
        }
        Value v2 = paintDef.item(0);
        switch (v2.getPrimitiveType()) {
            case 25: {
                return PaintServer.convertRGBICCColor(paintedElement, v2, paintDef.item(1), opacity, ctx);
            }
            case 20: {
                Paint result = PaintServer.silentConvertURIPaint(paintedElement, paintedNode, v2, opacity, ctx);
                if (result != null) {
                    return result;
                }
                v2 = paintDef.item(1);
                switch (v2.getPrimitiveType()) {
                    case 21: {
                        return null;
                    }
                    case 25: {
                        if (paintDef.getLength() == 2) {
                            return PaintServer.convertColor(v2, opacity);
                        }
                        return PaintServer.convertRGBICCColor(paintedElement, v2, paintDef.item(2), opacity, ctx);
                    }
                }
                throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
            }
        }
        throw new IllegalArgumentException("Paint argument is not an appropriate CSS value");
    }

    public static Paint silentConvertURIPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(paintedElement, paintedNode, paintDef, opacity, ctx);
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element paintedElement, GraphicsNode paintedNode, Value paintDef, float opacity, BridgeContext ctx) {
        String uri = paintDef.getStringValue();
        Element paintElement = ctx.getReferencedElement(paintedElement, uri);
        Bridge bridge = ctx.getBridge(paintElement);
        if (bridge == null || !(bridge instanceof PaintBridge)) {
            throw new BridgeException(ctx, paintedElement, "css.uri.badTarget", new Object[]{uri});
        }
        return ((PaintBridge)bridge).createPaint(ctx, paintElement, paintedElement, paintedNode, opacity);
    }

    public static Color convertRGBICCColor(Element paintedElement, Value colorDef, Value iccColor, float opacity, BridgeContext ctx) {
        Color color = null;
        if (iccColor != null) {
            if (iccColor instanceof ICCColor) {
                color = PaintServer.convertICCColor(paintedElement, (ICCColor)iccColor, opacity, ctx);
            } else if (iccColor instanceof ICCNamedColor) {
                color = PaintServer.convertICCNamedColor(paintedElement, (ICCNamedColor)iccColor, opacity, ctx);
            } else if (iccColor instanceof CIELabColor) {
                color = PaintServer.convertCIELabColor(paintedElement, (CIELabColor)iccColor, opacity, ctx);
            } else if (iccColor instanceof DeviceColor) {
                color = PaintServer.convertDeviceColor(paintedElement, colorDef, (DeviceColor)iccColor, opacity, ctx);
            }
        }
        if (color == null) {
            color = PaintServer.convertColor(colorDef, opacity);
        }
        return color;
    }

    public static Color convertICCColor(Element e2, ICCColor c2, float opacity, BridgeContext ctx) {
        String iccProfileName = c2.getColorProfile();
        if (iccProfileName == null) {
            return null;
        }
        SVGColorProfileElementBridge profileBridge = (SVGColorProfileElementBridge)ctx.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (profileBridge == null) {
            return null;
        }
        ICCColorSpaceWithIntent profileCS = profileBridge.createICCColorSpaceWithIntent(ctx, e2, iccProfileName);
        if (profileCS == null) {
            return null;
        }
        int n2 = c2.getNumberOfColors();
        float[] colorValue = new float[n2];
        if (n2 == 0) {
            return null;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            colorValue[i2] = c2.getColor(i2);
        }
        float[] rgb = profileCS.intendedToRGB(colorValue);
        return new Color(rgb[0], rgb[1], rgb[2], opacity);
    }

    public static Color convertICCNamedColor(Element e2, ICCNamedColor c2, float opacity, BridgeContext ctx) {
        String iccProfileName = c2.getColorProfile();
        if (iccProfileName == null) {
            return null;
        }
        SVGColorProfileElementBridge profileBridge = (SVGColorProfileElementBridge)ctx.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (profileBridge == null) {
            return null;
        }
        ICCColorSpaceWithIntent profileCS = profileBridge.createICCColorSpaceWithIntent(ctx, e2, iccProfileName);
        if (profileCS == null) {
            return null;
        }
        ICC_Profile iccProfile = profileCS.getProfile();
        String iccProfileSrc = null;
        if (NamedColorProfileParser.isNamedColorProfile(iccProfile)) {
            NamedColorProfile ncp;
            NamedColorProfileParser parser = new NamedColorProfileParser();
            try {
                ncp = parser.parseProfile(iccProfile, iccProfileName, iccProfileSrc);
            }
            catch (IOException ioe) {
                return null;
            }
            NamedColorSpace ncs = ncp.getNamedColor(c2.getColorName());
            if (ncs != null) {
                ColorWithAlternatives specColor = new ColorWithAlternatives(ncs, new float[]{1.0f}, opacity, null);
                return specColor;
            }
        }
        return null;
    }

    public static Color convertCIELabColor(Element e2, CIELabColor c2, float opacity, BridgeContext ctx) {
        CIELabColorSpace cs = new CIELabColorSpace(c2.getWhitePoint());
        float[] lab = c2.getColorValues();
        Color specColor = cs.toColor(lab[0], lab[1], lab[2], opacity);
        return specColor;
    }

    public static Color convertDeviceColor(Element e2, Value srgb, DeviceColor c2, float opacity, BridgeContext ctx) {
        int r2 = PaintServer.resolveColorComponent(srgb.getRed());
        int g2 = PaintServer.resolveColorComponent(srgb.getGreen());
        int b2 = PaintServer.resolveColorComponent(srgb.getBlue());
        if (c2.isNChannel()) {
            return PaintServer.convertColor(srgb, opacity);
        }
        if (c2.getNumberOfColors() == 4) {
            DeviceCMYKColorSpace cmykCs = ColorSpaces.getDeviceCMYKColorSpace();
            float[] comps = new float[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                comps[i2] = c2.getColor(i2);
            }
            ColorWithAlternatives cmyk = new ColorWithAlternatives(cmykCs, comps, opacity, null);
            ColorWithAlternatives specColor = new ColorWithAlternatives(r2, g2, b2, Math.round(opacity * 255.0f), new Color[]{cmyk});
            return specColor;
        }
        return PaintServer.convertColor(srgb, opacity);
    }

    public static Color convertColor(Value c2, float opacity) {
        int r2 = PaintServer.resolveColorComponent(c2.getRed());
        int g2 = PaintServer.resolveColorComponent(c2.getGreen());
        int b2 = PaintServer.resolveColorComponent(c2.getBlue());
        return new Color(r2, g2, b2, Math.round(opacity * 255.0f));
    }

    public static Stroke convertStroke(Element e2) {
        Value v2 = CSSUtilities.getComputedStyle(e2, 52);
        float width = v2.getFloatValue();
        if (width == 0.0f) {
            return null;
        }
        v2 = CSSUtilities.getComputedStyle(e2, 48);
        int linecap = PaintServer.convertStrokeLinecap(v2);
        v2 = CSSUtilities.getComputedStyle(e2, 49);
        int linejoin = PaintServer.convertStrokeLinejoin(v2);
        v2 = CSSUtilities.getComputedStyle(e2, 50);
        float miterlimit = PaintServer.convertStrokeMiterlimit(v2);
        v2 = CSSUtilities.getComputedStyle(e2, 46);
        float[] dasharray = PaintServer.convertStrokeDasharray(v2);
        float dashoffset = 0.0f;
        if (dasharray != null && (dashoffset = (v2 = CSSUtilities.getComputedStyle(e2, 47)).getFloatValue()) < 0.0f) {
            float dashpatternlength = 0.0f;
            for (float aDasharray : dasharray) {
                dashpatternlength += aDasharray;
            }
            if (dasharray.length % 2 != 0) {
                dashpatternlength *= 2.0f;
            }
            if (dashpatternlength == 0.0f) {
                dashoffset = 0.0f;
            } else {
                while (dashoffset < 0.0f) {
                    dashoffset += dashpatternlength;
                }
            }
        }
        return new BasicStroke(width, linecap, linejoin, miterlimit, dasharray, dashoffset);
    }

    public static float[] convertStrokeDasharray(Value v2) {
        float[] dasharray = null;
        if (v2.getCssValueType() == 2) {
            int length = v2.getLength();
            dasharray = new float[length];
            float sum = 0.0f;
            for (int i2 = 0; i2 < dasharray.length; ++i2) {
                dasharray[i2] = v2.item(i2).getFloatValue();
                sum += dasharray[i2];
            }
            if (sum == 0.0f) {
                dasharray = null;
            }
        }
        return dasharray;
    }

    public static float convertStrokeMiterlimit(Value v2) {
        float miterlimit = v2.getFloatValue();
        return miterlimit < 1.0f ? 1.0f : miterlimit;
    }

    public static int convertStrokeLinecap(Value v2) {
        String s2 = v2.getStringValue();
        switch (s2.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linecap argument is not an appropriate CSS value");
    }

    public static int convertStrokeLinejoin(Value v2) {
        String s2 = v2.getStringValue();
        switch (s2.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new IllegalArgumentException("Linejoin argument is not an appropriate CSS value");
    }

    public static int resolveColorComponent(Value v2) {
        switch (v2.getPrimitiveType()) {
            case 2: {
                float f2 = v2.getFloatValue();
                f2 = f2 > 100.0f ? 100.0f : (f2 < 0.0f ? 0.0f : f2);
                return Math.round(255.0f * f2 / 100.0f);
            }
            case 1: {
                float f3 = v2.getFloatValue();
                f3 = f3 > 255.0f ? 255.0f : (f3 < 0.0f ? 0.0f : f3);
                return Math.round(f3);
            }
        }
        throw new IllegalArgumentException("Color component argument is not an appropriate CSS value");
    }

    public static float convertOpacity(Value v2) {
        float r2 = v2.getFloatValue();
        return r2 < 0.0f ? 0.0f : (r2 > 1.0f ? 1.0f : r2);
    }
}

