/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.slideshow;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JWindow;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class Main
extends JComponent {
    StaticRenderer renderer;
    UserAgent userAgent;
    DocumentLoader loader;
    BridgeContext ctx;
    BufferedImage image;
    BufferedImage display;
    File[] files;
    static int duration = 3000;
    static int frameDelay = duration + 7000;
    volatile boolean done = false;
    volatile Thread transitionThread = null;
    long startLastTransition = 0L;
    volatile boolean paused = false;

    public Main(File[] files, Dimension size) {
        this.setBackground(Color.black);
        this.files = files;
        UserAgentAdapter ua = new UserAgentAdapter();
        this.renderer = new StaticRenderer();
        this.userAgent = ua;
        this.loader = new DocumentLoader(this.userAgent);
        this.ctx = new BridgeContext(this.userAgent, this.loader);
        ua.setBridgeContext(this.ctx);
        if (size == null) {
            size = Toolkit.getDefaultToolkit().getScreenSize();
        }
        this.setPreferredSize(size);
        this.setDoubleBuffered(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (Main.this.done) {
                    System.exit(0);
                } else {
                    Main.this.togglePause();
                }
            }
        });
        size.width += 2;
        size.height += 2;
        this.display = new BufferedImage(size.width, size.height, 4);
        RenderThread t2 = new RenderThread();
        t2.start();
        JWindow w2 = new JWindow();
        w2.setBackground(Color.black);
        w2.getContentPane().setBackground(Color.black);
        w2.getContentPane().add(this);
        w2.pack();
        w2.setLocation(new Point(-1, -1));
        w2.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransition(BufferedImage newImg) {
        Main main = this;
        synchronized (main) {
            while (this.transitionThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.transitionThread = new TransitionThread(newImg);
            this.transitionThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void togglePause() {
        Main main = this;
        synchronized (main) {
            Cursor c2;
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                c2 = new Cursor(3);
            } else {
                c2 = new Cursor(0);
                if (this.transitionThread != null) {
                    Thread thread = this.transitionThread;
                    synchronized (thread) {
                        this.transitionThread.notifyAll();
                    }
                }
            }
            this.setCursor(c2);
        }
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        if (this.display == null) {
            return;
        }
        g2d.drawImage(this.display, null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFileList(String file, List fileVec) {
        BufferedReader br;
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Unable to open file-list: " + file);
            return;
        }
        try {
            String line;
            URL flURL = new File(file).toURI().toURL();
            while ((line = br.readLine()) != null) {
                String str = line;
                int idx = str.indexOf(35);
                if (idx != -1) {
                    str = str.substring(0, idx);
                }
                if ((str = str.trim()).length() == 0) continue;
                try {
                    URL imgURL = new URL(flURL, str);
                    fileVec.add(imgURL.getFile());
                }
                catch (MalformedURLException mue) {
                    System.err.println("Can't make sense of line:\n  " + line);
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Error while reading file-list: " + file);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] args) {
        ArrayList<String> fileVec = new ArrayList<String>();
        Dimension d2 = null;
        if (args.length == 0) {
            Main.showUsage();
            return;
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-h") || args[i2].equals("-help") || args[i2].equals("--help")) {
                Main.showUsage();
                return;
            }
            if (args[i2].equals("--")) {
                ++i2;
                while (i2 < args.length) {
                    fileVec.add(args[i2++]);
                }
                break;
            }
            if (args[i2].equals("-fl") || args[i2].equals("--file-list")) {
                if (i2 + 1 == args.length) {
                    System.err.println("Must provide name of file list file after " + args[i2]);
                    break;
                }
                Main.readFileList(args[i2 + 1], fileVec);
                ++i2;
                continue;
            }
            if (args[i2].equals("-ft") || args[i2].equals("--frame-time")) {
                if (i2 + 1 == args.length) {
                    System.err.println("Must provide time in millis after " + args[i2]);
                    break;
                }
                try {
                    frameDelay = Integer.decode(args[i2 + 1]);
                    ++i2;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Can't parse frame time: " + args[i2 + 1]);
                }
                continue;
            }
            if (args[i2].equals("-tt") || args[i2].equals("--transition-time")) {
                if (i2 + 1 == args.length) {
                    System.err.println("Must provide time in millis after " + args[i2]);
                    break;
                }
                try {
                    duration = Integer.decode(args[i2 + 1]);
                    ++i2;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Can't parse transition time: " + args[i2 + 1]);
                }
                continue;
            }
            if (args[i2].equals("-ws") || args[i2].equals("--window-size")) {
                if (i2 + 1 == args.length) {
                    System.err.println("Must provide window size [w,h] after " + args[i2]);
                    break;
                }
                try {
                    int w2;
                    int h2;
                    int idx = args[i2 + 1].indexOf(44);
                    if (idx == -1) {
                        w2 = h2 = Integer.decode(args[i2 + 1]).intValue();
                    } else {
                        String wStr = args[i2 + 1].substring(0, idx);
                        String hStr = args[i2 + 1].substring(idx + 1);
                        w2 = Integer.decode(wStr);
                        h2 = Integer.decode(hStr);
                    }
                    d2 = new Dimension(w2, h2);
                    ++i2;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Can't parse window size: " + args[i2 + 1]);
                }
                continue;
            }
            fileVec.add(args[i2]);
        }
        File[] files = new File[fileVec.size()];
        for (int i3 = 0; i3 < fileVec.size(); ++i3) {
            try {
                files[i3] = new File((String)fileVec.get(i3));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        new Main(files, d2);
    }

    public static void showUsage() {
        System.out.println("Options:\n                                 -- : Remaining args are file names\n                         -fl <file>\n                 --file-list <file> : file contains list of images to\n                                      show one per line\n             -ws <width>[,<height>]\n    -window-size <width>[,<height>] : Set the size of slideshow window\n                                      defaults to full screen\n                          -ft <int>\n                 --frame-time <int> : Amount of time in millisecs to\n                                      show each frame.\n                                      Includes transition time.\n                          -tt <int>\n            --transition-time <int> : Amount of time in millisecs to\n                                      transition between frames.\n                             <file> : SVG file to display");
    }

    class TransitionThread
    extends Thread {
        BufferedImage src;
        int blockw;
        int blockh;

        public TransitionThread(BufferedImage bi) {
            super("TransitionThread");
            this.blockw = 75;
            this.blockh = 75;
            this.setDaemon(true);
            this.src = bi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int xblocks = (Main.this.display.getWidth() + this.blockw - 1) / this.blockw;
            int yblocks = (Main.this.display.getHeight() + this.blockh - 1) / this.blockh;
            int nblocks = xblocks * yblocks;
            int tblock = duration / nblocks;
            Point[] rects = new Point[nblocks];
            for (int y2 = 0; y2 < yblocks; ++y2) {
                for (int x2 = 0; x2 < xblocks; ++x2) {
                    rects[y2 * xblocks + x2] = new Point(x2, y2);
                }
            }
            Graphics2D g2d = Main.this.display.createGraphics();
            g2d.setColor(Color.black);
            long currTrans = System.currentTimeMillis();
            while (currTrans - Main.this.startLastTransition < (long)frameDelay) {
                try {
                    long stime = (long)frameDelay - (currTrans - Main.this.startLastTransition);
                    if (stime > 500L) {
                        System.gc();
                        currTrans = System.currentTimeMillis();
                        stime = (long)frameDelay - (currTrans - Main.this.startLastTransition);
                    }
                    if (stime > 0L) {
                        TransitionThread.sleep(stime);
                    }
                }
                catch (InterruptedException stime) {
                    // empty catch block
                }
                currTrans = System.currentTimeMillis();
            }
            TransitionThread stime = this;
            synchronized (stime) {
                while (Main.this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            long last = Main.this.startLastTransition = System.currentTimeMillis();
            for (int i2 = 0; i2 < rects.length; ++i2) {
                int idx = (int)(Math.random() * (double)(rects.length - i2));
                Point pt = rects[idx];
                System.arraycopy(rects, idx + 1, rects, idx + 1 - 1, rects.length - i2 - idx - 1);
                int x3 = pt.x * this.blockw;
                int y3 = pt.y * this.blockh;
                int w2 = this.blockw;
                int h2 = this.blockh;
                if (x3 + w2 > this.src.getWidth()) {
                    w2 = this.src.getWidth() - x3;
                }
                if (y3 + h2 > this.src.getHeight()) {
                    h2 = this.src.getHeight() - y3;
                }
                BufferedImage bufferedImage = Main.this.display;
                synchronized (bufferedImage) {
                    g2d.fillRect(x3, y3, w2, h2);
                    BufferedImage sub = this.src.getSubimage(x3, y3, w2, h2);
                    g2d.drawImage(sub, null, x3, y3);
                }
                Main.this.repaint(x3, y3, w2, h2);
                long current = System.currentTimeMillis();
                try {
                    long dt = current - last;
                    if (dt < (long)tblock) {
                        TransitionThread.sleep((long)tblock - dt);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                last = current;
            }
            Main main = Main.this;
            synchronized (main) {
                Main.this.transitionThread = null;
                Main.this.notifyAll();
            }
        }
    }

    class RenderThread
    extends Thread {
        RenderThread() {
            super("RenderThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Main.this.renderer.setDoubleBuffered(true);
            for (File file : Main.this.files) {
                GraphicsNode gvtRoot = null;
                GVTBuilder builder = new GVTBuilder();
                try {
                    String fileName = file.toURI().toURL().toString();
                    System.out.println("Reading: " + fileName);
                    Document svgDoc = Main.this.loader.loadDocument(fileName);
                    System.out.println("Building: " + fileName);
                    gvtRoot = builder.build(Main.this.ctx, svgDoc);
                    System.out.println("Rendering: " + fileName);
                    Main.this.renderer.setTree(gvtRoot);
                    SVGSVGElement elt = ((SVGDocument)svgDoc).getRootElement();
                    Main.this.renderer.setTransform(ViewBox.getViewTransform(null, elt, Main.this.display.getWidth(), Main.this.display.getHeight(), Main.this.ctx));
                    Main.this.renderer.updateOffScreen(Main.this.display.getWidth(), Main.this.display.getHeight());
                    Rectangle r2 = new Rectangle(0, 0, Main.this.display.getWidth(), Main.this.display.getHeight());
                    Main.this.renderer.repaint(r2);
                    System.out.println("Painting: " + fileName);
                    Main.this.image = Main.this.renderer.getOffScreen();
                    Main.this.setTransition(Main.this.image);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (Main.this.transitionThread != null) {
                try {
                    Main.this.transitionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Main.this.done = true;
                Main.this.setCursor(new Cursor(3));
            }
        }
    }
}

