/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.dom.AnimationTarget;
import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatableValue;

public class AnimatableAngleValue
extends AnimatableNumberValue {
    protected static final String[] UNITS = new String[]{"", "", "deg", "rad", "grad"};
    protected short unit;

    public AnimatableAngleValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableAngleValue(AnimationTarget target, float v2, short unit) {
        super(target, v2);
        this.unit = unit;
    }

    @Override
    public AnimatableValue interpolate(AnimatableValue result, AnimatableValue to, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableAngleValue res = result == null ? new AnimatableAngleValue(this.target) : (AnimatableAngleValue)result;
        float v2 = this.value;
        short u2 = this.unit;
        if (to != null) {
            AnimatableAngleValue toAngle = (AnimatableAngleValue)to;
            if (toAngle.unit != u2) {
                v2 = AnimatableAngleValue.rad(v2, u2);
                v2 += interpolation * (AnimatableAngleValue.rad(toAngle.value, toAngle.unit) - v2);
                u2 = 3;
            } else {
                v2 += interpolation * (toAngle.value - v2);
            }
        }
        if (accumulation != null) {
            AnimatableAngleValue accAngle = (AnimatableAngleValue)accumulation;
            if (accAngle.unit != u2) {
                v2 += (float)multiplier * AnimatableAngleValue.rad(accAngle.value, accAngle.unit);
                u2 = 3;
            } else {
                v2 += (float)multiplier * accAngle.value;
            }
        }
        if (res.value != v2 || res.unit != u2) {
            res.value = v2;
            res.unit = u2;
            res.hasChanged = true;
        }
        return res;
    }

    public short getUnit() {
        return this.unit;
    }

    @Override
    public float distanceTo(AnimatableValue other) {
        AnimatableAngleValue o2 = (AnimatableAngleValue)other;
        return Math.abs(AnimatableAngleValue.rad(this.value, this.unit) - AnimatableAngleValue.rad(o2.value, o2.unit));
    }

    @Override
    public AnimatableValue getZeroValue() {
        return new AnimatableAngleValue(this.target, 0.0f, 1);
    }

    @Override
    public String getCssText() {
        return super.getCssText() + UNITS[this.unit];
    }

    public static float rad(float v2, short unit) {
        switch (unit) {
            case 3: {
                return v2;
            }
            case 4: {
                return (float)Math.PI * v2 / 200.0f;
            }
        }
        return (float)Math.PI * v2 / 180.0f;
    }
}

