/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import org.antlr.tool.ErrorManager;

public class Attribute {
    public String decl;
    public String type;
    public String name;
    public String initValue;

    public Attribute(String decl) {
        this.extractAttribute(decl);
    }

    public Attribute(String name, String decl) {
        this.name = name;
        this.decl = decl;
    }

    protected void extractAttribute(String decl) {
        if (decl == null) {
            return;
        }
        boolean inID = false;
        int start = -1;
        int rightEdgeOfDeclarator = decl.length() - 1;
        int equalsIndex = decl.indexOf(61);
        if (equalsIndex > 0) {
            this.initValue = decl.substring(equalsIndex + 1, decl.length());
            rightEdgeOfDeclarator = equalsIndex - 1;
        }
        for (int i2 = rightEdgeOfDeclarator; i2 >= 0; --i2) {
            if (!inID && Character.isLetterOrDigit(decl.charAt(i2))) {
                inID = true;
                continue;
            }
            if (!inID || Character.isLetterOrDigit(decl.charAt(i2)) || decl.charAt(i2) == '_') continue;
            start = i2 + 1;
            break;
        }
        if (start < 0 && inID) {
            start = 0;
        }
        if (start < 0) {
            ErrorManager.error(104, decl);
        }
        int stop = -1;
        for (int i3 = start; i3 <= rightEdgeOfDeclarator; ++i3) {
            if (!Character.isLetterOrDigit(decl.charAt(i3)) && decl.charAt(i3) != '_') {
                stop = i3;
                break;
            }
            if (i3 != rightEdgeOfDeclarator) continue;
            stop = i3 + 1;
        }
        this.name = decl.substring(start, stop);
        this.type = decl.substring(0, start);
        if (stop <= rightEdgeOfDeclarator) {
            this.type = this.type + decl.substring(stop, rightEdgeOfDeclarator + 1);
        }
        this.type = this.type.trim();
        if (this.type.length() == 0) {
            this.type = null;
        }
        this.decl = decl;
    }

    public String toString() {
        if (this.initValue != null) {
            return this.type + " " + this.name + "=" + this.initValue;
        }
        return this.type + " " + this.name;
    }
}

