/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.tool.Grammar;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MachineProbe {
    DFA dfa;

    public MachineProbe(DFA dfa) {
        this.dfa = dfa;
    }

    List<DFAState> getAnyDFAPathToTarget(DFAState targetState) {
        HashSet<DFAState> visited = new HashSet<DFAState>();
        return this.getAnyDFAPathToTarget(this.dfa.startState, targetState, visited);
    }

    public List<DFAState> getAnyDFAPathToTarget(DFAState startState, DFAState targetState, Set<DFAState> visited) {
        ArrayList<DFAState> dfaStates = new ArrayList<DFAState>();
        visited.add(startState);
        if (startState.equals(targetState)) {
            dfaStates.add(targetState);
            return dfaStates;
        }
        for (int i2 = 0; i2 < startState.getNumberOfTransitions(); ++i2) {
            List<DFAState> path;
            Transition e2 = startState.getTransition(i2);
            if (visited.contains(e2.target) || (path = this.getAnyDFAPathToTarget((DFAState)e2.target, targetState, visited)) == null) continue;
            dfaStates.add(startState);
            dfaStates.addAll(path);
            return dfaStates;
        }
        return null;
    }

    public List<IntSet> getEdgeLabels(DFAState targetState) {
        List<DFAState> dfaStates = this.getAnyDFAPathToTarget(targetState);
        ArrayList<IntSet> labels = new ArrayList<IntSet>();
        for (int i2 = 0; i2 < dfaStates.size() - 1; ++i2) {
            DFAState d2 = dfaStates.get(i2);
            DFAState nextState = dfaStates.get(i2 + 1);
            for (int j2 = 0; j2 < d2.getNumberOfTransitions(); ++j2) {
                Transition e2 = d2.getTransition(j2);
                if (e2.target.stateNumber != nextState.stateNumber) continue;
                labels.add(e2.label.getSet());
            }
        }
        return labels;
    }

    public String getInputSequenceDisplay(Grammar g2, List<IntSet> labels) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (IntSet label : labels) {
            tokens.add(label.toString(g2));
        }
        return ((Object)tokens).toString();
    }

    public List<Token> getGrammarLocationsForInputSequence(List<Set<NFAState>> nfaStates, List<IntSet> labels) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        block0: for (int i2 = 0; i2 < nfaStates.size() - 1; ++i2) {
            Set<NFAState> cur = nfaStates.get(i2);
            Set<NFAState> next = nfaStates.get(i2 + 1);
            IntSet label = labels.get(i2);
            for (NFAState p2 : cur) {
                for (int j2 = 0; j2 < p2.getNumberOfTransitions(); ++j2) {
                    Transition t2 = p2.transition(j2);
                    if (t2.isEpsilon() || t2.label.getSet().and(label).isNil() || !next.contains(t2.target) || p2.associatedASTNode == null) continue;
                    Token oldtoken = p2.associatedASTNode.token;
                    CommonToken token = new CommonToken(oldtoken.getType(), oldtoken.getText());
                    token.setLine(oldtoken.getLine());
                    token.setCharPositionInLine(oldtoken.getCharPositionInLine());
                    tokens.add(token);
                    continue block0;
                }
            }
        }
        return tokens;
    }
}

