/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import javax.help.HelpUtilities;
import javax.help.Map;
import javax.help.SearchTOCItem;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class BasicSearchCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected boolean selected;
    private boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    protected Map map;
    protected ValueJLabel hits;
    protected ValueJLabel quality;
    protected JLabel title;
    private static Icon high = UIManager.getIcon("SearchHigh.icon");
    private static Icon medhigh = UIManager.getIcon("SearchMedHigh.icon");
    private static Icon med = UIManager.getIcon("SearchMed.icon");
    private static Icon medlow = UIManager.getIcon("SearchMedLow.icon");
    private static Icon low = UIManager.getIcon("SearchLow.icon");
    private static boolean debug = false;

    public BasicSearchCellRenderer(Map map) {
        this.map = map;
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
        this.setLayout(new BoxLayout(this, 0));
        this.hits = new ValueJLabel();
        this.hits.setHorizontalAlignment(2);
        this.quality = new ValueJLabel();
        this.title = new JLabel();
        this.title.setFont(this.getFont());
        this.title.setHorizontalAlignment(2);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.quality);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.hits);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.title);
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        if (font != null && this.title != null) {
            this.title.setFont(font);
        }
        super.setFont(font);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
        Serializable serializable;
        SearchTOCItem searchTOCItem = (SearchTOCItem)((DefaultMutableTreeNode)object).getUserObject();
        String string = "";
        if (searchTOCItem != null) {
            string = searchTOCItem.getName();
        }
        if (bl) {
            this.hits.setForeground(this.getTextNonSelectionColor());
            this.title.setForeground(this.getTextSelectionColor());
            this.title.setBackground(this.getBackgroundSelectionColor());
        } else {
            serializable = this.getBackgroundNonSelectionColor();
            if (serializable == null) {
                serializable = this.getBackground();
            }
            this.hits.setForeground(this.getTextNonSelectionColor());
            this.title.setForeground(this.getTextNonSelectionColor());
            this.title.setBackground((Color)serializable);
        }
        serializable = Locale.getDefault();
        if (searchTOCItem != null && (serializable = searchTOCItem.getLocale()) != null) {
            this.setLocale((Locale)serializable);
        }
        if (searchTOCItem != null) {
            int n3 = searchTOCItem.hitCount();
            this.hits.setText(String.valueOf(n3));
            this.hits.setAccessibility(null, HelpUtilities.getString((Locale)serializable, "search.hitDesc"), new Integer(n3), new Integer(n3), new Integer(n3));
            String string2 = null;
            double d2 = searchTOCItem.getConfidence();
            if (d2 < 1.0) {
                this.quality.setIcon(high);
                string2 = HelpUtilities.getString((Locale)serializable, "search.high");
            } else if (d2 < 5.0) {
                this.quality.setIcon(medhigh);
                string2 = HelpUtilities.getString((Locale)serializable, "search.midhigh");
            } else if (d2 < 12.5) {
                this.quality.setIcon(med);
                string2 = HelpUtilities.getString((Locale)serializable, "search.mid");
            } else if (d2 < 25.0) {
                this.quality.setIcon(medlow);
                string2 = HelpUtilities.getString((Locale)serializable, "search.midlow");
            } else {
                this.quality.setIcon(low);
                string2 = HelpUtilities.getString((Locale)serializable, "search.low");
            }
            this.quality.setAccessibility(string2, HelpUtilities.getString((Locale)serializable, "search.qualityDesc"), new Double(d2), new Double(d2), new Double(d2));
            this.title.setText(string);
        }
        this.selected = bl;
        this.hasFocus = bl4;
        return this;
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n2 = -1;
        if (color != null) {
            n2 = this.getLabelStart();
            graphics.setColor(color);
            Dimension dimension = this.getSize();
            graphics.fillRect(n2, 0, dimension.width - 1 - n2, dimension.height);
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n2 = 0;
            } else if (n2 == -1) {
                n2 = this.getLabelStart();
            }
            graphics.setColor(this.getBorderSelectionColor());
            graphics.drawRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight() - 1);
        }
        super.paintChildren(graphics);
    }

    private int getLabelStart() {
        return this.title.getX() - 1;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n2 = 0;
        int n3 = 0;
        if (dimension != null) {
            n3 = dimension.height;
        }
        Insets insets = this.getInsets();
        n2 += insets.left + insets.right;
        n2 += 4;
        Dimension dimension2 = this.quality.getPreferredSize();
        n2 += dimension2.width;
        n3 = Math.max(n3, dimension2.height + insets.top + insets.bottom);
        n2 += 4;
        dimension2 = this.hits.getPreferredSize();
        n2 += dimension2.width;
        n3 = Math.max(n3, dimension2.height + insets.top + insets.bottom);
        n2 += 4;
        dimension2 = this.title.getPreferredSize();
        n2 += dimension2.width;
        n3 = Math.max(n3, dimension2.height + insets.top + insets.bottom);
        n2 += 3;
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        dimension.setSize(n2, n3);
        return dimension;
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("BasicSearchCellRenderer: " + string);
        }
    }

    private class ValueJLabel
    extends JLabel {
        String accessName;
        String accessDesc;
        Number accessValue;
        Number minValue;
        Number maxValue;

        private ValueJLabel() {
        }

        public void setAccessibility(String string, String string2, Number number, Number number2, Number number3) {
            this.accessName = string;
            this.accessDesc = string2;
            this.accessValue = number;
            this.minValue = number2;
            this.maxValue = number3;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleValueJLabel();
            }
            this.accessibleContext.setAccessibleDescription(this.accessDesc);
            this.accessibleContext.setAccessibleName(this.accessName);
            return this.accessibleContext;
        }

        protected class AccessibleValueJLabel
        extends JLabel.AccessibleJLabel
        implements AccessibleValue {
            protected AccessibleValueJLabel() {
                super(ValueJLabel.this);
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                return ValueJLabel.this.accessValue;
            }

            public boolean setCurrentAccessibleValue(Number number) {
                return false;
            }

            public Number getMinimumAccessibleValue() {
                return ValueJLabel.this.minValue;
            }

            public Number getMaximumAccessibleValue() {
                return ValueJLabel.this.maxValue;
            }
        }
    }
}

