/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.TabColorProvider;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicJideTabbedPaneUI
extends JideTabbedPaneUI
implements SwingConstants,
DocumentListener {
    protected int _tabRectPadding;
    protected int _closeButtonMarginHorizon;
    protected int _closeButtonMarginVertical;
    protected int _textMarginVertical;
    protected int _noIconMargin;
    protected int _iconMargin;
    protected int _textPadding;
    protected int _buttonSize;
    protected int _buttonMargin;
    protected int _fitStyleBoundSize;
    protected int _fitStyleFirstTabMargin;
    protected int _fitStyleIconMinWidth;
    protected int _fitStyleTextMinWidth;
    protected int _compressedStyleNoIconRectSize;
    protected int _compressedStyleIconMargin;
    protected int _compressedStyleCloseButtonMarginHorizon;
    protected int _compressedStyleCloseButtonMarginVertical;
    protected int _fixedStyleRectSize;
    protected int _closeButtonMargin;
    protected int _gripLeftMargin;
    protected int _closeButtonMarginSize;
    protected int _closeButtonLeftMargin;
    protected int _closeButtonRightMargin;
    protected Component _tabLeadingComponent = null;
    protected Component _tabTrailingComponent = null;
    protected JideTabbedPane _tabPane;
    protected Font _selectedTabFont;
    protected Color _tabBackground;
    protected Color _background;
    protected Color _highlight;
    protected Color _lightHighlight;
    protected Color _shadow;
    protected Color _darkShadow;
    protected Color _focus;
    protected Color _inactiveTabForeground;
    protected Color _inactiveSelectedTabForeground;
    protected Color _activeTabForeground;
    protected Color _tabListBackground;
    protected Color _selectedColor;
    protected Color _activeBackground;
    protected int _textIconGap;
    protected int _tabRunOverlay;
    protected boolean _showIconOnTab;
    protected boolean _showCloseButtonOnTab;
    protected int _closeButtonAlignment = 11;
    protected Insets _tabInsets;
    protected Insets _selectedTabPadInsets;
    protected Insets _tabAreaInsets;
    protected boolean _ignoreContentBorderInsetsIfNoTabs;
    protected int[] _tabRuns = new int[10];
    protected int _runCount = 0;
    protected int _selectedRun = -1;
    protected Rectangle[] _rects = new Rectangle[0];
    protected int _additionalWidth = 0;
    protected int _maxTabHeight;
    protected int _maxTabWidth;
    protected int _gripperWidth = 6;
    protected int _gripperHeight = 6;
    protected ChangeListener _tabChangeListener;
    protected FocusListener _tabFocusListener;
    protected PropertyChangeListener _propertyChangeListener;
    protected ChangeListener _tabModelChangeListener;
    protected MouseListener _mouseListener;
    protected MouseMotionListener _mousemotionListener;
    protected MouseWheelListener _mouseWheelListener;
    private ContainerListener _containerListener;
    private ComponentListener _componentListener;
    private Insets _currentTabInsets = new Insets(0, 0, 0, 0);
    private Insets _currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets _currentTabAreaInsets = new Insets(2, 4, 0, 4);
    private Insets _currentContentBorderInsets = new Insets(3, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable _mnemonicToIndexMap;
    private InputMap _mnemonicInputMap;
    public ScrollableTabSupport _tabScroller;
    protected transient Rectangle _calcRect = new Rectangle(0, 0, 0, 0);
    protected int _tabCount;
    protected JButton[] _closeButtons;
    private ThemePainter _painter;
    private Painter _gripperPainter;
    private DropTargetListener _dropListener;
    private boolean _layouted;
    public DropTarget _dt;
    public static final int DEFAULT_LEFT_MARGIN = 0;
    public static final int OFFICE2003_LEFT_MARGIN = 18;
    public static final int EXCEL_LEFT_MARGIN = 6;
    protected int _rectSizeExtend = 0;
    protected Polygon tabRegion = null;
    protected Color _selectColor1 = null;
    protected Color _selectColor2 = null;
    protected Color _selectColor3 = null;
    protected Color _unselectColor1 = null;
    protected Color _unselectColor2 = null;
    protected Color _unselectColor3 = null;
    protected Color _officeTabBorderColor;
    protected Color _defaultTabBorderShadowColor;
    protected boolean _mouseEnter = false;
    protected int _indexMouseOver;
    protected boolean _alwaysShowLineBorder = false;
    protected boolean _showFocusIndicator = false;
    private TabContainer _tabContainer;
    public static final String BUTTON_NAME_CLOSE = "JideTabbedPane.close";
    public static final String BUTTON_NAME_TAB_LIST = "JideTabbedPane.showList";
    public static final String BUTTON_NAME_SCROLL_BACKWARD = "JideTabbedPane.scrollBackward";
    public static final String BUTTON_NAME_SCROLL_FORWARD = "JideTabbedPane.scrollForward";
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;
    protected TabSpaceAllocator tryTabSpacer = new TabSpaceAllocator();
    protected Color _closeButtonSelectedColor = new Color(255, 162, 165);
    protected Color _closeButtonColor = Color.BLACK;
    protected Color _popupColor = Color.BLACK;
    protected TabEditor _tabEditor;
    protected boolean _isEditing;
    protected int _editingTab = -1;
    protected String _oldValue;
    protected String _oldPrefix;
    protected String _oldPostfix;
    protected Component _originalFocusComponent;
    protected final boolean PAINT_TAB = true;
    protected final boolean PAINT_TAB_BORDER = true;
    protected final boolean PAINT_TAB_BACKGROUND = true;
    protected final boolean PAINT_TABAREA = true;
    protected final boolean PAINT_CONTENT_BORDER = true;
    protected final boolean PAINT_CONTENT_BORDER_EDGE = true;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJideTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        this._tabPane = (JideTabbedPane)jComponent;
        if (this._tabPane.isTabShown() && this._tabPane.getTabLeadingComponent() != null) {
            this._tabLeadingComponent = this._tabPane.getTabLeadingComponent();
        }
        if (this._tabPane.isTabShown() && this._tabPane.getTabTrailingComponent() != null) {
            this._tabTrailingComponent = this._tabPane.getTabTrailingComponent();
        }
        this.setMouseOverTabIndex(-1);
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installColorTheme();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installColorTheme() {
        switch (this.getTabShape()) {
            case 8: {
                this._selectColor1 = this._darkShadow;
                this._selectColor2 = this._lightHighlight;
                this._selectColor3 = this._shadow;
                this._unselectColor1 = this._darkShadow;
                this._unselectColor2 = this._lightHighlight;
                this._unselectColor3 = this._shadow;
                break;
            }
            case 1: 
            case 11: {
                this._selectColor1 = this._lightHighlight;
                this._selectColor2 = this._shadow;
                this._selectColor3 = this._defaultTabBorderShadowColor;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                this._unselectColor3 = this._selectColor3;
                break;
            }
            case 2: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 9: {
                this._selectColor2 = this._selectColor1 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                break;
            }
            case 5: {
                this._unselectColor1 = this._selectColor1 = this._shadow;
                break;
            }
            case 10: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._shadow;
                this._unselectColor1 = this._selectColor1;
                this._unselectColor2 = this._selectColor2;
                break;
            }
            case 3: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this.getPainter().getControlShadow();
                this._unselectColor2 = this._lightHighlight;
                break;
            }
            default: {
                this._selectColor1 = this._shadow;
                this._selectColor2 = this._lightHighlight;
                this._unselectColor1 = this._shadow;
                this._unselectColor2 = null;
                this._unselectColor3 = null;
            }
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallColorTheme();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this._tabTrailingComponent = null;
        this._tabLeadingComponent = null;
        this._tabPane = null;
    }

    public void uninstallColorTheme() {
        this._selectColor1 = null;
        this._selectColor2 = null;
        this._selectColor3 = null;
        this._unselectColor1 = null;
        this._unselectColor2 = null;
        this._unselectColor3 = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this._tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    protected boolean scrollableTabLayoutEnabled() {
        return this._tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this._tabScroller == null) {
            this._tabScroller = new ScrollableTabSupport(this._tabPane.getTabPlacement());
            this._tabPane.add(this._tabScroller.viewport);
            this._tabPane.add(this._tabScroller.scrollForwardButton);
            this._tabPane.add(this._tabScroller.scrollBackwardButton);
            this._tabPane.add(this._tabScroller.listButton);
            this._tabPane.add(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.add(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.add(this._tabTrailingComponent);
            }
        }
        this.installTabContainer();
    }

    private void installTabContainer() {
        for (int i2 = 0; i2 < this._tabPane.getTabCount(); ++i2) {
            Component component;
            Component component2 = component = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(i2) : null;
            if (component == null) continue;
            if (this._tabContainer == null) {
                this._tabContainer = new TabContainer();
            }
            this._tabContainer.add(component);
        }
        if (this._tabContainer == null) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this._tabScroller.tabPanel.add(this._tabContainer);
        } else {
            this._tabPane.add(this._tabContainer);
        }
    }

    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this._tabPane.remove(this._tabScroller.viewport);
            this._tabPane.remove(this._tabScroller.scrollForwardButton);
            this._tabPane.remove(this._tabScroller.scrollBackwardButton);
            this._tabPane.remove(this._tabScroller.listButton);
            this._tabPane.remove(this._tabScroller.closeButton);
            if (this._tabLeadingComponent != null) {
                this._tabPane.remove(this._tabLeadingComponent);
            }
            if (this._tabTrailingComponent != null) {
                this._tabPane.remove(this._tabTrailingComponent);
            }
            this._tabScroller = null;
        }
    }

    private void uninstallTabContainer() {
        if (this._tabContainer == null) {
            return;
        }
        this._tabContainer.notifyTabbedPane = false;
        this._tabContainer.removeAll();
        if (this.scrollableTabLayoutEnabled()) {
            this._tabScroller.tabPanel.remove(this._tabContainer);
        } else {
            this._tabPane.remove(this._tabContainer);
        }
        this._tabContainer = null;
    }

    protected void installDefaults() {
        Insets insets;
        Insets insets2;
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideTabbedPane.gripperPainter");
        LookAndFeel.installColorsAndFont(this._tabPane, "JideTabbedPane.background", "JideTabbedPane.foreground", "JideTabbedPane.font");
        LookAndFeel.installBorder(this._tabPane, "JideTabbedPane.border");
        this._selectedTabFont = UIDefaultsLookup.getFont("JideTabbedPane.selectedTabFont");
        this._highlight = UIDefaultsLookup.getColor("JideTabbedPane.light");
        this._lightHighlight = UIDefaultsLookup.getColor("JideTabbedPane.highlight");
        this._shadow = UIDefaultsLookup.getColor("JideTabbedPane.shadow");
        this._darkShadow = UIDefaultsLookup.getColor("JideTabbedPane.darkShadow");
        this._focus = UIDefaultsLookup.getColor("TabbedPane.focus");
        if (this.getTabShape() == 3) {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._inactiveSelectedTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.foreground");
            this._selectedColor = this._lightHighlight;
            this._activeBackground = this._lightHighlight;
        } else {
            this._background = UIDefaultsLookup.getColor("JideTabbedPane.background");
            this._tabBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground");
            this._inactiveTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.unselectedTabTextForeground");
            this._inactiveSelectedTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabTextForeground");
            this._activeTabForeground = UIDefaultsLookup.getColor("JideTabbedPane.activeTabTextForeground");
            if (this._activeTabForeground == null) {
                this._activeTabForeground = this._inactiveSelectedTabForeground;
            }
            this._selectedColor = UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground");
            this._activeBackground = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
            if (this._activeBackground == null) {
                this._activeBackground = UIDefaultsLookup.getColor("JideTabbedPane.activeTabBackground");
            }
            if (this._activeBackground == null) {
                this._activeBackground = this._selectedColor;
            }
        }
        this._tabListBackground = UIDefaultsLookup.getColor("JideTabbedPane.tabListBackground");
        this._textIconGap = UIDefaultsLookup.getInt("JideTabbedPane.textIconGap");
        Insets insets3 = this._tabPane.getTabInsets();
        if (insets3 == null || insets3 instanceof UIResource) {
            this._tabPane.setTabInsets(UIDefaultsLookup.getInsets("JideTabbedPane.tabInsets"));
        }
        this._selectedTabPadInsets = UIDefaultsLookup.getInsets("TabbedPane.selectedTabPadInsets");
        if (this._selectedTabPadInsets == null) {
            this._selectedTabPadInsets = new InsetsUIResource(0, 0, 0, 0);
        }
        if ((insets2 = this._tabPane.getTabAreaInsets()) == null || insets2 instanceof UIResource) {
            this._tabPane.setTabAreaInsets(UIDefaultsLookup.getInsets("JideTabbedPane.tabAreaInsets"));
        }
        if ((insets = this._tabPane.getContentBorderInsets()) == null || insets instanceof UIResource) {
            this._tabPane.setContentBorderInsets(UIDefaultsLookup.getInsets("JideTabbedPane.contentBorderInsets"));
        }
        this._ignoreContentBorderInsetsIfNoTabs = UIDefaultsLookup.getBoolean("JideTabbedPane.ignoreContentBorderInsetsIfNoTabs");
        this._tabRunOverlay = UIDefaultsLookup.getInt("JideTabbedPane.tabRunOverlay");
        this._showIconOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showIconOnTab");
        this._showCloseButtonOnTab = UIDefaultsLookup.getBoolean("JideTabbedPane.showCloseButtonOnTab");
        this._closeButtonAlignment = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonAlignment");
        this._gripperWidth = UIDefaultsLookup.getInt("Gripper.size");
        this._tabRectPadding = UIDefaultsLookup.getInt("JideTabbedPane.tabRectPadding");
        this._closeButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginHorizonal");
        this._closeButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginVertical");
        this._textMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.textMarginVertical");
        this._noIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.noIconMargin");
        this._iconMargin = UIDefaultsLookup.getInt("JideTabbedPane.iconMargin");
        this._textPadding = UIDefaultsLookup.getInt("JideTabbedPane.textPadding");
        this._buttonSize = UIDefaultsLookup.getInt("JideTabbedPane.buttonSize");
        this._buttonMargin = UIDefaultsLookup.getInt("JideTabbedPane.buttonMargin");
        this._fitStyleBoundSize = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleBoundSize");
        this._fitStyleFirstTabMargin = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleFirstTabMargin");
        this._fitStyleIconMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleIconMinWidth");
        this._fitStyleTextMinWidth = UIDefaultsLookup.getInt("JideTabbedPane.fitStyleTextMinWidth");
        this._compressedStyleNoIconRectSize = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleNoIconRectSize");
        this._compressedStyleIconMargin = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleIconMargin");
        this._compressedStyleCloseButtonMarginHorizon = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginHorizontal");
        this._compressedStyleCloseButtonMarginVertical = UIDefaultsLookup.getInt("JideTabbedPane.compressedStyleCloseButtonMarginVertical");
        this._fixedStyleRectSize = UIDefaultsLookup.getInt("JideTabbedPane.fixedStyleRectSize");
        this._closeButtonMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMargin");
        this._gripLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.gripLeftMargin");
        this._closeButtonMarginSize = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonMarginSize");
        this._closeButtonLeftMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonLeftMargin");
        this._closeButtonRightMargin = UIDefaultsLookup.getInt("JideTabbedPane.closeButtonRightMargin");
        this._defaultTabBorderShadowColor = UIDefaultsLookup.getColor("JideTabbedPane.defaultTabBorderShadowColor");
        this._alwaysShowLineBorder = UIDefaultsLookup.getBoolean("JideTabbedPane.alwaysShowLineBorder");
        this._showFocusIndicator = UIDefaultsLookup.getBoolean("JideTabbedPane.showFocusIndicator");
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._gripperPainter = null;
        this._highlight = null;
        this._lightHighlight = null;
        this._shadow = null;
        this._darkShadow = null;
        this._focus = null;
        this._inactiveTabForeground = null;
        this._selectedColor = null;
        this._tabInsets = null;
        this._selectedTabPadInsets = null;
        this._tabAreaInsets = null;
        this._defaultTabBorderShadowColor = null;
    }

    protected void installListeners() {
        if (this._tabModelChangeListener == null) {
            this._tabModelChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n2;
                    if (BasicJideTabbedPaneUI.this._tabPane != null && (n2 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex()) >= 0 && n2 < BasicJideTabbedPaneUI.this._tabPane.getTabCount() && BasicJideTabbedPaneUI.this._tabScroller != null && BasicJideTabbedPaneUI.this._tabScroller.closeButton != null) {
                        BasicJideTabbedPaneUI.this._tabScroller.closeButton.setEnabled(BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(n2));
                    }
                }
            };
            this._tabPane.getModel().addChangeListener(this._tabModelChangeListener);
        }
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createPropertyChangeListener();
            this._tabPane.addPropertyChangeListener(this._propertyChangeListener);
        }
        if (this._tabChangeListener == null) {
            this._tabChangeListener = this.createChangeListener();
            this._tabPane.addChangeListener(this._tabChangeListener);
        }
        if (this._tabFocusListener == null) {
            this._tabFocusListener = this.createFocusListener();
            this._tabPane.addFocusListener(this._tabFocusListener);
        }
        if (this._mouseListener == null) {
            this._mouseListener = this.createMouseListener();
            this._tabPane.addMouseListener(this._mouseListener);
        }
        if (this._mousemotionListener == null) {
            this._mousemotionListener = this.createMouseMotionListener();
            this._tabPane.addMouseMotionListener(this._mousemotionListener);
        }
        if (this._mouseWheelListener == null) {
            this._mouseWheelListener = this.createMouseWheelListener();
            this._tabPane.addMouseWheelListener(this._mouseWheelListener);
        }
        if (this._containerListener == null) {
            this._containerListener = new ContainerHandler();
            this._tabPane.addContainerListener(this._containerListener);
            if (this._tabPane.getTabCount() > 0) {
                this.htmlViews = this.createHTMLVector();
            }
        }
        if (this._componentListener == null) {
            this._componentListener = new ComponentHandler();
            this._tabPane.addComponentListener(this._componentListener);
        }
        if (!this._tabPane.isDragOverDisabled() && this._dropListener == null) {
            this._dropListener = this.createDropListener();
            this._dt = new DropTarget(this.getTabPanel(), this._dropListener);
        }
    }

    protected DropListener createDropListener() {
        return new DropListener();
    }

    protected void uninstallListeners() {
        if (this._tabModelChangeListener != null) {
            this._tabPane.getModel().removeChangeListener(this._tabModelChangeListener);
            this._tabModelChangeListener = null;
        }
        if (this._containerListener != null) {
            this._tabPane.removeContainerListener(this._containerListener);
            this._containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this._componentListener != null) {
            this._tabPane.removeComponentListener(this._componentListener);
            this._componentListener = null;
        }
        if (this._tabChangeListener != null) {
            this._tabPane.removeChangeListener(this._tabChangeListener);
            this._tabChangeListener = null;
        }
        if (this._tabFocusListener != null) {
            this._tabPane.removeFocusListener(this._tabFocusListener);
            this._tabFocusListener = null;
        }
        if (this._mouseListener != null) {
            this._tabPane.removeMouseListener(this._mouseListener);
            this._mouseListener = null;
        }
        if (this._mousemotionListener != null) {
            this._tabPane.removeMouseMotionListener(this._mousemotionListener);
            this._mousemotionListener = null;
        }
        if (this._mouseWheelListener != null) {
            this._tabPane.removeMouseWheelListener(this._mouseWheelListener);
            this._mouseWheelListener = null;
        }
        if (this._propertyChangeListener != null) {
            this._tabPane.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
        if (this._dt != null && this._dropListener != null) {
            this._dt.removeDropTargetListener(this._dropListener);
            this._dropListener = null;
            this._dt = null;
            this.getTabPanel().setDropTarget(null);
        }
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected FocusListener createFocusListener() {
        return new TabFocusListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._tabPane, actionMap);
        this.ensureCloseButtonCreated();
        if (this.scrollableTabLayoutEnabled()) {
            Icon icon = this._tabScroller.scrollForwardButton.getIcon();
            this._tabScroller.scrollForwardButton.setAction(actionMap.get("scrollTabsForwardAction"));
            if (icon != null) {
                this._tabScroller.scrollForwardButton.setIcon(icon);
            }
            Icon icon2 = this._tabScroller.scrollBackwardButton.getIcon();
            this._tabScroller.scrollBackwardButton.setAction(actionMap.get("scrollTabsBackwardAction"));
            if (icon2 != null) {
                this._tabScroller.scrollBackwardButton.setIcon(icon2);
            }
            Icon icon3 = this._tabScroller.listButton.getIcon();
            this._tabScroller.listButton.setAction(actionMap.get("scrollTabsListAction"));
            if (icon3 != null) {
                this._tabScroller.listButton.setIcon(icon3);
            }
            Action action = this._tabPane.getCloseAction();
            this.updateButtonFromAction(this._tabScroller.closeButton, action);
            Icon icon4 = this._tabScroller.closeButton.getIcon();
            this._tabScroller.closeButton.setAction(actionMap.get("closeTabAction"));
            if (icon4 != null) {
                this._tabScroller.closeButton.setIcon(icon4);
            }
            this._tabScroller.scrollForwardButton.setToolTipText(this.getResourceString(BUTTON_NAME_SCROLL_FORWARD));
            this._tabScroller.scrollBackwardButton.setToolTipText(this.getResourceString(BUTTON_NAME_SCROLL_BACKWARD));
            this._tabScroller.listButton.setToolTipText(this.getResourceString(BUTTON_NAME_TAB_LIST));
            this._tabScroller.closeButton.setToolTipText(this.getResourceString(BUTTON_NAME_CLOSE));
        }
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.ancestorInputMap");
        }
        if (n2 == 0) {
            return (InputMap)UIDefaultsLookup.get("JideTabbedPane.focusInputMap");
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get("JideTabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("JideTabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigateNext", new NextAction());
        actionMapUIResource.put("navigatePrevious", new PreviousAction());
        actionMapUIResource.put("navigateRight", new RightAction());
        actionMapUIResource.put("navigateLeft", new LeftAction());
        actionMapUIResource.put("navigateUp", new UpAction());
        actionMapUIResource.put("navigateDown", new DownAction());
        actionMapUIResource.put("navigatePageUp", new PageUpAction());
        actionMapUIResource.put("navigatePageDown", new PageDownAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        actionMapUIResource.put("setSelectedIndex", new SetSelectedIndexAction());
        actionMapUIResource.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        actionMapUIResource.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        actionMapUIResource.put("scrollTabsListAction", new ScrollTabsListAction());
        actionMapUIResource.put("closeTabAction", new CloseTabAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._tabPane, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this._tabPane, 0, null);
        if (this._closeButtons != null) {
            for (int i2 = 0; i2 < this._closeButtons.length; ++i2) {
                this._closeButtons[i2] = null;
            }
            this._closeButtons = null;
        }
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int i2 = this._tabPane.getTabCount() - 1; i2 >= 0; --i2) {
            int n2 = this._tabPane.getMnemonicAt(i2);
            if (n2 <= 0) continue;
            this.addMnemonic(i2, n2);
        }
    }

    private void resetMnemonics() {
        if (this._mnemonicToIndexMap != null) {
            this._mnemonicToIndexMap.clear();
            this._mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n2, int n3) {
        if (this._mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this._mnemonicInputMap.put(KeyStroke.getKeyStroke(n3, 8), "setSelectedIndex");
        this._mnemonicToIndexMap.put(n3, n2);
    }

    private void initMnemonics() {
        this._mnemonicToIndexMap = new Hashtable();
        this._mnemonicInputMap = new InputMapUIResource();
        this._mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this._tabPane, 1));
        SwingUtilities.replaceUIInputMap(this._tabPane, 1, this._mnemonicInputMap);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = this._tabPane.getTabCount();
        this.paintBackground(graphics, jComponent);
        if (n2 == 0) {
            return;
        }
        if (this._tabCount != n2) {
            this._tabCount = n2;
            this.updateMnemonics();
        }
        int n3 = this._tabPane.getSelectedIndex();
        int n4 = this._tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n4, n3, jComponent);
        }
        this.paintContentBorder(graphics, n4, n3);
    }

    public void paintBackground(Graphics graphics, Component component) {
        if (this._tabPane.isOpaque()) {
            int n2 = component.getWidth();
            int n3 = component.getHeight();
            graphics.setColor(this._background);
            graphics.fillRect(0, 0, n2, n3);
        }
    }

    protected void paintTabArea(Graphics graphics, int n2, int n3, Component component) {
        int n4 = this._tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        this.paintTabAreaBackground(graphics, rectangle3, n2);
        boolean bl = n2 == 2 || n2 == 4 || this._tabPane.getComponentOrientation().isLeftToRight();
        for (int i2 = this._runCount - 1; i2 >= 0; --i2) {
            int n5 = this._tabRuns[i2];
            int n6 = this._tabRuns[i2 == this._runCount - 1 ? 0 : i2 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n4 - 1;
            for (int i3 = n5; i3 <= n7; ++i3) {
                if (!this._rects[i3].intersects(rectangle3) && bl || i3 == n3) continue;
                this.paintTab(graphics, n2, this._rects, i3, rectangle, rectangle2);
            }
        }
        if (n3 >= 0 && this.getRunForTab(n4, n3) == 0 && (this._rects[n3].intersects(rectangle3) || !bl)) {
            this.paintTab(graphics, n2, this._rects, n3, rectangle, rectangle2);
        }
    }

    protected void paintTabAreaBackground(Graphics graphics, Rectangle rectangle, int n2) {
        this.getPainter().paintTabAreaBackground(this._tabPane, graphics, rectangle, n2 == 1 || n2 == 3 ? 0 : 1, 0);
    }

    protected void paintTab(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this._tabPane.getSelectedIndex();
        boolean bl = n4 == n3;
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        this.paintTabBackground(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        Object object2 = JideSwingUtilities.setupShapeAntialiasing(graphics);
        this.paintTabBorder(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        JideSwingUtilities.restoreShapeAntialiasing(graphics, object2);
        Icon icon = this._tabPane.getIconForTab(n3);
        Rectangle rectangle4 = new Rectangle(rectangle3);
        if (this._tabPane.isShowGripper()) {
            if (bl2) {
                rectangle4.x += this._gripperWidth;
            }
            rectangle4.width -= this._gripperWidth;
            object = new Rectangle(rectangle3);
            ((Rectangle)object).x = bl2 ? (((Rectangle)object).x += this._gripLeftMargin) : rectangle3.x + rectangle3.width - this._gripLeftMargin - this._gripperWidth;
            ((Rectangle)object).width = this._gripperWidth;
            if (this._gripperPainter != null) {
                this._gripperPainter.paint(this._tabPane, graphics, (Rectangle)object, 0, bl ? 3 : 0);
            } else {
                this.getPainter().paintGripper(this._tabPane, graphics, (Rectangle)object, 0, bl ? 3 : 0);
            }
        }
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(n3) && (!this._tabPane.isShowCloseButtonOnSelectedTab() || bl)) {
            if (n2 == 1 || n2 == 3) {
                int n5 = this._closeButtons[n3].getPreferredSize().width + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (!(this._closeButtonAlignment == 10 ^ bl2)) {
                    rectangle4.x += n5;
                }
                rectangle4.width -= n5;
            } else {
                int n6 = this._closeButtons[n3].getPreferredSize().height + this._closeButtonLeftMargin + this._closeButtonRightMargin;
                if (this._closeButtonAlignment == 10) {
                    rectangle4.y += n6;
                    rectangle4.height -= n6;
                } else {
                    rectangle4.height -= n6;
                }
            }
        }
        object = this.getCurrentDisplayTitleAt(this._tabPane, n3);
        Font font = bl ? (this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : (this._tabPane.getFont() instanceof UIResource ? this._selectedTabFont : this._tabPane.getFont())) : this._tabPane.getFont();
        if (bl && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.layoutLabel(n2, fontMetrics, n3, (String)object, icon, rectangle4, rectangle, rectangle2, bl);
        if (!(this._isEditing && bl || SystemInfo.isJdk6Above() && this._tabPane.getTabComponentAt(n3) != null)) {
            this.paintText(graphics, n2, font, fontMetrics, n3, (String)object, rectangle2, bl);
        }
        if (!SystemInfo.isJdk6Above() || this._tabPane.getTabComponentAt(n3) == null) {
            this.paintIcon(graphics, n2, n3, icon, rectangle, bl);
        }
        this.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n2, int n3, boolean bl, int n4, int n5) {
        switch (n2) {
            case 2: 
            case 4: {
                graphics.setColor(this._shadow);
                for (int i2 = n4; i2 <= n4 + this._rects[n3].width; i2 += 12) {
                    for (int i3 = 0; i3 < this.xCropLen.length; i3 += 2) {
                        graphics.drawLine(i2 + this.yCropLen[i3], n5 - this.xCropLen[i3], i2 + this.yCropLen[i3 + 1] - 1, n5 - this.xCropLen[i3 + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this._shadow);
                for (int i4 = n5; i4 <= n5 + this._rects[n3].height; i4 += 12) {
                    for (int i5 = 0; i5 < this.xCropLen.length; i5 += 2) {
                        graphics.drawLine(n4 - this.xCropLen[i5], i4 + this.yCropLen[i5], n4 - this.xCropLen[i5 + 1], i4 + this.yCropLen[i5 + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this._tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this._textIconGap);
        this._tabPane.putClientProperty("html", null);
        if (n2 == 1 || n2 == 3) {
            if (rectangle2.x - rectangle.x < this._iconMargin) {
                rectangle2.x = rectangle.x + this._iconMargin;
                rectangle3.x = icon != null ? rectangle2.x + rectangle2.width + this._textIconGap : rectangle.x + this._textPadding;
                rectangle2.width = Math.min(rectangle2.width, rectangle.width - this._tabRectPadding);
                rectangle3.width = rectangle.width - this._tabRectPadding - rectangle2.width - (icon != null ? this._textIconGap + this._iconMargin : this._noIconMargin);
            }
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !bl) {
                rectangle2.width = rectangle2.width + this._closeButtons[n3].getPreferredSize().width + this._closeButtonMarginHorizon;
                rectangle3.width = 0;
            }
        } else {
            rectangle2.y = rectangle.y + this._iconMargin;
            rectangle3.y = icon != null ? rectangle2.y + rectangle2.height + this._textIconGap : rectangle.y + this._textPadding;
            rectangle2.x = rectangle.x + 2;
            rectangle3.x = rectangle.x + 2;
            rectangle3.width = rectangle.width - this._textMarginVertical;
            rectangle3.height = rectangle.height - this._tabRectPadding - rectangle2.height - (icon != null ? this._textIconGap + this._iconMargin : this._noIconMargin);
            if (this.getTabResizeMode() == 4 && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab() && !bl) {
                rectangle2.height = rectangle2.height + this._closeButtons[n3].getPreferredSize().height + this._closeButtonMarginVertical;
                rectangle3.height = 0;
            }
        }
    }

    protected void paintIcon(Graphics graphics, int n2, int n3, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null && rectangle.width >= icon.getIconWidth()) {
            if (n2 == 1 || n2 == 3) {
                icon.paintIcon(this._tabPane, graphics, rectangle.x, rectangle.y);
            } else if (rectangle.height < this._rects[n3].height - this._gripperHeight) {
                icon.paintIcon(this._tabPane, graphics, rectangle.x, rectangle.y);
            }
        }
    }

    protected void paintText(Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl) {
        View view;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (bl && this._tabPane.isBoldActiveTab()) {
            graphics2D.setFont(font.deriveFont(1));
        } else {
            graphics2D.setFont(font);
        }
        String string2 = string;
        if (n2 == 1 || n2 == 3) {
            if (rectangle.width <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(fontMetrics, string2) > rectangle.width) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!string2.equals(string)) {
                string2 = string2.length() >= 2 ? string2.substring(0, string2.length() - 2) + ".." : "";
            }
        } else {
            if (rectangle.height <= 0) {
                return;
            }
            while (SwingUtilities.computeStringWidth(fontMetrics, string2) > rectangle.height) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!string2.equals(string)) {
                string2 = string2.length() >= 2 ? string2.substring(0, string2.length() - 2) + ".." : "";
            }
        }
        if ((view = this.getTextViewForTab(n3)) != null) {
            view.paint(graphics2D, rectangle);
        } else {
            int n4 = this._tabPane.getDisplayedMnemonicIndexAt(n3);
            Component component = null;
            if (n3 >= 0 && n3 < this._tabPane.getTabCount()) {
                component = this._tabPane.getComponentAt(n3);
            }
            JideTabbedPane.ColorProvider colorProvider = this._tabPane.getTabColorProvider();
            Color color = null;
            if (component instanceof TabColorProvider) {
                color = ((TabColorProvider)((Object)component)).getTabForeground();
            }
            if (this._tabPane.isEnabled() && this._tabPane.isEnabledAt(n3)) {
                if (color == null && colorProvider != null && colorProvider.getForegroundAt(n3) != null) {
                    graphics2D.setColor(colorProvider.getForegroundAt(n3));
                } else {
                    if (color == null) {
                        color = this._tabPane.getForegroundAt(n3);
                    }
                    if (bl && this.showFocusIndicator()) {
                        if (!(color instanceof ColorUIResource)) {
                            graphics2D.setColor(color);
                        } else {
                            graphics2D.setColor(this._activeTabForeground);
                        }
                    } else if (bl) {
                        if (!(color instanceof ColorUIResource)) {
                            graphics2D.setColor(color);
                        } else {
                            graphics2D.setColor(this._inactiveSelectedTabForeground);
                        }
                    } else if (!(color instanceof ColorUIResource)) {
                        graphics2D.setColor(color);
                    } else {
                        graphics2D.setColor(this._inactiveTabForeground);
                    }
                }
                if (n2 == 1 || n2 == 3) {
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
                } else {
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.translate(rectangle.x, rectangle.y);
                    if (n2 == 4) {
                        graphics2D.rotate(1.5707963267948966);
                        graphics2D.translate(0, -rectangle.width);
                    } else {
                        graphics2D.rotate(-1.5707963267948966);
                        graphics2D.translate(-rectangle.height + fontMetrics.getHeight() / 2 + this._rectSizeExtend, 0);
                    }
                    JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n4, 0, (rectangle.width - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
                    graphics2D.setTransform(affineTransform);
                }
            } else if (n2 == 1 || n2 == 3) {
                graphics2D.setColor(this._tabPane.getBackgroundAt(n3).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics2D.setColor(this._tabPane.getBackgroundAt(n3).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n4, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            } else {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(rectangle.x, rectangle.y);
                if (n2 == 4) {
                    graphics2D.rotate(1.5707963267948966);
                    graphics2D.translate(0, -rectangle.width);
                } else {
                    graphics2D.rotate(-1.5707963267948966);
                    graphics2D.translate(-rectangle.height + fontMetrics.getHeight() / 2 + this._rectSizeExtend, 0);
                }
                graphics2D.setColor(this._tabPane.getBackgroundAt(n3).brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n4, 0, (rectangle.width - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
                graphics2D.setColor(this._tabPane.getBackgroundAt(n3).darker());
                JideSwingUtilities.drawStringUnderlineCharAt(this._tabPane, graphics2D, string2, n4, n2 == 4 ? -1 : 1, (rectangle.width - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() - 1);
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.dispose();
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintBoxTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 8: {
                this.paintExcelTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 1: {
                this.paintWindowsTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 11: {
                if (!bl) break;
                this.paintWindowsTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 2: {
                this.paintVsnetTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 9: {
                this.paintRoundedVsnetTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 5: {
                this.paintFlatTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 10: {
                this.paintRoundedFlatTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            default: {
                this.paintOffice2003TabBorder(graphics, n2, n3, n4, n5, n6, n7, bl);
            }
        }
        int n8 = this.getTabShape();
        if (n8 == 1) {
            if (this._mouseEnter && this._tabPane.getColorTheme() == 4 && n3 == this._indexMouseOver && !bl && this._tabPane.isEnabledAt(this._indexMouseOver)) {
                this.paintTabBorderMouseOver(graphics, n2, n3, n4, n5, n6, n7, bl);
            }
        } else if (n8 == 11 && this._mouseEnter && n3 == this._indexMouseOver && !bl && this._tabPane.isEnabledAt(this._indexMouseOver)) {
            this.paintTabBorderMouseOver(graphics, n2, n3, n4, n5, n6, n7, bl);
        }
    }

    protected void paintOffice2003TabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n2) {
            case 2: {
                n5 += 2;
                if (bl) {
                    int n8;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + 3, n4, n5 + n7 - 5);
                    graphics.drawLine(n4 + 1, n5 + n7 - 4, n4 + 1, n5 + n7 - 4);
                    graphics.drawLine(n4 + 2, n5 + n7 - 3, n4 + n6 - 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 1);
                    graphics.drawLine(n4 + 2, n5, n4 + 2, n5 - 1);
                    for (n8 = 0; n8 < n6 - 4; ++n8) {
                        graphics.drawLine(n4 + 3 + n8, n5 - 2 - n8, n4 + 3 + n8, n5 - 2 - n8);
                    }
                    graphics.drawLine(n4 + n6 - 1, n5 - n6 + 1, n4 + n6 - 1, n5 - n6 + 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 1, n5 + 3, n4 + 1, n5 + n7 - 5);
                    graphics.drawLine(n4 + 2, n5 + n7 - 4, n4 + n6 - 1, n5 + n7 - 4);
                    graphics.drawLine(n4 + 2, n5 + 2, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 3, n5, n4 + 3, n5 - 1);
                    for (n8 = 0; n8 < n6 - 4; ++n8) {
                        graphics.drawLine(n4 + 4 + n8, n5 - 2 - n8, n4 + 4 + n8, n5 - 2 - n8);
                    }
                    break;
                }
                if (n3 == 0) {
                    int n9;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + 3, n4, n5 + n7 - 5);
                    graphics.drawLine(n4 + 1, n5 + n7 - 4, n4 + 1, n5 + n7 - 4);
                    graphics.drawLine(n4 + 2, n5 + n7 - 3, n4 + n6 - 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 1);
                    graphics.drawLine(n4 + 2, n5, n4 + 2, n5 - 1);
                    for (n9 = 0; n9 < n6 - 4; ++n9) {
                        graphics.drawLine(n4 + 3 + n9, n5 - 2 - n9, n4 + 3 + n9, n5 - 2 - n9);
                    }
                    graphics.drawLine(n4 + n6 - 1, n5 - n6 + 1, n4 + n6 - 1, n5 - n6 + 2);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 1, n5 + 3, n4 + 1, n5 + n7 - 6);
                        graphics.drawLine(n4 + 2, n5 + 2, n4 + 2, n5 + 1);
                        graphics.drawLine(n4 + 3, n5, n4 + 3, n5 - 1);
                        for (n9 = 0; n9 < n6 - 4; ++n9) {
                            graphics.drawLine(n4 + 4 + n9, n5 - 2 - n9, n4 + 4 + n9, n5 - 2 - n9);
                        }
                        graphics.setColor(this.getPainter().getControlDk());
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 2, n5 + n7 - 4, n4 + n6 - 1, n5 + n7 - 4);
                    graphics.drawLine(n4 + 1, n5 + n7 - 5, n4 + 1, n5 + n7 - 5);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4, n5 + 3, n4, n5 + n7 - 5);
                graphics.drawLine(n4 + 1, n5 + n7 - 4, n4 + 1, n5 + n7 - 4);
                graphics.drawLine(n4 + 2, n5 + n7 - 3, n4 + n6 - 1, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 2, n5, n4 + 2, n5 - 1);
                graphics.drawLine(n4 + 3, n5 - 2, n4 + 3, n5 - 2);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + 1, n5 + 3, n4 + 1, n5 + n7 - 6);
                    graphics.drawLine(n4 + 2, n5 + 2, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 3, n5, n4 + 3, n5 - 1);
                    graphics.drawLine(n4 + 4, n5 - 2, n4 + 4, n5 - 2);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n4 + 2, n5 + n7 - 4, n4 + n6 - 1, n5 + n7 - 4);
                graphics.drawLine(n4 + 1, n5 + n7 - 5, n4 + 1, n5 + n7 - 5);
                break;
            }
            case 4: {
                if (bl) {
                    int n10;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 5, n4 + n6 - 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 1, n4, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + 4, n4 + n6 - 2, n5 + 3);
                    graphics.drawLine(n4 + n6 - 3, n5 + 2, n4 + n6 - 3, n5 + 1);
                    for (n10 = 0; n10 < n6 - 4; ++n10) {
                        graphics.drawLine(n4 + n6 - 4 - n10, n5 - n10, n4 + n6 - 4 - n10, n5 - n10);
                    }
                    graphics.drawLine(n4, n5 - n6 + 3, n4, n5 - n6 + 4);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 5, n4 + n6 - 2, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 3, n5 + 4, n4 + n6 - 3, n5 + 3);
                    graphics.drawLine(n4 + n6 - 4, n5 + 2, n4 + n6 - 4, n5 + 1);
                    for (n10 = 0; n10 < n6 - 4; ++n10) {
                        graphics.drawLine(n4 + n6 - 5 - n10, n5 - n10, n4 + n6 - 5 - n10, n5 - n10);
                    }
                    break;
                }
                if (n3 == 0) {
                    int n11;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 5, n4 + n6 - 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 1, n4, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + 4, n4 + n6 - 2, n5 + 3);
                    graphics.drawLine(n4 + n6 - 3, n5 + 2, n4 + n6 - 3, n5 + 1);
                    for (n11 = 0; n11 < n6 - 4; ++n11) {
                        graphics.drawLine(n4 + n6 - 4 - n11, n5 - n11, n4 + n6 - 4 - n11, n5 - n11);
                    }
                    graphics.drawLine(n4, n5 - n6 + 3, n4, n5 - n6 + 4);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 5, n4 + n6 - 2, n5 + n7 - 4);
                        graphics.drawLine(n4 + n6 - 3, n5 + 4, n4 + n6 - 3, n5 + 3);
                        graphics.drawLine(n4 + n6 - 4, n5 + 2, n4 + n6 - 4, n5 + 1);
                        for (n11 = 0; n11 < n6 - 4; ++n11) {
                            graphics.drawLine(n4 + n6 - 5 - n11, n5 - n11, n4 + n6 - 5 - n11, n5 - n11);
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4, n5 + n7 - 2);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4 + n6 - 1, n5 + 5, n4 + n6 - 1, n5 + n7 - 3);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 3, n5 + n7 - 1, n4, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + 4, n4 + n6 - 2, n5 + 3);
                graphics.drawLine(n4 + n6 - 3, n5 + 2, n4 + n6 - 3, n5 + 1);
                graphics.drawLine(n4 + n6 - 4, n5, n4 + n6 - 4, n5);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 5, n4 + n6 - 2, n5 + n7 - 4);
                    graphics.drawLine(n4 + n6 - 3, n5 + 4, n4 + n6 - 3, n5 + 3);
                    graphics.drawLine(n4 + n6 - 4, n5 + 2, n4 + n6 - 4, n5 + 1);
                    graphics.drawLine(n4 + n6 - 5, n5, n4 + n6 - 5, n5);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5 + n7 - 3);
                graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4, n5 + n7 - 2);
                break;
            }
            case 3: {
                if (bl2) {
                    if (bl) {
                        int n12;
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                        graphics.drawLine(n4 + 5, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                        graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + 4, n5 + n7 - 2);
                        graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 2, n5 + n7 - 3);
                        graphics.drawLine(n4, n5 + n7 - 4, n4, n5 + n7 - 4);
                        for (n12 = 3; n12 < n7 - 2; ++n12) {
                            graphics.drawLine(n4 + 2 - n12, n5 + n7 - 2 - n12, n4 + 2 - n12, n5 + n7 - 2 - n12);
                        }
                        graphics.drawLine(n4 - n7 + 3, n5, n4 - n7 + 4, n5);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 5, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5 + n7 - 3);
                        graphics.drawLine(n4 + 3, n5 + n7 - 3, n4 + 4, n5 + n7 - 3);
                        graphics.drawLine(n4 + 1, n5 + n7 - 4, n4 + 2, n5 + n7 - 4);
                        graphics.drawLine(n4, n5 + n7 - 5, n4, n5 + n7 - 5);
                        for (n12 = 3; n12 < n7 - 2; ++n12) {
                            graphics.drawLine(n4 + 2 - n12, n5 + n7 - 3 - n12, n4 + 2 - n12, n5 + n7 - 3 - n12);
                        }
                        break;
                    }
                    if (n3 == 0) {
                        int n13;
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                        graphics.drawLine(n4 + 5, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                        graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + 4, n5 + n7 - 2);
                        graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 2, n5 + n7 - 3);
                        graphics.drawLine(n4, n5 + n7 - 4, n4, n5 + n7 - 4);
                        for (n13 = 3; n13 < n7 - 2; ++n13) {
                            graphics.drawLine(n4 + 2 - n13, n5 + n7 - 2 - n13, n4 + 2 - n13, n5 + n7 - 2 - n13);
                        }
                        graphics.drawLine(n4 - n7 + 3, n5, n4 - n7 + 4, n5);
                        if (this._unselectColor2 != null) {
                            graphics.setColor(this._unselectColor2);
                            graphics.drawLine(n4 + 3, n5 + n7 - 3, n4 + 4, n5 + n7 - 3);
                            graphics.drawLine(n4 + 1, n5 + n7 - 4, n4 + 2, n5 + n7 - 4);
                            graphics.drawLine(n4, n5 + n7 - 5, n4, n5 + n7 - 5);
                            for (n13 = 3; n13 < n7 - 2; ++n13) {
                                graphics.drawLine(n4 + 2 - n13, n5 + n7 - 3 - n13, n4 + 2 - n13, n5 + n7 - 3 - n13);
                            }
                            graphics.drawLine(n4 + 5, n5 + n7 - 2, n4 + n6 - 4, n5 + n7 - 2);
                        }
                        if (this._unselectColor3 == null) break;
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5);
                        break;
                    }
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 5, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + 4, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 2, n5 + n7 - 3);
                    graphics.drawLine(n4, n5 + n7 - 4, n4, n5 + n7 - 4);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 3, n5 + n7 - 3, n4 + 4, n5 + n7 - 3);
                        graphics.drawLine(n4 + 1, n5 + n7 - 4, n4 + 2, n5 + n7 - 4);
                        graphics.drawLine(n4, n5 + n7 - 5, n4, n5 + n7 - 5);
                        graphics.drawLine(n4 + 5, n5 + n7 - 2, n4 + n6 - 4, n5 + n7 - 2);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5);
                    break;
                }
                if (bl) {
                    int n14;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + n7 - 3, n4, n5);
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 6, n5 + n7 - 1, n4 + 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 4, n5 + n7 - 2, n4 + n6 - 5, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 3, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 4, n4 + n6 - 1, n5 + n7 - 4);
                    for (n14 = 3; n14 < n7 - 2; ++n14) {
                        graphics.drawLine(n4 + n6 - 3 + n14, n5 + n7 - 2 - n14, n4 + n6 - 3 + n14, n5 + n7 - 2 - n14);
                    }
                    graphics.drawLine(n4 + n6 - 4 + n7, n5, n4 + n6 - 5 + n7, n5);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 6, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5, n4 + 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 4, n5 + n7 - 3, n4 + n6 - 5, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 4, n4 + n6 - 3, n5 + n7 - 4);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 5, n4 + n6 - 1, n5 + n7 - 5);
                    for (n14 = 3; n14 < n7 - 2; ++n14) {
                        graphics.drawLine(n4 + n6 - 3 + n14, n5 + n7 - 3 - n14, n4 + n6 - 3 + n14, n5 + n7 - 3 - n14);
                    }
                    break;
                }
                if (n3 == 0) {
                    int n15;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + n7 - 3, n4, n5);
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 6, n5 + n7 - 1, n4 + 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 4, n5 + n7 - 2, n4 + n6 - 5, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 3, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 4, n4 + n6 - 1, n5 + n7 - 4);
                    for (n15 = 3; n15 < n7 - 2; ++n15) {
                        graphics.drawLine(n4 + n6 - 3 + n15, n5 + n7 - 2 - n15, n4 + n6 - 3 + n15, n5 + n7 - 2 - n15);
                    }
                    graphics.drawLine(n4 + n6 - 4 + n7, n5, n4 + n6 - 5 + n7, n5);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 4, n5 + n7 - 3, n4 + n6 - 5, n5 + n7 - 3);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 4, n4 + n6 - 3, n5 + n7 - 4);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7 - 5, n4 + n6 - 1, n5 + n7 - 5);
                        for (n15 = 3; n15 < n7 - 2; ++n15) {
                            graphics.drawLine(n4 + n6 - 3 + n15, n5 + n7 - 3 - n15, n4 + n6 - 3 + n15, n5 + n7 - 3 - n15);
                        }
                        graphics.drawLine(n4 + n6 - 6, n5 + n7 - 2, n4 + 3, n5 + n7 - 2);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4 + n6 - 6, n5 + n7 - 1, n4 + 2, n5 + n7 - 1);
                graphics.drawLine(n4, n5 + n7 - 3, n4, n5);
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 4, n5 + n7 - 2, n4 + n6 - 5, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 3, n5 + n7 - 3);
                graphics.drawLine(n4 + n6 - 1, n5 + n7 - 4, n4 + n6 - 1, n5 + n7 - 4);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + n6 - 4, n5 + n7 - 3, n4 + n6 - 5, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 4, n4 + n6 - 3, n5 + n7 - 4);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 5, n4 + n6 - 1, n5 + n7 - 5);
                    graphics.drawLine(n4 + n6 - 6, n5 + n7 - 2, n4 + 3, n5 + n7 - 2);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5);
                break;
            }
            default: {
                if (bl2) {
                    if (bl) {
                        int n16;
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4 + 3, n5 + 1, n4 + 4, n5 + 1);
                        graphics.drawLine(n4 + 1, n5 + 2, n4 + 2, n5 + 2);
                        graphics.drawLine(n4, n5 + 3, n4, n5 + 3);
                        graphics.drawLine(n4 + 5, n5, n4 + n6 - 3, n5);
                        graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                        for (n16 = 3; n16 < n7 - 2; ++n16) {
                            graphics.drawLine(n4 + 2 - n16, n5 + 1 + n16, n4 + 2 - n16, n5 + 1 + n16);
                        }
                        graphics.drawLine(n4 - n7 + 3, n5 + n7 - 1, n4 - n7 + 4, n5 + n7 - 1);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 3, n5 + 2, n4 + 4, n5 + 2);
                        graphics.drawLine(n4 + 1, n5 + 3, n4 + 2, n5 + 3);
                        graphics.drawLine(n4, n5 + 4, n4, n5 + 4);
                        graphics.drawLine(n4 + 5, n5 + 1, n4 + n6 - 3, n5 + 1);
                        graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 1);
                        for (n16 = 3; n16 < n7 - 2; ++n16) {
                            graphics.drawLine(n4 + 2 - n16, n5 + 2 + n16, n4 + 2 - n16, n5 + 2 + n16);
                        }
                        break;
                    }
                    if (n3 == 0) {
                        int n17;
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n4 + 3, n5 + 1, n4 + 4, n5 + 1);
                        graphics.drawLine(n4 + 1, n5 + 2, n4 + 2, n5 + 2);
                        graphics.drawLine(n4, n5 + 3, n4, n5 + 3);
                        graphics.drawLine(n4 + 5, n5, n4 + n6 - 3, n5);
                        graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                        for (n17 = 3; n17 < n7 - 2; ++n17) {
                            graphics.drawLine(n4 + 2 - n17, n5 + 1 + n17, n4 + 2 - n17, n5 + 1 + n17);
                        }
                        graphics.drawLine(n4 - n7 + 3, n5 + n7 - 1, n4 - n7 + 4, n5 + n7 - 1);
                        if (this._unselectColor2 != null) {
                            graphics.setColor(this._unselectColor2);
                            graphics.drawLine(n4 + 3, n5 + 2, n4 + 4, n5 + 2);
                            graphics.drawLine(n4 + 1, n5 + 3, n4 + 2, n5 + 3);
                            graphics.drawLine(n4, n5 + 4, n4, n5 + 4);
                            for (n17 = 3; n17 < n7 - 2; ++n17) {
                                graphics.drawLine(n4 + 2 - n17, n5 + 2 + n17, n4 + 2 - n17, n5 + 2 + n17);
                            }
                            graphics.drawLine(n4 + 5, n5 + 1, n4 + n6 - 4, n5 + 1);
                        }
                        if (this._unselectColor3 == null) break;
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n4 + n6 - 3, n5 + 1, n4 + n6 - 3, n5 + 1);
                        graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 1);
                        break;
                    }
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 3, n5 + 1, n4 + 4, n5 + 1);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 2, n5 + 2);
                    graphics.drawLine(n4, n5 + 3, n4, n5 + 3);
                    graphics.drawLine(n4 + 5, n5, n4 + n6 - 3, n5);
                    graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 3, n5 + 2, n4 + 4, n5 + 2);
                        graphics.drawLine(n4 + 1, n5 + 3, n4 + 2, n5 + 3);
                        graphics.drawLine(n4, n5 + 4, n4, n5 + 4);
                        graphics.drawLine(n4 + 5, n5 + 1, n4 + n6 - 4, n5 + 1);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 3, n5 + 1, n4 + n6 - 3, n5 + 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 1);
                    break;
                }
                if (bl) {
                    int n18;
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + n6 - 4, n5 + 1, n4 + n6 - 5, n5 + 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 3, n5 + 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + 3, n4 + n6 - 1, n5 + 3);
                    graphics.drawLine(n4 + n6 - 6, n5, n4 + 2, n5);
                    graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                    for (n18 = 3; n18 < n7 - 2; ++n18) {
                        graphics.drawLine(n4 + n6 - 3 + n18, n5 + 1 + n18, n4 + n6 - 3 + n18, n5 + 1 + n18);
                    }
                    graphics.drawLine(n4 + n6 - 4 + n7, n5 + n7 - 1, n4 + n6 - 5 + n7, n5 + n7 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 4, n5 + 2, n4 + n6 - 5, n5 + 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 3, n5 + 3);
                    graphics.drawLine(n4 + n6 - 1, n5 + 4, n4 + n6 - 1, n5 + 4);
                    graphics.drawLine(n4 + n6 - 6, n5 + 1, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
                    for (n18 = 3; n18 < n7 - 2; ++n18) {
                        graphics.drawLine(n4 + n6 - 3 + n18, n5 + 2 + n18, n4 + n6 - 3 + n18, n5 + 2 + n18);
                    }
                    break;
                }
                if (n3 == 0) {
                    int n19;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + n6 - 4, n5 + 1, n4 + n6 - 5, n5 + 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 3, n5 + 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + 3, n4 + n6 - 1, n5 + 3);
                    graphics.drawLine(n4 + n6 - 6, n5, n4 + 2, n5);
                    graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                    for (n19 = 3; n19 < n7 - 2; ++n19) {
                        graphics.drawLine(n4 + n6 - 3 + n19, n5 + 1 + n19, n4 + n6 - 3 + n19, n5 + 1 + n19);
                    }
                    graphics.drawLine(n4 + n6 - 4 + n7, n5 + n7 - 1, n4 + n6 - 5 + n7, n5 + n7 - 1);
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 4, n5 + 2, n4 + n6 - 5, n5 + 2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 3, n5 + 3);
                        graphics.drawLine(n4 + n6 - 1, n5 + 4, n4 + n6 - 1, n5 + 4);
                        for (n19 = 3; n19 < n7 - 2; ++n19) {
                            graphics.drawLine(n4 + n6 - 3 + n19, n5 + 2 + n19, n4 + n6 - 3 + n19, n5 + 2 + n19);
                        }
                        graphics.drawLine(n4 + n6 - 6, n5 + 1, n4 + 3, n5 + 1);
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4 + n6 - 4, n5 + 1, n4 + n6 - 5, n5 + 1);
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 3, n5 + 2);
                graphics.drawLine(n4 + n6 - 1, n5 + 3, n4 + n6 - 1, n5 + 3);
                graphics.drawLine(n4 + n6 - 6, n5, n4 + 2, n5);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                if (this._unselectColor2 != null) {
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + n6 - 4, n5 + 2, n4 + n6 - 5, n5 + 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 3, n5 + 3);
                    graphics.drawLine(n4 + n6 - 1, n5 + 4, n4 + n6 - 1, n5 + 4);
                    graphics.drawLine(n4 + n6 - 6, n5 + 1, n4 + 3, n5 + 1);
                }
                if (this._unselectColor3 == null) break;
                graphics.setColor(this._unselectColor3);
                graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
            }
        }
    }

    protected void paintExcelTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n2) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + 5, n4, n5 + n7 - 5);
                    int n8 = 0;
                    int n9 = 0;
                    while (n8 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + 1 + n9, n5 + 4 - n8, n4 + 2 + n9, n5 + 4 - n8);
                        ++n8;
                        n9 += 2;
                    }
                    n8 = 0;
                    n9 = 0;
                    while (n8 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n9, n5 + n7 - 4 + n8, n4 + 1 + n9, n5 + n7 - 4 + n8);
                        ++n8;
                        n9 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 1, n5 + 6, n4 + 1, n5 + n7 - 6);
                        n8 = 0;
                        n9 = 0;
                        while (n8 < n6 / 2 + 1) {
                            graphics.drawLine(n4 + 1 + n9, n5 + 5 - n8, n4 + 2 + n9, n5 + 5 - n8);
                            ++n8;
                            n9 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + 1, n5 + n7 - 5, n4 + 1, n5 + n7 - 5);
                    n8 = 0;
                    n9 = 0;
                    while (n8 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + 2 + n9, n5 + n7 - 4 + n8, n4 + 3 + n9, n5 + n7 - 4 + n8);
                        ++n8;
                        n9 += 2;
                    }
                } else if (n3 == 0) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + 5, n4, n5 + n7 - 5);
                    int n10 = 0;
                    int n11 = 0;
                    while (n10 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + 1 + n11, n5 + 4 - n10, n4 + 2 + n11, n5 + 4 - n10);
                        ++n10;
                        n11 += 2;
                    }
                    n10 = 0;
                    n11 = 0;
                    while (n10 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n11, n5 + n7 - 4 + n10, n4 + 1 + n11, n5 + n7 - 4 + n10);
                        ++n10;
                        n11 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 1, n5 + 6, n4 + 1, n5 + n7 - 6);
                        n10 = 0;
                        n11 = 0;
                        while (n10 < n6 / 2) {
                            graphics.drawLine(n4 + 1 + n11, n5 + 5 - n10, n4 + 2 + n11, n5 + 5 - n10);
                            ++n10;
                            n11 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 1, n5 + n7 - 5, n4 + 1, n5 + n7 - 5);
                    n10 = 0;
                    n11 = 0;
                    while (n10 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + 2 + n11, n5 + n7 - 4 + n10, n4 + 3 + n11, n5 + n7 - 4 + n10);
                        ++n10;
                        n11 += 2;
                    }
                } else if (n3 == this._tabPane.getSelectedIndex() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + 5, n4, n5 + n7 - 5);
                    int n12 = 0;
                    int n13 = 0;
                    while (n12 < 4) {
                        graphics.drawLine(n4 + 1 + n13, n5 + 4 - n12, n4 + 2 + n13, n5 + 4 - n12);
                        ++n12;
                        n13 += 2;
                    }
                    n12 = 0;
                    n13 = 0;
                    while (n12 < 5) {
                        graphics.drawLine(n4 + n13, n5 + n7 - 4 + n12, n4 + 1 + n13, n5 + n7 - 4 + n12);
                        ++n12;
                        n13 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 1, n5 + 6, n4 + 1, n5 + n7 - 6);
                        n12 = 0;
                        n13 = 0;
                        while (n12 < 4) {
                            graphics.drawLine(n4 + 1 + n13, n5 + 5 - n12, n4 + 2 + n13, n5 + 5 - n12);
                            ++n12;
                            n13 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 1, n5 + n7 - 5, n4 + 1, n5 + n7 - 5);
                    n12 = 0;
                    n13 = 0;
                    while (n12 < 5) {
                        graphics.drawLine(n4 + 2 + n13, n5 + n7 - 4 + n12, n4 + 3 + n13, n5 + n7 - 4 + n12);
                        ++n12;
                        n13 += 2;
                    }
                } else {
                    if (n3 == this._tabPane.getSelectedIndex() - 1) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + 5, n4, n5 + n7 - 5);
                    int n14 = 0;
                    int n15 = 0;
                    while (n14 < 4) {
                        graphics.drawLine(n4 + 1 + n15, n5 + 4 - n14, n4 + 2 + n15, n5 + 4 - n14);
                        ++n14;
                        n15 += 2;
                    }
                    n14 = 0;
                    n15 = 0;
                    while (n14 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n15, n5 + n7 - 4 + n14, n4 + 1 + n15, n5 + n7 - 4 + n14);
                        ++n14;
                        n15 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 1, n5 + 6, n4 + 1, n5 + n7 - 6);
                        n14 = 0;
                        n15 = 0;
                        while (n14 < 4) {
                            graphics.drawLine(n4 + 1 + n15, n5 + 5 - n14, n4 + 2 + n15, n5 + 5 - n14);
                            ++n14;
                            n15 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 1, n5 + n7 - 5, n4 + 1, n5 + n7 - 5);
                    n14 = 0;
                    n15 = 0;
                    while (n14 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + 2 + n15, n5 + n7 - 4 + n14, n4 + 3 + n15, n5 + n7 - 4 + n14);
                        ++n14;
                        n15 += 2;
                    }
                }
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 5, n4 + n6 - 1, n5 + n7 - 5);
                    int n16 = 0;
                    int n17 = 0;
                    while (n16 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 2 - n17, n5 + 4 - n16, n4 + n6 - 3 - n17, n5 + 4 - n16);
                        ++n16;
                        n17 += 2;
                    }
                    n16 = 0;
                    n17 = 0;
                    while (n16 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 1 - n17, n5 + n7 - 4 + n16, n4 + n6 - 2 - n17, n5 + n7 - 4 + n16);
                        ++n16;
                        n17 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 6, n4 + n6 - 2, n5 + n7 - 6);
                        n16 = 0;
                        n17 = 0;
                        while (n16 < n6 / 2 + 1) {
                            graphics.drawLine(n4 + n6 - 2 - n17, n5 + 5 - n16, n4 + n6 - 3 - n17, n5 + 5 - n16);
                            ++n16;
                            n17 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 5, n4 + n6 - 2, n5 + n7 - 5);
                    n16 = 0;
                    n17 = 0;
                    while (n16 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 3 - n17, n5 + n7 - 4 + n16, n4 + n6 - 4 - n17, n5 + n7 - 4 + n16);
                        ++n16;
                        n17 += 2;
                    }
                } else if (n3 == 0) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 5, n4 + n6 - 1, n5 + n7 - 5);
                    int n18 = 0;
                    int n19 = 0;
                    while (n18 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 2 - n19, n5 + 4 - n18, n4 + n6 - 3 - n19, n5 + 4 - n18);
                        ++n18;
                        n19 += 2;
                    }
                    n18 = 0;
                    n19 = 0;
                    while (n18 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 1 - n19, n5 + n7 - 4 + n18, n4 + n6 - 2 - n19, n5 + n7 - 4 + n18);
                        ++n18;
                        n19 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 6, n4 + n6 - 2, n5 + n7 - 6);
                        n18 = 0;
                        n19 = 0;
                        while (n18 < n6 / 2 + 1) {
                            graphics.drawLine(n4 + n6 - 2 - n19, n5 + 5 - n18, n4 + n6 - 3 - n19, n5 + 5 - n18);
                            ++n18;
                            n19 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 5, n4 + n6 - 2, n5 + n7 - 5);
                    n18 = 0;
                    n19 = 0;
                    while (n18 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 3 - n19, n5 + n7 - 4 + n18, n4 + n6 - 4 - n19, n5 + n7 - 4 + n18);
                        ++n18;
                        n19 += 2;
                    }
                } else if (n3 == this._tabPane.getSelectedIndex() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 5, n4 + n6 - 1, n5 + n7 - 5);
                    int n20 = 0;
                    int n21 = 0;
                    while (n20 < 4) {
                        graphics.drawLine(n4 + n6 - 2 - n21, n5 + 4 - n20, n4 + n6 - 3 - n21, n5 + 4 - n20);
                        ++n20;
                        n21 += 2;
                    }
                    n20 = 0;
                    n21 = 0;
                    while (n20 < 5) {
                        graphics.drawLine(n4 + n6 - 1 - n21, n5 + n7 - 4 + n20, n4 + n6 - 2 - n21, n5 + n7 - 4 + n20);
                        ++n20;
                        n21 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 6, n4 + n6 - 2, n5 + n7 - 6);
                        n20 = 0;
                        n21 = 0;
                        while (n20 < 4) {
                            graphics.drawLine(n4 + n6 - 2 - n21, n5 + 5 - n20, n4 + n6 - 3 - n21, n5 + 5 - n20);
                            ++n20;
                            n21 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 5, n4 + n6 - 2, n5 + n7 - 5);
                    n20 = 0;
                    n21 = 0;
                    while (n20 < 5) {
                        graphics.drawLine(n4 + n6 - 3 - n21, n5 + n7 - 4 + n20, n4 + n6 - 4 - n21, n5 + n7 - 4 + n20);
                        ++n20;
                        n21 += 2;
                    }
                } else {
                    if (n3 == this._tabPane.getSelectedIndex() - 1) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 5, n4 + n6 - 1, n5 + n7 - 5);
                    int n22 = 0;
                    int n23 = 0;
                    while (n22 < 4) {
                        graphics.drawLine(n4 + n6 - 2 - n23, n5 + 4 - n22, n4 + n6 - 3 - n23, n5 + 4 - n22);
                        ++n22;
                        n23 += 2;
                    }
                    n22 = 0;
                    n23 = 0;
                    while (n22 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 1 - n23, n5 + n7 - 4 + n22, n4 + n6 - 2 - n23, n5 + n7 - 4 + n22);
                        ++n22;
                        n23 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 6, n4 + n6 - 2, n5 + n7 - 6);
                        n22 = 0;
                        n23 = 0;
                        while (n22 < 4) {
                            graphics.drawLine(n4 + n6 - 2 - n23, n5 + 5 - n22, n4 + n6 - 3 - n23, n5 + 5 - n22);
                            ++n22;
                            n23 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 5, n4 + n6 - 2, n5 + n7 - 5);
                    n22 = 0;
                    n23 = 0;
                    while (n22 < n6 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 3 - n23, n5 + n7 - 4 + n22, n4 + n6 - 4 - n23, n5 + n7 - 4 + n22);
                        ++n22;
                        n23 += 2;
                    }
                }
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 5, n5 + n7 - 1, n4 + n6 - 5, n5 + n7 - 1);
                    int n24 = 0;
                    int n25 = 0;
                    while (n24 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + 4 - n24, n5 + n7 - 2 - n25, n4 + 4 - n24, n5 + n7 - 3 - n25);
                        ++n24;
                        n25 += 2;
                    }
                    n24 = 0;
                    n25 = 0;
                    while (n24 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 4 - 1 + n24, n5 + n7 - 1 - n25, n4 + n6 - 4 - 1 + n24, n5 + n7 - 2 - n25);
                        ++n24;
                        n25 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 5, n5 + n7 - 3, n4 + 5, n5 + n7 - 3);
                        n24 = 0;
                        n25 = 0;
                        while (n24 < n7 / 2 + 1) {
                            graphics.drawLine(n4 + 4 - n24, n5 + n7 - 4 - n25, n4 + 4 - n24, n5 + n7 - 5 - n25);
                            ++n24;
                            n25 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + 5, n5 + n7 - 2, n4 + n6 - 6, n5 + n7 - 2);
                    n24 = 0;
                    n25 = 0;
                    while (n24 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 5 + n24, n5 + n7 - 3 - n25, n4 + n6 - 5 + n24, n5 + n7 - 4 - n25);
                        ++n24;
                        n25 += 2;
                    }
                } else if (bl2 && n3 == 0 || !bl2 && n3 == this._tabPane.getTabCount() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 5, n5 + n7 - 1, n4 + n6 - 5, n5 + n7 - 1);
                    int n26 = 0;
                    int n27 = 0;
                    while (n26 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + 4 - n26, n5 + n7 - 2 - n27, n4 + 4 - n26, n5 + n7 - 3 - n27);
                        ++n26;
                        n27 += 2;
                    }
                    n26 = 0;
                    n27 = 0;
                    while (n26 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 4 - 1 + n26, n5 + n7 - 1 - n27, n4 + n6 - 4 - 1 + n26, n5 + n7 - 2 - n27);
                        ++n26;
                        n27 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        n26 = 0;
                        n27 = 0;
                        while (n26 < n7 / 2 + 1) {
                            graphics.drawLine(n4 + 5 - n26, n5 + n7 - 2 - n27, n4 + 5 - n26, n5 + n7 - 3 - n27);
                            ++n26;
                            n27 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 6, n5 + n7 - 2, n4 + n6 - 6, n5 + n7 - 2);
                    n26 = 0;
                    n27 = 0;
                    while (n26 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 5 + n26, n5 + n7 - 3 - n27, n4 + n6 - 5 + n26, n5 + n7 - 4 - n27);
                        ++n26;
                        n27 += 2;
                    }
                } else if (n3 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 5, n5 + n7 - 1, n4 + n6 - 6, n5 + n7 - 1);
                    int n28 = 0;
                    int n29 = 0;
                    while (n28 < 5) {
                        graphics.drawLine(n4 + 4 - n28, n5 + n7 - 2 - n29, n4 + 4 - n28, n5 + n7 - 3 - n29);
                        ++n28;
                        n29 += 2;
                    }
                    n28 = 0;
                    n29 = 0;
                    while (n28 < 5) {
                        graphics.drawLine(n4 + n6 - 5 + n28, n5 + n7 - 1 - n29, n4 + n6 - 5 + n28, n5 + n7 - 2 - n29);
                        ++n28;
                        n29 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        n28 = 0;
                        n29 = 0;
                        while (n28 < 5) {
                            graphics.drawLine(n4 + 5 - n28, n5 + n7 - 2 - n29, n4 + 5 - n28, n5 + n7 - 3 - n29);
                            ++n28;
                            n29 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 6, n5 + n7 - 2, n4 + n6 - 6, n5 + n7 - 2);
                    n28 = 0;
                    n29 = 0;
                    while (n28 < 5) {
                        graphics.drawLine(n4 + n6 - 5 + n28, n5 + n7 - 3 - n29, n4 + n6 - 5 + n28, n5 + n7 - 4 - n29);
                        ++n28;
                        n29 += 2;
                    }
                } else {
                    if (n3 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 5, n5 + n7 - 1, n4 + n6 - 6, n5 + n7 - 1);
                    int n30 = 0;
                    int n31 = 0;
                    while (n30 < 5) {
                        graphics.drawLine(n4 + 4 - n30, n5 + n7 - 2 - n31, n4 + 4 - n30, n5 + n7 - 3 - n31);
                        ++n30;
                        n31 += 2;
                    }
                    n30 = 0;
                    n31 = 0;
                    while (n30 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 5 + n30, n5 + n7 - 1 - n31, n4 + n6 - 5 + n30, n5 + n7 - 2 - n31);
                        ++n30;
                        n31 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        n30 = 0;
                        n31 = 0;
                        while (n30 < 5) {
                            graphics.drawLine(n4 + 5 - n30, n5 + n7 - 2 - n31, n4 + 5 - n30, n5 + n7 - 3 - n31);
                            ++n30;
                            n31 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 6, n5 + n7 - 2, n4 + n6 - 6, n5 + n7 - 2);
                    n30 = 0;
                    n31 = 0;
                    while (n30 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 5 + n30, n5 + n7 - 3 - n31, n4 + n6 - 5 + n30, n5 + n7 - 4 - n31);
                        ++n30;
                        n31 += 2;
                    }
                }
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 5, n5, n4 + n6 - 5, n5);
                    int n32 = 0;
                    int n33 = 0;
                    while (n32 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + 4 - n32, n5 + 1 + n33, n4 + 4 - n32, n5 + 2 + n33);
                        ++n32;
                        n33 += 2;
                    }
                    n32 = 0;
                    n33 = 0;
                    while (n32 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 4 - 1 + n32, n5 + n33, n4 + n6 - 4 - 1 + n32, n5 + 1 + n33);
                        ++n32;
                        n33 += 2;
                    }
                    if (this._selectColor2 != null) {
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 6, n5 + 1, n4 + n6 - 7, n5 + 1);
                        n32 = 0;
                        n33 = 0;
                        while (n32 < n7 / 2 + 1) {
                            graphics.drawLine(n4 + 5 - n32, n5 + 1 + n33, n4 + 5 - n32, n5 + 2 + n33);
                            ++n32;
                            n33 += 2;
                        }
                    }
                    if (this._selectColor3 == null) break;
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + n6 - 6, n5 + 1, n4 + n6 - 6, n5 + 1);
                    n32 = 0;
                    n33 = 0;
                    while (n32 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 5 + n32, n5 + 2 + n33, n4 + n6 - 5 + n32, n5 + 3 + n33);
                        ++n32;
                        n33 += 2;
                    }
                } else if (bl2 && n3 == 0 || !bl2 && n3 == this._tabPane.getTabCount() - 1) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 5, n5, n4 + n6 - 5, n5);
                    int n34 = 0;
                    int n35 = 0;
                    while (n34 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + 4 - n34, n5 + 1 + n35, n4 + 4 - n34, n5 + 2 + n35);
                        ++n34;
                        n35 += 2;
                    }
                    n34 = 0;
                    n35 = 0;
                    while (n34 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 4 - 1 + n34, n5 + n35, n4 + n6 - 4 - 1 + n34, n5 + 1 + n35);
                        ++n34;
                        n35 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 6, n5 + 1, n4 + n6 - 7, n5 + 1);
                        n34 = 0;
                        n35 = 0;
                        while (n34 < n7 / 2 + 1) {
                            graphics.drawLine(n4 + 5 - n34, n5 + 1 + n35, n4 + 5 - n34, n5 + 2 + n35);
                            ++n34;
                            n35 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 6, n5 + 1, n4 + n6 - 6, n5 + 1);
                    n34 = 0;
                    n35 = 0;
                    while (n34 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 5 + n34, n5 + 2 + n35, n4 + n6 - 5 + n34, n5 + 3 + n35);
                        ++n34;
                        n35 += 2;
                    }
                } else if (n3 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 5, n5, n4 + n6 - 5, n5);
                    int n36 = 0;
                    int n37 = 0;
                    while (n36 < 5) {
                        graphics.drawLine(n4 + 4 - n36, n5 + 1 + n37, n4 + 4 - n36, n5 + 2 + n37);
                        ++n36;
                        n37 += 2;
                    }
                    n36 = 0;
                    n37 = 0;
                    while (n36 < 5) {
                        graphics.drawLine(n4 + n6 - 4 - 1 + n36, n5 + n37, n4 + n6 - 4 - 1 + n36, n5 + 1 + n37);
                        ++n36;
                        n37 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 6, n5 + 1, n4 + n6 - 7, n5 + 1);
                        n36 = 0;
                        n37 = 0;
                        while (n36 < 5) {
                            graphics.drawLine(n4 + 5 - n36, n5 + 1 + n37, n4 + 5 - n36, n5 + 2 + n37);
                            ++n36;
                            n37 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 6, n5 + 1, n4 + n6 - 6, n5 + 1);
                    n36 = 0;
                    n37 = 0;
                    while (n36 < 5) {
                        graphics.drawLine(n4 + n6 - 5 + n36, n5 + 2 + n37, n4 + n6 - 5 + n36, n5 + 3 + n37);
                        ++n36;
                        n37 += 2;
                    }
                } else {
                    if (n3 == this._tabPane.getSelectedIndex() + (bl2 ? -1 : 1)) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 5, n5, n4 + n6 - 5, n5);
                    int n38 = 0;
                    int n39 = 0;
                    while (n38 < 5) {
                        graphics.drawLine(n4 + 4 - n38, n5 + 1 + n39, n4 + 4 - n38, n5 + 2 + n39);
                        ++n38;
                        n39 += 2;
                    }
                    n38 = 0;
                    n39 = 0;
                    while (n38 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 4 - 1 + n38, n5 + n39, n4 + n6 - 4 - 1 + n38, n5 + 1 + n39);
                        ++n38;
                        n39 += 2;
                    }
                    if (this._unselectColor2 != null) {
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 6, n5 + 1, n4 + n6 - 7, n5 + 1);
                        n38 = 0;
                        n39 = 0;
                        while (n38 < 5) {
                            graphics.drawLine(n4 + 5 - n38, n5 + 1 + n39, n4 + 5 - n38, n5 + 2 + n39);
                            ++n38;
                            n39 += 2;
                        }
                    }
                    if (this._unselectColor3 == null) break;
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 6, n5 + 1, n4 + n6 - 6, n5 + 1);
                    n38 = 0;
                    n39 = 0;
                    while (n38 < n7 / 2 + 1) {
                        graphics.drawLine(n4 + n6 - 5 + n38, n5 + 2 + n39, n4 + n6 - 5 + n38, n5 + 3 + n39);
                        ++n38;
                        n39 += 2;
                    }
                }
                break;
            }
        }
    }

    protected void paintWindowsTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.getColorTheme();
        switch (n2) {
            case 2: {
                if (n8 == 2 || n8 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4 - 2, n5 + 1, n4 - 2, n5 + n7 - 1);
                        graphics.drawLine(n4 - 1, n5, n4 - 1, n5);
                        graphics.drawLine(n4, n5 - 1, n4 + n6 - 1, n5 - 1);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 - 1, n5 + n7, n4 - 1, n5 + n7);
                        graphics.drawLine(n4, n5 + n7 + 1, n4, n5 + n7 + 1);
                        graphics.drawLine(n4 + 1, n5 + n7, n4 + n6 - 1, n5 + n7);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4, n5 + n7, n4, n5 + n7);
                        graphics.drawLine(n4 + 1, n5 + n7 + 1, n4 + n6 - 1, n5 + n7 + 1);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 3);
                        graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                        graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                        graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + 2, n5 + n7 - 1);
                        graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                        graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + 3, n4, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 2);
                    graphics.drawLine(n4 + 2, n5 + 1, n4 + n6 - 1, n5 + 1);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + 2, n5 + n7, n4 + 2, n5 + n7);
                    graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + 3, n5 + n7, n4 + n6 - 1, n5 + n7);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 - 2, n5 + 1, n4 - 2, n5 + n7 - 1);
                    graphics.drawLine(n4 - 1, n5, n4 - 1, n5);
                    graphics.drawLine(n4, n5 - 1, n4, n5 - 1);
                    graphics.drawLine(n4 - 1, n5 + n7, n4 - 1, n5 + n7);
                    graphics.drawLine(n4, n5 + n7 + 1, n4, n5 + n7 + 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 - 1, n5 + 1, n4 - 1, n5 + n7 - 1);
                    graphics.drawLine(n4, n5, n4, n5 + n7);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + 1, n5 - 2, n4 + n6 - 1, n5 - 2);
                    graphics.drawLine(n4 + 1, n5 + n7 + 2, n4 + n6 - 1, n5 + n7 + 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 4);
                    graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                    graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                    graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4, n5 + 4, n4, n5 + n7 - 2);
                graphics.drawLine(n4 + 1, n5 + 3, n4 + 1, n5 + 3);
                graphics.drawLine(n4 + 2, n5 + 2, n4 + n6 - 1, n5 + 2);
                graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                graphics.drawLine(n4 + 2, n5 + n7, n4 + n6 - 1, n5 + n7);
                break;
            }
            case 4: {
                if (n8 == 2 || n8 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4 + n6 - 1, n5 - 1, n4, n5 - 1);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + n6, n5 + 1, n4 + n6, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7, n4, n5 + n7);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4 + n6, n5, n4 + n6, n5);
                        graphics.drawLine(n4 + n6 + 1, n5 + 1, n4 + n6 + 1, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6, n5 + n7, n4 + n6, n5 + n7);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7 + 1, n4, n5 + n7 + 1);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n4 + n6 - 3, n5, n4, n5);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 3);
                        graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4, n5 + n7 - 2);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 3);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 3, n5 + n7 - 1, n4, n5 + n7 - 1);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + n6 - 3, n5 + 1, n4, n5 + 1);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 1, n4, n5 + n7 - 1);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + 3, n4 + n6 - 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7, n4, n5 + n7);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + n6 + 1, n5 + 1, n4 + n6 + 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6, n5, n4 + n6, n5);
                    graphics.drawLine(n4 + n6 - 1, n5 - 1, n4 + n6 - 1, n5 - 1);
                    graphics.drawLine(n4 + n6, n5 + n7, n4 + n6, n5 + n7);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 + 1, n4 + n6 - 1, n5 + n7 + 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6, n5 + 1, n4 + n6, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + n6 - 2, n5 - 2, n4, n5 - 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 + 2, n4, n5 + n7 + 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 4);
                    graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 3, n5, n4, n5);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4 + n6 - 1, n5 + 4, n4 + n6 - 1, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 2, n5 + 3);
                graphics.drawLine(n4 + n6 - 3, n5 + 2, n4, n5 + 2);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 3, n5 + n7, n4, n5 + n7);
                break;
            }
            case 3: {
                if (n8 == 2 || n8 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4, n5 + n7, n4, n5 + n7);
                        graphics.drawLine(n4 - 1, n5 + n7 - 1, n4 - 1, n5);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 1, n5 + n7, n4 + n6 - 2, n5 + n7);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7 - 1, n4 + n6 - 1, n5 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4 + 1, n5 + n7 + 1, n4 + n6 - 2, n5 + n7 + 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7, n4 + n6 - 1, n5 + n7);
                        graphics.drawLine(n4 + n6, n5 + n7 - 1, n4 + n6, n5 - 1);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n4, n5 + n7 - 2, n4, n5 + n7 - 2);
                        graphics.drawLine(n4 - 1, n5 + n7 - 3, n4 - 1, n5);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + n6 - 4, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 3, n5 + n7 - 3, n4 + n6 - 3, n5 - 1);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + n6 - 4, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5 - 1);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6, n5 + n7 - 3, n4 + n6, n5);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 1, n5 + n7 + 1, n4 + n6, n5 + n7 + 1);
                    graphics.drawLine(n4, n5 + n7, n4, n5 + n7);
                    graphics.drawLine(n4 - 1, n5 + n7 - 1, n4 - 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 + 1, n5 + n7, n4 + n6 + 1, n5 + n7);
                    graphics.drawLine(n4 + n6 + 2, n5 + n7 - 1, n4 + n6 + 2, n5 + n7 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 1, n5 + n7, n4 + n6, n5 + n7);
                    graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 + 1, n5 + n7 - 1);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 - 1, n5 + n7 - 2, n4 - 1, n5);
                    graphics.drawLine(n4 + n6 + 2, n5 + n7 - 2, n4 + n6 + 2, n5);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5 - 1);
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5 - 1);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5);
                break;
            }
            default: {
                if (n8 == 2 || n8 == 1) {
                    if (bl) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4, n5 - 1, n4, n5 - 1);
                        graphics.drawLine(n4 - 1, n5, n4 - 1, n5 + n7 - 1);
                        graphics.drawLine(n4 + 1, n5 - 2, n4 + n6 + 1, n5 - 2);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + n6 + 2, n5 - 1, n4 + n6 + 2, n5 + n7 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4 + n6 + 2, n5 - 1, n4 + n6 + 2, n5 - 1);
                        graphics.drawLine(n4 + n6 + 3, n5, n4 + n6 + 3, n5 + n7 - 1);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                        graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
                        graphics.drawLine(n4 + 3, n5, n4 + n6 - 2, n5);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, n5 + n7 - 1);
                        graphics.setColor(this._unselectColor3);
                        graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, n5 + 1);
                        graphics.drawLine(n4 + n6, n5 + 2, n4 + n6, n5 + n7 - 1);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex()) break;
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + 3, n5, n4 + n6 - 2, n5);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, n5 + n7 - 1);
                    graphics.setColor(this._unselectColor3);
                    graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, n5 + 1);
                    graphics.drawLine(n4 + n6, n5 + 2, n4 + n6, n5 + n7 - 1);
                    break;
                }
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 1, n5 - 2, n4 + n6, n5 - 2);
                    graphics.drawLine(n4, n5 - 1, n4, n5 - 1);
                    graphics.drawLine(n4 - 1, n5, n4 - 1, n5);
                    graphics.drawLine(n4 + n6 + 1, n5 - 1, n4 + n6 + 1, n5 - 1);
                    graphics.drawLine(n4 + n6 + 2, n5, n4 + n6 + 2, n5);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 1, n5 - 1, n4 + n6, n5 - 1);
                    graphics.drawLine(n4, n5, n4 + n6 + 1, n5);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 - 1, n5 + 1, n4 - 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 + 2, n5 + 1, n4 + n6 + 2, n5 + n7 - 1);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 3, n5, n4 + n6 - 3, n5);
                    graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
                graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                graphics.drawLine(n4 + 3, n5, n4 + n6 - 3, n5);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
            }
        }
    }

    protected void paintTabBorderMouseOver(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (this.getTabShape() == 1) {
            switch (n2) {
                case 2: {
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        n5 -= 2;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + 4, n4, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + 3, n4 + 1, n5 + 3);
                    graphics.drawLine(n4 + 2, n5 + 2, n4 + 2, n5 + 2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + 2, n5 + n7, n4 + 2, n5 + n7);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 1, n5 + 4, n4 + 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + 2, n5 + 3, n4 + 2, n5 + n7 - 1);
                    break;
                }
                case 4: {
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        n5 -= 2;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 4, n4 + n6 - 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 2, n5 + 3);
                    graphics.drawLine(n4 + n6 - 3, n5 + 2, n4 + n6 - 3, n5 + 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7, n4 + n6 - 3, n5 + n7);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 4, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 3, n5 + 3, n4 + n6 - 3, n5 + n7 - 1);
                    break;
                }
                case 3: {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5 + n7 - 3);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                    graphics.drawLine(n4 + 2, n5 + n7 - 3, n4 + n6 - 2, n5 + n7 - 3);
                    break;
                }
                default: {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 3, n5, n4 + n6 - 3, n5);
                    graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 3, n5 + 1, n4 + n6 - 3, n5 + 1);
                    graphics.drawLine(n4 + 2, n5 + 2, n4 + n6 - 2, n5 + 2);
                    break;
                }
            }
        } else if (this.getTabShape() == 11) {
            switch (n2) {
                case 2: {
                    if (this.getColorTheme() == 4) {
                        if (n3 > this._tabPane.getSelectedIndex()) {
                            n5 -= 2;
                        }
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4, n5 + 4, n4, n5 + n7 - 2);
                        graphics.drawLine(n4 + 1, n5 + 3, n4 + 1, n5 + 3);
                        graphics.drawLine(n4 + 2, n5 + 2, n4 + 2, n5 + 2);
                        graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                        graphics.drawLine(n4 + 2, n5 + n7, n4 + 2, n5 + n7);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 1, n5 + 4, n4 + 1, n5 + n7 - 2);
                        graphics.drawLine(n4 + 2, n5 + 3, n4 + 2, n5 + n7 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4 + 3, n5 + 2, n4 + n6 - 1, n5 + 2);
                        graphics.drawLine(n4 + 3, n5 + n7, n4 + n6 - 1, n5 + n7);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        --n5;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + 3, n4, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 2);
                    graphics.drawLine(n4 + 2, n5 + 1, n4 + n6 - 1, n5 + 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + 2, n5 + n7, n4 + 2, n5 + n7);
                    graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + 3, n5 + n7, n4 + n6 - 1, n5 + n7);
                    break;
                }
                case 4: {
                    if (this.getColorTheme() == 4) {
                        if (n3 > this._tabPane.getSelectedIndex()) {
                            n5 -= 2;
                        }
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4 + n6 - 1, n5 + 4, n4 + n6 - 1, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 2, n5 + 3);
                        graphics.drawLine(n4 + n6 - 3, n5 + 2, n4 + n6 - 3, n5 + 2);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6 - 3, n5 + n7, n4 + n6 - 3, n5 + n7);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 4, n4 + n6 - 2, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 3, n5 + 3, n4 + n6 - 3, n5 + n7 - 1);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4 + n6 - 4, n5 + 2, n4, n5 + 2);
                        graphics.drawLine(n4 + n6 - 4, n5 + n7, n4, n5 + n7);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        --n5;
                    }
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + n6 - 1, n5 + 3, n4 + n6 - 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7, n4, n5 + n7);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 3, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 3, n5 + n7 - 1, n4, n5 + n7 - 1);
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + 2);
                    graphics.drawLine(n4 + n6 - 3, n5 + 1, n4, n5 + 1);
                    break;
                }
                case 3: {
                    if (this.getColorTheme() == 4) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                        graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                        graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5 + n7 - 3);
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                        graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5 + n7 - 3);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                        graphics.drawLine(n4 + 2, n5 + n7 - 3, n4 + n6 - 2, n5 + n7 - 3);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4 + 1, n5, n4 + 1, n5 + n7 - 4);
                        graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 4);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        n4 -= 2;
                    }
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6, n5 + n7 - 3, n4 + n6, n5);
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 3, n4 + n6 - 1, n5);
                    break;
                }
                default: {
                    if (this.getColorTheme() == 4) {
                        graphics.setColor(this._selectColor1);
                        graphics.drawLine(n4 + 3, n5, n4 + n6 - 3, n5);
                        graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                        graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 2);
                        graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + 2);
                        graphics.setColor(this._selectColor2);
                        graphics.drawLine(n4 + 3, n5 + 1, n4 + n6 - 3, n5 + 1);
                        graphics.drawLine(n4 + 2, n5 + 2, n4 + n6 - 2, n5 + 2);
                        graphics.setColor(this._selectColor3);
                        graphics.drawLine(n4 + 1, n5 + 3, n4 + 1, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + 3, n4 + n6 - 1, n5 + n7 - 1);
                        break;
                    }
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        --n4;
                    }
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + 3, n5, n4 + n6 - 2, n5);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, n5 + n7 - 1);
                    graphics.setColor(this._selectColor3);
                    graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, n5 + 1);
                    graphics.drawLine(n4 + n6, n5 + 2, n4 + n6, n5 + n7 - 1);
                }
            }
        }
    }

    protected void paintVsnetTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n2) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5, n4 + n6 - 1, n5);
                    graphics.drawLine(n4, n5, n4, n5 + n7 - 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 2, n5);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5, n4 + n6 - 1, n5);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 2);
                    graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                graphics.drawLine(n4 + 1, n5, n4 + n6 - 3, n5);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5, n4, n5 + n7 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 2);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + 1, n4, n5 + n7 - 1);
                    graphics.drawLine(n4, n5, n4 + n6 - 1, n5);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
            }
        }
    }

    protected void paintRoundedVsnetTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n2) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                    graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 3);
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                graphics.drawLine(n4 + 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                    graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                    graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 3);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                graphics.drawLine(n4 + 1, n5 + 1, n4 + n6 - 3, n5 + 1);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 3);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                    graphics.drawLine(n4, n5 + 2, n4 + 2, n5);
                    graphics.drawLine(n4 + 2, n5, n4 + n6 - 3, n5);
                    graphics.drawLine(n4 + n6 - 3, n5, n4 + n6 - 1, n5 + 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (bl2) {
                    if (n3 > this._tabPane.getSelectedIndex()) {
                        graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
                        break;
                    }
                    if (n3 >= this._tabPane.getSelectedIndex() || n3 == 0) break;
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex() || n3 == this._tabPane.getTabCount() - 1) break;
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 2);
            }
        }
    }

    protected void paintFlatTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        switch (n2) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n4, n5, n6, n7);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n3 > this._tabPane.getSelectedIndex()) {
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawRect(n4, n5, n6, n7 - 1);
                        break;
                    }
                    graphics.drawRect(n4, n5, n6, n7);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.drawRect(n4, n5, n6, n7);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n4 - 1, n5, n6, n7);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                if (n3 > this._tabPane.getSelectedIndex()) {
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawRect(n4 - 1, n5, n6, n7 - 1);
                        break;
                    }
                    graphics.drawRect(n4 - 1, n5, n6, n7);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.drawRect(n4 - 1, n5, n6, n7);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n4, n5 - 1, n6, n7);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawRect(n4, n5 - 1, n6, n7);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawRect(n4, n5, n6, n7);
                    break;
                }
                graphics.setColor(this._unselectColor1);
                graphics.drawRect(n4, n5, n6, n7);
            }
        }
    }

    protected void paintRoundedFlatTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        switch (n2) {
            case 2: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                    graphics.drawLine(n4 + 2, n5 + n7, n4 + n6 - 1, n5 + n7);
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                    graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                        graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 3);
                    } else {
                        graphics.drawLine(n4 + 2, n5 + n7, n4 + n6 - 1, n5 + n7);
                        graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4, n5 + n7 - 2, n4, n5 + n7 - 2);
                        graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                        break;
                    }
                    graphics.drawLine(n4, n5 + n7 - 1, n4, n5 + n7 - 1);
                    graphics.drawLine(n4 + 1, n5 + n7, n4 + 1, n5 + n7);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                graphics.drawLine(n4 + 2, n5 + n7, n4 + n6 - 1, n5 + n7);
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + 1, n5 + n7 - 1);
                break;
            }
            case 4: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                    graphics.drawLine(n4, n5 + n7, n4 + n6 - 3, n5 + n7);
                    graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 2);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 3);
                    } else {
                        graphics.drawLine(n4, n5 + n7, n4 + n6 - 3, n5 + n7);
                        graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 2);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                        break;
                    }
                    graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                graphics.drawLine(n4, n5 + n7, n4 + n6 - 3, n5 + n7);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 2);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                break;
            }
            case 3: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                    graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                    graphics.drawLine(n4 + n6, n5, n4 + n6, n5 + n7 - 3);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 3);
                    } else {
                        graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                        graphics.drawLine(n4 + n6, n5, n4 + n6, n5 + n7 - 3);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                        break;
                    }
                    graphics.drawLine(n4 + n6 - 1, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
                graphics.drawLine(n4 + n6, n5, n4 + n6, n5 + n7 - 3);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                break;
            }
            default: {
                if (bl) {
                    graphics.setColor(this._selectColor1);
                    graphics.drawLine(n4, n5 + n7 - 1, n4, n5 + 2);
                    graphics.drawLine(n4 + 2, n5, n4 + n6 - 2, n5);
                    graphics.drawLine(n4 + n6, n5 + 2, n4 + n6, n5 + n7 - 1);
                    graphics.setColor(this._selectColor2);
                    graphics.drawLine(n4, n5 + 2, n4 + 2, n5);
                    graphics.drawLine(n4 + n6 - 2, n5, n4 + n6, n5 + 2);
                    break;
                }
                if (n3 > this._tabPane.getSelectedIndex()) {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + n7 - 1, n4, n5 + 2);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4 + 2, n5, n4 + n6 - 3, n5);
                        graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                    } else {
                        graphics.drawLine(n4 + 2, n5, n4 + n6 - 2, n5);
                        graphics.drawLine(n4 + n6, n5 + 2, n4 + n6, n5 + n7 - 1);
                    }
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4, n5 + 2, n4 + 2, n5);
                    if (n3 == this._tabPane.getTabCount() - 1) {
                        graphics.drawLine(n4 + n6 - 3, n5, n4 + n6 - 1, n5 + 2);
                        break;
                    }
                    graphics.drawLine(n4 + n6 - 2, n5, n4 + n6, n5 + 2);
                    break;
                }
                if (n3 >= this._tabPane.getSelectedIndex()) break;
                graphics.setColor(this._unselectColor1);
                graphics.drawLine(n4, n5 + n7 - 1, n4, n5 + 2);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 2, n5);
                graphics.drawLine(n4 + n6, n5 + 2, n4 + n6, n5 + n7 - 1);
                graphics.setColor(this._unselectColor2);
                graphics.drawLine(n4, n5 + 2, n4 + 2, n5);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6, n5 + 2);
            }
        }
    }

    protected void paintBoxTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        if (bl) {
            graphics.setColor(this._selectColor1);
            graphics.drawLine(n4, n5, n4 + n6 - 2, n5);
            graphics.drawLine(n4, n5, n4, n5 + n7 - 2);
            graphics.setColor(this._selectColor2);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 1);
            graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
        } else if (n3 != this._tabPane.getSelectedIndex() - 1) {
            switch (n2) {
                case 2: 
                case 4: {
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4 + 2, n5 + n7, n4 + n6 - 2, n5 + n7);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + 2, n5 + n7 + 1, n4 + n6 - 2, n5 + n7 + 1);
                    break;
                }
                default: {
                    if (bl2) {
                        graphics.setColor(this._unselectColor1);
                        graphics.drawLine(n4 + n6, n5 + 2, n4 + n6, n5 + n7 - 2);
                        graphics.setColor(this._unselectColor2);
                        graphics.drawLine(n4 + n6 + 1, n5 + 2, n4 + n6 + 1, n5 + n7 - 2);
                        break;
                    }
                    graphics.setColor(this._unselectColor1);
                    graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 2);
                    graphics.setColor(this._unselectColor2);
                    graphics.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + n7 - 2);
                }
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        switch (this.getTabShape()) {
            case 3: {
                this.paintButtonTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 8: {
                this.paintExcelTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 1: {
                this.paintDefaultTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 11: {
                if (!bl) break;
                this.paintDefaultTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 2: 
            case 9: {
                this.paintVsnetTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            case 5: 
            case 10: {
                this.paintFlatTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl);
                break;
            }
            default: {
                this.paintOffice2003TabBackground(graphics, n2, n3, n4, n5, n6, n7, bl);
            }
        }
    }

    protected void paintOffice2003TabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n2) {
            case 2: {
                if (n3 != 0 && !bl) {
                    int[] nArray = new int[]{n4 + n6, n4 + 4, n4 + 2, n4, n4, n4 + 3, n4 + n6};
                    int[] nArray2 = new int[]{n5, n5, n5 + 2, n5 + 5, n5 + n7 - 5, n5 + n7 - 2, n5 + n7 - 2};
                    int n8 = nArray2.length;
                    this.tabRegion = new Polygon(nArray, nArray2, n8);
                    break;
                }
                int[] nArray = new int[]{n4 + n6, n4 + 2, n4, n4, n4 + 3, n4 + n6};
                int[] nArray3 = new int[]{n5 - n6 + 2 + 2, n5 + 2, n5 + 5, n5 + n7 - 5, n5 + n7 - 2, n5 + n7 - 2};
                int n9 = nArray3.length;
                this.tabRegion = new Polygon(nArray, nArray3, n9);
                break;
            }
            case 4: {
                if (n3 != 0 && !bl) {
                    int[] nArray = new int[]{n4, n4 + n6 - 4, n4 + n6 - 3, n4 + n6 - 1, n4 + n6 - 1, n4 + n6 - 3, n4};
                    int[] nArray4 = new int[]{n5, n5, n5 + 2, n5 + 5, n5 + n7 - 5, n5 + n7 - 2, n5 + n7 - 2};
                    int n10 = nArray4.length;
                    this.tabRegion = new Polygon(nArray, nArray4, n10);
                    break;
                }
                int[] nArray = new int[]{n4, n4 + n6 - 3, n4 + n6 - 1, n4 + n6 - 1, n4 + n6 - 3, n4};
                int[] nArray5 = new int[]{n5 - n6 + 2 + 2, n5 + 2, n5 + 5, n5 + n7 - 5, n5 + n7 - 2, n5 + n7 - 2};
                int n11 = nArray5.length;
                this.tabRegion = new Polygon(nArray, nArray5, n11);
                break;
            }
            case 3: {
                if (bl2) {
                    int[] nArray = new int[]{n4 - (n3 == 0 || bl ? n7 - 5 : 0), n4, n4 + 4, n4 + n6 - 3, n4 + n6 - 1, n4 + n6 - 1};
                    int[] nArray6 = new int[]{n5, n5 + n7 - 5, n5 + n7 - 1, n5 + n7 - 1, n5 + n7 - 5, n5};
                    int n12 = nArray6.length;
                    this.tabRegion = new Polygon(nArray, nArray6, n12);
                    break;
                }
                int[] nArray = new int[]{n4, n4, n4 + 2, n4 + n6 - 5, n4 + n6 - 1, n4 + n6 - 1 + (n3 == 0 || bl ? n7 - 5 : 0)};
                int[] nArray7 = new int[]{n5, n5 + n7 - 5, n5 + n7 - 1, n5 + n7 - 1, n5 + n7 - 5, n5};
                int n13 = nArray7.length;
                this.tabRegion = new Polygon(nArray, nArray7, n13);
                break;
            }
            default: {
                if (bl2) {
                    int[] nArray = new int[]{n4 - (n3 == 0 || bl ? n7 - 5 : 0), n4, n4 + 4, n4 + n6 - 3, n4 + n6 - 1, n4 + n6 - 1};
                    int[] nArray8 = new int[]{n5 + n7, n5 + 3, n5 + 1, n5 + 1, n5 + 3, n5 + n7};
                    int n14 = nArray8.length;
                    this.tabRegion = new Polygon(nArray, nArray8, n14);
                    break;
                }
                int[] nArray = new int[]{n4, n4, n4 + 2, n4 + n6 - 5, n4 + n6 - 1, n4 + n6 - 1 + (n3 == 0 || bl ? n7 - 5 : 0)};
                int[] nArray9 = new int[]{n5 + n7, n5 + 3, n5 + 1, n5 + 1, n5 + 3, n5 + n7};
                int n15 = nArray9.length;
                this.tabRegion = new Polygon(nArray, nArray9, n15);
            }
        }
    }

    protected void paintExcelTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        switch (n2) {
            case 2: {
                if (!bl) {
                    if (bl2 && n3 == 0 || !bl2 && n3 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n4 + n6, n4, n4, n4 + n6};
                        int[] nArray2 = new int[]{n5 - 5, n5 + 5, n5 + n7 - 5, n5 + n7 + 6};
                        int n8 = nArray2.length;
                        this.tabRegion = new Polygon(nArray, nArray2, n8);
                        break;
                    }
                    int[] nArray = new int[]{n4 + n6, n4 + 9, n4, n4, n4 + n6};
                    int[] nArray3 = new int[]{n5 + 8, n5 + 2, n5 + 6, n5 + n7 - 5, n5 + n7 + 6};
                    int n9 = nArray3.length;
                    this.tabRegion = new Polygon(nArray, nArray3, n9);
                    break;
                }
                int[] nArray = new int[]{n4 + n6, n4, n4, n4 + n6};
                int[] nArray4 = new int[]{n5 - 5, n5 + 5, n5 + n7 - 5, n5 + n7 + 6};
                int n10 = nArray4.length;
                this.tabRegion = new Polygon(nArray, nArray4, n10);
                break;
            }
            case 4: {
                if (!bl) {
                    if (bl2 && n3 == 0 || !bl2 && n3 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n4, n4 + n6 - 1, n4 + n6 - 1, n4};
                        int[] nArray5 = new int[]{n5 - 5, n5 + 5, n5 + n7 - 5, n5 + n7 + 6};
                        int n11 = nArray5.length;
                        this.tabRegion = new Polygon(nArray, nArray5, n11);
                        break;
                    }
                    int[] nArray = new int[]{n4, n4 + n6 - 10, n4 + n6 - 1, n4 + n6 - 1, n4};
                    int[] nArray6 = new int[]{n5 + 8, n5 + 2, n5 + 6, n5 + n7 - 5, n5 + n7 + 6};
                    int n12 = nArray6.length;
                    this.tabRegion = new Polygon(nArray, nArray6, n12);
                    break;
                }
                int[] nArray = new int[]{n4, n4 + n6 - 1, n4 + n6 - 1, n4};
                int[] nArray7 = new int[]{n5 - 5, n5 + 5, n5 + n7 - 4, n5 + n7 + 6};
                int n13 = nArray7.length;
                this.tabRegion = new Polygon(nArray, nArray7, n13);
                break;
            }
            case 3: {
                if (!bl) {
                    if (bl2 && n3 == 0 || !bl2 && n3 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n4 - 5, n4 + 5, n4 + n6 - 5, n4 + n6 + 5};
                        int[] nArray8 = new int[]{n5, n5 + n7 - 1, n5 + n7 - 1, n5};
                        int n14 = nArray8.length;
                        this.tabRegion = new Polygon(nArray, nArray8, n14);
                        break;
                    }
                    int[] nArray = new int[]{n4 + 7, n4 + 1, n4 + 5, n4 + n6 - 5, n4 + n6 + 5};
                    int[] nArray9 = new int[]{n5, n5 + n7 - 10, n5 + n7 - 1, n5 + n7 - 1, n5};
                    int n15 = nArray9.length;
                    this.tabRegion = new Polygon(nArray, nArray9, n15);
                    break;
                }
                int[] nArray = new int[]{n4 - 5, n4 + 5, n4 + n6 - 5, n4 + n6 + 5};
                int[] nArray10 = new int[]{n5, n5 + n7 - 1, n5 + n7 - 1, n5};
                int n16 = nArray10.length;
                this.tabRegion = new Polygon(nArray, nArray10, n16);
                break;
            }
            default: {
                if (!bl) {
                    if (bl2 && n3 == 0 || !bl2 && n3 == this._tabPane.getTabCount() - 1) {
                        int[] nArray = new int[]{n4 - 6, n4 + 5, n4 + n6 - 5, n4 + n6 + 5};
                        int[] nArray11 = new int[]{n5 + n7, n5, n5, n5 + n7};
                        int n17 = nArray11.length;
                        this.tabRegion = new Polygon(nArray, nArray11, n17);
                        break;
                    }
                    int[] nArray = new int[]{n4 + 7, n4 + 1, n4 + 6, n4 + n6 - 5, n4 + n6 + 5};
                    int[] nArray12 = new int[]{n5 + n7, n5 + 9, n5, n5, n5 + n7};
                    int n18 = nArray12.length;
                    this.tabRegion = new Polygon(nArray, nArray12, n18);
                    break;
                }
                int[] nArray = new int[]{n4 - 6, n4 + 5, n4 + n6 - 5, n4 + n6 + 5};
                int[] nArray13 = new int[]{n5 + n7, n5, n5, n5 + n7};
                int n19 = nArray13.length;
                this.tabRegion = new Polygon(nArray, nArray13, n19);
            }
        }
    }

    protected void paintDefaultTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        switch (n2) {
            case 2: {
                if (bl) {
                    int[] nArray = new int[]{++n4 + n6, n4, n4 - 2, n4 - 2, n4 + n6};
                    int[] nArray2 = new int[]{n5 - 1, n5 - 1, n5 + 1, n5 + n7 + 2, n5 + n7 + 2};
                    int n8 = nArray2.length;
                    this.tabRegion = new Polygon(nArray, nArray2, n8);
                    break;
                }
                if (n3 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n4 + n6, n4 + 2, n4, n4, n4 + n6};
                    int[] nArray3 = new int[]{++n5 + 1, n5 + 1, n5 + 3, n5 + n7 - 1, n5 + n7 - 1};
                    int n9 = nArray3.length;
                    this.tabRegion = new Polygon(nArray, nArray3, n9);
                    break;
                }
                int[] nArray = new int[]{n4 + n6, n4 + 2, n4, n4, n4 + n6};
                int[] nArray4 = new int[]{n5 + 1, n5 + 1, n5 + 3, n5 + n7 - 2, n5 + n7 - 2};
                int n10 = nArray4.length;
                this.tabRegion = new Polygon(nArray, nArray4, n10);
                break;
            }
            case 4: {
                if (bl) {
                    int[] nArray = new int[]{n4, n4 + n6 - 1, n4 + n6, n4 + n6, n4};
                    int[] nArray5 = new int[]{n5 - 1, n5 - 1, n5 + 1, n5 + n7 + 2, n5 + n7 + 2};
                    int n11 = nArray5.length;
                    this.tabRegion = new Polygon(nArray, nArray5, n11);
                    break;
                }
                if (n3 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n4, n4 + n6 - 3, n4 + n6 - 1, n4 + n6 - 1, n4};
                    int[] nArray6 = new int[]{++n5 + 1, n5 + 1, n5 + 3, n5 + n7 - 1, n5 + n7 - 1};
                    int n12 = nArray6.length;
                    this.tabRegion = new Polygon(nArray, nArray6, n12);
                    break;
                }
                int[] nArray = new int[]{n4, n4 + n6 - 2, n4 + n6 - 1, n4 + n6 - 1, n4};
                int[] nArray7 = new int[]{n5 + 1, n5 + 1, n5 + 3, n5 + n7 - 2, n5 + n7 - 2};
                int n13 = nArray7.length;
                this.tabRegion = new Polygon(nArray, nArray7, n13);
                break;
            }
            case 3: {
                if (bl) {
                    int[] nArray = new int[]{n4, n4, n4 + 2, n4 + n6 + 2, n4 + n6 + 2};
                    int[] nArray8 = new int[]{n5 + n7, n5, n5 - 2, n5 - 2, n5 + n7};
                    int n14 = nArray8.length;
                    this.tabRegion = new Polygon(nArray, nArray8, n14);
                    break;
                }
                int[] nArray = new int[]{n4 + 1, n4 + 1, n4 + 1, n4 + n6 - 1, n4 + n6 - 1};
                int[] nArray9 = new int[]{n5 + n7 - 1, n5 + 2, n5, n5, n5 + n7 - 1};
                int n15 = nArray9.length;
                this.tabRegion = new Polygon(nArray, nArray9, n15);
                break;
            }
            default: {
                if (bl) {
                    int[] nArray = new int[]{n4, n4, n4 + 2, n4 + n6 + 2, n4 + n6 + 2};
                    int[] nArray10 = new int[]{n5 + n7 + 1, n5, n5 - 2, n5 - 2, n5 + n7 + 1};
                    int n16 = nArray10.length;
                    this.tabRegion = new Polygon(nArray, nArray10, n16);
                    break;
                }
                int[] nArray = new int[]{n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 1, n4 + n6 - 1};
                int[] nArray11 = new int[]{n5 + n7, n5 + 2, n5, n5, n5 + n7};
                int n17 = nArray11.length;
                this.tabRegion = new Polygon(nArray, nArray11, n17);
            }
        }
    }

    protected void paintTabBackgroundMouseOver(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Color color, Color color2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        switch (n2) {
            case 2: {
                Polygon polygon;
                if (n3 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n4 + n6, n4 + 2, n4, n4, n4 + 2, n4 + n6};
                    int[] nArray2 = new int[]{n5 + 2, n5 + 2, n5 + 4, n5 + n7 - 1, n5 + n7, n5 + n7};
                    int n8 = nArray2.length;
                    polygon = new Polygon(nArray, nArray2, n8);
                } else {
                    int[] nArray = new int[]{n4 + n6, n4 + 2, n4, n4, n4 + 2, n4 + n6};
                    int[] nArray3 = new int[]{n5 + 1, n5 + 1, n5 + 3, n5 + n7 - 3, n5 + n7 - 2, n5 + n7 - 2};
                    int n9 = nArray3.length;
                    polygon = new Polygon(nArray, nArray3, n9);
                }
                JideSwingUtilities.fillGradient(graphics2D, polygon, color, color2, false);
                break;
            }
            case 4: {
                Polygon polygon;
                if (n3 < this._tabPane.getSelectedIndex()) {
                    int[] nArray = new int[]{n4, n4 + n6 - 3, n4 + n6 - 1, n4 + n6 - 1, n4 + n6 - 3, n4};
                    int[] nArray4 = new int[]{n5 + 2, n5 + 2, n5 + 4, n5 + n7 - 1, n5 + n7, n5 + n7};
                    int n10 = nArray4.length;
                    polygon = new Polygon(nArray, nArray4, n10);
                } else {
                    int[] nArray = new int[]{n4, n4 + n6 - 2, n4 + n6 - 1, n4 + n6 - 1, n4 + n6 - 3, n4};
                    int[] nArray5 = new int[]{n5 + 1, n5 + 1, n5 + 3, n5 + n7 - 3, n5 + n7 - 2, n5 + n7 - 2};
                    int n11 = nArray5.length;
                    polygon = new Polygon(nArray, nArray5, n11);
                }
                JideSwingUtilities.fillGradient(graphics2D, polygon, color2, color, false);
                break;
            }
            case 3: {
                int[] nArray = new int[]{n4 + 1, n4 + 1, n4 + 1, n4 + n6 - 1, n4 + n6 - 1};
                int[] nArray6 = new int[]{n5 + n7 - 2, n5 + 2, n5, n5, n5 + n7 - 2};
                int n12 = nArray6.length;
                Polygon polygon = new Polygon(nArray, nArray6, n12);
                JideSwingUtilities.fillGradient(graphics2D, polygon, color2, color, true);
                break;
            }
            default: {
                int[] nArray = new int[]{n4 + 1, n4 + 1, n4 + 3, n4 + n6 - 1, n4 + n6 - 1};
                int[] nArray7 = new int[]{n5 + n7, n5 + 2, n5, n5, n5 + n7};
                int n13 = nArray7.length;
                Polygon polygon = new Polygon(nArray, nArray7, n13);
                JideSwingUtilities.fillGradient(graphics2D, polygon, color, color2, true);
            }
        }
    }

    protected void paintVsnetTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int[] nArray;
        int[] nArray2;
        switch (n2) {
            case 2: {
                nArray2 = new int[]{n4 + 1, n4 + 1, n4 + n6, n4 + n6};
                nArray = new int[]{n5 + n7 - 1, n5 + 1, n5 + 1, n5 + n7 - 1};
                break;
            }
            case 4: {
                nArray2 = new int[]{n4, n4, n4 + n6 - 1, n4 + n6 - 1};
                nArray = new int[]{n5 + n7 - 1, n5 + 1, n5 + 1, n5 + n7 - 1};
                break;
            }
            case 3: {
                nArray2 = new int[]{n4 + 1, n4 + 1, n4 + n6 - 1, n4 + n6 - 1};
                nArray = new int[]{n5 + n7 - 1, n5, n5, n5 + n7 - 1};
                break;
            }
            default: {
                nArray2 = new int[]{n4 + 1, n4 + 1, n4 + n6 - 1, n4 + n6 - 1};
                nArray = new int[]{n5 + n7, n5 + 1, n5 + 1, n5 + n7};
            }
        }
        int n8 = nArray.length;
        this.tabRegion = new Polygon(nArray2, nArray, n8);
    }

    protected void paintFlatTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        switch (n2) {
            case 2: {
                int[] nArray = new int[]{n4 + 1, n4 + 1, n4 + n6, n4 + n6};
                int[] nArray2 = new int[]{n5 + n7, n5 + 1, n5 + 1, n5 + n7};
                int n8 = nArray2.length;
                this.tabRegion = new Polygon(nArray, nArray2, n8);
                break;
            }
            case 4: {
                int[] nArray = new int[]{n4, n4, n4 + n6 - 1, n4 + n6 - 1};
                int[] nArray3 = new int[]{n5 + n7, n5 + 1, n5 + 1, n5 + n7};
                int n9 = nArray3.length;
                this.tabRegion = new Polygon(nArray, nArray3, n9);
                break;
            }
            case 3: {
                int[] nArray = new int[]{n4 + 1, n4 + 1, n4 + n6, n4 + n6};
                int[] nArray4 = new int[]{n5 + n7 - 1, n5, n5, n5 + n7 - 1};
                int n10 = nArray4.length;
                this.tabRegion = new Polygon(nArray, nArray4, n10);
                break;
            }
            default: {
                int[] nArray = new int[]{n4, n4 + 1, n4 + n6, n4 + n6};
                int[] nArray5 = new int[]{n5 + n7, n5 + 1, n5 + 1, n5 + n7};
                int n11 = nArray5.length;
                this.tabRegion = new Polygon(nArray, nArray5, n11);
            }
        }
    }

    protected void paintButtonTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int[] nArray = new int[]{n4, n4, n4 + n6, n4 + n6};
        int[] nArray2 = new int[]{n5 + n7, n5, n5, n5 + n7};
        int n8 = nArray2.length;
        this.tabRegion = new Polygon(nArray, nArray2, n8);
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        int n4 = this._tabPane.getWidth();
        int n5 = this._tabPane.getHeight();
        Insets insets = this._tabPane.getInsets();
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        Dimension dimension = new Dimension(0, 0);
        Dimension dimension2 = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            dimension = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            dimension2 = this._tabTrailingComponent.getPreferredSize();
        }
        switch (n2) {
            case 2: {
                int n10 = this.calculateTabAreaWidth(n2, this._runCount, this._maxTabWidth);
                if (this.isTabLeadingComponentVisible() && dimension.width > n10) {
                    n10 = dimension.width;
                }
                if (this.isTabTrailingComponentVisible() && dimension2.width > n10) {
                    n10 = dimension2.width;
                }
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(graphics, new Rectangle(n6, n7, n10, n9), n2);
                }
                n8 -= (n6 += n10) - insets.left;
                break;
            }
            case 4: {
                int n11 = this.calculateTabAreaWidth(n2, this._runCount, this._maxTabWidth);
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(graphics, new Rectangle(n6, n7, n11, n9), n2);
                }
                n8 -= n11;
                break;
            }
            case 3: {
                int n12 = this.calculateTabAreaHeight(n2, this._runCount, this._maxTabHeight);
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(graphics, new Rectangle(n6, n7, n8, n12), n2);
                }
                n9 -= n12;
                break;
            }
            default: {
                int n13 = this.calculateTabAreaHeight(n2, this._runCount, this._maxTabHeight);
                if (this.isTabLeadingComponentVisible() && dimension.height > n13) {
                    n13 = dimension.height;
                }
                if (this.isTabTrailingComponentVisible() && n13 < dimension2.height) {
                    n13 = dimension2.height;
                }
                if (this.scrollableTabLayoutEnabled()) {
                    this.paintTabAreaBackground(graphics, new Rectangle(n6, n7, n8, n13), n2);
                }
                n9 -= (n7 += n13) - insets.top;
            }
        }
        if (this.getTabShape() != 3) {
            this.paintContentBorder(graphics, n6, n7, n8, n9);
            switch (n2) {
                case 2: {
                    this.paintContentBorderLeftEdge(graphics, n2, n3, n6, n7, n8, n9);
                    break;
                }
                case 4: {
                    this.paintContentBorderRightEdge(graphics, n2, n3, n6, n7, n8, n9);
                    break;
                }
                case 3: {
                    this.paintContentBorderBottomEdge(graphics, n2, n3, n6, n7, n8, n9);
                    break;
                }
                default: {
                    this.paintContentBorderTopEdge(graphics, n2, n3, n6, n7, n8, n9);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this._tabPane.isOpaque()) {
            graphics.setColor(this._tabBackground);
            graphics.fillRect(n2, n3, n4, n5);
        }
    }

    protected Color getBorderEdgeColor() {
        if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
            return this._shadow;
        }
        return this._lightHighlight;
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n3 < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(n3, this._calcRect);
        graphics.setColor(this.getBorderEdgeColor());
        if (n2 != 1 || n3 < 0 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4, n5, n4 + n6 - 1, n5);
        } else {
            graphics.drawLine(n4, n5, rectangle.x, n5);
            if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
                if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n5, rectangle.x + rectangle.width - 1, n5);
                    graphics.drawLine(rectangle.x + rectangle.width, n5, n4 + n6 - 1, n5);
                } else {
                    graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 1, n5);
                }
            } else if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.setColor(this._darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width - 1, n5, rectangle.x + rectangle.width - 1, n5);
                graphics.setColor(this._lightHighlight);
                graphics.drawLine(rectangle.x + rectangle.width, n5, n4 + n6 - 1, n5);
            } else {
                graphics.setColor(this._selectedColor == null ? this._tabPane.getBackground() : this._selectedColor);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 1, n5);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n3 < 0) {
            return;
        }
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(n3, this._calcRect);
        if (n2 != 3 || n3 < 0 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.setColor(this.getBorderEdgeColor());
            graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
        } else if (!this.getBorderEdgeColor().equals(this._lightHighlight)) {
            graphics.setColor(this.getBorderEdgeColor());
            graphics.drawLine(n4, n5 + n7 - 1, rectangle.x - 1, n5 + n7 - 1);
            graphics.drawLine(rectangle.x, n5 + n7 - 1, rectangle.x, n5 + n7 - 1);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width - 1, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
            }
        } else {
            graphics.setColor(this._darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, rectangle.x - 1, n5 + n7 - 1);
            graphics.setColor(this._lightHighlight);
            graphics.drawLine(rectangle.x, n5 + n7 - 1, rectangle.x, n5 + n7 - 1);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.setColor(this._darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width - 1, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
            }
        }
    }

    protected void ensureCurrentLayout() {
        if (!this._tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this._tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    private void updateCloseButtons() {
        boolean bl = this._tabPane.getComponentOrientation().isLeftToRight();
        if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab()) {
            for (int i2 = 0; i2 < this._closeButtons.length; ++i2) {
                Rectangle rectangle;
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (i2 != this._tabPane.getSelectedIndex()) {
                        this._closeButtons[i2].setBounds(0, 0, 0, 0);
                        continue;
                    }
                } else if (i2 >= this._rects.length) {
                    this._closeButtons[i2].setBounds(0, 0, 0, 0);
                    continue;
                }
                if (!this._tabPane.isTabClosableAt(i2)) {
                    this._closeButtons[i2].setBounds(0, 0, 0, 0);
                    continue;
                }
                Dimension dimension = this._closeButtons[i2].getPreferredSize();
                if (this._closeButtonAlignment == 11) {
                    if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                        if (bl) {
                            rectangle = new Rectangle(this._rects[i2].x + this._rects[i2].width - dimension.width - this._closeButtonRightMargin, this._rects[i2].y + (this._rects[i2].height - dimension.height) / 2, dimension.width, dimension.height);
                            rectangle.x -= this.getTabGap();
                            if (i2 > this._tabPane.getSelectedIndex() && (9 == this._tabPane.getTabShape() || 2 == this._tabPane.getTabShape())) {
                                --rectangle.x;
                            }
                        } else {
                            rectangle = new Rectangle(this._rects[i2].x + this._closeButtonLeftMargin + this.getTabGap(), this._rects[i2].y + (this._rects[i2].height - dimension.height) / 2, dimension.width, dimension.height);
                        }
                    } else {
                        rectangle = new Rectangle(this._rects[i2].x + (this._rects[i2].width - dimension.width) / 2, this._rects[i2].y + this._rects[i2].height - dimension.height - this._closeButtonRightMargin, dimension.width, dimension.height);
                        rectangle.y -= this.getTabGap();
                    }
                } else if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
                    if (bl) {
                        rectangle = new Rectangle(this._rects[i2].x + this._closeButtonLeftMargin + this.getTabGap(), this._rects[i2].y + (this._rects[i2].height - dimension.height) / 2, dimension.width, dimension.height);
                    } else {
                        rectangle = new Rectangle(this._rects[i2].x + this._rects[i2].width - dimension.width - this._closeButtonRightMargin, this._rects[i2].y + (this._rects[i2].height - dimension.height) / 2, dimension.width, dimension.height);
                        rectangle.x -= this.getTabGap();
                    }
                } else {
                    rectangle = this._tabPane.getTabPlacement() == 2 ? new Rectangle(this._rects[i2].x + (this._rects[i2].width - dimension.width) / 2, this._rects[i2].y + this._closeButtonLeftMargin, dimension.width, dimension.height) : new Rectangle(this._rects[i2].x + (this._rects[i2].width - dimension.width) / 2 - 2, this._rects[i2].y + this._closeButtonLeftMargin, dimension.width, dimension.height);
                }
                if (this._closeButtons[i2] instanceof JideTabbedPane.NoFocusButton) {
                    ((JideTabbedPane.NoFocusButton)this._closeButtons[i2]).setIndex(i2);
                }
                if (!rectangle.equals(this._closeButtons[i2].getBounds())) {
                    this._closeButtons[i2].setBounds(rectangle);
                }
                if (this._tabPane.getSelectedIndex() == i2) {
                    this._closeButtons[i2].setBackground(this._selectedColor == null ? this._tabPane.getBackgroundAt(i2) : this._selectedColor);
                    continue;
                }
                this._closeButtons[i2].setBackground(this._tabPane.getBackgroundAt(i2));
            }
        }
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n2) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n2, rectangle);
    }

    @Override
    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this._runCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        void var10_14;
        Component[] componentArray;
        this.ensureCurrentLayout();
        Point point = new Point(n2, n3);
        if (!this._tabPane.isShowTabArea()) {
            return -1;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n2, n3, point);
        }
        int n4 = this._tabPane.getTabCount();
        boolean bl = this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3;
        boolean bl2 = bl && !this._tabPane.getComponentOrientation().isLeftToRight();
        int n5 = bl2 ? 0 : Integer.MAX_VALUE;
        for (Component component : componentArray = this._tabPane.getComponents()) {
            if (!(component instanceof JideTabbedPane.NoFocusButton) || !component.isVisible()) continue;
            Rectangle rectangle = component.getBounds();
            if (bl && rectangle.x != 0) {
                if (bl2) {
                    n5 = Math.max(n5, rectangle.x);
                    continue;
                }
                n5 = Math.min(n5, rectangle.x);
                continue;
            }
            if (bl || rectangle.y == 0) continue;
            n5 = Math.min(n5, rectangle.y);
        }
        if (this._tabPane.getTabTrailingComponent() != null && this._tabPane.getTabTrailingComponent().isVisible()) {
            Rectangle i2 = this._tabPane.getTabTrailingComponent().getBounds();
            if (bl && i2.x != 0) {
                n5 = bl2 ? Math.max(n5, i2.x) : Math.min(n5, i2.x);
            } else if (!bl && i2.y != 0) {
                n5 = Math.min(n5, i2.y);
            }
        }
        if (bl ? bl2 && n2 <= n5 || !bl2 && n2 >= n5 : n3 >= n5) {
            return -1;
        }
        boolean bl3 = false;
        while (var10_14 < n4) {
            if (this._rects[var10_14].contains(point.x, point.y)) {
                return (int)var10_14;
            }
            ++var10_14;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n2, Rectangle rectangle) {
        if (this._rects.length == 0) {
            return null;
        }
        if (n2 > this._rects.length - 1) {
            n2 = this._rects.length - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        rectangle.width = this._rects[n2].width;
        rectangle.height = this._rects[n2].height;
        if (this.scrollableTabLayoutEnabled()) {
            int n3 = this._tabPane.getTabPlacement();
            Point point = this._tabScroller.viewport.getLocation();
            Point point2 = this._tabScroller.viewport.getViewPosition();
            rectangle.x = this._rects[n2].x + point.x - ((n3 == 1 || n3 == 3) && !this._tabPane.getComponentOrientation().isLeftToRight() ? -point2.x : point2.x);
            rectangle.y = this._rects[n2].y + point.y - point2.y;
        } else {
            rectangle.x = this._rects[n2].x;
            rectangle.y = this._rects[n2].y;
        }
        return rectangle;
    }

    public int getTabAtLocation(int n2, int n3) {
        this.ensureCurrentLayout();
        int n4 = this._tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this._rects[i2].contains(n2, n3)) continue;
            return i2;
        }
        return -1;
    }

    public boolean isEmptyTabArea(int n2, int n3) {
        int n4 = this._tabPane.getTabCount();
        if (this.getTabAtLocation(n2, n3) >= 0 || n4 <= 0) {
            return false;
        }
        int n5 = this._tabPane.getTabPlacement();
        return n5 == 1 || n5 == 3 ? this._rects[0].contains(this._rects[0].x + 1, n3) : this._rects[0].contains(n2, this._rects[0].y + 1);
    }

    private int getClosestTab(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = n5 = Math.min(this._rects.length, this._tabPane.getTabCount());
        int n8 = this._tabPane.getTabPlacement();
        boolean bl = n8 == 1 || n8 == 3;
        int n9 = bl ? n2 : n3;
        Rectangle[] rectangleArray = new Rectangle[this._rects.length];
        boolean bl2 = false;
        if (!bl || this._tabPane.getComponentOrientation().isLeftToRight()) {
            System.arraycopy(this._rects, 0, rectangleArray, 0, this._rects.length);
        } else {
            bl2 = true;
            for (n4 = 0; n4 < this._rects.length; ++n4) {
                rectangleArray[n4] = new Rectangle(this._rects[this._rects.length - 1 - n4]);
                if (n4 != this._rects.length - 1) continue;
                rectangleArray[n4].width += this._additionalWidth;
            }
        }
        while (n6 != n7) {
            int n10;
            int n11;
            n4 = n7 + n6 >> 1;
            if (bl) {
                n11 = rectangleArray[n4].x;
                n10 = n11 + rectangleArray[n4].width;
            } else {
                n11 = rectangleArray[n4].y;
                n10 = n11 + rectangleArray[n4].height;
            }
            if (n9 < n11) {
                n7 = n4;
                if (n6 != n7) continue;
                int n12 = Math.max(0, n4 - 1);
                return bl2 ? rectangleArray.length - 1 - n12 : n12;
            }
            if (n9 >= n10) {
                n6 = n4;
                if (n7 - n6 > 1) continue;
                int n13 = Math.max(n4 + 1, n5 - 1);
                return bl2 ? rectangleArray.length - 1 - n13 : n13;
            }
            return bl2 ? rectangleArray.length - 1 - n4 : n4;
        }
        return bl2 ? rectangleArray.length - 1 - n6 : n6;
    }

    private Point translatePointToTabPanel(int n2, int n3, Point point) {
        Point point2 = this._tabScroller.viewport.getLocation();
        Point point3 = this._tabScroller.viewport.getViewPosition();
        point.x = n2 - point2.x + point3.x;
        point.y = n3 - point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this._tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n2) {
        int n3 = this._rects.length;
        if (n2 != n3) {
            Rectangle[] rectangleArray = new Rectangle[n2];
            System.arraycopy(this._rects, 0, rectangleArray, 0, Math.min(n3, n2));
            this._rects = rectangleArray;
            for (int i2 = n3; i2 < n2; ++i2) {
                this._rects[i2] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int n2 = this._tabRuns.length;
        int[] nArray = new int[n2 + 10];
        System.arraycopy(this._tabRuns, 0, nArray, 0, this._runCount);
        this._tabRuns = nArray;
    }

    protected int getRunForTab(int n2, int n3) {
        for (int i2 = 0; i2 < this._runCount; ++i2) {
            int n4 = this._tabRuns[i2];
            int n5 = this.lastTabInRun(n2, i2);
            if (n3 < n4 || n3 > n5) continue;
            return i2;
        }
        return 0;
    }

    protected int lastTabInRun(int n2, int n3) {
        int n4;
        if (this._runCount == 1) {
            return n2 - 1;
        }
        int n5 = n4 = n3 == this._runCount - 1 ? 0 : n3 + 1;
        if (this._tabRuns[n4] == 0) {
            return n2 - 1;
        }
        return this._tabRuns[n4] - 1;
    }

    protected int getTabRunOverlay(int n2) {
        return this._tabRunOverlay;
    }

    protected int getTabRunIndent(int n2, int n3) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n2, int n3) {
        return this._runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n2) {
        return true;
    }

    protected View getTextViewForTab(int n2) {
        if (this.htmlViews != null && n2 < this.htmlViews.size()) {
            return (View)this.htmlViews.elementAt(n2);
        }
        return null;
    }

    protected int calculateTabHeight(int n2, int n3, FontMetrics fontMetrics) {
        Component component;
        int n4 = 0;
        Component component2 = component = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(n3) : null;
        if (component != null) {
            n4 = component.getPreferredSize().height;
            return n4;
        }
        if (n2 == 1 || n2 == 3) {
            View view = this.getTextViewForTab(n3);
            n4 = view != null ? (n4 += (int)view.getPreferredSpan(1)) : (n4 += fontMetrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(n3);
            Insets insets = this.getTabInsets(n2, n3);
            if (icon != null) {
                n4 = Math.max(n4, icon.getIconHeight());
            }
            n4 += insets.top + insets.bottom + 2;
        } else {
            View view;
            Icon icon = this._tabPane.getIconForTab(n3);
            Insets insets = this.getTabInsets(n2, n3);
            n4 = insets.top + insets.bottom + 3;
            if (icon != null) {
                n4 += icon.getIconHeight() + this._textIconGap;
            }
            if ((view = this.getTextViewForTab(n3)) != null) {
                n4 += (int)view.getPreferredSpan(0);
            } else {
                String string = this.getCurrentDisplayTitleAt(this._tabPane, n3);
                n4 += SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            if (this._tabPane.isShowGripper()) {
                n4 += this._gripperHeight;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(n3)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == n3) {
                        n4 += this._closeButtons[n3].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    n4 += this._closeButtons[n3].getPreferredSize().height + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        }
        return n4;
    }

    protected int calculateMaxTabHeight(int n2) {
        int n3 = this._tabPane.getTabCount();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            FontMetrics fontMetrics = this.getFontMetrics(i2);
            n4 = Math.max(this.calculateTabHeight(n2, i2, fontMetrics), n4);
        }
        return n4;
    }

    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        int n4 = 0;
        if (n2 == 1 || n2 == 3) {
            View view;
            Component component;
            Icon icon = this._tabPane.getIconForTab(n3);
            Insets insets = this.getTabInsets(n2, n3);
            n4 = insets.left + insets.right + 3 + this.getTabGap();
            Component component2 = component = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(n3) : null;
            if (component != null) {
                return n4 += component.getPreferredSize().width;
            }
            if (icon != null) {
                n4 += icon.getIconWidth() + this._textIconGap;
            }
            if ((view = this.getTextViewForTab(n3)) != null) {
                n4 += (int)view.getPreferredSpan(0);
            } else {
                String string = this.getCurrentDisplayTitleAt(this._tabPane, n3);
                n4 += SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            if (this._tabPane.isShowGripper()) {
                n4 += this._gripperWidth;
            }
            if (this.scrollableTabLayoutEnabled() && this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this._tabPane.isTabClosableAt(n3)) {
                if (this._tabPane.isShowCloseButtonOnSelectedTab()) {
                    if (this._tabPane.getSelectedIndex() == n3) {
                        n4 += this._closeButtons[n3].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                    }
                } else {
                    n4 += this._closeButtons[n3].getPreferredSize().width + this._closeButtonRightMargin + this._closeButtonLeftMargin;
                }
            }
        } else {
            Component component;
            Component component3 = component = SystemInfo.isJdk6Above() ? this._tabPane.getTabComponentAt(n3) : null;
            if (component != null) {
                Insets insets = this.getTabInsets(n2, n3);
                n4 = component.getPreferredSize().width + insets.left + insets.right + 3;
                return n4;
            }
            View view = this.getTextViewForTab(n3);
            n4 = view != null ? (n4 += (int)view.getPreferredSpan(1)) : (n4 += fontMetrics.getHeight());
            Icon icon = this._tabPane.getIconForTab(n3);
            Insets insets = this.getTabInsets(n2, n3);
            if (icon != null) {
                n4 = Math.max(n4, icon.getIconWidth());
            }
            n4 += insets.left + insets.right + 2;
        }
        return n4;
    }

    protected int calculateMaxTabWidth(int n2) {
        int n3 = this._tabPane.getTabCount();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            FontMetrics fontMetrics = this.getFontMetrics(i2);
            n4 = Math.max(this.calculateTabWidth(n2, i2, fontMetrics), n4);
        }
        return n4;
    }

    protected int calculateTabAreaHeight(int n2, int n3, int n4) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n2, int n3, int n4) {
        if (!this._tabPane.isTabShown()) {
            return 0;
        }
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n2, int n3) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getTabInsets(), this._currentTabInsets, n2);
        return this._currentTabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n2) {
        BasicJideTabbedPaneUI.rotateInsets(this._selectedTabPadInsets, this._currentPadInsets, n2);
        return this._currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n2) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getTabAreaInsets(), this._currentTabAreaInsets, n2);
        return this._currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n2) {
        BasicJideTabbedPaneUI.rotateInsets(this._tabPane.getContentBorderInsets(), this._currentContentBorderInsets, n2);
        if (this._ignoreContentBorderInsetsIfNoTabs && !this._tabPane.isTabShown()) {
            return new Insets(0, 0, 0, 0);
        }
        return this._currentContentBorderInsets;
    }

    protected FontMetrics getFontMetrics(int n2) {
        int n3 = this._tabPane.getSelectedIndex();
        Font font = n3 == n2 ? (this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._selectedTabFont) : this._tabPane.getFont();
        if (n3 == n2 && this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        return this._tabPane.getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n2) {
        int n3 = this._tabPane.getTabPlacement();
        int n4 = this._tabPane.getSelectedIndex();
        int n5 = this._tabPane.getTabCount();
        boolean bl = this._tabPane.getComponentOrientation().isLeftToRight();
        if (n5 <= 0) {
            return;
        }
        block0 : switch (n3) {
            case 12: {
                this.selectNextTab(n4);
                break;
            }
            case 13: {
                this.selectPreviousTab(n4);
                break;
            }
            case 2: 
            case 4: {
                switch (n2) {
                    case 1: {
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        int n6 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n6);
                        break block0;
                    }
                    case 3: {
                        int n7 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n7);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 1: {
                        int n8 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n8);
                        break block0;
                    }
                    case 5: {
                        int n9 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n9);
                        break block0;
                    }
                    case 3: {
                        if (bl) {
                            this.selectNextTabInRun(n4);
                            break block0;
                        }
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        if (bl) {
                            this.selectPreviousTabInRun(n4);
                            break block0;
                        }
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n2) {
        int n3 = this._tabPane.getTabCount();
        int n4 = this.getNextTabIndexInRun(n3, n2);
        while (n4 != n2 && !this._tabPane.isEnabledAt(n4)) {
            n4 = this.getNextTabIndexInRun(n3, n4);
        }
        this._tabPane.setSelectedIndex(n4);
    }

    protected void selectPreviousTabInRun(int n2) {
        int n3 = this._tabPane.getTabCount();
        int n4 = this.getPreviousTabIndexInRun(n3, n2);
        while (n4 != n2 && !this._tabPane.isEnabledAt(n4)) {
            n4 = this.getPreviousTabIndexInRun(n3, n4);
        }
        this._tabPane.setSelectedIndex(n4);
    }

    protected void selectNextTab(int n2) {
        int n3 = this.getNextTabIndex(n2);
        while (n3 != n2 && !this._tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndex(n3);
        }
        this._tabPane.setSelectedIndex(n3);
    }

    protected void selectPreviousTab(int n2) {
        int n3 = this.getPreviousTabIndex(n2);
        while (n3 != n2 && !this._tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndex(n3);
        }
        this._tabPane.setSelectedIndex(n3);
    }

    protected void selectAdjacentRunTab(int n2, int n3, int n4) {
        int n5;
        if (this._runCount < 2) {
            return;
        }
        Rectangle rectangle = this._rects[n3];
        switch (n2) {
            case 2: 
            case 4: {
                n5 = this.getTabAtLocation(rectangle.x + (rectangle.width >> 1) + n4, rectangle.y + (rectangle.height >> 1));
                break;
            }
            default: {
                n5 = this.getTabAtLocation(rectangle.x + (rectangle.width >> 1), rectangle.y + (rectangle.height >> 1) + n4);
            }
        }
        if (n5 != -1) {
            while (!this._tabPane.isEnabledAt(n5) && n5 != n3) {
                n5 = this.getNextTabIndex(n5);
            }
            this._tabPane.setSelectedIndex(n5);
        }
    }

    protected int getTabRunOffset(int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6 = this.getRunForTab(n3, n4);
        switch (n2) {
            case 2: {
                if (n6 == 0) {
                    n5 = bl ? -(this.calculateTabAreaWidth(n2, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                if (n6 == this._runCount - 1) {
                    n5 = bl ? this._maxTabWidth : this.calculateTabAreaWidth(n2, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                n5 = bl ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 4: {
                if (n6 == 0) {
                    n5 = bl ? this._maxTabWidth : this.calculateTabAreaWidth(n2, this._runCount, this._maxTabWidth) - this._maxTabWidth;
                    break;
                }
                if (n6 == this._runCount - 1) {
                    n5 = bl ? -(this.calculateTabAreaWidth(n2, this._runCount, this._maxTabWidth) - this._maxTabWidth) : -this._maxTabWidth;
                    break;
                }
                n5 = bl ? this._maxTabWidth : -this._maxTabWidth;
                break;
            }
            case 3: {
                if (n6 == 0) {
                    n5 = bl ? this._maxTabHeight : this.calculateTabAreaHeight(n2, this._runCount, this._maxTabHeight) - this._maxTabHeight;
                    break;
                }
                if (n6 == this._runCount - 1) {
                    n5 = bl ? -(this.calculateTabAreaHeight(n2, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight;
                    break;
                }
                n5 = bl ? this._maxTabHeight : -this._maxTabHeight;
                break;
            }
            default: {
                n5 = n6 == 0 ? (bl ? -(this.calculateTabAreaHeight(n2, this._runCount, this._maxTabHeight) - this._maxTabHeight) : -this._maxTabHeight) : (n6 == this._runCount - 1 ? (bl ? this._maxTabHeight : this.calculateTabAreaHeight(n2, this._runCount, this._maxTabHeight) - this._maxTabHeight) : (bl ? this._maxTabHeight : -this._maxTabHeight));
            }
        }
        return n5;
    }

    protected int getPreviousTabIndex(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this._tabPane.getTabCount() - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getNextTabIndex(int n2) {
        return (n2 + 1) % this._tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n2, int n3) {
        if (this._runCount < 2) {
            return this.getNextTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        int n5 = this.getNextTabIndex(n3);
        if (n5 == this._tabRuns[this.getNextTabRun(n4)]) {
            return this._tabRuns[n4];
        }
        return n5;
    }

    protected int getPreviousTabIndexInRun(int n2, int n3) {
        if (this._runCount < 2) {
            return this.getPreviousTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        if (n3 == this._tabRuns[n4]) {
            int n5 = this._tabRuns[this.getNextTabRun(n4)] - 1;
            return n5 != -1 ? n5 : n2 - 1;
        }
        return this.getPreviousTabIndex(n3);
    }

    protected int getPreviousTabRun(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this._runCount - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getNextTabRun(int n2) {
        return (n2 + 1) % this._runCount;
    }

    public static void rotateInsets(Insets insets, Insets insets2, int n2) {
        if (insets == null) {
            insets2.top = 0;
            insets2.left = 0;
            insets2.bottom = 0;
            insets2.right = 0;
            return;
        }
        switch (n2) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    public boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        Component component2 = this._tabPane.getLastFocusedComponent(component);
        if (component2 != null && component2.requestFocusInWindow()) {
            return true;
        }
        if (component != null && JideSwingUtilities.passesFocusabilityTest(component)) {
            JideSwingUtilities.compositeRequestFocus(component);
            return true;
        }
        return component != null && component.requestFocusInWindow();
    }

    @Deprecated
    protected TabCloseButton createNoFocusButton(int n2) {
        return new TabCloseButton(n2);
    }

    private JButton createButton(int n2) {
        return this._tabPane.createNoFocusButton(n2);
    }

    protected void stopOrCancelEditing() {
        boolean bl = true;
        if (this._tabPane != null && this._tabPane.isTabEditing() && this._tabPane.getTabEditingValidator() != null) {
            bl = this._tabPane.getTabEditingValidator().isValid(this._editingTab, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
        }
        if (bl) {
            this._tabPane.stopTabEditing();
        } else {
            this._tabPane.cancelTabEditing();
        }
    }

    protected void ensureCurrentRects(int n2, int n3) {
        int n4;
        int n5;
        Dimension dimension = this._tabPane.getSize();
        Insets insets = this._tabPane.getInsets();
        int n6 = 0;
        int n7 = 0;
        boolean bl = this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4;
        boolean bl2 = this._tabPane.getComponentOrientation().isLeftToRight();
        if (n3 == 0) {
            return;
        }
        Rectangle rectangle = this._rects[n3 - 1];
        Dimension dimension2 = new Dimension(0, 0);
        Dimension dimension3 = new Dimension(0, 0);
        if (this.isTabLeadingComponentVisible()) {
            dimension2 = this._tabLeadingComponent.getPreferredSize();
        }
        if (this.isTabTrailingComponentVisible()) {
            dimension3 = this._tabTrailingComponent.getPreferredSize();
        }
        if (bl) {
            n7 = rectangle.y + rectangle.height;
            if (this._tabLeadingComponent != null) {
                n7 -= dimension2.height;
            }
        } else {
            Rectangle[] rectangleArray = this._rects;
            n5 = rectangleArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                Rectangle rectangle2 = rectangleArray[n4];
                n6 += rectangle2.width;
            }
            n6 = bl2 ? (n6 += this._rects[0].x) : (n6 += n2);
            if (this._tabLeadingComponent != null) {
                n6 -= dimension2.width;
            }
        }
        if (this.getTabResizeMode() == 2) {
            if (bl) {
                int n8 = this.getTabShape() != 3 ? (int)dimension.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom - n2 - this.getTabRightPadding() : (int)dimension.getHeight() - this._fitStyleBoundSize - insets.top - insets.bottom;
                if (this._tabPane.isShowCloseButton()) {
                    n8 -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    n8 -= dimension2.height;
                }
                if (this.isTabTrailingComponentVisible()) {
                    n8 -= dimension3.height;
                }
                if (n7 > (n8 -= this._buttonSize * (n5 = this.getNumberOfTabButtons()))) {
                    n4 = n8 / n3;
                    n7 = this._fitStyleFirstTabMargin;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        this._rects[i2].height = n4;
                        Rectangle rectangle3 = this._rects[i2];
                        rectangle3.y = this.getTabShape() != 3 ? n7 + n2 : n7;
                        n7 += rectangle3.height;
                    }
                }
            } else {
                int n9 = this.getTabShape() != 3 ? (int)dimension.getWidth() - this._fitStyleBoundSize - insets.left - insets.right - n2 - this.getTabRightPadding() : (int)dimension.getWidth() - this._fitStyleBoundSize - insets.left - insets.right;
                if (this._tabPane.isShowCloseButton()) {
                    n9 -= this._buttonSize;
                }
                if (this.isTabLeadingComponentVisible()) {
                    n9 -= dimension2.width;
                }
                if (this.isTabTrailingComponentVisible()) {
                    n9 -= dimension3.width;
                }
                if (n6 > (n9 -= this._buttonSize * (n5 = this.getNumberOfTabButtons()))) {
                    int n10;
                    n4 = n9 / n3;
                    int n11 = n10 = this._tabPane.isShowGripper() ? this._gripperWidth : 0;
                    if (n4 < this._textIconGap + this._fitStyleTextMinWidth + this._fitStyleIconMinWidth + n10 && n4 > this._fitStyleIconMinWidth + n10) {
                        n4 = this._fitStyleIconMinWidth + n10;
                    }
                    if (n4 < this._fitStyleIconMinWidth + n10 && n4 > this._fitStyleFirstTabMargin + n10) {
                        n4 = this._fitStyleFirstTabMargin + n10;
                    }
                    this.tryTabSpacer.reArrange(this._rects, insets, n9);
                }
                n6 = this._fitStyleFirstTabMargin;
                for (n4 = 0; n4 < n3; ++n4) {
                    Rectangle rectangle4 = this._rects[n4];
                    rectangle4.x = this.getTabShape() != 3 ? n6 + n2 : n6;
                    n6 += rectangle4.width;
                }
                if (!bl2) {
                    Insets insets2 = this.getTabAreaInsets(this._tabPane.getTabPlacement());
                    int n12 = dimension.width - dimension2.width - dimension3.width - (insets.right + insets2.right);
                    if (this._tabPane.isShowCloseButton()) {
                        n12 -= this._buttonSize;
                    }
                    for (int i3 = 0; i3 < n3; ++i3) {
                        this._rects[i3].x = n12 - this._rects[i3].x - this._rects[i3].width;
                    }
                }
            }
        }
        if (this.getTabResizeMode() == 3) {
            if (bl) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    this._rects[i4].height = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[i4].height += this._closeButtons[i4].getPreferredSize().height;
                    }
                    if (i4 != 0) {
                        this._rects[i4].y = this._rects[i4 - 1].y + this._rects[i4 - 1].height;
                    }
                    n7 = this._rects[i4].y + this._rects[i4].height;
                }
            } else {
                for (int i5 = 0; i5 < n3; ++i5) {
                    n5 = this._rects[i5].width;
                    this._rects[i5].width = this._fixedStyleRectSize;
                    if (this.isShowCloseButton() && this._tabPane.isShowCloseButtonOnTab()) {
                        this._rects[i5].width += this._closeButtons[i5].getPreferredSize().width;
                    }
                    if (i5 == 0 && !bl2) {
                        this._rects[i5].x += n5 - this._rects[i5].width;
                    }
                    if (i5 != 0) {
                        this._rects[i5].x = bl2 ? this._rects[i5 - 1].x + this._rects[i5 - 1].width : this._rects[i5 - 1].x - this._rects[i5 - 1].width;
                    }
                    n6 = this._rects[i5].x + this._rects[i5].width;
                }
            }
        }
        if (this.getTabResizeMode() == 4) {
            if (bl) {
                for (int i6 = 0; i6 < n3; ++i6) {
                    if (i6 != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[i6].height = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(i6);
                            this._rects[i6].height = (icon == null ? 0 : icon.getIconHeight()) + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[i6].height = this._rects[i6].height + this._closeButtons[i6].getPreferredSize().height + this._compressedStyleCloseButtonMarginVertical;
                        }
                    }
                    if (i6 != 0) {
                        this._rects[i6].y = this._rects[i6 - 1].y + this._rects[i6 - 1].height;
                    }
                    n7 = this._rects[i6].y + this._rects[i6].height;
                }
            } else {
                for (int i7 = 0; i7 < n3; ++i7) {
                    n5 = this._rects[i7].width;
                    if (i7 != this._tabPane.getSelectedIndex()) {
                        if (!this._tabPane.isShowIconsOnTab() && !this._tabPane.isUseDefaultShowIconsOnTab()) {
                            this._rects[i7].width = this._compressedStyleNoIconRectSize;
                        } else {
                            Icon icon = this._tabPane.getIconForTab(i7);
                            this._rects[i7].width = (icon == null ? 0 : icon.getIconWidth()) + this._compressedStyleIconMargin;
                        }
                        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && !this._tabPane.isShowCloseButtonOnSelectedTab()) {
                            this._rects[i7].width = this._rects[i7].width + this._closeButtons[i7].getPreferredSize().width + this._compressedStyleCloseButtonMarginHorizon;
                        }
                    }
                    if (i7 == 0 && !bl2) {
                        this._rects[i7].x += n5 - this._rects[i7].width;
                    }
                    if (i7 != 0) {
                        this._rects[i7].x = bl2 ? this._rects[i7 - 1].x + this._rects[i7 - 1].width : this._rects[i7 - 1].x - this._rects[i7 - 1].width;
                    }
                    n6 = this._rects[i7].x + this._rects[i7].width;
                }
            }
        }
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            n6 += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                n6 += dimension2.width;
            }
        } else {
            n7 += this.getLayoutSize();
            if (this.isTabLeadingComponentVisible()) {
                n7 += dimension3.height;
            }
        }
        if (this._tabPane.getTabAlignment() == 0 && (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3)) {
            int n13 = this._rects[0].x;
            n5 = this._rects[this._rects.length - 1].x + this._rects[this._rects.length - 1].width;
            int n14 = this._tabPane.getWidth();
            int n15 = n14 / 2 - (n5 - n13) / 2 - n13;
            for (Rectangle rectangle5 : this._rects) {
                rectangle5.x += n15;
            }
        }
        this._tabScroller.tabPanel.setPreferredSize(new Dimension(n6, n7));
    }

    protected ListCellRenderer getTabListCellRenderer() {
        return this._tabPane.getTabListCellRenderer();
    }

    protected void updateCloseAction() {
        this.ensureCloseButtonCreated();
    }

    private Vector createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n2 = this._tabPane.getTabCount();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = this.getCurrentDisplayTitleAt(this._tabPane, i2);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this._tabPane, string));
                    continue;
                }
                vector.addElement(null);
            }
        }
        return vector;
    }

    @Override
    public Component getTabPanel() {
        if (this.scrollableTabLayoutEnabled()) {
            return this._tabScroller.tabPanel;
        }
        return this._tabPane;
    }

    @Override
    public void ensureActiveTabIsVisible(boolean bl) {
        if (this._tabPane == null || this._tabPane.getWidth() == 0) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.ensureCurrentLayout();
            int n2 = this._tabPane.getSelectedIndex();
            if (!(bl && n2 == 0 || n2 >= this._rects.length || n2 == -1)) {
                this._tabScroller.tabPanel.scrollIndexToVisible(n2);
                if (this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4 || this._tabPane.getComponentOrientation().isLeftToRight()) {
                    this._tabScroller.tabPanel.getParent().doLayout();
                }
            }
            if (this._tabPane.getTabPlacement() == 2 || this._tabPane.getTabPlacement() == 4 || this._tabPane.getComponentOrientation().isLeftToRight()) {
                this._tabPane.revalidate();
                this._tabPane.repaintTabAreaAndContentBorder();
            } else {
                this._tabPane.repaint();
            }
        }
    }

    protected boolean isShowCloseButtonOnTab() {
        if (this._tabPane.isUseDefaultShowCloseButtonOnTab()) {
            return this._showCloseButtonOnTab;
        }
        return this._tabPane.isShowCloseButtonOnTab();
    }

    protected boolean isShowCloseButton() {
        return this._tabPane.isShowCloseButton();
    }

    public void ensureCloseButtonCreated() {
        if (this.isShowCloseButton() && this.isShowCloseButtonOnTab() && this.scrollableTabLayoutEnabled()) {
            JButton jButton;
            int n2;
            JButton[] jButtonArray;
            if (this._closeButtons == null) {
                this._closeButtons = new JButton[this._tabPane.getTabCount()];
            } else if (this._closeButtons.length > this._tabPane.getTabCount()) {
                jButtonArray = new JButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, jButtonArray, 0, jButtonArray.length);
                for (n2 = jButtonArray.length; n2 < this._closeButtons.length; ++n2) {
                    jButton = this._closeButtons[n2];
                    this._tabScroller.tabPanel.remove(jButton);
                }
                this._closeButtons = jButtonArray;
            } else if (this._closeButtons.length < this._tabPane.getTabCount()) {
                jButtonArray = new JButton[this._tabPane.getTabCount()];
                System.arraycopy(this._closeButtons, 0, jButtonArray, 0, this._closeButtons.length);
                this._closeButtons = jButtonArray;
            }
            jButtonArray = this.getActionMap();
            for (n2 = 0; n2 < this._closeButtons.length; ++n2) {
                jButton = this._closeButtons[n2];
                if (jButton == null) {
                    this._closeButtons[n2] = jButton = this.createButton(0);
                    if (jButton instanceof JideTabbedPane.NoFocusButton) {
                        ((JideTabbedPane.NoFocusButton)jButton).setIndex(n2);
                    }
                    jButton.setBounds(0, 0, 0, 0);
                    Action action = this._tabPane.getCloseAction();
                    Icon icon = jButton.getIcon();
                    jButton.setAction(jButtonArray.get("closeTabAction"));
                    this.updateButtonFromAction(jButton, action);
                    if (icon != null) {
                        this._tabScroller.closeButton.setIcon(icon);
                    }
                    this._tabScroller.tabPanel.add(jButton);
                }
                if (!(jButton instanceof JideTabbedPane.NoFocusButton)) continue;
                ((JideTabbedPane.NoFocusButton)jButton).setIndex(n2);
            }
        }
    }

    private void updateButtonFromAction(JButton jButton, Action action) {
        Object object;
        if (action == null) {
            return;
        }
        jButton.setEnabled(action.isEnabled());
        Object object2 = action.getValue("ShortDescription");
        if (object2 instanceof String) {
            jButton.setToolTipText((String)object2);
        }
        if ((object = action.getValue("SmallIcon")) instanceof Icon) {
            jButton.setIcon((Icon)object);
        }
    }

    protected boolean isShowTabButtons() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.isShowTabArea() && this._tabPane.isShowTabButtons();
    }

    protected boolean isShrinkTabs() {
        return this._tabPane.getTabCount() != 0 && this._tabPane.getTabResizeMode() == 2;
    }

    @Override
    public boolean isTabEditing() {
        return this._isEditing;
    }

    protected TabEditor createDefaultTabEditor() {
        final TabEditor tabEditor = new TabEditor();
        tabEditor.getDocument().addDocumentListener(this);
        tabEditor.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                return true;
            }

            @Override
            public boolean shouldYieldFocus(JComponent jComponent) {
                boolean bl = true;
                if (BasicJideTabbedPaneUI.this._tabPane != null && BasicJideTabbedPaneUI.this._tabPane.isTabEditing() && BasicJideTabbedPaneUI.this._tabPane.getTabEditingValidator() != null) {
                    bl = BasicJideTabbedPaneUI.this._tabPane.getTabEditingValidator().alertIfInvalid(BasicJideTabbedPaneUI.this._editingTab, BasicJideTabbedPaneUI.this._oldPrefix + BasicJideTabbedPaneUI.this._tabEditor.getText() + BasicJideTabbedPaneUI.this._oldPostfix);
                }
                if (bl && BasicJideTabbedPaneUI.this._tabPane != null && BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                    BasicJideTabbedPaneUI.this._tabPane.stopTabEditing();
                }
                return bl;
            }
        });
        tabEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                BasicJideTabbedPaneUI.this._originalFocusComponent = focusEvent.getOppositeComponent();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        tabEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tabEditor.transferFocus();
            }
        });
        tabEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (BasicJideTabbedPaneUI.this._isEditing && keyEvent.getKeyCode() == 27) {
                    if (BasicJideTabbedPaneUI.this._editingTab >= 0 && BasicJideTabbedPaneUI.this._editingTab < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                        BasicJideTabbedPaneUI.this._tabPane.setTitleAt(BasicJideTabbedPaneUI.this._editingTab, BasicJideTabbedPaneUI.this._oldValue);
                    }
                    BasicJideTabbedPaneUI.this._tabPane.cancelTabEditing();
                }
            }
        });
        tabEditor.setFont(this._tabPane.getFont());
        return tabEditor;
    }

    @Override
    public void stopTabEditing() {
        if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
            this._tabPane.setTitleAt(this._editingTab, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
        }
        this.cancelTabEditing();
    }

    @Override
    public void cancelTabEditing() {
        if (this._tabEditor != null) {
            this._isEditing = false;
            ((Container)this.getTabPanel()).remove(this._tabEditor);
            if (this._editingTab >= 0 && this._editingTab < this._tabPane.getTabCount()) {
                Rectangle rectangle = this._tabPane.getBoundsAt(this._editingTab);
                this.getTabPanel().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                this.getTabPanel().repaint();
            }
            if (this._originalFocusComponent != null) {
                this._originalFocusComponent.requestFocus();
            } else {
                this._tabPane.requestFocusForVisibleComponent();
            }
            this._editingTab = -1;
            this._oldValue = null;
            this._tabPane.doLayout();
        }
    }

    @Override
    public boolean editTabAt(int n2) {
        if (this._isEditing) {
            return false;
        }
        if (this._tabEditor == null) {
            this._tabEditor = this.createDefaultTabEditor();
        }
        if (this._tabEditor != null) {
            this.prepareEditor(this._tabEditor, n2);
            ((Container)this.getTabPanel()).add(this._tabEditor);
            this.resizeEditor(n2);
            this._editingTab = n2;
            this._isEditing = true;
            this._tabEditor.requestFocusInWindow();
            this._tabEditor.selectAll();
            return true;
        }
        return false;
    }

    @Override
    public int getEditingTabIndex() {
        return this._editingTab;
    }

    protected void prepareEditor(TabEditor tabEditor, int n2) {
        Font font = this._tabPane.getSelectedTabFont() != null ? this._tabPane.getSelectedTabFont() : this._tabPane.getFont();
        if (this._tabPane.isBoldActiveTab() && font.getStyle() != 1) {
            font = font.deriveFont(1);
        }
        tabEditor.setFont(font);
        this._oldValue = this._tabPane.getTitleAt(n2);
        if (this._oldValue.startsWith("<HTML>") && this._oldValue.endsWith("/HTML>")) {
            this._oldPrefix = "<HTML>";
            this._oldPostfix = "</HTML>";
            String string = this._oldValue.substring("<HTML>".length(), this._oldValue.length() - "</HTML>".length());
            if (string.startsWith("<B>") && string.endsWith("/B>")) {
                string = string.substring("<B>".length(), string.length() - "</B>".length());
                this._oldPrefix = this._oldPrefix + "<B>";
                this._oldPostfix = "</B>" + this._oldPostfix;
            }
            tabEditor.setText(string);
        } else {
            this._oldPrefix = "";
            this._oldPostfix = "";
            tabEditor.setText(this._oldValue);
        }
        tabEditor.selectAll();
        tabEditor.setForeground(this._tabPane.getForegroundAt(n2));
    }

    protected Rectangle getTabsTextBoundsAt(int n2) {
        String string;
        Rectangle rectangle = this._tabPane.getBoundsAt(n2);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        if (rectangle.width < 200) {
            rectangle.width = 200;
        }
        if ((string = this.getCurrentDisplayTitleAt(this._tabPane, n2)) == null || string.length() == 0) {
            string = "i";
        }
        Icon icon = this._tabPane.getIconForTab(n2);
        Font font = this._tabPane.getFont();
        if (n2 == this._tabPane.getSelectedIndex() && this._tabPane.isBoldActiveTab()) {
            font = font.deriveFont(1);
        }
        SwingUtilities.layoutCompoundLabel(this._tabPane, this._tabPane.getGraphics().getFontMetrics(font), string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, icon == null ? 0 : this._textIconGap);
        if (this._tabPane.getTabPlacement() == 1 || this._tabPane.getTabPlacement() == 3) {
            rectangle2.x = rectangle.x + this._iconMargin;
            rectangle3.x = icon != null ? rectangle2.x + rectangle2.width + this._textIconGap : rectangle.x + this._textPadding;
            rectangle3.width += 2;
        } else {
            rectangle2.y = rectangle.y + this._iconMargin;
            rectangle3.y = icon != null ? rectangle2.y + rectangle2.height + this._textIconGap : rectangle.y + this._textPadding;
            rectangle2.x = rectangle.x + 2;
            rectangle3.x = rectangle.x + 2;
            rectangle3.height += 2;
        }
        return rectangle3;
    }

    private void updateTab() {
        if (this._isEditing) {
            this.resizeEditor(this.getEditingTabIndex());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTab();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTab();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTab();
    }

    protected void resizeEditor(int n2) {
        Rectangle rectangle = this.getTabsTextBoundsAt(n2);
        if (rectangle.isEmpty()) {
            rectangle = new Rectangle(14, 3);
        }
        rectangle.x -= this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).left;
        rectangle.width = rectangle.width + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).left + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).right;
        rectangle.y -= this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).top;
        rectangle.height = rectangle.height + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).top + this._tabEditor.getBorder().getBorderInsets((Component)this._tabEditor).bottom;
        this._tabEditor.setBounds(SwingUtilities.convertRectangle(this._tabPane, rectangle, this.getTabPanel()));
        this._tabEditor.invalidate();
        this._tabEditor.validate();
        this._tabPane.doLayout();
        this.getTabPanel().getParent().getParent().repaint();
    }

    protected String getCurrentDisplayTitleAt(JideTabbedPane jideTabbedPane, int n2) {
        String string = jideTabbedPane.getDisplayTitleAt(n2);
        if (this._isEditing && n2 == this._editingTab) {
            string = this._tabEditor.getText();
        }
        return string;
    }

    public void startEditing(MouseEvent mouseEvent) {
        boolean bl;
        int n2 = this.tabForCoordinate(this._tabPane, mouseEvent.getX(), mouseEvent.getY());
        if (!mouseEvent.isPopupTrigger() && n2 >= 0 && this._tabPane.isEnabledAt(n2) && this._tabPane.isTabEditingAllowed() && mouseEvent.getClickCount() == 2) {
            bl = true;
            if (this._tabPane.getTabEditingValidator() != null) {
                bl = this._tabPane.getTabEditingValidator().shouldStartEdit(n2, mouseEvent);
            }
            if (bl) {
                mouseEvent.consume();
                this._tabPane.editTabAt(n2);
            }
        }
        if (mouseEvent.getClickCount() == 1 && this._tabPane.isTabEditing()) {
            bl = true;
            if (this._tabPane.getTabEditingValidator() != null) {
                bl = this._tabPane.getTabEditingValidator().alertIfInvalid(n2, this._oldPrefix + this._tabEditor.getText() + this._oldPostfix);
            }
            if (bl) {
                this._tabPane.stopTabEditing();
            }
        }
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected int getTabLabelShiftX(int n2, int n3, boolean bl) {
        int n4;
        Rectangle rectangle = this._rects[n3];
        switch (n2) {
            case 2: {
                n4 = bl ? -1 : 1;
                break;
            }
            case 4: {
                n4 = bl ? 1 : -1;
                break;
            }
            default: {
                n4 = rectangle.width % 2;
            }
        }
        return n4;
    }

    protected int getTabLabelShiftY(int n2, int n3, boolean bl) {
        int n4;
        Rectangle rectangle = this._rects[n3];
        switch (n2) {
            case 3: {
                n4 = bl ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n4 = rectangle.height % 2;
                break;
            }
            default: {
                n4 = bl ? -1 : 1;
            }
        }
        return n4;
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = new Rectangle(rectangleArray[n3]);
        if (this._tabPane.hasFocus() && bl) {
            int n4;
            int n5;
            int n6;
            int n7;
            graphics.setColor(this._focus);
            switch (n2) {
                case 2: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6 - this.getTabGap();
                    break;
                }
                case 4: {
                    n7 = rectangle3.x + 2;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6 - this.getTabGap();
                    break;
                }
                case 3: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 2;
                    n5 = rectangle3.width - 6 - this.getTabGap();
                    n4 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 6 - this.getTabGap();
                    n4 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n7, n6, n5, n4);
        }
    }

    protected boolean isRoundedCorner() {
        return "true".equals(SecurityUtils.getProperty("shadingtheme", "false"));
    }

    protected int getTabShape() {
        return this._tabPane.getTabShape();
    }

    protected int getTabResizeMode() {
        return this._tabPane.getTabResizeMode();
    }

    protected int getColorTheme() {
        return this._tabPane.getColorTheme();
    }

    protected int getLeftMargin() {
        if (this.getTabShape() == 4) {
            return 18;
        }
        if (this.getTabShape() == 8) {
            return 6;
        }
        return 0;
    }

    protected int getTabGap() {
        if (this.getTabShape() == 4) {
            return 4;
        }
        return 0;
    }

    protected int getLayoutSize() {
        int n2 = this.getTabShape();
        if (n2 == 8) {
            return 6;
        }
        if (n2 == 7) {
            return 15;
        }
        if (this._tabPane.getTabShape() == 5 || this._tabPane.getTabShape() == 10) {
            return 2;
        }
        if (n2 == 1 || n2 == 11) {
            return 6;
        }
        return 0;
    }

    protected int getTabRightPadding() {
        if (this.getTabShape() == 8) {
            return 4;
        }
        return 0;
    }

    protected MouseListener createMouseListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11 || this._tabPane.isShowCloseButtonOnMouseOver()) {
            return new RolloverMouseHandler();
        }
        return new MouseHandler();
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        if (this.getTabShape() == 1 || this.getTabShape() == 11 || this._tabPane.isShowCloseButtonOnMouseOver()) {
            return new RolloverMouseMotionHandler();
        }
        return new MouseMotionHandler();
    }

    protected boolean isTabLeadingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabLeadingComponent != null && this._tabLeadingComponent.isVisible();
    }

    protected boolean isTabTrailingComponentVisible() {
        return this._tabPane.isTabShown() && this._tabTrailingComponent != null && this._tabTrailingComponent.isVisible();
    }

    protected boolean isTabTopVisible(int n2) {
        switch (n2) {
            case 2: 
            case 4: {
                return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().width > this.calculateMaxTabWidth(n2) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().width > this.calculateMaxTabWidth(n2);
            }
        }
        return this.isTabLeadingComponentVisible() && this._tabLeadingComponent.getPreferredSize().height > this.calculateMaxTabHeight(n2) || this.isTabTrailingComponentVisible() && this._tabTrailingComponent.getPreferredSize().height > this.calculateMaxTabHeight(n2);
    }

    protected boolean showFocusIndicator() {
        return this._tabPane.hasFocusComponent() && this._showFocusIndicator;
    }

    private int getNumberOfTabButtons() {
        int n2;
        int n3 = n2 = !this.isShowTabButtons() || this.isShrinkTabs() ? 1 : 4;
        if (!this.isShowCloseButton() || this.isShowCloseButtonOnTab()) {
            --n2;
        }
        return n2;
    }

    protected String getResourceString(String string) {
        if (this._tabPane != null) {
            return this._tabPane.getResourceString(string);
        }
        return Resource.getResourceBundle(Locale.getDefault()).getString(string);
    }

    private void setMouseOverTabIndex(int n2) {
        if (this._indexMouseOver != n2) {
            this._indexMouseOver = n2;
            this._tabPane.putClientProperty("JideTabbedPane.mouseOverTabIndex", this._indexMouseOver);
        }
    }

    public class RolloverMouseHandler
    extends MouseHandler {
        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            int n2 = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(n2);
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(-1);
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class RolloverMouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            int n2 = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n2 != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this.setMouseOverTabIndex(n2);
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    public class DefaultMouseHandler
    extends MouseHandler {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            int n2 = BasicJideTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            BasicJideTabbedPaneUI.this._mouseEnter = true;
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(n2);
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            BasicJideTabbedPaneUI.this.setMouseOverTabIndex(-1);
            BasicJideTabbedPaneUI.this._mouseEnter = false;
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }
    }

    public class DefaultMouseMotionHandler
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            int n2 = BasicJideTabbedPaneUI.this.getTabAtLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n2 != BasicJideTabbedPaneUI.this._indexMouseOver) {
                BasicJideTabbedPaneUI.this.setMouseOverTabIndex(n2);
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            }
        }
    }

    private class DropListener
    implements DropTargetListener {
        private DragOverTimer _timer;
        int _index = -1;

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (!BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            int n2 = BasicJideTabbedPaneUI.this.getTabAtLocation(dropTargetDragEvent.getLocation().x, dropTargetDragEvent.getLocation().y);
            if (n2 >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(n2)) {
                if (n2 != BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && n2 != this._index) {
                    this.stopTimer();
                    this.startTimer(n2);
                    this._index = n2;
                }
            } else {
                this.stopTimer();
            }
            dropTargetDragEvent.rejectDrag();
        }

        private void startTimer(int n2) {
            this._timer = new DragOverTimer(n2);
            this._timer.start();
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
                this._index = -1;
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.stopTimer();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.stopTimer();
        }
    }

    private class DragOverTimer
    extends Timer
    implements ActionListener {
        private int _index;
        private static final long serialVersionUID = -2529347876574638854L;

        public DragOverTimer(int n2) {
            super(500, null);
            this._index = n2;
            this.addActionListener(this);
            this.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() == 0) {
                return;
            }
            if (this._index == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex()) {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                    BasicJideTabbedPaneUI.this._tabPane.repaint(BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, this._index));
                }
            } else {
                if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                    BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow();
                }
                BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._index);
            }
            this.stop();
        }
    }

    protected class TabEditor
    extends JTextField
    implements UIResource {
        TabEditor() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createCompoundBorder(new PartialLineBorder(Color.BLACK, 1, true), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        }

        public boolean stopEditing() {
            return true;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Color color = graphics2D.getColor();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            graphics2D.setColor(this.getBackground());
            graphics.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 1, 1);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
            super.paintComponent(graphics);
        }
    }

    public static class TabSpaceAllocator {
        static final int startOffset = 4;
        private Insets insets = null;
        static final int tabWidth = 24;
        static final int textIconGap = 8;
        private AbstractTab[] tabs;

        private void setInsets(Insets insets) {
            this.insets = (Insets)insets.clone();
        }

        private void init(Rectangle[] rectangleArray, Insets insets) {
            this.setInsets(insets);
            this.tabs = new AbstractTab[rectangleArray.length];
            for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                this.tabs[i2] = new AbstractTab();
                this.tabs[i2].id = i2;
                this.tabs[i2].width = rectangleArray[i2].width;
            }
            this.tabSort();
        }

        private void bestfit(AbstractTab[] abstractTabArray, int n2, int n3) {
            int n4 = abstractTabArray.length;
            int n5 = abstractTabArray[n3].width;
            int n6 = n3;
            if (n3 == n4 - 1) {
                abstractTabArray[n3].width = n2;
                return;
            }
            int n7 = n2 / (n4 - n3);
            while (n5 < n7) {
                n2 -= n5;
                if (++n3 < n4 - 1) {
                    n5 = abstractTabArray[n3].width;
                    continue;
                }
                abstractTabArray[n3].width = n7;
                return;
            }
            if (n3 == n6) {
                for (int i2 = n3; i2 < n4; ++i2) {
                    abstractTabArray[i2].width = n7;
                }
            } else if (n3 < n4 - 1) {
                this.bestfit(abstractTabArray, n2, n3);
            }
        }

        private void tabSort() {
            int n2 = this.tabs.length;
            AbstractTab abstractTab = new AbstractTab();
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                for (int i3 = i2 + 1; i3 < n2; ++i3) {
                    if (this.tabs[i2].width <= this.tabs[i3].width) continue;
                    abstractTab.copy(this.tabs[i3]);
                    this.tabs[i3].copy(this.tabs[i2]);
                    this.tabs[i2].copy(abstractTab);
                }
            }
        }

        private void outpush(Rectangle[] rectangleArray) {
            for (AbstractTab abstractTab : this.tabs) {
                rectangleArray[abstractTab.id].width = abstractTab.width;
            }
            rectangleArray[0].x = 4;
            for (int i2 = 1; i2 < rectangleArray.length; ++i2) {
                rectangleArray[i2].x = rectangleArray[i2 - 1].x + rectangleArray[i2 - 1].width;
            }
        }

        public void reArrange(Rectangle[] rectangleArray, Insets insets, int n2) {
            this.init(rectangleArray, insets);
            this.bestfit(this.tabs, n2, 0);
            this.outpush(rectangleArray);
            int n3 = rectangleArray[rectangleArray.length - 1].x + rectangleArray[rectangleArray.length - 1].width;
            if (n3 > n2) {
                int n4 = n3 - n2;
                rectangleArray[rectangleArray.length - 1].width -= n4;
            }
            this.clearup();
        }

        private void clearup() {
            for (int i2 = 0; i2 < this.tabs.length; ++i2) {
                this.tabs[i2] = null;
            }
            this.tabs = null;
        }
    }

    static class AbstractTab {
        int width;
        int id;

        AbstractTab() {
        }

        public void copy(AbstractTab abstractTab) {
            this.width = abstractTab.width;
            this.id = abstractTab.id;
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            JideTabbedPane jideTabbedPane = (JideTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource || component == jideTabbedPane.getTabLeadingComponent() || component == jideTabbedPane.getTabTrailingComponent()) {
                return;
            }
            int n2 = jideTabbedPane.indexOfComponent(component);
            String string = BasicJideTabbedPaneUI.this.getCurrentDisplayTitleAt(jideTabbedPane, n2);
            boolean bl = BasicHTML.isHTMLString(string);
            if (bl) {
                if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                    BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jideTabbedPane, string);
                    BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(view, n2);
                }
            } else if (BasicJideTabbedPaneUI.this.htmlViews != null) {
                BasicJideTabbedPaneUI.this.htmlViews.insertElementAt(null, n2);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                if (n2 <= BasicJideTabbedPaneUI.this._tabPane.getEditingTabIndex()) {
                    ++((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI())._editingTab;
                }
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            JideTabbedPane jideTabbedPane = (JideTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource || component == jideTabbedPane.getTabLeadingComponent() || component == jideTabbedPane.getTabTrailingComponent()) {
                return;
            }
            Integer n2 = (Integer)jideTabbedPane.getClientProperty("__index_to_remove__");
            if (n2 != null) {
                if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.size() > n2) {
                    BasicJideTabbedPaneUI.this.htmlViews.removeElementAt(n2);
                }
                jideTabbedPane.putClientProperty("__index_to_remove__", null);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.isTabEditing()) {
                ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            }
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
        }
    }

    private class ComponentHandler
    implements ComponentListener {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() && (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 7 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }
    }

    public class MouseWheelHandler
    implements MouseWheelListener {
        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            block3: {
                block4: {
                    block2: {
                        if (!BasicJideTabbedPaneUI.this._tabPane.isScrollSelectedTabOnWheel()) break block2;
                        BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(Math.min(BasicJideTabbedPaneUI.this._tabPane.getTabCount() - 1, Math.max(0, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() + mouseWheelEvent.getWheelRotation())));
                        break block3;
                    }
                    if (!BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() || mouseWheelEvent.getWheelRotation() == 0) break block3;
                    if (mouseWheelEvent.getWheelRotation() <= 0) break block4;
                    for (int i2 = 0; i2 < mouseWheelEvent.getScrollAmount(); ++i2) {
                        BasicJideTabbedPaneUI.this._tabScroller.scrollForward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                    }
                    break block3;
                }
                if (mouseWheelEvent.getWheelRotation() >= 0) break block3;
                for (int i3 = 0; i3 < mouseWheelEvent.getScrollAmount(); ++i3) {
                    BasicJideTabbedPaneUI.this._tabScroller.scrollBackward(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement());
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicJideTabbedPaneUI.this._tabPane == null || !BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                int n2 = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY());
                Action action = BasicJideTabbedPaneUI.this.getActionMap().get("closeTabAction");
                if (action != null && n2 >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(n2) && BasicJideTabbedPaneUI.this._tabPane.isCloseTabOnMouseMiddleButton() && BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(n2)) {
                    ActionEvent actionEvent = new ActionEvent(BasicJideTabbedPaneUI.this._tabPane, n2, "middleMouseButtonClicked");
                    action.actionPerformed(actionEvent);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n2;
            if (BasicJideTabbedPaneUI.this._tabPane == null || !BasicJideTabbedPaneUI.this._tabPane.isEnabled()) {
                return;
            }
            if ((SwingUtilities.isLeftMouseButton(mouseEvent) || BasicJideTabbedPaneUI.this._tabPane.isRightClickSelect()) && (n2 = BasicJideTabbedPaneUI.this.tabForCoordinate(BasicJideTabbedPaneUI.this._tabPane, mouseEvent.getX(), mouseEvent.getY())) >= 0 && BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(n2)) {
                if (n2 == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex() && JideSwingUtilities.isAncestorOfFocusOwner(BasicJideTabbedPaneUI.this._tabPane)) {
                    if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                } else {
                    BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(n2);
                    if (BasicJideTabbedPaneUI.this._tabPane == null) {
                        return;
                    }
                    BasicJideTabbedPaneUI.this._tabPane.processMouseSelection(n2, mouseEvent);
                    final Component component = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n2);
                    if (BasicJideTabbedPaneUI.this._tabPane.isAutoFocusOnTabHideClose() && component != null && !component.isVisible() && SystemInfo.isJdk15Above() && !SystemInfo.isJdk6Above()) {
                        component.addComponentListener(new ComponentAdapter(){

                            @Override
                            public void componentShown(ComponentEvent componentEvent) {
                                component.removeComponentListener(this);
                                Component component2 = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(component);
                                if (component2 != null) {
                                    component2.requestFocus();
                                } else if (BasicJideTabbedPaneUI.this._tabPane.isRequestFocusEnabled()) {
                                    BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                                }
                            }
                        });
                    } else {
                        Component component2 = BasicJideTabbedPaneUI.this._tabPane.getLastFocusedComponent(component);
                        if (component2 != null) {
                            component2.requestFocus();
                        } else {
                            boolean bl = JideSwingUtilities.compositeRequestFocus(component);
                            if (!bl) {
                                BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                            }
                        }
                    }
                }
            }
            if (!BasicJideTabbedPaneUI.this.isTabEditing()) {
                BasicJideTabbedPaneUI.this.startEditing(mouseEvent);
            }
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
    }

    public class TabFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.repaintSelectedTab();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.repaintSelectedTab();
        }

        private void repaintSelectedTab() {
            Rectangle rectangle;
            if (BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 0 && (rectangle = BasicJideTabbedPaneUI.this.getTabBounds(BasicJideTabbedPaneUI.this._tabPane, BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex())) != null) {
                BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle);
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ((BasicJideTabbedPaneUI)BasicJideTabbedPaneUI.this._tabPane.getUI()).stopOrCancelEditing();
            BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("mnemonicAt".equals(string)) {
                BasicJideTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if ("displayedMnemonicIndexAt".equals(string)) {
                jTabbedPane.repaint();
            } else if (string.equals("indexForTitle")) {
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                String string2 = BasicJideTabbedPaneUI.this.getCurrentDisplayTitleAt(BasicJideTabbedPaneUI.this._tabPane, n2);
                if (BasicHTML.isHTMLString(string2)) {
                    if (BasicJideTabbedPaneUI.this.htmlViews == null) {
                        BasicJideTabbedPaneUI.this.htmlViews = BasicJideTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(BasicJideTabbedPaneUI.this._tabPane, string2);
                        BasicJideTabbedPaneUI.this.htmlViews.setElementAt(view, n2);
                    }
                } else if (BasicJideTabbedPaneUI.this.htmlViews != null && BasicJideTabbedPaneUI.this.htmlViews.elementAt(n2) != null) {
                    BasicJideTabbedPaneUI.this.htmlViews.setElementAt(null, n2);
                }
                BasicJideTabbedPaneUI.this.updateMnemonics();
                if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() && (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 7 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                    BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(false);
                }
            } else if (string.equals("indexForTabComponent")) {
                Component component;
                if (BasicJideTabbedPaneUI.this._tabContainer != null) {
                    BasicJideTabbedPaneUI.this._tabContainer.removeUnusedTabComponents();
                }
                Component component2 = component = SystemInfo.isJdk6Above() ? BasicJideTabbedPaneUI.this._tabPane.getTabComponentAt((Integer)propertyChangeEvent.getNewValue()) : null;
                if (component != null) {
                    if (BasicJideTabbedPaneUI.this._tabContainer == null) {
                        BasicJideTabbedPaneUI.this.installTabContainer();
                    } else {
                        BasicJideTabbedPaneUI.this._tabContainer.add(component);
                    }
                }
                BasicJideTabbedPaneUI.this._tabPane.revalidate();
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            } else if (string.equals("tabLayoutPolicy")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (string.equals("closeTabAction")) {
                BasicJideTabbedPaneUI.this.updateCloseAction();
            } else if (string.equals("dragOverDisabled")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (string.equals("tabColorProvider")) {
                BasicJideTabbedPaneUI.this._tabPane.repaint();
            } else if (string.equals("locale")) {
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (string.equals("boldActiveTab")) {
                BasicJideTabbedPaneUI.this.getTabPanel().invalidate();
                BasicJideTabbedPaneUI.this._tabPane.invalidate();
                if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled() && (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 7 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                    BasicJideTabbedPaneUI.this._tabScroller.viewport.setViewSize(new Dimension(BasicJideTabbedPaneUI.this._tabPane.getWidth(), BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewSize().height));
                    BasicJideTabbedPaneUI.this.ensureActiveTabIsVisible(true);
                }
            } else if (string.equals("tabLeadingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabLeadingComponent = (Component)propertyChangeEvent.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabLeadingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setVisible(true);
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabLeadingComponent);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (string.equals("tabTrailingComponent")) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(false);
                    BasicJideTabbedPaneUI.this._tabPane.remove(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                }
                BasicJideTabbedPaneUI.this._tabTrailingComponent = (Component)propertyChangeEvent.getNewValue();
                if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null) {
                    BasicJideTabbedPaneUI.this._tabPane.add(BasicJideTabbedPaneUI.this._tabTrailingComponent);
                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(true);
                }
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.updateUI();
            } else if (string.equals("shrinkTab") || string.equals("hideIfOneTab") || string.equals("showTabArea") || string.equals("showTabContent") || string.equals("boxStyle") || string.equals("showIconsOnTab") || string.equals("showCloseButton") || string.equals("useDefaultShowIconsOnTab") || string.equals("showCloseButtonOnTab") || string.equals("useDefaultShowCloseButtonOnTab") || string.equals("tabClosable") || string.equals("tabShape") || string.equals("colorTheme") || string.equals("tabResizeMode") || string.equals("showTabButtons")) {
                if ((string.equals("useDefaultShowCloseButtonOnTab") || string.equals("showCloseButtonOnTab")) && BasicJideTabbedPaneUI.this.isShowCloseButton() && BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab()) {
                    BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                }
                BasicJideTabbedPaneUI.this._tabPane.updateUI();
            } else if (string.equals("__index_to_remove__")) {
                BasicJideTabbedPaneUI.this.setVisibleComponent(null);
            } else if (string.equals("componentOrientation") && BasicJideTabbedPaneUI.this._tabPane != null) {
                if (BasicJideTabbedPaneUI.this._tabCount != BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                    BasicJideTabbedPaneUI.this._tabCount = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
                    BasicJideTabbedPaneUI.this.updateMnemonics();
                }
                if (BasicJideTabbedPaneUI.this._tabScroller != null && BasicJideTabbedPaneUI.this._tabScroller.tabPanel != null) {
                    BasicJideTabbedPaneUI.this._tabScroller.setLeadingTabIndex(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), BasicJideTabbedPaneUI.this._tabScroller.leadingTabIndex);
                }
            }
        }
    }

    @Deprecated
    public class TabCloseButton
    extends JButton
    implements MouseMotionListener,
    MouseListener,
    UIResource {
        @Deprecated
        public static final int CLOSE_BUTTON = 0;
        @Deprecated
        public static final int EAST_BUTTON = 1;
        @Deprecated
        public static final int WEST_BUTTON = 2;
        @Deprecated
        public static final int NORTH_BUTTON = 3;
        @Deprecated
        public static final int SOUTH_BUTTON = 4;
        @Deprecated
        public static final int LIST_BUTTON = 5;
        private int _type;
        private int _index = -1;
        private boolean _mouseOver = false;
        private boolean _mousePressed = false;

        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
            String string = this.getName();
            if (string != null) {
                this.setToolTipText(BasicJideTabbedPaneUI.this.getResourceString(string));
            }
        }

        public TabCloseButton() {
            this(0);
        }

        public TabCloseButton(int n2) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setType(n2);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int n2) {
            this._index = n2;
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            if (this.isMouseOver() && this.isMousePressed()) {
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                graphics.setColor(UIDefaultsLookup.getColor("control"));
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            } else if (this.isMouseOver()) {
                graphics.setColor(UIDefaultsLookup.getColor("control"));
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            }
            graphics.setColor(UIDefaultsLookup.getColor("controlShadow").darker());
            int n2 = this.getWidth() >> 1;
            int n3 = this.getHeight() >> 1;
            int n4 = this.getType();
            if (!(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 1 && BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 3 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                if (n4 == 1) {
                    n4 = 2;
                } else if (n4 == 2) {
                    n4 = 1;
                }
            }
            switch (n4) {
                case 0: {
                    if (this.isEnabled()) {
                        graphics.drawLine(n2 - 3, n3 - 3, n2 + 3, n3 + 3);
                        graphics.drawLine(n2 - 4, n3 - 3, n2 + 2, n3 + 3);
                        graphics.drawLine(n2 + 3, n3 - 3, n2 - 3, n3 + 3);
                        graphics.drawLine(n2 + 2, n3 - 3, n2 - 4, n3 + 3);
                        break;
                    }
                    graphics.drawLine(n2 - 3, n3 - 3, n2 + 3, n3 + 3);
                    graphics.drawLine(n2 + 3, n3 - 3, n2 - 3, n3 + 3);
                    break;
                }
                case 1: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int n5 = n2 + 2;
                        int n6 = n3;
                        if (this.isEnabled()) {
                            graphics.drawLine(n5 - 4, n6 - 4, n5 - 4, n6 + 4);
                            graphics.drawLine(n5 - 3, n6 - 3, n5 - 3, n6 + 3);
                            graphics.drawLine(n5 - 2, n6 - 2, n5 - 2, n6 + 2);
                            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + 1);
                            graphics.drawLine(n5, n6, n5, n6);
                            break;
                        }
                        graphics.drawLine(n5 - 4, n6 - 4, n5, n6);
                        graphics.drawLine(n5 - 4, n6 - 4, n5 - 4, n6 + 4);
                        graphics.drawLine(n5 - 4, n6 + 4, n5, n6);
                        break;
                    }
                    int n7 = n2 + 3;
                    int n8 = n3 - 2;
                    if (this.isEnabled()) {
                        graphics.drawLine(n7 - 8, n8, n7, n8);
                        graphics.drawLine(n7 - 7, n8 + 1, n7 - 1, n8 + 1);
                        graphics.drawLine(n7 - 6, n8 + 2, n7 - 2, n8 + 2);
                        graphics.drawLine(n7 - 5, n8 + 3, n7 - 3, n8 + 3);
                        graphics.drawLine(n7 - 4, n8 + 4, n7 - 4, n8 + 4);
                        break;
                    }
                    graphics.drawLine(n7 - 8, n8, n7, n8);
                    graphics.drawLine(n7 - 8, n8, n7 - 4, n8 + 4);
                    graphics.drawLine(n7 - 4, n8 + 4, n7, n8);
                    break;
                }
                case 2: {
                    if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int n9 = n2 - 3;
                        int n10 = n3;
                        if (this.isEnabled()) {
                            graphics.drawLine(n9, n10, n9, n10);
                            graphics.drawLine(n9 + 1, n10 - 1, n9 + 1, n10 + 1);
                            graphics.drawLine(n9 + 2, n10 - 2, n9 + 2, n10 + 2);
                            graphics.drawLine(n9 + 3, n10 - 3, n9 + 3, n10 + 3);
                            graphics.drawLine(n9 + 4, n10 - 4, n9 + 4, n10 + 4);
                            break;
                        }
                        graphics.drawLine(n9, n10, n9 + 4, n10 - 4);
                        graphics.drawLine(n9, n10, n9 + 4, n10 + 4);
                        graphics.drawLine(n9 + 4, n10 - 4, n9 + 4, n10 + 4);
                        break;
                    }
                    int n11 = n2 - 5;
                    int n12 = n3 + 3;
                    if (this.isEnabled()) {
                        graphics.drawLine(n11, n12, n11 + 8, n12);
                        graphics.drawLine(n11 + 1, n12 - 1, n11 + 7, n12 - 1);
                        graphics.drawLine(n11 + 2, n12 - 2, n11 + 6, n12 - 2);
                        graphics.drawLine(n11 + 3, n12 - 3, n11 + 5, n12 - 3);
                        graphics.drawLine(n11 + 4, n12 - 4, n11 + 4, n12 - 4);
                        break;
                    }
                    graphics.drawLine(n11, n12, n11 + 8, n12);
                    graphics.drawLine(n11, n12, n11 + 4, n12 - 4);
                    graphics.drawLine(n11 + 8, n12, n11 + 4, n12 - 4);
                    break;
                }
                case 5: {
                    int n13 = n2 + 2;
                    int n14 = n3;
                    graphics.drawLine(n13 - 6, n14 - 4, n13 - 6, n14 + 4);
                    graphics.drawLine(n13 + 1, n14 - 4, n13 + 1, n14 + 4);
                    graphics.drawLine(n13 - 6, n14 - 4, n13 + 1, n14 - 4);
                    graphics.drawLine(n13 - 4, n14 - 2, n13 - 1, n14 - 2);
                    graphics.drawLine(n13 - 4, n14, n13 - 1, n14);
                    graphics.drawLine(n13 - 4, n14 + 2, n13 - 1, n14 + 2);
                    graphics.drawLine(n13 - 6, n14 + 4, n13 + 1, n14 + 4);
                    break;
                }
            }
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        public boolean scrollsForward() {
            return this.getType() == 1 || this.getType() == 4;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.setMousePressed(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(true);
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(true);
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setMouseOver(false);
            this.setMousePressed(false);
            this.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.tabPanel.repaint();
        }

        public int getType() {
            return this._type;
        }

        public void setType(int n2) {
            this._type = n2;
        }

        public boolean isMouseOver() {
            return this._mouseOver;
        }

        public void setMouseOver(boolean bl) {
            this._mouseOver = bl;
        }

        public boolean isMousePressed() {
            return this._mousePressed;
        }

        public void setMousePressed(boolean bl) {
            this._mousePressed = bl;
        }
    }

    public class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public void scrollIndexToVisible(int n2) {
            Rectangle rectangle = new Rectangle(BasicJideTabbedPaneUI.this._rects[n2]);
            if (!(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 1 && BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() != 3 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() || n2 != 0)) {
                rectangle.width += BasicJideTabbedPaneUI.this.getLeftMargin();
            }
            this.scrollRectToVisible(rectangle);
        }

        @Override
        public void scrollRectToVisible(Rectangle rectangle) {
            super.scrollRectToVisible(rectangle);
        }

        @Override
        public Dimension getPreferredSize() {
            if (BasicJideTabbedPaneUI.this._rects.length <= 0) {
                return new Dimension(0, 0);
            }
            if (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || BasicJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                    return new Dimension(BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].width + 10, BasicJideTabbedPaneUI.this._rects[0].y + BasicJideTabbedPaneUI.this._rects[0].height);
                }
                return new Dimension(BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this.getLeftMargin(), BasicJideTabbedPaneUI.this._rects[0].y + BasicJideTabbedPaneUI.this._rects[0].height);
            }
            return new Dimension(BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width, BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].y + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].height);
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
            return 1;
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
            return 1;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (BasicJideTabbedPaneUI.this._tabPane.isOpaque()) {
                if (BasicJideTabbedPaneUI.this.getTabShape() == 3) {
                    graphics.setColor(UIDefaultsLookup.getColor("JideTabbedPane.selectedTabBackground"));
                } else {
                    graphics.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
                }
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            BasicJideTabbedPaneUI.this.paintTabArea(graphics, BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex(), this);
        }

        @Override
        public void setToolTipText(String string) {
            BasicJideTabbedPaneUI.this._tabPane.setToolTipText(string);
        }

        @Override
        public String getToolTipText() {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText();
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipText(SwingUtilities.convertMouseEvent(this, mouseEvent, BasicJideTabbedPaneUI.this._tabPane));
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            return BasicJideTabbedPaneUI.this._tabPane.getToolTipLocation(SwingUtilities.convertMouseEvent(this, mouseEvent, BasicJideTabbedPaneUI.this._tabPane));
        }

        @Override
        public JToolTip createToolTip() {
            return BasicJideTabbedPaneUI.this._tabPane.createToolTip();
        }

        @Override
        public void doLayout() {
            if (BasicJideTabbedPaneUI.this._tabContainer != null && BasicJideTabbedPaneUI.this._tabContainer.getParent() == this) {
                BasicJideTabbedPaneUI.this._tabContainer.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    public class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setOpaque(false);
        }

        @Override
        public void setViewPosition(Point point) {
            super.setViewPosition(point);
        }

        @Override
        public Color getBackground() {
            return UIDefaultsLookup.getColor("JideTabbedPane.background");
        }
    }

    public class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public JButton listButton;
        public JButton closeButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n2) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = BasicJideTabbedPaneUI.this.createButton(1);
            this.scrollBackwardButton = BasicJideTabbedPaneUI.this.createButton(2);
            this.scrollForwardButton.setBackground(this.viewport.getBackground());
            this.scrollBackwardButton.setBackground(this.viewport.getBackground());
            this.listButton = BasicJideTabbedPaneUI.this.createButton(5);
            this.listButton.setBackground(this.viewport.getBackground());
            this.closeButton = BasicJideTabbedPaneUI.this.createButton(0);
            this.closeButton.setBackground(this.viewport.getBackground());
        }

        public void createPopupMenu(int n2) {
            Serializable serializable;
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int n4 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!BasicJideTabbedPaneUI.this._tabPane.isEnabledAt(i2)) continue;
                serializable = new JCheckBoxMenuItem(new ActivateTabAction(BasicJideTabbedPaneUI.this._tabPane.getTitleAt(i2), BasicJideTabbedPaneUI.this._tabPane.getIconForTab(i2), i2));
                jPopupMenu.add((JMenuItem)serializable);
                ((JComponent)serializable).setToolTipText(BasicJideTabbedPaneUI.this._tabPane.getToolTipTextAt(i2));
                ((AbstractButton)serializable).setSelected(n4 == i2);
                ((AbstractButton)serializable).setHorizontalTextPosition(4);
            }
            Dimension dimension = jPopupMenu.getPreferredSize();
            serializable = this.listButton.getBounds();
            switch (n2) {
                case 1: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x + ((Rectangle)serializable).width - dimension.width, ((Rectangle)serializable).y + ((Rectangle)serializable).height);
                    break;
                }
                case 3: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x + ((Rectangle)serializable).width - dimension.width, ((Rectangle)serializable).y - dimension.height);
                    break;
                }
                case 2: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x + ((Rectangle)serializable).width, ((Rectangle)serializable).y + ((Rectangle)serializable).height - dimension.height);
                    break;
                }
                case 4: {
                    jPopupMenu.show(BasicJideTabbedPaneUI.this._tabPane, ((Rectangle)serializable).x - dimension.width, ((Rectangle)serializable).y + ((Rectangle)serializable).height - dimension.height);
                }
            }
        }

        public void createPopup(int n2) {
            BasicJideTabbedPaneUI.this._tabPane.showTabListPopup(this.listButton);
        }

        public void scrollForward(int n2) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n2 == 1 || n2 == 3 ? (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() ? rectangle.width >= dimension.width - rectangle.x : rectangle.x <= 0) : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n2) {
            this.setLeadingTabIndex(n2, this.leadingTabIndex > 0 ? this.leadingTabIndex - 1 : 0);
        }

        public void setLeadingTabIndex(int n2, int n3) {
            if (n3 < 0 || n3 >= BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                return;
            }
            this.leadingTabIndex = n3;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n2) {
                case 1: 
                case 3: {
                    this.tabViewPosition.y = 0;
                    if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                        int n4 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x;
                        if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                        this.tabViewPosition.x = dimension.width - rectangle.width;
                        break;
                    }
                    if (BasicJideTabbedPaneUI.this._rects.length <= 0) {
                        this.tabViewPosition.x = 0;
                        break;
                    }
                    if (BasicJideTabbedPaneUI.this._rects.length == 1) {
                        this.tabViewPosition.x = BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth - rectangle.width;
                        break;
                    }
                    Insets insets = BasicJideTabbedPaneUI.this.getTabAreaInsets(n2);
                    Rectangle[] rectangleArray = BasicJideTabbedPaneUI.this._rects;
                    if (BasicJideTabbedPaneUI.this._rects[0].x < BasicJideTabbedPaneUI.this._rects[1].x) {
                        rectangleArray = new Rectangle[BasicJideTabbedPaneUI.this._rects.length];
                        int n5 = 0;
                        if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                            n5 = BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].width;
                            BasicJideTabbedPaneUI.this._additionalWidth = BasicJideTabbedPaneUI.this._rects[0].x;
                        }
                        for (int i2 = 0; i2 < BasicJideTabbedPaneUI.this._tabCount; ++i2) {
                            rectangleArray[i2] = new Rectangle(BasicJideTabbedPaneUI.this._rects[i2]);
                            rectangleArray[i2].x = n5 - BasicJideTabbedPaneUI.this._rects[i2].x - BasicJideTabbedPaneUI.this._rects[i2].width + insets.left;
                        }
                    }
                    this.tabViewPosition.x = rectangleArray[this.leadingTabIndex].x + rectangleArray[this.leadingTabIndex].width + (this.leadingTabIndex == 0 ? BasicJideTabbedPaneUI.this._additionalWidth : 0) - rectangle.width;
                    break;
                }
                case 2: 
                case 4: {
                    this.tabViewPosition.x = 0;
                    int n6 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    this.tabViewPosition.y = dimension.height - rectangle.height;
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
            BasicJideTabbedPaneUI.this._tabPane.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            if (BasicJideTabbedPaneUI.this._tabPane == null) {
                return;
            }
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() || n3 != 1 && n3 != 3) {
                BasicJideTabbedPaneUI.this.ensureCurrentLayout();
            }
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n4 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            if (!(n3 != 1 && n3 != 3 || BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight())) {
                this.leadingTabIndex = BasicJideTabbedPaneUI.this.getClosestTab(rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height - 1);
                if (this.leadingTabIndex < 0) {
                    this.leadingTabIndex = 0;
                }
            } else {
                this.leadingTabIndex = BasicJideTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            }
            if (this.leadingTabIndex < BasicJideTabbedPaneUI.this._rects.length && this.leadingTabIndex >= BasicJideTabbedPaneUI.this._rects.length) {
                switch (n3) {
                    case 1: 
                    case 3: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicJideTabbedPaneUI.this._rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BasicJideTabbedPaneUI.this.getContentBorderInsets(n3);
            switch (n3) {
                case 2: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n4 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 || this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n4 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                        this.scrollBackwardButton.setEnabled(rectangle2.x > 0 || this.leadingTabIndex > 0);
                        this.scrollForwardButton.setEnabled(this.leadingTabIndex < n4 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                        break;
                    }
                    this.scrollBackwardButton.setEnabled(BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > rectangle2.width);
                    int n5 = n2 = this.leadingTabIndex < n4 - 1 && BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > 0;
                    if (n2 && BasicJideTabbedPaneUI.this._rects.length > 0 && BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x < rectangle2.width) {
                        n2 = 0;
                    }
                    this.scrollForwardButton.setEnabled(n2 != 0);
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    if (BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight()) {
                        this.scrollBackwardButton.setEnabled(rectangle2.x > 0 || this.leadingTabIndex > 0);
                        this.scrollForwardButton.setEnabled(this.leadingTabIndex < n4 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                        break;
                    }
                    this.scrollBackwardButton.setEnabled(BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > rectangle2.width);
                    int n6 = n2 = this.leadingTabIndex < n4 - 1 && BasicJideTabbedPaneUI.this._tabScroller.viewport.getViewPosition().x > 0;
                    if (n2 && BasicJideTabbedPaneUI.this._rects.length > 0 && BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth - BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x < rectangle2.width) {
                        n2 = 0;
                    }
                    this.scrollForwardButton.setEnabled(n2 != 0);
                }
            }
            if (SystemInfo.isJdk15Above()) {
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton, 0);
                BasicJideTabbedPaneUI.this._tabPane.setComponentZOrder(BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton, 0);
            }
            BasicJideTabbedPaneUI.this._tabScroller.scrollForwardButton.repaint();
            BasicJideTabbedPaneUI.this._tabScroller.scrollBackwardButton.repaint();
            n2 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            if (n2 >= 0 && n2 < BasicJideTabbedPaneUI.this._tabPane.getTabCount()) {
                this.closeButton.setEnabled(BasicJideTabbedPaneUI.this._tabPane.isTabClosableAt(n2));
            }
        }

        public String toString() {
            return "viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition;
        }
    }

    protected class ActivateTabAction
    extends AbstractAction {
        int _tabIndex;
        private static final long serialVersionUID = 3270152106579039554L;

        public ActivateTabAction(String string, Icon icon, int n2) {
            super(string, icon);
            this._tabIndex = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI.this._tabPane.setSelectedIndex(this._tabIndex);
        }
    }

    protected class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        protected TabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int n2, int n3) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n2);
        }

        @Override
        protected int preferredTabAreaWidth(int n2, int n3) {
            return BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int n4 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component component = BasicJideTabbedPaneUI.this.getVisibleComponent();
            boolean bl = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            JViewport jViewport = null;
            this.calculateLayoutInfo();
            if (n4 < 0) {
                if (component != null) {
                    BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = n4 >= BasicJideTabbedPaneUI.this._tabPane.getTabCount() ? null : BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n4);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && JideSwingUtilities.isAncestorOfFocusOwner(component) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                        bl2 = true;
                    }
                    BasicJideTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = BasicJideTabbedPaneUI.this.getContentBorderInsets(n2);
                Rectangle rectangle = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                int n5 = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                Dimension dimension = new Dimension(0, 0);
                Dimension dimension2 = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    dimension = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    dimension2 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                if (n5 > 0) {
                    int n6;
                    int n7;
                    Serializable serializable;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    switch (n2) {
                        case 2: {
                            n16 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            n15 = rectangle.height - insets.top - insets.bottom;
                            n14 = insets.left;
                            n13 = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                n13 += dimension.height;
                                n15 -= dimension.height;
                                if (dimension.width > n16) {
                                    n16 = dimension.width;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                n15 -= dimension2.height;
                                if (dimension2.width > n16) {
                                    n16 = dimension2.width;
                                }
                            }
                            n12 = n14 + n16 + insets2.left;
                            n11 = insets.top + insets2.top;
                            n10 = rectangle.width - insets.left - insets.right - n16 - insets2.left - insets2.right;
                            n9 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n16 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(1, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                            n15 = rectangle.height - insets.top - insets.bottom;
                            n14 = rectangle.width - insets.right - n16;
                            n13 = insets.top;
                            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                n13 += dimension.height;
                                n15 -= dimension.height;
                                if (dimension.width > n16) {
                                    n16 = dimension.width;
                                    n14 = rectangle.width - insets.right - n16;
                                }
                            }
                            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                n15 -= dimension2.height;
                                if (dimension2.width > n16) {
                                    n16 = dimension2.width;
                                    n14 = rectangle.width - insets.right - n16;
                                }
                            }
                            n12 = insets.left + insets2.left;
                            n11 = insets.top + insets2.top;
                            n10 = rectangle.width - insets.left - insets.right - n16 - insets2.left - insets2.right;
                            n9 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n16 = rectangle.width - insets.left - insets.right;
                            n15 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            n14 = insets.left;
                            n13 = rectangle.height - insets.bottom - n15;
                            if (bl) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n14 += dimension.width;
                                    n16 -= dimension.width;
                                    if (dimension.height > n15) {
                                        n15 = dimension.height;
                                        n13 = rectangle.height - insets.bottom - n15;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n16 -= dimension2.width;
                                    if (dimension2.height > n15) {
                                        n15 = dimension2.height;
                                        n13 = rectangle.height - insets.bottom - n15;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n14 += dimension2.width;
                                    n16 -= dimension2.width;
                                    if (dimension2.height > n15) {
                                        n15 = dimension2.height;
                                        n13 = rectangle.height - insets.bottom - n15;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n16 -= dimension.width;
                                    if (dimension.height > n15) {
                                        n15 = dimension.height;
                                        n13 = rectangle.height - insets.bottom - n15;
                                    }
                                }
                            }
                            n12 = insets.left + insets2.left;
                            n11 = insets.top + insets2.top;
                            n10 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n9 = rectangle.height - insets.top - insets.bottom - n15 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n16 = rectangle.width - insets.left - insets.right;
                            n15 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                            n14 = insets.left;
                            n13 = insets.top;
                            Insets insets3 = BasicJideTabbedPaneUI.this.getTabAreaInsets(n2);
                            if (insets3 != null) {
                                n14 += insets3.left;
                                n16 -= insets3.left + insets3.right;
                            }
                            if (bl) {
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n14 += dimension.width;
                                    n16 -= dimension.width;
                                    if (dimension.height > n15) {
                                        n15 = dimension.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n16 -= dimension2.width;
                                    if (dimension2.height > n15) {
                                        n15 = dimension2.height;
                                    }
                                }
                            } else {
                                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                    n14 += dimension2.width;
                                    n16 -= dimension2.width;
                                    if (dimension2.height > n15) {
                                        n15 = dimension2.height;
                                    }
                                }
                                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                                    n16 -= dimension.width;
                                    if (dimension.height > n15) {
                                        n15 = dimension.height;
                                    }
                                }
                            }
                            n12 = insets.left + insets2.left;
                            n11 = insets.top + n15 + insets2.top;
                            n10 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n9 = rectangle.height - insets.top - insets.bottom - n15 - insets2.top - insets2.bottom;
                        }
                    }
                    for (n8 = 0; n8 < n5; n8 += 1) {
                        int n17;
                        int n18;
                        int n19;
                        int n20;
                        int n21;
                        serializable = BasicJideTabbedPaneUI.this._tabPane.getComponent(n8);
                        n7 = 1;
                        if (serializable instanceof ScrollableTabViewport) {
                            jViewport = (JViewport)serializable;
                            int n22 = n14;
                            int n23 = n16;
                            n6 = n13;
                            n21 = n15;
                            n20 = BasicJideTabbedPaneUI.this.getNumberOfTabButtons();
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    n19 = BasicJideTabbedPaneUI.this._rects[n3 - 1].y + BasicJideTabbedPaneUI.this._rects[n3 - 1].height;
                                    if (n19 > n15 && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1 || BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            n20 += 3;
                                        }
                                        n21 = Math.max(n15 - BasicJideTabbedPaneUI.this._buttonSize * n20, 0);
                                    } else {
                                        n21 = Math.max(n15 - BasicJideTabbedPaneUI.this._buttonSize * n20, 0);
                                        n7 = 0;
                                    }
                                    if (n21 + BasicJideTabbedPaneUI.this.getLayoutSize() >= n15 - BasicJideTabbedPaneUI.this._buttonSize * n20) break;
                                    n21 += BasicJideTabbedPaneUI.this.getLayoutSize();
                                    break;
                                }
                                default: {
                                    n18 = 0;
                                    if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                                        n18 = bl ? BasicJideTabbedPaneUI.this._rects[n3 - 1].x + BasicJideTabbedPaneUI.this._rects[n3 - 1].width : BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this.getLeftMargin();
                                    }
                                    int n24 = n17 = n18 <= n16 || BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2 ? 1 : 0;
                                    if (BasicJideTabbedPaneUI.this.isShowTabButtons() || n17 == 0 && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1) {
                                        if (!BasicJideTabbedPaneUI.this.isShowTabButtons()) {
                                            n20 += 3;
                                        }
                                        n23 = Math.max(n16 - BasicJideTabbedPaneUI.this._buttonSize * n20, 0);
                                        if (!bl) {
                                            n22 += BasicJideTabbedPaneUI.this._buttonSize * n20;
                                        }
                                    } else {
                                        n7 = 0;
                                        n23 = Math.max(n16 - BasicJideTabbedPaneUI.this._buttonSize * n20, 0);
                                        if (!bl) {
                                            n22 += BasicJideTabbedPaneUI.this._buttonSize * n20;
                                        }
                                    }
                                    if (n23 + BasicJideTabbedPaneUI.this.getLayoutSize() >= n16 - BasicJideTabbedPaneUI.this._buttonSize * n20) break;
                                    n23 += BasicJideTabbedPaneUI.this.getLayoutSize();
                                    if (bl) break;
                                    n22 -= BasicJideTabbedPaneUI.this.getLayoutSize();
                                }
                            }
                            if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null && BasicJideTabbedPaneUI.this._tabPane.isHideTrailingWhileNoButtons()) {
                                BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(n7 != 0);
                            }
                            ((Component)serializable).setBounds(n22, n6, n23, n21);
                            try {
                                if (bl || n2 != 1 && n2 != 3) continue;
                                if (BasicJideTabbedPaneUI.this.getTabResizeMode() == 2) {
                                    jViewport.setViewPosition(new Point(0, 0));
                                    continue;
                                }
                                if (BasicJideTabbedPaneUI.this._layouted) continue;
                                BasicJideTabbedPaneUI.this._tabScroller.setLeadingTabIndex(n2, 0);
                                continue;
                            }
                            finally {
                                BasicJideTabbedPaneUI.this._layouted = true;
                            }
                        }
                        if (serializable instanceof JideTabbedPane.NoFocusButton) {
                            JideTabbedPane.NoFocusButton noFocusButton = (JideTabbedPane.NoFocusButton)serializable;
                            if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (noFocusButton.getType() != 0 || !BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab())) {
                                Dimension dimension3 = noFocusButton.getPreferredSize();
                                n6 = 0;
                                n21 = 0;
                                n20 = dimension3.width;
                                n19 = dimension3.height;
                                n18 = 0;
                                switch (n2) {
                                    case 2: 
                                    case 4: {
                                        int n25;
                                        n17 = BasicJideTabbedPaneUI.this._rects[n3 - 1].y + BasicJideTabbedPaneUI.this._rects[n3 - 1].height;
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || n17 > n15 && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1)) {
                                            n25 = noFocusButton.getType();
                                            noFocusButton.setType(n25);
                                            switch (n25) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        n18 = 1;
                                                        n21 = rectangle.height - insets.top - dimension3.height - 5;
                                                        break;
                                                    }
                                                    n18 = 0;
                                                    n21 = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    n18 = 1;
                                                    n21 = rectangle.height - insets.top - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.height - 5;
                                                    break;
                                                }
                                                case 1: {
                                                    n18 = !BasicJideTabbedPaneUI.this.isShrinkTabs() ? 1 : 0;
                                                    n21 = rectangle.height - insets.top - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.height - 5;
                                                    break;
                                                }
                                                case 2: {
                                                    n18 = !BasicJideTabbedPaneUI.this.isShrinkTabs() ? 1 : 0;
                                                    n21 = rectangle.height - insets.top - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.height - 5;
                                                }
                                            }
                                            n6 = n14 + 2;
                                        } else {
                                            n7 = 0;
                                            n25 = noFocusButton.getType();
                                            noFocusButton.setType(n25);
                                            if (n25 == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    n18 = 1;
                                                    n21 = rectangle.height - insets.top - dimension3.height - 5;
                                                } else {
                                                    n18 = 0;
                                                    n21 = 0;
                                                }
                                                n6 = n14 + 2;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null && BasicJideTabbedPaneUI.this._tabPane.isHideTrailingWhileNoButtons()) {
                                            BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(n7 != 0);
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            n21 -= dimension2.height;
                                        }
                                        n25 = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && dimension.width >= BasicJideTabbedPaneUI.this._rects[0].width && n2 == 2) {
                                            n6 += dimension.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                            n25 = dimension.width;
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || dimension2.width < BasicJideTabbedPaneUI.this._rects[0].width || n25 >= dimension2.width || n2 != 2) break;
                                        n6 += dimension2.width - BasicJideTabbedPaneUI.this._rects[0].width;
                                        break;
                                    }
                                    default: {
                                        int n26;
                                        boolean bl3;
                                        int n27 = 0;
                                        if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                                            n27 = bl ? BasicJideTabbedPaneUI.this._rects[n3 - 1].x + BasicJideTabbedPaneUI.this._rects[n3 - 1].width : BasicJideTabbedPaneUI.this._rects[0].x + BasicJideTabbedPaneUI.this._rects[0].width + BasicJideTabbedPaneUI.this._additionalWidth;
                                        }
                                        boolean bl4 = bl3 = n27 <= n16 || BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2;
                                        if (BasicJideTabbedPaneUI.this._tabPane.isTabShown() && (BasicJideTabbedPaneUI.this.isShowTabButtons() || !bl3 && BasicJideTabbedPaneUI.this._tabPane.getTabCount() > 1 || noFocusButton.getType() == 0 && BasicJideTabbedPaneUI.this.isShowCloseButton())) {
                                            n26 = noFocusButton.getType();
                                            noFocusButton.setType(n26);
                                            switch (n26) {
                                                case 0: {
                                                    if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                        n18 = 1;
                                                        if (bl) {
                                                            n6 = rectangle.width - insets.left - dimension3.width - 5;
                                                            break;
                                                        }
                                                        n6 = insets.left - 5;
                                                        break;
                                                    }
                                                    n18 = 0;
                                                    n6 = 0;
                                                    break;
                                                }
                                                case 5: {
                                                    n18 = 1;
                                                    if (bl) {
                                                        n6 = rectangle.width - insets.left - (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width - 5;
                                                        break;
                                                    }
                                                    n6 = insets.left + (1 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width + 5;
                                                    break;
                                                }
                                                case 1: {
                                                    int n28 = n18 = !BasicJideTabbedPaneUI.this.isShrinkTabs() ? 1 : 0;
                                                    if (bl) {
                                                        n6 = rectangle.width - insets.left - (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width - 5;
                                                        break;
                                                    }
                                                    n6 = insets.left + (2 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width + 5;
                                                    break;
                                                }
                                                case 2: {
                                                    int n29 = n18 = !BasicJideTabbedPaneUI.this.isShrinkTabs() ? 1 : 0;
                                                    n6 = bl ? rectangle.width - insets.left - (4 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width - 5 : insets.left + (3 - (!BasicJideTabbedPaneUI.this.isShowCloseButton() || BasicJideTabbedPaneUI.this.isShowCloseButtonOnTab() ? 1 : 0)) * dimension3.width + 5;
                                                }
                                            }
                                            n21 = (n15 - dimension3.height >> 1) + n13;
                                        } else {
                                            n7 = 0;
                                            n26 = noFocusButton.getType();
                                            noFocusButton.setType(n26);
                                            if (n26 == 0) {
                                                if (BasicJideTabbedPaneUI.this.isShowCloseButton()) {
                                                    n18 = 1;
                                                    n6 = rectangle.width - insets.left - dimension3.width - 5;
                                                } else {
                                                    n18 = 0;
                                                    n6 = 0;
                                                }
                                                n21 = (n15 - dimension3.height >> 1) + n13;
                                            }
                                        }
                                        if (BasicJideTabbedPaneUI.this._tabTrailingComponent != null && BasicJideTabbedPaneUI.this._tabPane.isHideTrailingWhileNoButtons()) {
                                            BasicJideTabbedPaneUI.this._tabTrailingComponent.setVisible(n7 != 0);
                                        }
                                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                                            n6 = bl ? (n6 -= dimension2.width) : (n6 += dimension2.width);
                                        }
                                        int n25 = -1;
                                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && dimension.height >= BasicJideTabbedPaneUI.this._rects[0].height) {
                                            if (n2 == 1) {
                                                n21 = n13 + 2 + dimension.height - BasicJideTabbedPaneUI.this._rects[0].height;
                                                n25 = dimension.height;
                                            } else {
                                                n21 = n13 + 2;
                                            }
                                        }
                                        if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || dimension2.height < BasicJideTabbedPaneUI.this._rects[0].height || n25 >= dimension2.height) break;
                                        n21 = n2 == 1 ? n13 + 2 + dimension2.height - BasicJideTabbedPaneUI.this._rects[0].height : n13 + 2;
                                    }
                                }
                                ((Component)serializable).setVisible(n18 != 0);
                                if (n18 == 0) continue;
                                ((Component)serializable).setBounds(n6, n21, n20, n19);
                                continue;
                            }
                            noFocusButton.setBounds(0, 0, 0, 0);
                            continue;
                        }
                        if (serializable == BasicJideTabbedPaneUI.this._tabPane.getTabLeadingComponent() || serializable == BasicJideTabbedPaneUI.this._tabPane.getTabTrailingComponent()) continue;
                        if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                            ((Component)serializable).setBounds(n12, n11, n10, n9);
                            continue;
                        }
                        ((Component)serializable).setBounds(0, 0, 0, 0);
                    }
                    if (bl) {
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14 + n16 - dimension.width, n13 - dimension.height, dimension.width, dimension.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14, n13 - dimension.height, dimension.width, dimension.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14 - dimension.width, n13, dimension.width, dimension.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14 - dimension.width, n13 + n15 - dimension.height, dimension.width, dimension.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14 + n16 - dimension2.width, n13 + n15, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14, n13 + n15, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14 + n16, n13, dimension2.width, dimension2.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14 + n16, n13 + n15 - dimension2.height, dimension2.width, dimension2.height);
                                    break;
                                }
                            }
                        }
                    } else {
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14 + n16 - dimension2.width, n13 - dimension2.height, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14, n13 - dimension2.height, dimension2.width, dimension2.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14 - dimension2.width, n13, dimension2.width, dimension2.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(n14 - dimension2.width, n13 + n15 - dimension2.height, dimension2.width, dimension2.height);
                                }
                            }
                        }
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            switch (BasicJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                                case 2: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14 + n16 - dimension.width, n13 + n15, dimension.width, dimension.height);
                                    break;
                                }
                                case 4: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14, n13 + n15, dimension.width, dimension.height);
                                    break;
                                }
                                case 3: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14 + n16, n13, dimension.width, dimension.height);
                                    break;
                                }
                                default: {
                                    BasicJideTabbedPaneUI.this._tabLeadingComponent.setBounds(n14 + n16, n13 + n15 - dimension.height, dimension.width, dimension.height);
                                }
                            }
                        }
                    }
                    int n30 = n8 = n2 == 2 || n2 == 4 ? 1 : 0;
                    if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && BasicJideTabbedPaneUI.this._tabPane.isLayoutTrailingComponentBeforeButtons()) {
                        serializable = new ArrayList();
                        for (n7 = 0; n7 < n5; n7 += 1) {
                            Component component3 = BasicJideTabbedPaneUI.this._tabPane.getComponent(n7);
                            if (!(component3 instanceof JButton) || !(component3 instanceof UIResource) || component3 == BasicJideTabbedPaneUI.this._tabLeadingComponent || component3 == BasicJideTabbedPaneUI.this._tabTrailingComponent || !component3.isVisible() || component3.getBounds().width == 0) continue;
                            serializable.add((JButton)component3);
                        }
                        if (serializable.size() > 0) {
                            Rectangle rectangle2 = ((JButton)serializable.get(serializable.size() - 1)).getBounds();
                            Rectangle rectangle3 = ((JButton)serializable.get(0)).getBounds();
                            Rectangle rectangle4 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getBounds();
                            if (!n8) {
                                BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(new Rectangle(rectangle3.x, rectangle4.y, rectangle4.width, rectangle4.height));
                                n6 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getWidth() - (rectangle2.x + rectangle2.width - rectangle3.x);
                                Iterator iterator = serializable.iterator();
                                while (iterator.hasNext()) {
                                    JButton jButton = (JButton)iterator.next();
                                    Rectangle rectangle5 = jButton.getBounds();
                                    jButton.setBounds(rectangle4.x + n6 + rectangle5.x - rectangle3.x, rectangle5.y, rectangle5.width, rectangle5.height);
                                }
                            } else {
                                BasicJideTabbedPaneUI.this._tabTrailingComponent.setBounds(new Rectangle(rectangle4.x, rectangle3.y, rectangle4.width, rectangle4.height));
                                n6 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getHeight() - (rectangle2.y + rectangle2.height - rectangle3.y);
                                Iterator iterator = serializable.iterator();
                                while (iterator.hasNext()) {
                                    JButton jButton = (JButton)iterator.next();
                                    Rectangle rectangle6 = jButton.getBounds();
                                    jButton.setBounds(rectangle6.x, rectangle4.y + n6 + rectangle6.y - rectangle3.y, rectangle6.width, rectangle6.height);
                                }
                            }
                        }
                    }
                    if (!(bl || n8 || jViewport == null || jViewport.getSize().equals(BasicJideTabbedPaneUI.this._tabPane.getSize()))) {
                        int n31 = BasicJideTabbedPaneUI.this._tabScroller.tabPanel.getWidth() - jViewport.getWidth();
                    }
                    BasicJideTabbedPaneUI.this.updateCloseButtons();
                    ((TabbedPaneLayout)this).layoutTabComponents();
                    if (bl2 && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        @Override
        protected void calculateTabRects(int n2, int n3) {
            int n4;
            Dimension dimension = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets insets2 = BasicJideTabbedPaneUI.this.getTabAreaInsets(n2);
            boolean bl = n2 == 2 || n2 == 4;
            boolean bl2 = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            int n5 = insets2.left;
            int n6 = insets2.top;
            Dimension dimension2 = new Dimension(0, 0);
            Dimension dimension3 = new Dimension(0, 0);
            if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                dimension2 = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
            }
            if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                dimension3 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
            }
            int n7 = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n2);
            switch (n2) {
                case 2: 
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n2 == 4 && BasicJideTabbedPaneUI.this._maxTabWidth < dimension2.width) {
                        BasicJideTabbedPaneUI.this._maxTabWidth = dimension2.width;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || n2 != 4 || BasicJideTabbedPaneUI.this._maxTabWidth >= dimension3.width) break;
                    BasicJideTabbedPaneUI.this._maxTabWidth = dimension3.width;
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = n7;
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n2 == 3 && BasicJideTabbedPaneUI.this._maxTabHeight < dimension2.height) {
                        BasicJideTabbedPaneUI.this._maxTabHeight = dimension2.height;
                    }
                    if (!BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() || n2 != 3 || BasicJideTabbedPaneUI.this._maxTabHeight >= dimension3.height) break;
                    BasicJideTabbedPaneUI.this._maxTabHeight = dimension3.height;
                }
            }
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            BasicJideTabbedPaneUI.this._selectedRun = 0;
            BasicJideTabbedPaneUI.this._runCount = 1;
            for (n4 = 0; n4 < n3; ++n4) {
                int n8;
                FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(n4);
                Rectangle rectangle = BasicJideTabbedPaneUI.this._rects[n4];
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = BasicJideTabbedPaneUI.this._rects[n4 - 1].x + BasicJideTabbedPaneUI.this._rects[n4 - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rectangle.x = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? n5 + BasicJideTabbedPaneUI.this.getLeftMargin() : n5;
                    }
                    rectangle.width = BasicJideTabbedPaneUI.this.calculateTabWidth(n2, n4, fontMetrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rectangle.width);
                    rectangle.y = n6;
                    n8 = -1;
                    if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n2 == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < dimension2.height) {
                        rectangle.y = n6 + dimension2.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        n8 = dimension2.height;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rectangle.y += 2;
                        }
                    }
                    if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && n2 == 1 && BasicJideTabbedPaneUI.this._maxTabHeight < dimension3.height && n8 < dimension3.height) {
                        rectangle.y = n6 + dimension3.height - BasicJideTabbedPaneUI.this._maxTabHeight - 2;
                        if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                            rectangle.y += 2;
                        }
                    }
                    rectangle.height = n7;
                    continue;
                }
                if (n4 > 0) {
                    rectangle.y = BasicJideTabbedPaneUI.this._rects[n4 - 1].y + BasicJideTabbedPaneUI.this._rects[n4 - 1].height;
                } else {
                    BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                    BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                    rectangle.y = BasicJideTabbedPaneUI.this.getTabShape() != 3 ? n6 + BasicJideTabbedPaneUI.this.getLeftMargin() : n6;
                }
                rectangle.height = BasicJideTabbedPaneUI.this.calculateTabHeight(n2, n4, fontMetrics) + BasicJideTabbedPaneUI.this._rectSizeExtend;
                BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rectangle.height);
                rectangle.x = n5;
                n8 = -1;
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible() && n2 == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < dimension2.width) {
                    rectangle.x = n5 + dimension2.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    n8 = dimension2.width;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rectangle.x += 2;
                    }
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible() && n2 == 2 && BasicJideTabbedPaneUI.this._maxTabWidth < dimension3.width && n8 < dimension3.width) {
                    rectangle.x = n5 + dimension3.width - BasicJideTabbedPaneUI.this._maxTabWidth - 2;
                    if (BasicJideTabbedPaneUI.this._rectSizeExtend > 0) {
                        rectangle.x += 2;
                    }
                }
                rectangle.width = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n2);
            }
            if (!bl2 && !bl) {
                n4 = 0;
                if (BasicJideTabbedPaneUI.this._rects.length > 0) {
                    n4 = Math.max(BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].x + BasicJideTabbedPaneUI.this._rects[BasicJideTabbedPaneUI.this._rects.length - 1].width, dimension.width - insets2.right);
                    BasicJideTabbedPaneUI.this._additionalWidth = BasicJideTabbedPaneUI.this.getLeftMargin();
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    BasicJideTabbedPaneUI.this._rects[i2].x = n4 - BasicJideTabbedPaneUI.this._rects[i2].x - BasicJideTabbedPaneUI.this._rects[i2].width + insets2.left;
                }
            } else {
                BasicJideTabbedPaneUI.this._additionalWidth = 0;
            }
            BasicJideTabbedPaneUI.this.ensureCurrentRects(BasicJideTabbedPaneUI.this.getLeftMargin(), n3);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Dimension calculateSize(boolean bl) {
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets insets2 = BasicJideTabbedPaneUI.this.getContentBorderInsets(n2);
            Insets insets3 = BasicJideTabbedPaneUI.this.getTabAreaInsets(n2);
            Dimension dimension = new Dimension(0, 0);
            int n3 = insets2.top + insets2.bottom;
            int n4 = insets2.left + insets2.right;
            int n5 = 0;
            int n6 = 0;
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                Dimension dimension2;
                Serializable serializable;
                int n7;
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (BasicJideTabbedPaneUI.this._tabPane.isShowTabContent()) {
                    for (n7 = 0; n7 < BasicJideTabbedPaneUI.this._tabPane.getTabCount(); ++n7) {
                        serializable = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n7);
                        if (serializable == null) continue;
                        dimension2 = dimension;
                        Dimension dimension3 = dimension2 = bl ? ((Component)serializable).getMinimumSize() : ((Component)serializable).getPreferredSize();
                        if (dimension2 == null) continue;
                        n6 = Math.max(dimension2.height, n6);
                        n5 = Math.max(dimension2.width, n5);
                    }
                    n4 += n5;
                    n3 += n6;
                }
                serializable = new Dimension(0, 0);
                dimension2 = new Dimension(0, 0);
                if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                    serializable = BasicJideTabbedPaneUI.this._tabLeadingComponent.getPreferredSize();
                }
                if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                    dimension2 = BasicJideTabbedPaneUI.this._tabTrailingComponent.getPreferredSize();
                }
                switch (n2) {
                    case 2: 
                    case 4: {
                        n3 = Math.max(n3, (bl ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n2)) + insets3.top + insets3.bottom);
                        n7 = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            n7 = Math.max(((Dimension)serializable).width, n7);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            n7 = Math.max(dimension2.width, n7);
                        }
                        n4 += n7;
                        break;
                    }
                    default: {
                        n4 = BasicJideTabbedPaneUI.this._tabPane.getTabResizeMode() == 2 ? Math.max(n4, (BasicJideTabbedPaneUI.this._tabPane.getTabCount() << 2) + insets3.left + insets3.right) : Math.max(n4, (bl ? 0 : BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n2)) + insets3.left + insets3.right);
                        if (!BasicJideTabbedPaneUI.this._tabPane.isTabShown()) break;
                        n7 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                        if (BasicJideTabbedPaneUI.this.isTabLeadingComponentVisible()) {
                            n7 = Math.max(((Dimension)serializable).height, n7);
                        }
                        if (BasicJideTabbedPaneUI.this.isTabTrailingComponentVisible()) {
                            n7 = Math.max(dimension2.height, n7);
                        }
                        n3 += n7;
                    }
                }
            }
            return new Dimension(n4 + insets.left + insets.right, n3 + insets.bottom + insets.top);
        }

        protected int preferredTabAreaHeight(int n2, int n3) {
            int n4 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(i2);
                    int n9 = BasicJideTabbedPaneUI.this.calculateTabWidth(n2, i2, fontMetrics);
                    if (n7 != 0 && n7 + n9 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n9;
                }
                n5 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n2, n6, n8);
            }
            return n5;
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            int n4 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(i2);
                    int n8 = BasicJideTabbedPaneUI.this.calculateTabHeight(n2, i2, fontMetrics);
                    if (n7 != 0 && n7 + n8 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n8;
                }
                n5 = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(n2, n6, BasicJideTabbedPaneUI.this._maxTabWidth);
            }
            return n5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            int n3 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            Component component = BasicJideTabbedPaneUI.this.getVisibleComponent();
            TabbedPaneLayout tabbedPaneLayout = this;
            synchronized (tabbedPaneLayout) {
                BasicJideTabbedPaneUI.this.ensureCloseButtonCreated();
                this.calculateLayoutInfo();
                if (n3 < 0) {
                    if (component != null) {
                        BasicJideTabbedPaneUI.this.setVisibleComponent(null);
                    }
                } else {
                    int n4 = 0;
                    int n5 = 0;
                    Insets insets2 = BasicJideTabbedPaneUI.this.getContentBorderInsets(n2);
                    Component component2 = BasicJideTabbedPaneUI.this._tabPane.getComponentAt(n3);
                    boolean bl = false;
                    if (component2 != null) {
                        if (component2 != component && component != null && JideSwingUtilities.isAncestorOfFocusOwner(component) && BasicJideTabbedPaneUI.this._tabPane.isAutoRequestFocus()) {
                            bl = true;
                        }
                        BasicJideTabbedPaneUI.this.setVisibleComponent(component2);
                    }
                    Rectangle rectangle = BasicJideTabbedPaneUI.this._tabPane.getBounds();
                    int n6 = BasicJideTabbedPaneUI.this._tabPane.getComponentCount();
                    if (n6 > 0) {
                        int n7;
                        int n8;
                        switch (n2) {
                            case 2: {
                                n4 = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                n8 = insets.left + n4 + insets2.left;
                                n7 = insets.top + insets2.top;
                                break;
                            }
                            case 4: {
                                n4 = BasicJideTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabWidth);
                                n8 = insets.left + insets2.left;
                                n7 = insets.top + insets2.top;
                                break;
                            }
                            case 3: {
                                n5 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                n8 = insets.left + insets2.left;
                                n7 = insets.top + insets2.top;
                                break;
                            }
                            default: {
                                n5 = BasicJideTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicJideTabbedPaneUI.this._runCount, BasicJideTabbedPaneUI.this._maxTabHeight);
                                n8 = insets.left + insets2.left;
                                n7 = insets.top + n5 + insets2.top;
                            }
                        }
                        int n9 = rectangle.width - n4 - insets.left - insets.right - insets2.left - insets2.right;
                        int n10 = rectangle.height - n5 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                        for (int i2 = 0; i2 < n6; ++i2) {
                            Component component3 = BasicJideTabbedPaneUI.this._tabPane.getComponent(i2);
                            if (component3 == BasicJideTabbedPaneUI.this._tabContainer) {
                                int n11 = n4 == 0 ? rectangle.width : n4 + insets.left + insets.right + insets2.left + insets2.right;
                                int n12 = n5 == 0 ? rectangle.height : n5 + insets.top + insets.bottom + insets2.top + insets2.bottom;
                                int n13 = 0;
                                int n14 = 0;
                                if (n2 == 3) {
                                    n14 = rectangle.height - n12;
                                } else if (n2 == 4) {
                                    n13 = rectangle.width - n11;
                                }
                                component3.setBounds(n13, n14, n11, n12);
                                continue;
                            }
                            component3.setBounds(n8, n7, n9, n10);
                        }
                    }
                    this.layoutTabComponents();
                    if (bl && !BasicJideTabbedPaneUI.this.requestFocusForVisibleComponent() && !BasicJideTabbedPaneUI.this._tabPane.requestFocusInWindow()) {
                        BasicJideTabbedPaneUI.this._tabPane.requestFocus();
                    }
                }
            }
        }

        public void calculateLayoutInfo() {
            int n2 = BasicJideTabbedPaneUI.this._tabPane.getTabCount();
            BasicJideTabbedPaneUI.this.assureRectsCreated(n2);
            this.calculateTabRects(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), n2);
        }

        private void layoutTabComponents() {
            if (BasicJideTabbedPaneUI.this._tabContainer == null) {
                return;
            }
            Rectangle rectangle = new Rectangle();
            Point point = new Point(-BasicJideTabbedPaneUI.this._tabContainer.getX(), -BasicJideTabbedPaneUI.this._tabContainer.getY());
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicJideTabbedPaneUI.this.translatePointToTabPanel(0, 0, point);
            }
            for (int i2 = 0; i2 < BasicJideTabbedPaneUI.this._tabPane.getTabCount(); ++i2) {
                Component component;
                Component component2 = component = SystemInfo.isJdk6Above() ? BasicJideTabbedPaneUI.this._tabPane.getTabComponentAt(i2) : null;
                if (component == null) continue;
                BasicJideTabbedPaneUI.this.getTabBounds(i2, rectangle);
                Dimension dimension = component.getPreferredSize();
                Insets insets = BasicJideTabbedPaneUI.this.getTabInsets(BasicJideTabbedPaneUI.this._tabPane.getTabPlacement(), i2);
                int n2 = rectangle.x + insets.left + point.x;
                int n3 = rectangle.y + insets.top + point.y;
                int n4 = rectangle.width - insets.left - insets.right;
                int n5 = rectangle.height - insets.top - insets.bottom;
                int n6 = n2 + (n4 - dimension.width) / 2;
                int n7 = n3 + (n5 - dimension.height) / 2;
                int n8 = BasicJideTabbedPaneUI.this._tabPane.getTabPlacement();
                boolean bl = i2 == BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
                component.setBounds(n6 + BasicJideTabbedPaneUI.this.getTabLabelShiftX(n8, i2, bl), n7 + BasicJideTabbedPaneUI.this.getTabLabelShiftY(n8, i2, bl), dimension.width, dimension.height);
            }
        }

        protected void calculateTabRects(int n2, int n3) {
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            int n7;
            Dimension dimension = BasicJideTabbedPaneUI.this._tabPane.getSize();
            Insets insets = BasicJideTabbedPaneUI.this._tabPane.getInsets();
            Insets insets2 = BasicJideTabbedPaneUI.this.getTabAreaInsets(n2);
            int n8 = BasicJideTabbedPaneUI.this._tabPane.getSelectedIndex();
            boolean bl = n2 == 2 || n2 == 4;
            boolean bl2 = BasicJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight();
            int n9 = BasicJideTabbedPaneUI.this.calculateMaxTabHeight(n2);
            switch (n2) {
                case 2: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicJideTabbedPaneUI.this._maxTabWidth = BasicJideTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n7 = dimension.width - insets.right - insets2.right - BasicJideTabbedPaneUI.this._maxTabWidth;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = n9;
                    n7 = insets.left + insets2.left;
                    n6 = dimension.height - insets.bottom - insets2.bottom - BasicJideTabbedPaneUI.this._maxTabHeight;
                    n5 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicJideTabbedPaneUI.this._maxTabHeight = n9;
                    n7 = insets.left + insets2.left;
                    n6 = insets.top + insets2.top;
                    n5 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n10 = BasicJideTabbedPaneUI.this.getTabRunOverlay(n2);
            BasicJideTabbedPaneUI.this._runCount = 0;
            BasicJideTabbedPaneUI.this._selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                FontMetrics fontMetrics = BasicJideTabbedPaneUI.this.getFontMetrics(n4);
                rectangle = BasicJideTabbedPaneUI.this._rects[n4];
                if (!bl) {
                    if (n4 > 0) {
                        rectangle.x = BasicJideTabbedPaneUI.this._rects[n4 - 1].x + BasicJideTabbedPaneUI.this._rects[n4 - 1].width;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabWidth = 0;
                        rectangle.x = n7;
                    }
                    rectangle.width = BasicJideTabbedPaneUI.this.calculateTabWidth(n2, n4, fontMetrics);
                    BasicJideTabbedPaneUI.this._maxTabWidth = Math.max(BasicJideTabbedPaneUI.this._maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n5) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = n4;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rectangle.x = n7;
                    }
                    rectangle.y = n6;
                    rectangle.height = BasicJideTabbedPaneUI.this._maxTabHeight;
                } else {
                    if (n4 > 0) {
                        rectangle.y = BasicJideTabbedPaneUI.this._rects[n4 - 1].y + BasicJideTabbedPaneUI.this._rects[n4 - 1].height;
                    } else {
                        BasicJideTabbedPaneUI.this._tabRuns[0] = 0;
                        BasicJideTabbedPaneUI.this._runCount = 1;
                        BasicJideTabbedPaneUI.this._maxTabHeight = 0;
                        rectangle.y = n6;
                    }
                    rectangle.height = BasicJideTabbedPaneUI.this.calculateTabHeight(n2, n4, fontMetrics);
                    BasicJideTabbedPaneUI.this._maxTabHeight = Math.max(BasicJideTabbedPaneUI.this._maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n5) {
                        if (BasicJideTabbedPaneUI.this._runCount > BasicJideTabbedPaneUI.this._tabRuns.length - 1) {
                            BasicJideTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount] = n4;
                        ++BasicJideTabbedPaneUI.this._runCount;
                        rectangle.y = n6;
                    }
                    rectangle.x = n7;
                    rectangle.width = BasicJideTabbedPaneUI.this._maxTabWidth;
                }
                if (n4 != n8) continue;
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this._runCount - 1;
            }
            if (BasicJideTabbedPaneUI.this._runCount > 1) {
                this.normalizeTabRuns(n2, n3, bl ? n6 : n7, n5);
                BasicJideTabbedPaneUI.this._selectedRun = BasicJideTabbedPaneUI.this.getRunForTab(n3, n8);
                if (BasicJideTabbedPaneUI.this.shouldRotateTabRuns(n2)) {
                    this.rotateTabRuns(n2, BasicJideTabbedPaneUI.this._selectedRun);
                }
            }
            for (n4 = BasicJideTabbedPaneUI.this._runCount - 1; n4 >= 0; --n4) {
                int n11;
                int n12;
                int n13 = BasicJideTabbedPaneUI.this._tabRuns[n4];
                int n14 = BasicJideTabbedPaneUI.this._tabRuns[n4 == BasicJideTabbedPaneUI.this._runCount - 1 ? 0 : n4 + 1];
                int n15 = n12 = n14 != 0 ? n14 - 1 : n3 - 1;
                if (!bl) {
                    for (n11 = n13; n11 <= n12; ++n11) {
                        rectangle = BasicJideTabbedPaneUI.this._rects[n11];
                        rectangle.y = n6;
                        rectangle.x += BasicJideTabbedPaneUI.this.getTabRunIndent(n2, n4);
                    }
                    if (BasicJideTabbedPaneUI.this.shouldPadTabRun(n2, n4)) {
                        this.padTabRun(n2, n13, n12, n5);
                    }
                    if (n2 == 3) {
                        n6 -= BasicJideTabbedPaneUI.this._maxTabHeight - n10;
                        continue;
                    }
                    n6 += BasicJideTabbedPaneUI.this._maxTabHeight - n10;
                    continue;
                }
                for (n11 = n13; n11 <= n12; ++n11) {
                    rectangle = BasicJideTabbedPaneUI.this._rects[n11];
                    rectangle.x = n7;
                    rectangle.y += BasicJideTabbedPaneUI.this.getTabRunIndent(n2, n4);
                }
                if (BasicJideTabbedPaneUI.this.shouldPadTabRun(n2, n4)) {
                    this.padTabRun(n2, n13, n12, n5);
                }
                if (n2 == 4) {
                    n7 -= BasicJideTabbedPaneUI.this._maxTabWidth - n10;
                    continue;
                }
                n7 += BasicJideTabbedPaneUI.this._maxTabWidth - n10;
            }
            this.padSelectedTab(n2, n8);
            if (!bl2 && !bl) {
                int n16 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n3; ++n4) {
                    BasicJideTabbedPaneUI.this._rects[n4].x = n16 - BasicJideTabbedPaneUI.this._rects[n4].x - BasicJideTabbedPaneUI.this._rects[n4].width;
                }
            }
        }

        protected void rotateTabRuns(int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = BasicJideTabbedPaneUI.this._tabRuns[0];
                for (int i3 = 1; i3 < BasicJideTabbedPaneUI.this._runCount; ++i3) {
                    BasicJideTabbedPaneUI.this._tabRuns[i3 - 1] = BasicJideTabbedPaneUI.this._tabRuns[i3];
                }
                BasicJideTabbedPaneUI.this._tabRuns[BasicJideTabbedPaneUI.this._runCount - 1] = n4;
            }
        }

        protected void normalizeTabRuns(int n2, int n3, int n4, int n5) {
            boolean bl = n2 == 2 || n2 == 4;
            int n6 = BasicJideTabbedPaneUI.this._runCount - 1;
            boolean bl2 = true;
            double d2 = 1.25;
            while (bl2) {
                int n7;
                int n8;
                int n9 = BasicJideTabbedPaneUI.this.lastTabInRun(n3, n6);
                int n10 = BasicJideTabbedPaneUI.this.lastTabInRun(n3, n6 - 1);
                if (!bl) {
                    n8 = BasicJideTabbedPaneUI.this._rects[n9].x + BasicJideTabbedPaneUI.this._rects[n9].width;
                    n7 = (int)((double)BasicJideTabbedPaneUI.this._maxTabWidth * d2);
                } else {
                    n8 = BasicJideTabbedPaneUI.this._rects[n9].y + BasicJideTabbedPaneUI.this._rects[n9].height;
                    n7 = (int)((double)BasicJideTabbedPaneUI.this._maxTabHeight * d2 * 2.0);
                }
                if (n5 - n8 > n7) {
                    BasicJideTabbedPaneUI.this._tabRuns[n6] = n10;
                    if (!bl) {
                        BasicJideTabbedPaneUI.this._rects[n10].x = n4;
                    } else {
                        BasicJideTabbedPaneUI.this._rects[n10].y = n4;
                    }
                    for (int i2 = n10 + 1; i2 <= n9; ++i2) {
                        if (!bl) {
                            BasicJideTabbedPaneUI.this._rects[i2].x = BasicJideTabbedPaneUI.this._rects[i2 - 1].x + BasicJideTabbedPaneUI.this._rects[i2 - 1].width;
                            continue;
                        }
                        BasicJideTabbedPaneUI.this._rects[i2].y = BasicJideTabbedPaneUI.this._rects[i2 - 1].y + BasicJideTabbedPaneUI.this._rects[i2 - 1].height;
                    }
                } else if (n6 == BasicJideTabbedPaneUI.this._runCount - 1) {
                    bl2 = false;
                }
                if (n6 - 1 > 0) {
                    --n6;
                    continue;
                }
                n6 = BasicJideTabbedPaneUI.this._runCount - 1;
                d2 += 0.25;
            }
        }

        protected void padTabRun(int n2, int n3, int n4, int n5) {
            Rectangle rectangle = BasicJideTabbedPaneUI.this._rects[n4];
            if (n2 == 1 || n2 == 3) {
                int n6 = rectangle.x + rectangle.width - BasicJideTabbedPaneUI.this._rects[n3].x;
                int n7 = n5 - (rectangle.x + rectangle.width);
                float f2 = (float)n7 / (float)n6;
                for (int i2 = n3; i2 <= n4; ++i2) {
                    Rectangle rectangle2 = BasicJideTabbedPaneUI.this._rects[i2];
                    if (i2 > n3) {
                        rectangle2.x = BasicJideTabbedPaneUI.this._rects[i2 - 1].x + BasicJideTabbedPaneUI.this._rects[i2 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f2);
                }
                rectangle.width = n5 - rectangle.x;
            } else {
                int n8 = rectangle.y + rectangle.height - BasicJideTabbedPaneUI.this._rects[n3].y;
                int n9 = n5 - (rectangle.y + rectangle.height);
                float f3 = (float)n9 / (float)n8;
                for (int i3 = n3; i3 <= n4; ++i3) {
                    Rectangle rectangle3 = BasicJideTabbedPaneUI.this._rects[i3];
                    if (i3 > n3) {
                        rectangle3.y = BasicJideTabbedPaneUI.this._rects[i3 - 1].y + BasicJideTabbedPaneUI.this._rects[i3 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f3);
                }
                rectangle.height = n5 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n2, int n3) {
            if (n3 >= 0) {
                Rectangle rectangle = BasicJideTabbedPaneUI.this._rects[n3];
                Insets insets = BasicJideTabbedPaneUI.this.getSelectedTabPadInsets(n2);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    private class TabContainer
    extends JPanel
    implements UIResource {
        private boolean notifyTabbedPane;

        public TabContainer() {
            super(null);
            this.notifyTabbedPane = true;
            this.setOpaque(false);
        }

        @Override
        public void remove(Component component) {
            int n2 = BasicJideTabbedPaneUI.this._tabPane.indexOfTabComponent(component);
            super.remove(component);
            if (this.notifyTabbedPane && n2 != -1) {
                BasicJideTabbedPaneUI.this._tabPane.setTabComponentAt(n2, null);
            }
        }

        private void removeUnusedTabComponents() {
            for (Component component : this.getComponents()) {
                int n2;
                if (component instanceof UIResource || (n2 = BasicJideTabbedPaneUI.this._tabPane.indexOfTabComponent(component)) != -1) continue;
                super.remove(component);
            }
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return BasicJideTabbedPaneUI.this._tabScroller != null;
        }

        @Override
        public void doLayout() {
            if (BasicJideTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                BasicJideTabbedPaneUI.this._tabScroller.tabPanel.repaint();
            } else {
                BasicJideTabbedPaneUI.this._tabPane.repaint(this.getBounds());
            }
        }
    }

    private static class CloseTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 7779678389793199733L;

        public CloseTabAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_CLOSE));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            Component component;
            int n3;
            JideTabbedPane jideTabbedPane;
            Object object = actionEvent.getSource();
            boolean bl = false;
            if (object instanceof JideTabbedPane) {
                jideTabbedPane = (JideTabbedPane)object;
            } else if (object instanceof JideTabbedPane.NoFocusButton && ((JideTabbedPane.NoFocusButton)object).getParent() instanceof JideTabbedPane) {
                jideTabbedPane = (JideTabbedPane)((JideTabbedPane.NoFocusButton)object).getParent();
                bl = true;
            } else if (object instanceof JideTabbedPane.NoFocusButton && ((JideTabbedPane.NoFocusButton)object).getParent() instanceof ScrollableTabPanel) {
                jideTabbedPane = (JideTabbedPane)SwingUtilities.getAncestorOfClass(JideTabbedPane.class, (JideTabbedPane.NoFocusButton)object);
                bl = false;
            } else {
                return;
            }
            if (jideTabbedPane.isTabEditing()) {
                ((BasicJideTabbedPaneUI)jideTabbedPane.getUI()).stopOrCancelEditing();
            }
            ActionEvent actionEvent2 = actionEvent;
            if (object instanceof JideTabbedPane.NoFocusButton) {
                n3 = ((JideTabbedPane.NoFocusButton)object).getIndex();
                Component component2 = component = n3 != -1 ? jideTabbedPane.getComponentAt(n3) : jideTabbedPane.getSelectedComponent();
                if (component != null) {
                    actionEvent2 = new ActionEvent(component, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
                }
            } else if ("middleMouseButtonClicked".equals(actionEvent.getActionCommand())) {
                n3 = actionEvent.getID();
                Component component3 = component = n3 != -1 ? jideTabbedPane.getComponentAt(n3) : jideTabbedPane.getSelectedComponent();
                if (component != null) {
                    actionEvent2 = new ActionEvent(component, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
                }
            }
            if (jideTabbedPane.getCloseAction() != null) {
                actionEvent2 = new ActionEvent(actionEvent2.getSource(), actionEvent2.getID(), (String)jideTabbedPane.getCloseAction().getValue("ActionCommandKey"), actionEvent2.getWhen(), actionEvent2.getModifiers());
                jideTabbedPane.getCloseAction().actionPerformed(actionEvent2);
            } else if ("middleMouseButtonClicked".equals(actionEvent.getActionCommand())) {
                n3 = actionEvent.getID();
                if (n3 >= 0) {
                    jideTabbedPane.removeTabAt(n3);
                }
                if (jideTabbedPane.getTabCount() == 0) {
                    jideTabbedPane.updateUI();
                }
                jideTabbedPane.doLayout();
                if (jideTabbedPane.getSelectedIndex() >= 0) {
                    ((BasicJideTabbedPaneUI)jideTabbedPane.getUI())._tabScroller.tabPanel.scrollIndexToVisible(jideTabbedPane.getSelectedIndex());
                }
            } else if (bl) {
                if (jideTabbedPane.getSelectedIndex() >= 0) {
                    jideTabbedPane.removeTabAt(jideTabbedPane.getSelectedIndex());
                }
                if (jideTabbedPane.getTabCount() == 0) {
                    jideTabbedPane.updateUI();
                }
                jideTabbedPane.doLayout();
                if (jideTabbedPane.getSelectedIndex() >= 0) {
                    ((BasicJideTabbedPaneUI)jideTabbedPane.getUI())._tabScroller.tabPanel.scrollIndexToVisible(jideTabbedPane.getSelectedIndex());
                }
            } else if (object instanceof JideTabbedPane.NoFocusButton && (n2 = ((JideTabbedPane.NoFocusButton)object).getIndex()) != -1) {
                int n4 = jideTabbedPane.getSelectedIndex();
                jideTabbedPane.removeTabAt(n2);
                if (n2 < n4) {
                    jideTabbedPane.setSelectedIndex(n4 - 1);
                }
                if (jideTabbedPane.getTabCount() == 0) {
                    jideTabbedPane.updateUI();
                }
                jideTabbedPane.doLayout();
                if (jideTabbedPane.getSelectedIndex() >= 0) {
                    ((BasicJideTabbedPaneUI)jideTabbedPane.getUI())._tabScroller.tabPanel.scrollIndexToVisible(jideTabbedPane.getSelectedIndex());
                }
            }
        }
    }

    private static class ScrollTabsListAction
    extends AbstractAction {
        private static final long serialVersionUID = 246103712600916771L;

        public ScrollTabsListAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_TAB_LIST));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI basicJideTabbedPaneUI;
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof JideTabbedPane.NoFocusButton) {
                jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (JideTabbedPane.NoFocusButton)object);
            }
            if (jTabbedPane instanceof JideTabbedPane && (basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI()).scrollableTabLayoutEnabled()) {
                if (((JideTabbedPane)jTabbedPane).isTabListPopupVisible()) {
                    ((JideTabbedPane)jTabbedPane).hideTabListPopup();
                } else {
                    basicJideTabbedPaneUI._tabScroller.createPopup(jTabbedPane.getTabPlacement());
                }
            }
        }
    }

    private static class ScrollTabsBackwardAction
    extends AbstractAction {
        private static final long serialVersionUID = -426408621939940046L;

        public ScrollTabsBackwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_BACKWARD));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI basicJideTabbedPaneUI;
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof JideTabbedPane.NoFocusButton) {
                jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (JideTabbedPane.NoFocusButton)object);
            }
            if (jTabbedPane != null && (basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI()).scrollableTabLayoutEnabled()) {
                basicJideTabbedPaneUI._tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class ScrollTabsForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 8772616556895545931L;

        public ScrollTabsForwardAction() {
            this.putValue("ShortDescription", Resource.getResourceBundle(Locale.getDefault()).getString(BasicJideTabbedPaneUI.BUTTON_NAME_SCROLL_FORWARD));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicJideTabbedPaneUI basicJideTabbedPaneUI;
            JTabbedPane jTabbedPane = null;
            Object object = actionEvent.getSource();
            if (object instanceof JTabbedPane) {
                jTabbedPane = (JTabbedPane)object;
            } else if (object instanceof JideTabbedPane.NoFocusButton) {
                jTabbedPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, (JideTabbedPane.NoFocusButton)object);
            }
            if (jTabbedPane != null && (basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI()).scrollableTabLayoutEnabled()) {
                basicJideTabbedPaneUI._tabScroller.scrollForward(jTabbedPane.getTabPlacement());
            }
        }
    }

    private static class SetSelectedIndexAction
    extends AbstractAction {
        private static final long serialVersionUID = 6216635910156115469L;

        private SetSelectedIndexAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (jTabbedPane != null && jTabbedPane.getUI() instanceof BasicJideTabbedPaneUI) {
                BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
                String string = actionEvent.getActionCommand();
                if (string != null && string.length() > 0) {
                    Integer n2;
                    int n3 = actionEvent.getActionCommand().charAt(0);
                    if (n3 >= 97 && n3 <= 122) {
                        n3 -= 32;
                    }
                    if ((n2 = (Integer)basicJideTabbedPaneUI._mnemonicToIndexMap.get(new Integer(n3))) != null && jTabbedPane.isEnabledAt(n2)) {
                        jTabbedPane.setSelectedIndex(n2);
                    }
                }
            }
        }
    }

    private static class RequestFocusForVisibleAction
    extends AbstractAction {
        private static final long serialVersionUID = 6677797853998039155L;

        private RequestFocusForVisibleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.requestFocusForVisibleComponent();
        }
    }

    private static class RequestFocusAction
    extends AbstractAction {
        private static final long serialVersionUID = 3791111435639724577L;

        private RequestFocusAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            if (!jTabbedPane.requestFocusInWindow()) {
                jTabbedPane.requestFocus();
            }
        }
    }

    private static class PageDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 4895454480954468453L;

        private PageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                basicJideTabbedPaneUI.navigateSelectedTab(3);
            } else {
                basicJideTabbedPaneUI.navigateSelectedTab(5);
            }
        }
    }

    private static class PageUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1154273528778779166L;

        private PageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            int n2 = jTabbedPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                basicJideTabbedPaneUI.navigateSelectedTab(7);
            } else {
                basicJideTabbedPaneUI.navigateSelectedTab(1);
            }
        }
    }

    private static class PreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = 2095403667386334865L;

        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(13);
        }
    }

    private static class NextAction
    extends AbstractAction {
        private static final long serialVersionUID = -154035573464933924L;

        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(12);
        }
    }

    private static class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = -453174268282628886L;

        private DownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(5);
        }
    }

    private static class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6961702501242792445L;

        private UpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(1);
        }
    }

    private static class LeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 8670680299012169408L;

        private LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(7);
        }
    }

    private static class RightAction
    extends AbstractAction {
        private static final long serialVersionUID = -1759791760116532857L;

        private RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicJideTabbedPaneUI basicJideTabbedPaneUI = (BasicJideTabbedPaneUI)jTabbedPane.getUI();
            basicJideTabbedPaneUI.navigateSelectedTab(3);
        }
    }
}

